/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.model.BLA;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import java.util.ArrayList;

public class ControlOpResults {
    private static TraceComponent _tc = Tr.register(ControlOpResults.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String CLASS_NAME = "com.ibm.wsspi.management.bla.ControlOpResults";
    private ArrayList<ControlOpResult> _resultList;
    private int _numErrors = 0;

    public ControlOpResults() {
        this._resultList = new ArrayList();
    }

    public ControlOpResults(ControlOpResult[] resultArray) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>(ControlOpResult[])", resultArray);
        }
        this._resultList = new ArrayList();
        for (ControlOpResult result : resultArray) {
            this.addControlOpResult(result);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>(ControlOpResult[])");
        }
    }

    public void addControlOpResult(ControlOpResult result) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addControlOpResult", new Object[]{"result=" + result, "numErrors=" + this._numErrors});
        }
        this._resultList.add(result);
        InvocationResult[] invocationResults = result.getInvocationResults();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "numInvocationResults=" + invocationResults.length);
        }
        for (InvocationResult invocationResult : invocationResults) {
            if (invocationResult.getException() == null) continue;
            ++this._numErrors;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addControlOpResult", "numErrors=" + this._numErrors);
        }
    }

    public void mergeControlOpResults(ControlOpResults resultsToMergeIn) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeControlOpResults", "resultsToMergeIn=" + resultsToMergeIn);
        }
        ArrayList<ControlOpResult> resultListToMerge = resultsToMergeIn._resultList;
        for (ControlOpResult result : resultListToMerge) {
            this.addControlOpResult(result);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeControlOpResults");
        }
    }

    public ResultSummary getResultSummary() {
        String resultSummaryString;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getResultSummary");
        }
        int successCount = 0;
        int partialCount = 0;
        int failureCount = 0;
        for (ControlOpResult result : this._resultList) {
            ResultSummary currSummary = result.getResultSummary();
            switch (currSummary) {
                case SUCCESSFUL: {
                    ++successCount;
                    break;
                }
                case PARTIALLY_SUCCESSFUL: {
                    ++partialCount;
                    break;
                }
                case UNSUCCESSFUL: {
                    ++failureCount;
                }
            }
        }
        ResultSummary resultSummary = null;
        if (partialCount > 0) {
            resultSummary = ResultSummary.PARTIALLY_SUCCESSFUL;
            resultSummaryString = "Partially successful";
        } else if (failureCount == 0) {
            resultSummary = ResultSummary.SUCCESSFUL;
            resultSummaryString = "Successful";
        } else if (successCount > 0) {
            resultSummary = ResultSummary.PARTIALLY_SUCCESSFUL;
            resultSummaryString = "Partially successful";
        } else {
            resultSummary = ResultSummary.UNSUCCESSFUL;
            resultSummaryString = "Unsuccessful";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getResultSummary", resultSummaryString);
        }
        return resultSummary;
    }

    public int getNumberOfErrors() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNumberOfErrors", "numErrors=" + this._numErrors);
        }
        return this._numErrors;
    }

    public ControlOpResult[] getControlOpResultArray() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getControlOpResultArray");
        }
        ControlOpResult[] resultArray = new ControlOpResult[this._resultList.size()];
        this._resultList.toArray(resultArray);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getControlOpResultArray", resultArray);
        }
        return resultArray;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ControlOpResults: ");
        sb.append("resultListSize=");
        sb.append(this._resultList.size());
        sb.append(", numErrors=");
        sb.append(this._numErrors);
        if (this._resultList.size() > 0) {
            sb.append(", Results={");
            for (ControlOpResult result : this._resultList) {
                sb.append('{');
                sb.append(result);
                sb.append('}');
            }
            sb.append('}');
        }
        return sb.toString();
    }

    public static class InvocationResult {
        private static TraceComponent _tc_ir = Tr.register(InvocationResult.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
        private String _invocationTarget;
        private Exception _exception;

        public InvocationResult(String invocationTarget, Exception exception) {
            if (_tc_ir.isDebugEnabled()) {
                Tr.debug(_tc_ir, "InvocationResult created:", new Object[]{"target=" + invocationTarget, "exception=" + exception});
            }
            this._invocationTarget = invocationTarget;
            this._exception = exception;
        }

        public String getInvocationTarget() {
            return this._invocationTarget;
        }

        public Exception getException() {
            return this._exception;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InvocationResult: ");
            sb.append("invocationTarget=");
            sb.append(this._invocationTarget);
            sb.append(", exception=");
            sb.append(this._exception);
            return sb.toString();
        }
    }

    public static class ControlOpResult {
        private static TraceComponent _tc_cor = Tr.register(ControlOpResult.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
        public static final String KEY_MBEAN_OBJECT_NAMES = "mbeanObjectNames";
        public static final String KEY_SUCCESSFUL_SERVER_TARGETS = "successful";
        private ControlOpType _opType;
        private BLA _bla;
        private CompositionUnit _compUnit;
        private String _opName;
        private String _target;
        private String _handlerID;
        private Exception _exception;
        private InvocationResult[] _invocationResults;

        public ControlOpResult(BLA parentBLA, CompositionUnit compUnit, String compUnitOpName, String handlerID, String target, InvocationResult[] invocationResults) {
            if (_tc_cor.isEntryEnabled()) {
                Tr.entry(_tc_cor, "ControlOpResult", new Object[]{"compUnit=" + compUnit, "compUnitOpName=" + compUnitOpName, "handlerID=" + handlerID, "target=" + target});
            }
            this._opType = ControlOpType.CU;
            this._bla = parentBLA;
            this._compUnit = compUnit;
            this._opName = compUnitOpName;
            this._handlerID = handlerID;
            this._target = target;
            this._invocationResults = invocationResults;
            if (this._invocationResults == null) {
                this._invocationResults = new InvocationResult[0];
            }
            if (_tc_cor.isEntryEnabled()) {
                Tr.exit(_tc_cor, "ControlOpResult");
            }
        }

        public ControlOpResult(BLA parentBLA, CompositionUnit compUnit, String compUnitOpName, String handlerID, String target, Exception exception) {
            if (_tc_cor.isEntryEnabled()) {
                Tr.entry(_tc_cor, "ControlOpResult", new Object[]{"compUnit=" + compUnit, "compUnitOpName=" + compUnitOpName, "handlerID=" + handlerID, "target=" + target});
            }
            this._opType = ControlOpType.CU;
            this._bla = parentBLA;
            this._compUnit = compUnit;
            this._opName = compUnitOpName;
            this._handlerID = handlerID;
            this._target = target;
            this._invocationResults = new InvocationResult[1];
            this._invocationResults[0] = new InvocationResult(target, exception);
            if (_tc_cor.isEntryEnabled()) {
                Tr.exit(_tc_cor, "ControlOpResult");
            }
        }

        public BLA getBLA() {
            if (_tc_cor.isDebugEnabled()) {
                Tr.debug(_tc_cor, "getBLA", this._bla);
            }
            return this._bla;
        }

        public CompositionUnit getCompositionUnit() {
            if (_tc_cor.isDebugEnabled()) {
                Tr.debug(_tc_cor, "getCompositionUnit", this._compUnit);
            }
            return this._compUnit;
        }

        public String getOpName() {
            if (_tc_cor.isDebugEnabled()) {
                Tr.debug(_tc_cor, "getOpName", this._opName);
            }
            return this._opName;
        }

        public String getTarget() {
            if (_tc_cor.isDebugEnabled()) {
                Tr.debug(_tc_cor, "getTarget", this._target);
            }
            return this._target;
        }

        public String getHandlerID() {
            if (_tc_cor.isDebugEnabled()) {
                Tr.debug(_tc_cor, "getHandlerID", this._handlerID);
            }
            return this._handlerID;
        }

        public ResultSummary getResultSummary() {
            String resultSummaryString;
            ResultSummary resultSummary;
            if (_tc_cor.isEntryEnabled()) {
                Tr.entry(_tc_cor, "getResultSummary");
            }
            int numErrors = 0;
            for (InvocationResult result : this._invocationResults) {
                if (result.getException() == null) continue;
                ++numErrors;
            }
            if (numErrors == 0) {
                resultSummary = ResultSummary.SUCCESSFUL;
                resultSummaryString = "Successful";
            } else if (numErrors == this._invocationResults.length) {
                resultSummary = ResultSummary.UNSUCCESSFUL;
                resultSummaryString = "Unsuccessful";
            } else {
                resultSummary = ResultSummary.PARTIALLY_SUCCESSFUL;
                resultSummaryString = "Partially successful";
            }
            if (_tc_cor.isEntryEnabled()) {
                Tr.exit(_tc_cor, "getResultSummary", resultSummaryString);
            }
            return resultSummary;
        }

        public InvocationResult[] getInvocationResults() {
            if (_tc_cor.isDebugEnabled()) {
                Tr.debug(_tc_cor, "getInvocationResults", this._invocationResults);
            }
            return this._invocationResults;
        }

        public Exception getException() {
            InvocationResult result;
            Exception exception = null;
            InvocationResult[] arr$ = this._invocationResults;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (exception = (result = arr$[i$]).getException()) == null; ++i$) {
            }
            return exception;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ControlOpResult: ");
            sb.append("opType=");
            sb.append((Object)this._opType);
            sb.append(", bla=");
            sb.append(this._bla);
            sb.append(", compUnit=");
            sb.append(this._compUnit);
            sb.append(", opName=");
            sb.append(this._opName);
            sb.append(", handlerID=");
            sb.append(this._handlerID);
            sb.append(", target=");
            sb.append(this._target);
            sb.append(", exception=");
            sb.append(this._exception);
            if (this._invocationResults.length > 0) {
                sb.append(", InvocationResults={");
                for (InvocationResult result : this._invocationResults) {
                    sb.append('{');
                    sb.append(result);
                    sb.append('}');
                }
                sb.append('}');
            }
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ControlOpType {
            BLA,
            CU;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultSummary {
        SUCCESSFUL,
        PARTIALLY_SUCCESSFUL,
        UNSUCCESSFUL;

    }
}

