/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.op.compound;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.framework.StepProvider;
import com.ibm.wsspi.management.bla.op.ExecutionElement;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import com.ibm.wsspi.management.bla.op.compound.CompoundOperation;
import com.ibm.wsspi.management.bla.op.compound.Step;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Phase
extends ExecutionElement {
    private static TraceComponent tc = Tr.register(Phase.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    protected CompoundOperation _op;
    protected List<Step> _steps;
    protected int _nextStepIndex;
    private boolean _hasUI = false;

    public Phase(String phaseName, CompoundOperation op, boolean bHasUI) {
        super(phaseName);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Phase", new Object[]{phaseName, op});
        }
        this._op = op;
        this._nextStepIndex = 0;
        this._hasUI = bHasUI;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx " + phaseName + "  " + this._hasUI);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Phase");
        }
    }

    public void init(List<StepProvider> supportedStepProviders) {
        this._steps = new ArrayList<Step>();
        this.createSteps(supportedStepProviders);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "steps are: " + this._steps);
        }
    }

    public CompoundOperation getOp() {
        return this._op;
    }

    public boolean hasUI() {
        return this._hasUI;
    }

    public List<Step> getSteps() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSteps");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSteps", new Object[]{this._steps});
        }
        return this._steps;
    }

    protected void createSteps(List<StepProvider> spList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSteps");
        }
        for (StepProvider stepProvider : spList) {
            stepProvider.addSteps(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSteps");
        }
    }

    protected Step getNextStep() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextStep");
        }
        Step ret = null;
        if (this._steps != null && this._nextStepIndex < this._steps.size()) {
            ret = this._steps.get(this._nextStepIndex);
            ++this._nextStepIndex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextStep", ret);
        }
        return ret;
    }

    @Override
    public void execute() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", "Phase entry: " + this.getName());
        }
        try {
            Step step = this.getNextStep();
            while (step != null && !this.getOp().getStatus().equals("st_done")) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "execute:  Before step:", new String[]{"stepName=" + step.getName(), "stepClass=" + step.getClass().getName()});
                    }
                    step.execute();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "execute:  After step:", new String[]{"stepName=" + step.getName(), "stepClass=" + step.getClass().getName()});
                    }
                }
                catch (OpExecutionException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "execute:  After step:", new String[]{"stepName=" + step.getName(), "stepClass=" + step.getClass().getName(), "stepException=" + e.toString()});
                    }
                    throw e;
                }
                step = this.getNextStep();
            }
            this._status = "st_done";
        }
        catch (OpExecutionException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new String[]{"Phase exit: " + this.getName(), "exception=" + e.toString()});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", "Phase exit: " + this.getName());
        }
    }

    public String toString() {
        return "<Phase>" + this.getName() + " <AllSteps>" + this._steps + "</AllSteps></Phase>";
    }
}

