/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.op.compound;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import com.ibm.wsspi.management.bla.op.OpProgressListener;
import com.ibm.wsspi.management.bla.op.Operation;
import com.ibm.wsspi.management.bla.op.OperationContext;
import com.ibm.wsspi.management.bla.op.compound.CompoundOpProgressListener;
import com.ibm.wsspi.management.bla.op.compound.Phase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundOperation
extends Operation {
    private static TraceComponent tc = Tr.register(CompoundOperation.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    protected List<Phase> _phases;
    private int _nextPhase = 0;
    protected Phase _cleanupPhase;
    boolean _pausePhaseExecution = false;

    public CompoundOperation(String opName, OperationContext opContext, HashMap params) {
        super(opName, opContext, params);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CompoundOperation", new Object[]{opName, opContext});
        }
        this._phases = new ArrayList<Phase>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CompoundOperation");
        }
    }

    @Override
    public void execute() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", "opName=" + this.getName());
        }
        super.execute();
        if (this._pausePhaseExecution) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resetting status to executing");
            }
            this._status = "st_exec";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    @Override
    public void doExecute() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doExecute");
        }
        this.initPhasesAndSteps();
        this._doPhaseExecute();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doExecute");
        }
    }

    private void _doPhaseExecute() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_doPhaseExecute");
        }
        try {
            Phase phase = this.getNextPhase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "phase: " + phase);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "is cleanup phase: " + this._cleanupPhase);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "status: " + this._status);
            }
            while (phase != null && !this.getStatus().equals("st_done")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "executing phase: " + phase);
                }
                phase.execute();
                this.notifyListeners(phase);
                if (this._pausePhaseExecution) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pausePhaseExecution flag is set, pause phase execution");
                    }
                    phase = null;
                    break;
                }
                phase = this.getNextPhase();
            }
        }
        catch (OpExecutionException ex) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doExecute", "Exception from execution of operation: " + ex);
            }
            throw ex;
        }
        catch (Throwable ex) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doExcecute", new Object[]{"Exception from execution of operation:", ex});
            }
            OpExecutionException oee = new OpExecutionException(ex, ex.getMessage());
            throw oee;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_doPhaseExecute");
        }
    }

    private Phase getNextPhase() {
        if (this._phases.size() < this._nextPhase + 1) {
            return null;
        }
        return this._phases.get(this._nextPhase++);
    }

    protected abstract void initPhasesAndSteps() throws OpExecutionException;

    public List<Phase> getPhases() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPhases", new Object[]{this._phases});
        }
        return this._phases;
    }

    public void notifyListeners(Phase p) {
        for (OpProgressListener l : this._listeners) {
            if (!(l instanceof CompoundOpProgressListener)) continue;
            ((CompoundOpProgressListener)l).phaseCompleted(p, this);
        }
    }

    @Override
    protected void doFinishOperation() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "doFinishOperation: " + this.getName());
            }
            if (this._cleanupPhase != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "execute cleanup Phase: " + this._cleanupPhase.getName());
                }
                this._cleanupPhase.execute();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no cleanup phase");
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error in doFinishOperation", th);
            }
            FFDCFilter.processException((Throwable)th, (String)(this.getClass().getName() + ".doFinishOperation"), (String)"138");
        }
    }

    public void pauseExecution() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pauseExecution");
        }
        this._pausePhaseExecution = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pauseExecution");
        }
    }

    public void resumeExecution() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeExecution");
        }
        this._pausePhaseExecution = false;
        this._doPhaseExecute();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeExecution");
        }
    }

    public String toString() {
        return "<CompoundOperation>" + this.getName() + ", status=" + this.getStatus() + "  <AllPhases>" + this._phases + "</AllPhases></CompoundOperation>";
    }
}

