/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.op;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.wsspi.management.bla.cdr.ConfigData;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;

public class OperationContext {
    private static TraceComponent tc = Tr.register(OperationContext.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    protected boolean _bSessionOwner;
    protected String _sessionID;
    protected String _tempDir;
    protected Locale _locale;
    protected Hashtable _props;
    protected ConfigData _configData;
    protected Session _session;

    public OperationContext(Session sess, String tmpDir, Locale locale) {
        this(sess, tmpDir, locale, null, null);
    }

    public OperationContext(Session sess, String tempDir, Locale locale, Hashtable props, ConfigData cData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "OperationContext", new Object[]{sess, tempDir, locale, props, cData});
        }
        this._props = props != null ? props : new Hashtable();
        this._session = sess;
        if (this._session == null) {
            this._session = new Session(Long.toHexString(System.currentTimeMillis()), true);
        }
        this._tempDir = tempDir;
        if (this._tempDir == null) {
            this._tempDir = System.getProperty("java.io.tmpdir") + "/" + Long.toHexString(System.currentTimeMillis());
        }
        this._locale = locale;
        if (this._locale == null) {
            this._locale = Locale.getDefault();
        }
        this._configData = cData;
        if (this._configData == null) {
            this._configData = new ConfigData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "OperationContext");
        }
    }

    public String getSessionID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionID", new Object[]{this._session.toString()});
        }
        return this._session.toString();
    }

    public Session getSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSession");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSession", new Object[]{this._session});
        }
        return this._session;
    }

    public String getTempDir() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTempDir");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTempDir", new Object[]{this._tempDir});
        }
        return this._tempDir;
    }

    public Locale getLocale() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocale");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocale", new Object[]{this._locale});
        }
        return this._locale;
    }

    public Hashtable getProps() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProps");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProps", new Object[]{this._props});
        }
        return this._props;
    }

    public boolean isSessionOwner() {
        return this._bSessionOwner;
    }

    public ConfigData getConfigData() {
        return this._configData;
    }

    public Object clone() {
        return new OperationContext(this._session, this._tempDir, this._locale, new Hashtable(), this._configData);
    }

    public void cleanup() {
        String s = this.getTempDir();
        File dir = null;
        this._deleteDir(dir);
    }

    private void _deleteDir(File dir) {
        if (dir == null) {
            return;
        }
        if (dir.exists() && dir.isDirectory()) {
            String[] entries = dir.list();
            for (int i = 0; i < entries.length; ++i) {
                File f = new File(dir.getPath(), entries[i]);
                this._deleteDir(f);
            }
        }
        if (!dir.delete()) {
            Tr.warning(tc, "Failed to clean up the temp directory ", dir);
        }
    }
}

