/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.op;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.op.ClientNotifier;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.op.ExecutionElement;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import com.ibm.wsspi.management.bla.op.OpProgressListener;
import com.ibm.wsspi.management.bla.op.OperationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Operation
extends ExecutionElement {
    private static TraceComponent tc = Tr.register(Operation.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String CLASS_NAME = "com.ibm.wsspi.management.bla.op.Operation";
    protected OperationContext _opContext;
    protected HashMap _opParams;
    protected Object _result;
    protected List<OpProgressListener> _listeners;
    private ClientNotifier _clientNotifier;
    boolean _bFinishCalled = false;

    public Operation(String name) {
        this(name, null, null);
    }

    public Operation(String opName, OperationContext opContext, HashMap params) {
        super(opName);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Operation", new Object[]{opName, opContext, params});
        }
        this._opContext = opContext;
        this._opParams = params;
        this._listeners = new ArrayList<OpProgressListener>();
        this._clientNotifier = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Operation");
        }
    }

    public OperationContext getOpContext() {
        return this._opContext;
    }

    public HashMap getParams() {
        return this._opParams;
    }

    public Object getResult() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResult", new Object[]{this._result});
        }
        return this._result;
    }

    public void setResult(Object result) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setResult", new Object[]{result});
        }
        this._result = result;
    }

    public void addProgressListener(OpProgressListener l) {
        this._listeners.add(l);
        if (l instanceof ClientNotifier) {
            this._clientNotifier = (ClientNotifier)l;
        }
    }

    public boolean removeProgressListener(OpProgressListener l) {
        return this._listeners.remove(l);
    }

    public void notifyListeners() {
        for (OpProgressListener l : this._listeners) {
            l.opCompleted(this);
        }
    }

    public void notifyClient(String message) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyClient", new Object[]{"opName=" + this.getName(), "message=" + message});
        }
        if (this._clientNotifier == null) {
            OpExecutionException oee = new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0175E"));
            throw oee;
        }
        this._clientNotifier.sendNotification(message);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyClient");
        }
    }

    public void execute() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", "opName=" + this.getName());
        }
        try {
            this._status = "st_exec";
            this.doExecute();
        }
        catch (OpExecutionException e) {
            this.setResult(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute: Rethrowing exception: " + e);
            }
            throw e;
        }
        finally {
            try {
                this.notifyListeners();
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception notifying listeners of op completion");
                }
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.wsspi.management.bla.op.Operation.execute", (String)"145", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", "opName=" + this.getName());
        }
    }

    public abstract void doExecute() throws OpExecutionException;

    public void finishOperation() {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "finishOperation", "opName=" + this.getName() + ", status = " + this.getStatus());
            }
            if (this._bFinishCalled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishOperation: already called");
                }
                return;
            }
            this._bFinishCalled = true;
            try {
                this.doFinishOperation();
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error in doFinishOperation: " + th);
                }
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.wsspi.management.bla.op.Operation.finishOperation", (String)"177");
            }
            this._result = "st_done";
            this.setResult(null);
            try {
                String tempDir = this.getOpContext().getTempDir();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting temp dir : " + tempDir);
                }
                if (!UtilHelper.isEmpty(tempDir)) {
                    UtilHelper.deleteDirTree(tempDir);
                }
            }
            catch (Throwable th) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "error deleting temp dir : " + th);
            }
        }
        this.getOpContext().getProps().clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finishOperation", "opName=" + this.getName());
        }
    }

    protected abstract void doFinishOperation();
}

