/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Relationship {
    private static TraceComponent _tc = Tr.register(Relationship.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    public static final String RELATION_PROP_PREFIX = "rel_";
    private Properties _props;
    private ObjectName _target;

    public Relationship(Properties props, ObjectName target) {
        this._props = props;
        if (this._props == null) {
            this._props = new Properties();
        }
        this._target = target;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<Object> en = this._props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = (String)this._props.get(key);
            buf.append("," + key + "=" + val);
        }
        return this._target.toString() + buf.toString();
    }

    public ObjectName getTarget() {
        return this._target;
    }

    public Properties getProps() {
        return this._props;
    }

    public static Relationship getRelationship(String str) throws OpExecutionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRelationship", new Object[]{str});
        }
        try {
            String r = str;
            if (!str.startsWith("WebSphere")) {
                r = "WebSphere:" + str;
            }
            ObjectName on = new ObjectName(r);
            Properties p = new Properties();
            Hashtable<String, String> tbl = new Hashtable<String, String>();
            Hashtable allKeys = on.getKeyPropertyList();
            Enumeration en = allKeys.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String val = (String)allKeys.get(key);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "key=" + key + ",val=" + val);
                }
                if (key.startsWith(RELATION_PROP_PREFIX)) {
                    p.put(key, val);
                    continue;
                }
                tbl.put(key, val);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "p=" + p);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "tbl=" + tbl);
            }
            ObjectName target = new ObjectName(on.getDomain(), tbl);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "target: " + target);
            }
            Relationship rel = new Relationship(p, target);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getRelationship", new Object[]{rel});
            }
            return rel;
        }
        catch (MalformedObjectNameException ex) {
            throw new OpExecutionException(ex);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship r = (Relationship)o;
        return this.getTarget().equals(r.getTarget()) && (this.getProps() == null && r.getProps() == null || r.getProps() != null && this.getProps().equals(r.getProps()));
    }
}

