/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.model.ActivationPlanSpec;
import com.ibm.wsspi.management.bla.model.Relationship;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableUnit {
    private static TraceComponent _tc = Tr.register(DeployableUnit.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private String _name;
    private List<ObjectName> _targets;
    private List<Relationship> _relationships;
    private List<ActivationPlanSpec> _activationPlans;
    private Integer _startingWeight;

    public DeployableUnit(String name) {
        this._name = name;
        this._targets = new ArrayList<ObjectName>();
        this._relationships = new ArrayList<Relationship>();
        this._activationPlans = new ArrayList<ActivationPlanSpec>();
        this._startingWeight = 1;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name.toString();
    }

    public Integer getStartingWeight() {
        return this._startingWeight;
    }

    public void setStartingWeight(Integer weight) {
        this._startingWeight = weight;
    }

    public List<String> listTargets() {
        if (this._targets == null) {
            return null;
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (ObjectName on : this._targets) {
            targets.add(on.toString());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "targets for " + this._name + " :" + targets);
        }
        return targets;
    }

    public void setTargets(List<ObjectName> targets) throws OpExecutionException {
        this._targets = targets;
    }

    public void addTarget(ObjectName target) throws OpExecutionException {
        if (target == null) {
            return;
        }
        if (!this._targets.contains(target)) {
            this._targets.add(target);
        }
    }

    public boolean removeTarget(ObjectName target) throws OpExecutionException {
        if (target == null) {
            return false;
        }
        return this._targets.remove(target);
    }

    public List<String> listRelationships() {
        if (this._relationships == null) {
            return null;
        }
        ArrayList<String> rels = new ArrayList<String>();
        for (Relationship r : this._relationships) {
            rels.add(r.toString());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "relationships for " + this._name + " :" + rels);
        }
        return rels;
    }

    public void setRelationships(List<Relationship> relationships) throws OpExecutionException {
        this._relationships = relationships;
    }

    public void addRelationship(Relationship rel) throws OpExecutionException {
        if (rel == null) {
            return;
        }
        if (!this._relationships.contains(rel)) {
            this._relationships.add(rel);
        }
    }

    public boolean removeRelationship(Relationship rel) throws OpExecutionException {
        if (rel == null) {
            return false;
        }
        return this._relationships.remove(rel);
    }

    public List<String> listActivationPlans() {
        if (this._activationPlans == null) {
            return null;
        }
        ArrayList<String> activationPlans = new ArrayList<String>();
        for (ActivationPlanSpec spec : this._activationPlans) {
            activationPlans.add(spec.toString());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "activationPlans for " + this._name + " :" + activationPlans);
        }
        return activationPlans;
    }

    public void setActivationPlans(List<ActivationPlanSpec> actplans) throws OpExecutionException {
        this._activationPlans = actplans;
    }

    public void addActivationPlan(ActivationPlanSpec actPlan) throws OpExecutionException {
        if (actPlan == null) {
            return;
        }
        if (!this._activationPlans.contains(actPlan)) {
            this._activationPlans.add(actPlan);
        }
    }

    public boolean removeActivationPlan(ActivationPlanSpec actPlan) throws OpExecutionException {
        if (actPlan == null) {
            return false;
        }
        return this._activationPlans.remove(actPlan);
    }
}

