/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlOperationDefinition {
    private static TraceComponent _tc = Tr.register(ControlOperationDefinition.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String CLASS_NAME = "com.ibm.wsspi.management.bla.model.ControlOperationDefinition";
    private String _name;
    private String _description;
    private String _opHandlerID;
    private String _opHandlerDataURI;
    private List<ParameterDefinition> _parameterDefinitions;

    public ControlOperationDefinition(String name, String description, String opHandlerID, String opHandlerDataURI) throws OpExecutionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new Object[]{"name=" + name, "description=" + description, "opHandlerID=" + opHandlerID});
        }
        if (name == null || name.length() == 0 || description == null || description.length() == 0 || opHandlerID == null || opHandlerID.length() == 0) {
            OpExecutionException oee = new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0173E", new Object[]{name, description, opHandlerID}));
            FFDCFilter.processException(oee, "com.ibm.wsspi.management.bla.model.ControlOperationDefinition.<init>", "115");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ControlOperationDefinition: Exception:", oee);
            }
            throw oee;
        }
        this._name = name;
        this._description = description;
        this._opHandlerID = opHandlerID;
        this._opHandlerDataURI = opHandlerDataURI;
        this._parameterDefinitions = new ArrayList<ParameterDefinition>();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ControlOperationDefinition", "<init>");
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getOpHandlerID() {
        return this._opHandlerID;
    }

    public String getOpHandlerDataURI() {
        return this._opHandlerDataURI;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this._parameterDefinitions;
    }

    public ParameterDefinition getParameterDefinition(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        for (ParameterDefinition parameterDefinition : this._parameterDefinitions) {
            if (!parameterName.equals(parameterDefinition.getName())) continue;
            return parameterDefinition;
        }
        return null;
    }

    public void addParameterDefinition(ParameterDefinition newParameterDefinition) throws OpExecutionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addParameterDefinition", "newParamDef=" + newParameterDefinition);
        }
        if (newParameterDefinition == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addParameterDefinition", "Param Def not added: null definition");
            }
            return;
        }
        String newParameterName = newParameterDefinition.getName();
        for (ParameterDefinition existingParameterDefinition : this._parameterDefinitions) {
            if (!newParameterName.equals(existingParameterDefinition.getName())) continue;
            throw new OpExecutionException("Duplicate parameter: " + newParameterName);
        }
        this._parameterDefinitions.add(newParameterDefinition);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addParameterDefinition");
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("opName=");
        buff.append(this._name);
        buff.append(", opDesc=");
        buff.append(this._description);
        buff.append(", opHandlerID=");
        buff.append(this._opHandlerID);
        buff.append(", opHandlerDataURI=");
        buff.append(this._opHandlerDataURI);
        for (ParameterDefinition parameterDefinition : this._parameterDefinitions) {
            buff.append(", Parameter={");
            buff.append(parameterDefinition.toString());
            buff.append("}");
        }
        return buff.toString();
    }

    public static class ParameterDefinition {
        private String _name;
        private String _description;
        private boolean _isRequired;

        public ParameterDefinition(String name, String description, boolean isRequired) throws OpExecutionException {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "ParameterDefinition.<init>", new Object[]{"name=" + name, "description=" + description});
            }
            if (name == null || name.length() == 0 || description == null || description.length() == 0) {
                OpExecutionException oee = new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0174E", new Object[]{name, description}));
                FFDCFilter.processException(oee, "com.ibm.wsspi.management.bla.model.ControlOperationDefinitionParameterDefinition.<init>", "275");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "ParameterDefinition: Exception:", oee);
                }
                throw oee;
            }
            this._name = name;
            this._description = description;
            this._isRequired = isRequired;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return this._description;
        }

        public boolean isRequired() {
            return this._isRequired;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("paramName=");
            buff.append(this._name);
            buff.append(", paramDesc=");
            buff.append(this._description);
            buff.append(", paramIsRequired=");
            buff.append(this._isRequired);
            return buff.toString();
        }
    }
}

