/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CompositionUnitSpec {
    private static TraceComponent _tc = Tr.register(CompositionUnitSpec.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private ObjectName _cuObjectName;

    public CompositionUnitSpec(String name, String version) throws OpExecutionException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("cuname", name);
        table.put("cuedition", version);
        try {
            this._cuObjectName = new ObjectName("WebSphere", table);
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public CompositionUnitSpec(String itcuId) throws OpExecutionException {
        try {
            this._cuObjectName = UtilHelper.completeObjectName(itcuId, "cuname");
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public String getCUName() {
        return this._cuObjectName.getKeyProperty("cuname");
    }

    public String getCUVersion() {
        return this._cuObjectName.getKeyProperty("cuedition");
    }

    public String toString() {
        return this._cuObjectName.toString();
    }

    public ObjectName toObjectName() {
        return this._cuObjectName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositionUnitSpec)) {
            return false;
        }
        CompositionUnitSpec spec = (CompositionUnitSpec)o;
        return spec.getCUName().equals(this.getCUName()) && (spec.getCUVersion() == null && this.getCUVersion() == null || spec.getCUVersion() != null && spec.getCUVersion().equals(this.getCUVersion()));
    }

    public int hashCode() {
        int retVal = 31 * this.getCUName().hashCode();
        String ver = this.getCUVersion();
        if (ver == null) {
            ver = "";
        }
        return retVal += ver.hashCode();
    }

    public String getCompositionUnitXMLURIFromSpec(String cellName) {
        return "cells/" + cellName + "/" + "cus" + "/" + this.getCUName() + "/" + "cver" + "/" + this.getCUVersion() + "/" + "cu.xml";
    }

    public String toStringSkipVersion() {
        if ("BASE".equals(this.getCUVersion())) {
            return UtilHelper.getShortName(this._cuObjectName, "cuname");
        }
        return this._cuObjectName.toString();
    }
}

