/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.model.ModelConfigObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositionUnitRef
extends ModelConfigObject {
    private static TraceComponent _tc = Tr.register(CompositionUnitRef.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    protected List<BLASpec> _parentBLAs;
    protected List<CompositionUnitSpec> _relCUs;

    public CompositionUnitRef(String name, String version) {
        this.setName(name);
        this.setVersion(version);
        this._parentBLAs = new ArrayList<BLASpec>();
        this._relCUs = new ArrayList<CompositionUnitSpec>();
    }

    public List<BLASpec> listParentBLAs() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "listParentBLAs", this._parentBLAs);
        }
        return this._parentBLAs;
    }

    public void setParentBLAs(List<BLASpec> parentBLAs) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setParentBLAs", parentBLAs);
        }
        this._parentBLAs = parentBLAs;
    }

    public void addParentBLA(BLASpec blaSpec) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addParentBLA", "blaSpec=" + blaSpec);
        }
        if (!this._parentBLAs.contains(blaSpec)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setParentBLAs", "Adding BLA as parent.");
            }
            this._parentBLAs.add(blaSpec);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addParentBLA");
        }
    }

    public boolean removeParentBLA(BLASpec bla) {
        boolean ret = false;
        if (this._parentBLAs.contains(bla)) {
            ret = this._parentBLAs.remove(bla);
        }
        return ret;
    }

    public List<CompositionUnitSpec> listRelationshipCUs() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "listRelationshipCUs", this._relCUs);
        }
        return this._relCUs;
    }

    public void setCURels(List<CompositionUnitSpec> relCUs) {
        this._relCUs = relCUs;
    }

    public void addRelationshipCU(CompositionUnitSpec cu) {
        if (!this._relCUs.contains(cu)) {
            this._relCUs.add(cu);
        }
    }

    public boolean removeRelationshipCU(CompositionUnitSpec cu) {
        boolean ret = false;
        if (this._relCUs.contains(cu)) {
            ret = this._relCUs.remove(cu);
        }
        return ret;
    }
}

