/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.model.ActivationPlanSpec;
import com.ibm.wsspi.management.bla.model.CompositionUnitRef;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.model.ControlOperationDefinition;
import com.ibm.wsspi.management.bla.model.DeployableUnit;
import com.ibm.wsspi.management.bla.model.ModelConfigObject;
import com.ibm.wsspi.management.bla.model.Relationship;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositionUnit
extends ModelConfigObject {
    private static TraceComponent tc = Tr.register(CompositionUnit.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String META = "meta";
    private List<DeployableUnit> _deplUnits;
    private HashMap<ObjectName, Properties> _targetProps;
    private String _type;
    private String _metadataURI;
    private String _backingID;
    private String _desc;
    private int _startingWeight;
    private String _binaryURL;
    private List<Relationship> _relationships;
    protected CompositionUnitRef _cuRef;
    private List<ControlOperationDefinition> _controlOperations;
    protected Properties _props;
    protected String _j2eeSourceID;
    protected boolean _hidden;
    protected boolean _startedOnDistributed;
    protected RestartBehaviorUpdate _reStartBehaviorOnUpdate;
    private HashMap _j2eeProps;

    CompositionUnit(String name, String version) {
        this.setName(name);
        this.setVersion(version);
        this._deplUnits = new ArrayList<DeployableUnit>();
        this._metadataURI = META;
        this._binaryURL = "";
        this._startingWeight = 1;
        this._relationships = new ArrayList<Relationship>();
        this._cuRef = new CompositionUnitRef(name, version);
        this._controlOperations = new ArrayList<ControlOperationDefinition>();
        this._props = new Properties();
        this._j2eeSourceID = "";
        this._targetProps = new HashMap();
        this._hidden = false;
        this._startedOnDistributed = false;
        this._reStartBehaviorOnUpdate = RestartBehaviorUpdate.DEFAULT;
        this._j2eeProps = new HashMap();
    }

    CompositionUnit(String name, String version, String backingID) {
        this(name, version);
        this._backingID = backingID;
    }

    public String toString() {
        try {
            return this.getCompositionUnitSpec().toString();
        }
        catch (OpExecutionException opex) {
            return "Error in toString() - " + this.getName() + ", " + this.getVersion();
        }
    }

    public CompositionUnitSpec getCompositionUnitSpec() throws OpExecutionException {
        return new CompositionUnitSpec(this.getName(), this.getVersion());
    }

    public String getBackingID() {
        return this._backingID;
    }

    public void setBackingID(String backingID) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBackingID", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "backingID=" + backingID});
        }
        this._backingID = backingID;
    }

    public String getMetadataUri() {
        return this._metadataURI;
    }

    public void setMetadataUri(String metadataURI) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMetadataUri", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "metadataURI=" + metadataURI});
        }
        this._metadataURI = metadataURI;
    }

    public List<String> listDeplUnits() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listDeplUnits", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion()});
        }
        ArrayList<String> deplUnits = new ArrayList<String>();
        for (DeployableUnit du : this._deplUnits) {
            deplUnits.add(du.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listDeplUnits", deplUnits);
        }
        return deplUnits;
    }

    public void setDeplUnits(List<DeployableUnit> deplUnits) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDeplUnits", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnits=" + deplUnits});
        }
        this._deplUnits = deplUnits;
    }

    public List<String> listTargets(String deplUnit) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTargets(DU)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit});
        }
        DeployableUnit du = this.getDU(deplUnit);
        List<String> targets = du.listTargets();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listTargets(DU)", targets);
        }
        return targets;
    }

    public void setTargets(String deplUnit, List<String> targets) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargets", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "targets=" + targets});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ArrayList<ObjectName> targetONList = new ArrayList<ObjectName>();
        for (String targetString : targets) {
            ObjectName targetON = this.createTargetON(targetString);
            if (!targetONList.contains(targetON)) {
                targetONList.add(targetON);
            }
            if (this._targetProps.containsKey(targetON)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding target props for target " + targetON + " to CU.");
            }
            this._targetProps.put(targetON, this.createTargetDefaultProps());
        }
        du.setTargets(targetONList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargets");
        }
    }

    public void addTarget(String deplUnit, String target) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTarget", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "target=" + target});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ObjectName targetON = this.createTargetON(target);
        du.addTarget(targetON);
        if (!this._targetProps.containsKey(targetON)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding target props for target " + targetON + " to CU.");
            }
            this._targetProps.put(targetON, this.createTargetDefaultProps());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTarget");
        }
    }

    public boolean removeTarget(String deplUnit, String target) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTarget", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "target=" + target});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ObjectName targetON = this.createTargetON(target);
        boolean targetRemoved = du.removeTarget(targetON);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTarget", targetRemoved);
        }
        return targetRemoved;
    }

    public List<String> listRelationships(String deplUnit) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listRelationships(DU)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit});
        }
        DeployableUnit du = this.getDU(deplUnit);
        List<String> rels = du.listRelationships();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listRelationships(DU)", rels);
        }
        return rels;
    }

    public void setRelationships(String deplUnit, List<String> rels) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRelationships(DU)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "rels=" + rels});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relString : rels) {
            ObjectName relON = this.createRelationshipON(relString);
            Relationship rel = Relationship.getRelationship(relON.toString());
            if (relationships.contains(rel)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding relationship " + relON + ".");
            }
            relationships.add(rel);
        }
        du.setRelationships(relationships);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRelationships(DU)");
        }
    }

    public void setRelationships(List<String> rels) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRelationships", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "rels=" + rels});
        }
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relString : rels) {
            ObjectName relON = this.createRelationshipON(relString);
            Relationship rel = Relationship.getRelationship(relON.toString());
            if (relationships.contains(rel)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding relationship " + relON + ".");
            }
            relationships.add(rel);
        }
        for (DeployableUnit du : this._deplUnits) {
            du.setRelationships(relationships);
        }
    }

    public void addRelationship(String deplUnit, String relationship) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRelationship", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "relationship=" + relationship});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ObjectName relON = this.createRelationshipON(relationship);
        Relationship rel = Relationship.getRelationship(relON.toString());
        du.addRelationship(rel);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRelationship");
        }
    }

    public boolean removeRelationship(String deplUnit, String relationship) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRelationship", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "relationship=" + relationship});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ObjectName relON = this.createRelationshipON(relationship);
        Relationship rel = Relationship.getRelationship(relON.toString());
        boolean relationshipRemoved = du.removeRelationship(rel);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRelationship", relationshipRemoved);
        }
        return relationshipRemoved;
    }

    public List<String> listRelationships() {
        if (this._relationships == null) {
            return null;
        }
        ArrayList<String> rels = new ArrayList<String>();
        for (Relationship r : this._relationships) {
            rels.add(r.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "relationships for " + this.getName() + " :" + rels);
        }
        return rels;
    }

    public void setCULevelRelationships(List<String> rels) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRelationships", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "rels=" + rels});
        }
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relString : rels) {
            ObjectName relON = this.createRelationshipON(relString);
            Relationship rel = Relationship.getRelationship(relON.toString());
            if (relationships.contains(rel)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding relationship " + relON + ".");
            }
            relationships.add(rel);
        }
        this._relationships = relationships;
    }

    public void addCULevelRelationship(String relationship) throws OpExecutionException {
        ObjectName relON;
        Relationship rel;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRelationship", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "relationship=" + relationship});
        }
        if (!this._relationships.contains(rel = Relationship.getRelationship((relON = this.createRelationshipON(relationship)).toString()))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding relationship " + relON + " to CU.");
            }
            this._relationships.add(rel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRelationship");
        }
    }

    public boolean removeCULevelRelationship(String relationship) throws OpExecutionException {
        boolean ret = false;
        Relationship rel = Relationship.getRelationship(this.createRelationshipON(relationship).toString());
        if (this._relationships.contains(rel)) {
            ret = this._relationships.remove(rel);
        }
        return ret;
    }

    public List<String> listActivationPlans(String deplUnit) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listActivationPlans(DU)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit});
        }
        DeployableUnit du = this.getDU(deplUnit);
        List<String> actPlans = du.listActivationPlans();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listActivationPlans(DU)", actPlans);
        }
        return actPlans;
    }

    public void setActivationPlans(String deplUnit, List<String> actPlans) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActivationPlans", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "actPlans=" + actPlans});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ArrayList<ActivationPlanSpec> aps = new ArrayList<ActivationPlanSpec>();
        for (String ap : actPlans) {
            ActivationPlanSpec actPlan = new ActivationPlanSpec(ap);
            if (!aps.contains(actPlan) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding activation plan " + actPlan + ".");
            }
            aps.add(actPlan);
        }
        du.setActivationPlans(aps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActivationPlans");
        }
    }

    public void addActivationPlan(String deplUnit, String activationPlan) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActivationPlan", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "activationPlan=" + activationPlan});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ActivationPlanSpec spec = new ActivationPlanSpec(activationPlan);
        du.addActivationPlan(spec);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActivationPlan");
        }
    }

    public boolean removeActivationPlan(String deplUnit, String activationPlan) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeActivationPlan", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "deplUnit=" + deplUnit, "activationPlan=" + activationPlan});
        }
        DeployableUnit du = this.getDU(deplUnit);
        ActivationPlanSpec spec = new ActivationPlanSpec(activationPlan);
        boolean planRemoved = du.removeActivationPlan(spec);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeActivationPlan", planRemoved);
        }
        return planRemoved;
    }

    public List<String> listTargetsForCU() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTargetsForCU", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion()});
        }
        ArrayList<String> targets = new ArrayList<String>();
        List<String> deplUnits = this.listDeplUnits();
        for (String deplUnit : deplUnits) {
            List<String> tgs = this.listTargets(deplUnit);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deplUnit=" + deplUnit + ",targets=" + tgs);
            }
            for (String t : tgs) {
                if (targets.contains(t)) continue;
                targets.add(t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listTargetsForCU", targets);
        }
        return targets;
    }

    public List<String> listRelationshipsForCU() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listRelationshipsForCU", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion()});
        }
        ArrayList<String> relationships = new ArrayList<String>();
        List<String> deplUnits = this.listDeplUnits();
        for (String deplUnit : deplUnits) {
            List<String> rels = this.listRelationships(deplUnit);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deplUnit=" + deplUnit + ",relationships=" + rels);
            }
            for (String r : rels) {
                if (relationships.contains(r)) continue;
                relationships.add(r);
            }
        }
        List<String> cuRels = this.listRelationships();
        for (String r : cuRels) {
            if (relationships.contains(r)) continue;
            relationships.add(r);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listRelationshipsForCU", relationships);
        }
        return relationships;
    }

    public List<String> listActivationPlansForCU() throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listActivationPlansForCU", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion()});
        }
        ArrayList<String> actPlans = new ArrayList<String>();
        List<String> deplUnits = this.listDeplUnits();
        for (String deplUnit : deplUnits) {
            List<String> aps = this.listActivationPlans(deplUnit);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deplUnit=" + deplUnit + ",actPlans=" + aps);
            }
            for (String ap : aps) {
                if (actPlans.contains(ap)) continue;
                actPlans.add(ap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listActivationPlansForCU", actPlans);
        }
        return actPlans;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setType", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "type=" + type});
        }
        this._type = type;
    }

    public String getDescription() {
        return this._desc;
    }

    public void setDescription(String desc) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDescription", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "desc=" + desc});
        }
        this._desc = desc;
    }

    public String getBinaryURL() {
        return this._binaryURL;
    }

    public void setBinaryURL(String binaryURL) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBinaryURL", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "binaryURL=" + binaryURL});
        }
        this._binaryURL = binaryURL;
    }

    public int getStartingWeight() {
        return this._startingWeight;
    }

    public void setStartingWeight(int weight) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStartingWeight", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "weight=" + weight});
        }
        this._startingWeight = weight;
    }

    public void setJ2EESourceID(String j2eeSourceID) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setJ2EESourceID", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "j2eeSourceID=" + j2eeSourceID});
        }
        this._j2eeSourceID = j2eeSourceID;
    }

    public String getJ2EESourceID() {
        return this._j2eeSourceID;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setHidden", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "hidden=" + hidden});
        }
        this._hidden = hidden;
    }

    public boolean isStartedOnDistributed() {
        return this._startedOnDistributed;
    }

    public void setStartedOnDistributed(boolean startedOnDistributed) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStartedOnDistributed", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "startedOnDistributed=" + startedOnDistributed});
        }
        this._startedOnDistributed = startedOnDistributed;
    }

    public RestartBehaviorUpdate getRestartBehaviorOnUpdate() {
        return this._reStartBehaviorOnUpdate;
    }

    public void setRestartBehaviorOnUpdate(RestartBehaviorUpdate startBehaviorOnUpdate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRestartBehaviorOnUpdate", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "startBehaviorOnUpdate=" + (Object)((Object)startBehaviorOnUpdate)});
        }
        if (startBehaviorOnUpdate == null) {
            Tr.exit(tc, "setRestartBehaviorOnUpdate", "Null input parameter.  Nothing set.");
            return;
        }
        this._reStartBehaviorOnUpdate = startBehaviorOnUpdate;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRestartBehaviorOnUpdate");
        }
    }

    public Properties getProps() {
        return this._props;
    }

    public void setProps(Properties props) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setProps", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "props=" + props});
        }
        this._props = props;
    }

    public boolean isAutoStartEnabled(String target) throws OpExecutionException {
        return this.isAutoStartEnabled(this.createTargetON(target));
    }

    public boolean isAutoStartEnabled(ObjectName target) throws OpExecutionException {
        boolean isEnabled;
        Properties props;
        String isEnabledString;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAutoStartEnabled", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target});
        }
        if ((isEnabledString = (props = this.getPropsForExistingTarget(target)).getProperty("enable")) != null) {
            isEnabled = isEnabledString.equals("true");
        } else {
            isEnabled = Boolean.valueOf("true");
            this.setTargetEnableProp(target, isEnabled);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAutoStartEnabled", isEnabled);
        }
        return isEnabled;
    }

    public void setTargetEnableProp(String target, boolean isEnabled) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTargetEnableProp(String)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target, "isEnabled=" + isEnabled});
        }
        this.setTargetEnableProp(this.createTargetON(target), isEnabled);
    }

    public void setTargetEnableProp(ObjectName target, boolean isEnabled) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetEnableProp(ON)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target, "isEnabled=" + isEnabled});
        }
        Properties props = this.getPropsForExistingTarget(target);
        String isEnabledPropVal = isEnabled ? "true" : "false";
        props.setProperty("enable", isEnabledPropVal);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setTargetEnableProp(ON)", "enable=" + isEnabledPropVal);
        }
    }

    public boolean isTargetActive(String target) throws OpExecutionException {
        return this.isTargetActive(this.createTargetON(target));
    }

    public boolean isTargetActive(ObjectName target) throws OpExecutionException {
        Properties props;
        String isActiveString;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetActive", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target});
        }
        boolean isActive = (isActiveString = (props = this.getPropsForExistingTarget(target)).getProperty("active")) != null ? isActiveString.equals(Boolean.TRUE.toString()) : true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTargetActive", isActive);
        }
        return isActive;
    }

    public void setTargetActive(String target, boolean isActive) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTargetActive(String)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target, "isActive=" + isActive});
        }
        this.setTargetActive(this.createTargetON(target), isActive);
    }

    public void setTargetActive(ObjectName target, boolean isActive) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetActive(ON)", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target, "isActive=" + isActive});
        }
        Properties props = this.getPropsForExistingTarget(target);
        String isActivePropVal = isActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        props.setProperty("active", isActivePropVal);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setTargetActive(ON)", "active=" + isActivePropVal);
        }
    }

    public Properties getTargetProps(ObjectName target) {
        if (this._targetProps.containsKey(target)) {
            return this._targetProps.get(target);
        }
        return null;
    }

    public void setTargetProps(ObjectName target, Properties props) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTargetProps", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target, "props=" + props});
        }
        this.getPropsForExistingTarget(target);
        this._targetProps.put(target, props);
    }

    public void addTargetProps(ObjectName target, String propName, String propValue) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTargetProps", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "target=" + target, "propName=" + propName, "propValue=" + propValue});
        }
        Properties props = this.getPropsForExistingTarget(target);
        props.setProperty(propName, propValue);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTargetProps");
        }
    }

    public void addControlOperationDefinition(ControlOperationDefinition newOpDef) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addControlOperationDefinition", new Object[]{"thisCU=" + this.getName() + ", " + this.getVersion(), "newOpDef=" + newOpDef});
        }
        if (newOpDef == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addControlOperationDefinition", "New op not added:  null def.");
            }
            return;
        }
        String newOpName = newOpDef.getName();
        for (ControlOperationDefinition existingOpDef : this._controlOperations) {
            String cuID;
            if (!newOpName.equals(existingOpDef.getName())) continue;
            try {
                cuID = this.getCompositionUnitSpec().toString();
            }
            catch (Exception e) {
                cuID = this.getName();
            }
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0157E", new Object[]{newOpName, cuID}));
        }
        this._controlOperations.add(newOpDef);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addControlOperationDefinition");
        }
    }

    public List<ControlOperationDefinition> getControlOperationDefinitions() throws OpExecutionException {
        return this._controlOperations;
    }

    public ControlOperationDefinition getControlOperationDefinition(String opName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControlOperationDefinition", "opName=" + opName);
        }
        ControlOperationDefinition retDef = null;
        if (opName != null) {
            for (ControlOperationDefinition opDef : this._controlOperations) {
                if (!opName.equals(opDef.getName())) continue;
                retDef = opDef;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getControlOperationDefinition", "opDef=" + retDef);
        }
        return retDef;
    }

    public HashMap getJ2EEProps() {
        return this._j2eeProps;
    }

    public CompositionUnitRef getCURef() {
        return this._cuRef;
    }

    private Properties createTargetDefaultProps() {
        Properties defaultTargetProps = new Properties();
        defaultTargetProps.setProperty("enable", "true");
        defaultTargetProps.setProperty("active", Boolean.TRUE.toString());
        return defaultTargetProps;
    }

    private ObjectName createTargetON(String s) throws OpExecutionException {
        ObjectName on = null;
        try {
            on = new ObjectName(s);
            if (on.getDomain().startsWith("WebSphere:") && on.getKeyProperty("cluster") == null && (on.getKeyProperty("node") == null || on.getKeyProperty("server") == null)) {
                throw new MalformedObjectNameException();
            }
            return on;
        }
        catch (MalformedObjectNameException ex) {
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0108E", new Object[]{s}));
        }
    }

    private ObjectName createRelationshipON(String s) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createRelationshipON: " + s);
        }
        ObjectName on = null;
        try {
            String type = s;
            if (!s.startsWith("WebSphere")) {
                type = "WebSphere:" + s;
            }
            if ((on = new ObjectName(type)).getKeyProperty("cuname") == null) {
                throw new MalformedObjectNameException();
            }
            return on;
        }
        catch (MalformedObjectNameException ex) {
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0153E", new Object[]{s}));
        }
    }

    private ObjectName createActPlanON(String s) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createActPlanON: " + s);
        }
        ObjectName on = null;
        try {
            String type = s;
            if (!s.startsWith("WebSphere")) {
                type = "WebSphere:" + s;
            }
            if ((on = new ObjectName(type)).getKeyProperty("specname") == null) {
                throw new MalformedObjectNameException();
            }
            return on;
        }
        catch (MalformedObjectNameException ex) {
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0156E", new Object[]{s}));
        }
    }

    private DeployableUnit getDU(String deplUnit) throws OpExecutionException {
        DeployableUnit du = null;
        for (DeployableUnit tempDU : this._deplUnits) {
            if (!tempDU.getName().equalsIgnoreCase(deplUnit)) continue;
            du = tempDU;
            break;
        }
        if (du == null) {
            OpExecutionException oee = new OpExecutionException("Deployable unit \"" + deplUnit + "\" not found in composition unit \"" + this.getCompositionUnitSpec() + "\".");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getDU", oee);
            }
            throw oee;
        }
        return du;
    }

    private Properties getPropsForExistingTarget(ObjectName targetON) throws OpExecutionException {
        if (!this._targetProps.containsKey(targetON)) {
            OpExecutionException oee = new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0411E", new Object[]{targetON, this.getCompositionUnitSpec()}));
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getTargetProps", oee);
            }
            throw oee;
        }
        Properties targetProps = this._targetProps.get(targetON);
        return targetProps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RestartBehaviorUpdate {
        ALL,
        DEFAULT,
        NONE;


        public static RestartBehaviorUpdate getRestartType(String type) {
            if (ALL.toString().equalsIgnoreCase(type)) {
                return ALL;
            }
            if (DEFAULT.toString().equalsIgnoreCase(type)) {
                return DEFAULT;
            }
            if (NONE.toString().equalsIgnoreCase(type)) {
                return NONE;
            }
            return null;
        }
    }
}

