/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class BLASpec {
    private static TraceComponent _tc = Tr.register(BLASpec.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private ObjectName _blaObjectName;

    public BLASpec(String name, String version) throws OpExecutionException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("blaname", name);
        table.put("blaedition", version);
        try {
            this._blaObjectName = new ObjectName("WebSphere", table);
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public BLASpec(String blaId) throws OpExecutionException {
        try {
            this._blaObjectName = UtilHelper.completeObjectName(blaId, "blaname");
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public String getBLAName() {
        return this._blaObjectName.getKeyProperty("blaname");
    }

    public String getBLAVersion() {
        return this._blaObjectName.getKeyProperty("blaedition");
    }

    public String toString() {
        return this._blaObjectName.toString();
    }

    public ObjectName toObjectName() {
        return this._blaObjectName;
    }

    public String getBLAXMLURIFromSpec(String cellName) {
        StringBuilder sb = new StringBuilder();
        sb.append("cells/");
        sb.append(cellName);
        sb.append('/');
        sb.append("blas");
        sb.append('/');
        sb.append(this.getBLAName());
        sb.append('/');
        sb.append("bver");
        sb.append('/');
        sb.append(this.getBLAVersion());
        sb.append('/');
        sb.append("bla.xml");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BLASpec)) {
            return false;
        }
        BLASpec spec = (BLASpec)o;
        return spec.getBLAName().equals(this.getBLAName()) && (spec.getBLAVersion() == null && this.getBLAVersion() == null || spec.getBLAVersion() != null && spec.getBLAVersion().equals(this.getBLAVersion()));
    }

    public int hashCode() {
        int retVal = 31 * this.getBLAName().hashCode();
        String ver = this.getBLAVersion();
        if (ver == null) {
            ver = "";
        }
        return retVal += ver.hashCode();
    }

    public String toStringSkipVersion() {
        if ("BASE".equals(this.getBLAVersion())) {
            return UtilHelper.getShortName(this._blaObjectName, "blaname");
        }
        return this._blaObjectName.toString();
    }
}

