/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.model.BLA;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BLAFactory {
    private static TraceComponent tc = Tr.register(BLAFactory.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String BLA_FACTORY_IMPL_NAME = "com.ibm.ws.management.bla.model.BLAFactoryImpl";
    private static BLAFactory _blaFactory = null;

    public static BLAFactory getSingleton() throws OpExecutionException {
        if (_blaFactory == null) {
            try {
                _blaFactory = (BLAFactory)UtilHelper.createFactory(BLA_FACTORY_IMPL_NAME);
            }
            catch (Exception e) {
                throw new OpExecutionException(e.toString());
            }
        }
        return _blaFactory;
    }

    public BLA createBLANew(String name, String version) {
        return new BLA(name, version);
    }

    public abstract BLA readBLAFromBLASpec(BLASpec var1, String var2) throws OpExecutionException;

    public abstract BLA readBLAFromBLASpec(BLASpec var1, ConfigRepository var2) throws OpExecutionException;

    public abstract BLA readBLAFromBLAURI(String var1, ConfigRepository var2) throws OpExecutionException;

    public abstract List<BLASpec> listBLASpecs(String var1, String var2) throws OpExecutionException;

    public abstract List<BLASpec> listBLASpecs(String var1, ConfigRepository var2) throws OpExecutionException;

    public abstract List<BLASpec> listBLASpecs(String var1) throws OpExecutionException;

    public abstract List<BLASpec> listBLASpecs(BLASpec var1, String var2) throws OpExecutionException;

    public abstract List<BLASpec> listBLASpecs(BLASpec var1, ConfigRepository var2) throws OpExecutionException;

    public abstract String getBLAXMLURIFromDocUrl(String var1);

    public abstract BLASpec getBLASpecFromDocUrl(String var1) throws OpExecutionException;
}

