/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.model.BLARef;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.model.ModelConfigObject;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BLA
extends ModelConfigObject {
    private static TraceComponent tc = Tr.register(BLA.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private List<CompositionUnitSpec> _compUnits;
    private String _blaDesc;
    protected Properties _props;
    protected boolean _hidden;
    protected BLARef _blaRef;

    BLA(String name, String version) {
        this.setName(name);
        this.setVersion(version);
        this._compUnits = new ArrayList<CompositionUnitSpec>();
        this._blaRef = new BLARef(name, version);
        this._props = new Properties();
        this._hidden = false;
    }

    public BLASpec getBLASpec() throws OpExecutionException {
        return new BLASpec(this.getName(), this.getVersion());
    }

    public Iterator<CompositionUnitSpec> listCompositionUnits() {
        return this._compUnits.iterator();
    }

    public void addCompositionUnit(CompositionUnit compUnit) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompositionUnit: " + compUnit);
        }
        for (CompositionUnitSpec cuSpec : this._compUnits) {
            if (!compUnit.getCompositionUnitSpec().equals(cuSpec)) continue;
            OpExecutionException oee = new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0167E", new Object[]{cuSpec}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addCompositionUnit", oee);
            }
            throw oee;
        }
        this._compUnits.add(compUnit.getCompositionUnitSpec());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCompositionUnit", "compUnits=" + this._compUnits);
        }
    }

    public boolean removeCompositionUnit(CompositionUnitSpec cuSpec) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCompositionUnit", "cuSpec=" + cuSpec);
        }
        boolean compUnitRemoved = false;
        int index = -1;
        for (int i = 0; i < this._compUnits.size(); ++i) {
            CompositionUnitSpec cSpec = this._compUnits.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cSpec: " + cSpec);
            }
            if (!cuSpec.equals(cSpec)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this._compUnits.remove(index);
            compUnitRemoved = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCompositionUnit", new Object[]{"compUnitRemoved=" + compUnitRemoved, "compUnits=" + this._compUnits});
        }
        return compUnitRemoved;
    }

    public boolean removeCompositionUnit(CompositionUnit compUnit) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCompositionUnit", "compUnit=" + compUnit);
        }
        boolean compUnitRemoved = this.removeCompositionUnit(compUnit.getCompositionUnitSpec());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCompositionUnit", new Object[]{"compUnitRemoved=" + compUnitRemoved, "compUnits=" + this._compUnits});
        }
        return compUnitRemoved;
    }

    public boolean equals(Object thatObj) {
        if (!(thatObj instanceof BLA)) {
            return false;
        }
        BLA thatBLA = (BLA)thatObj;
        return thatBLA.getName().equals(this.getName()) && thatBLA.getVersion().equals(this.getVersion());
    }

    public String toString() {
        try {
            return this.getBLASpec().toString();
        }
        catch (OpExecutionException opex) {
            return "Error in toString() - " + this.getName() + ", " + this.getVersion();
        }
    }

    public String getDescription() {
        return this._blaDesc;
    }

    public void setDescription(String versionDesc) {
        this._blaDesc = versionDesc;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public Properties getProps() {
        return this._props;
    }

    public void setProps(Properties props) {
        this._props = props;
    }

    public BLARef getBLARef() {
        return this._blaRef;
    }
}

