/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AssetSpec {
    private static TraceComponent _tc = Tr.register(AssetSpec.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String ASSET_XML_PATH_1 = "cells/";
    private static final String ASSET_XML_PATH_2 = "/assets/";
    private static final String ASSET_XML_PATH_3 = "/aver/";
    private static final String ASSET_XML_PATH_4 = "/asset.xml";
    private ObjectName _assetObjectName;

    public AssetSpec(String assetName, String assetVersion) throws OpExecutionException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("assetname", assetName);
        table.put("assetversion", assetVersion);
        try {
            this._assetObjectName = new ObjectName("WebSphere", table);
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public AssetSpec(String assetID) throws OpExecutionException {
        try {
            this._assetObjectName = UtilHelper.completeObjectName(assetID, "assetname");
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public String getAssetName() {
        return this._assetObjectName.getKeyProperty("assetname");
    }

    public String getAssetVersion() {
        return this._assetObjectName.getKeyProperty("assetversion");
    }

    public String toString() {
        return this._assetObjectName.toString();
    }

    public String toStringSkipVersion() {
        if ("BASE".equals(this.getAssetVersion())) {
            return UtilHelper.getShortName(this._assetObjectName, "assetname");
        }
        return this._assetObjectName.toString();
    }

    public ObjectName toObjectName() {
        return this._assetObjectName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AssetSpec)) {
            return false;
        }
        AssetSpec spec = (AssetSpec)o;
        return spec.getAssetName().equals(this.getAssetName()) && (spec.getAssetVersion() == null && this.getAssetVersion() == null || spec.getAssetVersion() != null && spec.getAssetVersion().equals(this.getAssetVersion()));
    }

    public int hashCode() {
        int retVal = 31 * this.getAssetName().hashCode();
        String ver = this.getAssetVersion();
        if (ver == null) {
            ver = "";
        }
        return retVal += ver.hashCode();
    }

    public String getAssetXMLURIFromSpec(String cellName) {
        return ASSET_XML_PATH_1 + cellName + ASSET_XML_PATH_2 + this.getAssetName() + ASSET_XML_PATH_3 + this.getAssetVersion() + ASSET_XML_PATH_4;
    }
}

