/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.framework.DeployableObject;
import com.ibm.wsspi.management.bla.model.Asset;
import com.ibm.wsspi.management.bla.model.AssetFactory;
import com.ibm.wsspi.management.bla.model.AssetIn;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import com.ibm.wsspi.management.bla.op.OperationContext;

public abstract class AssetInFactory {
    private static TraceComponent _tc = Tr.register(AssetInFactory.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String ASSETIN_FACTORY_IMPL_NAME = "com.ibm.ws.management.bla.model.AssetInFactoryImpl";
    private static AssetInFactory _assetInFactory = null;

    public static synchronized AssetInFactory getSingleton() throws OpExecutionException {
        if (_assetInFactory == null) {
            try {
                _assetInFactory = (AssetInFactory)UtilHelper.createFactory(ASSETIN_FACTORY_IMPL_NAME);
            }
            catch (Exception ex) {
                Tr.debug(_tc, "Exception in AssetInFactory.getSingleton()", ex);
                FFDCFilter.processException(ex, "AssetInFactory.getSingleton", "45");
            }
        }
        return _assetInFactory;
    }

    public abstract AssetIn createAssetInNew(String var1, Asset var2, OperationContext var3) throws OpExecutionException;

    public AssetIn readAssetInFromAssetSpec(AssetSpec spec, OperationContext opCtx) throws OpExecutionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readAssetInFromAssetSpec", new Object[]{spec, opCtx});
        }
        Asset asset = AssetFactory.getSingleton().readAssetFromAssetSpec(spec, opCtx.getSessionID());
        AssetIn in = this.readAssetInFromAssetDeployed(asset, opCtx);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readAssetInFromAssetSpec", new Object[]{in});
        }
        return in;
    }

    public abstract AssetIn readAssetInFromAssetDeployed(Asset var1, OperationContext var2) throws OpExecutionException;

    public abstract AssetIn createAssetInForUpdate(DeployableObject var1, Asset var2, OperationContext var3) throws OpExecutionException;
}

