/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.model.Asset;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssetFactory {
    private static TraceComponent _tc = Tr.register(AssetFactory.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String ASSET_FACTORY_IMPL_NAME = "com.ibm.ws.management.bla.model.AssetFactoryImpl";
    private static AssetFactory _assetFactory = null;

    public static synchronized AssetFactory getSingleton() throws OpExecutionException {
        if (_assetFactory == null) {
            try {
                _assetFactory = (AssetFactory)UtilHelper.createFactory(ASSET_FACTORY_IMPL_NAME);
            }
            catch (Exception ex) {
                Tr.debug(_tc, "Exception in AssetFactory.getSingleton()", ex);
                FFDCFilter.processException(ex, "AssetFactory.getSingleton", "55");
            }
        }
        return _assetFactory;
    }

    public Asset createAssetNew(String name, String version) throws OpExecutionException {
        return new Asset(name, version);
    }

    public abstract Asset readAssetFromAssetSpec(AssetSpec var1, String var2) throws OpExecutionException;

    public abstract Asset readAssetFromAssetSpec(AssetSpec var1, ConfigRepository var2) throws OpExecutionException;

    public abstract Asset readAssetFromAssetURI(String var1, ConfigRepository var2) throws OpExecutionException;

    public abstract List<AssetSpec> listAssetSpecs(String var1, String var2) throws OpExecutionException;

    public abstract List<AssetSpec> listAssetSpecs(String var1, ConfigRepository var2) throws OpExecutionException;

    public abstract List<AssetSpec> listAssetSpecs(String var1) throws OpExecutionException;

    public abstract List<AssetSpec> listAssetSpecs(AssetSpec var1, String var2) throws OpExecutionException;

    public abstract List<AssetSpec> listAssetSpecs(AssetSpec var1, ConfigRepository var2) throws OpExecutionException;

    public abstract String getAssetXMLURIFromDocUrl(String var1);

    public abstract AssetSpec getAssetSpecFromDocUrl(String var1) throws OpExecutionException;

    public abstract String getAssetXMLURIFromAssetSpec(AssetSpec var1, String var2) throws OpExecutionException;
}

