/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.model.AssetRef;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.model.ModelConfigObject;
import com.ibm.wsspi.management.bla.model.Relationship;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Asset
extends ModelConfigObject {
    private static TraceComponent tc = Tr.register(Asset.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String SpecAttr = "spec";
    private static final String VersionAttr = "version";
    protected String _assetURI;
    protected String _assetDestinationURI;
    protected List<String> _typeAspects;
    protected AssetStorageType _assetStorageType;
    protected List<String> _deplUnits;
    protected List<Relationship> _relationships;
    protected String _assetDesc;
    protected String _filePermission;
    protected String _expansionFlag;
    protected AssetRef _assetRef;
    protected List<String> _defaultBindingProps;
    protected Properties _props;
    protected boolean _hidden;
    protected HashMap _j2eeProps;

    Asset(String name, String version) throws OpExecutionException {
        this.setName(name);
        this.setVersion(version);
        this._typeAspects = new ArrayList<String>();
        this._deplUnits = new ArrayList<String>();
        this._relationships = new ArrayList<Relationship>();
        this._assetStorageType = AssetStorageType.FULL;
        this._filePermission = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755";
        this._expansionFlag = "-1";
        this._assetRef = new AssetRef(name, version);
        this._defaultBindingProps = new ArrayList<String>();
        this._props = new Properties();
        this._j2eeProps = new HashMap();
        this._hidden = false;
    }

    public String getAssetDestinationURI() {
        ApplicationDeployment appD = this.getJ2EEAppDeployment();
        if (appD != null) {
            return appD.getBinariesURL();
        }
        return this._assetDestinationURI;
    }

    public void setAssetDestinationURI(String destinationURI) {
        this._assetDestinationURI = destinationURI;
    }

    public AssetSpec getAssetSpec() throws OpExecutionException {
        return new AssetSpec(this.getName(), this.getVersion());
    }

    public AssetStorageType getAssetStorageType() {
        ApplicationDeployment appD = this.getJ2EEAppDeployment();
        if (appD != null) {
            if (appD.isZeroEarCopy() || appD.isZeroBinaryCopy()) {
                return AssetStorageType.NONE;
            }
            return AssetStorageType.FULL;
        }
        return this._assetStorageType;
    }

    public void setAssetStorageType(AssetStorageType storageType) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "storageType: " + (Object)((Object)storageType));
        }
        if (storageType == null) {
            return;
        }
        if (storageType.equals((Object)this._assetStorageType)) {
            return;
        }
        if (this._assetStorageType.equals((Object)AssetStorageType.FULL)) {
            this._assetStorageType = storageType;
        } else if (this._assetStorageType.equals((Object)AssetStorageType.METADATA)) {
            if (AssetStorageType.FULL.equals((Object)storageType)) {
                throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0140E", new Object[]{this._assetStorageType, storageType}));
            }
            this._assetStorageType = storageType;
        } else if (this._assetStorageType.equals((Object)AssetStorageType.NONE)) {
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0140E", new Object[]{this._assetStorageType, storageType}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_assetStorageType: " + (Object)((Object)this._assetStorageType));
        }
    }

    public String getAssetURI() {
        if (this._assetURI == null) {
            return "bin/" + this.getName();
        }
        return this._assetURI;
    }

    public void setAssetURI(String _asseturi) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "....... calling setAssetURI : " + _asseturi);
        }
        this._assetURI = _asseturi;
    }

    public List<String> listDeplUnits() {
        ApplicationDeployment appD = this.getJ2EEAppDeployment();
        if (appD != null) {
            ArrayList<String> deplUnits = new ArrayList<String>();
            for (int i = 0; i < appD.getModules().size(); ++i) {
                ModuleDeployment moduleD = (ModuleDeployment)appD.getModules().get(i);
                deplUnits.add(moduleD.getUri());
            }
            return deplUnits;
        }
        return this._deplUnits;
    }

    public void setDeplUnits(List<String> deplUnits) {
        this._deplUnits = deplUnits;
    }

    public void addDeplUnit(String deplUnit) {
        this._deplUnits.add(deplUnit);
    }

    public boolean removeDelpUnit(String deplUnit) {
        return this._deplUnits.remove(deplUnit);
    }

    public List<String> listTypeAspects() {
        return this._typeAspects;
    }

    public void setTypeAspects(List<String> typeAspects) throws OpExecutionException {
        ArrayList<String> tAs = new ArrayList<String>();
        for (String ta : typeAspects) {
            tAs.add(this.createTypeAspectON(ta).toString());
        }
        this._typeAspects = tAs;
    }

    public void addTypeAspect(String ta) throws OpExecutionException {
        if (UtilHelper.isEmpty(ta)) {
            return;
        }
        String typeAspect = this.createTypeAspectON(ta).toString();
        if (!this._typeAspects.contains(typeAspect)) {
            this._typeAspects.add(typeAspect);
        }
    }

    public boolean removeTypeAspect(String ta) throws OpExecutionException {
        ObjectName on = this.createTypeAspectON(ta);
        int index = -1;
        for (int i = 0; i < this._typeAspects.size(); ++i) {
            String tA = this._typeAspects.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ta: " + tA);
            }
            if (!this.createTypeAspectON(tA).equals(on)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        this._typeAspects.remove(index);
        return true;
    }

    public List<String> listRelationships() {
        ArrayList<String> rels = new ArrayList<String>();
        for (Relationship r : this._relationships) {
            rels.add(r.toString());
        }
        return rels;
    }

    public void setRelationships(List<String> rels) throws OpExecutionException {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String r : rels) {
            Relationship rel = Relationship.getRelationship(this.createRelationshipON(r).toString());
            relationships.add(rel);
        }
        this._relationships = relationships;
    }

    public void addRelationship(String r) throws OpExecutionException {
        if (UtilHelper.isEmpty(r)) {
            return;
        }
        Relationship rel = Relationship.getRelationship(this.createRelationshipON(r).toString());
        if (!this._relationships.contains(rel)) {
            this._relationships.add(rel);
        }
    }

    public boolean removeRelationship(String r) throws OpExecutionException {
        return this._relationships.remove(Relationship.getRelationship(this.createRelationshipON(r).toString()));
    }

    public String getDescription() {
        return this._assetDesc;
    }

    public void setDescription(String desc) {
        this._assetDesc = desc;
    }

    public String getFilePermission() {
        ApplicationDeployment appD = this.getJ2EEAppDeployment();
        if (appD != null) {
            return appD.getFilePermission();
        }
        return this._filePermission;
    }

    public void setFilePermission(String permission) {
        this._filePermission = permission;
    }

    public String getExpansionFlag() {
        return this._expansionFlag;
    }

    public void setExpansionFlag(String flag) {
        this._expansionFlag = flag;
    }

    public List<String> listDefaultBindingProps() {
        return this._defaultBindingProps;
    }

    public void addDefaultBindingProps(String dftBindingProp) {
        this._defaultBindingProps.add(dftBindingProp);
    }

    public void removeDefaultBindingProps(String dftBindingProp) {
        if (this._defaultBindingProps.contains(dftBindingProp)) {
            this._defaultBindingProps.remove(dftBindingProp);
        }
    }

    public void setDefaultBindingProps(List<String> dftBindingProps) {
        this._defaultBindingProps = dftBindingProps;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public Properties getProps() {
        return this._props;
    }

    public void setProps(Properties props) {
        this._props = props;
    }

    public HashMap getJ2EEProps() {
        return this._j2eeProps;
    }

    public AssetRef getAssetRef() {
        return this._assetRef;
    }

    private ObjectName createTypeAspectON(String s) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createTypeAspectON: " + s);
        }
        ObjectName on = null;
        try {
            String type = s;
            if (!s.startsWith("WebSphere")) {
                type = "WebSphere:" + s;
            }
            if ((on = new ObjectName(type)).getKeyProperty(SpecAttr) == null) {
                throw new MalformedObjectNameException();
            }
            return on;
        }
        catch (MalformedObjectNameException ex) {
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0125E"));
        }
    }

    private ObjectName createRelationshipON(String relString) throws OpExecutionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createRelationshipON: " + relString);
        }
        ObjectName on = null;
        try {
            String tempRelString = relString;
            if (!tempRelString.startsWith("WebSphere")) {
                tempRelString = "WebSphere:" + tempRelString;
            }
            if ((on = new ObjectName(tempRelString)).getKeyProperty("assetname") == null) {
                throw new MalformedObjectNameException();
            }
            return on;
        }
        catch (MalformedObjectNameException ex) {
            throw new OpExecutionException(UtilHelper.getMessage(UtilHelper.getBundle("com.ibm.ws.management.bla.resources.BLAMessages", null), "CWWMH0152E", new Object[]{relString}));
        }
    }

    private ApplicationDeployment getJ2EEAppDeployment() {
        if (this._j2eeProps.containsKey("__j2ee_app_deployment")) {
            return (ApplicationDeployment)this._j2eeProps.get("__j2ee_app_deployment");
        }
        return null;
    }

    public String toString() {
        try {
            return this.getAssetSpec().toString();
        }
        catch (OpExecutionException opex) {
            return "Error in toString() - " + this.getName() + ", " + this.getVersion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssetStorageType {
        FULL,
        METADATA,
        NONE;


        public static AssetStorageType getAssetStorageType(String type) {
            if (FULL.toString().equalsIgnoreCase(type)) {
                return FULL;
            }
            if (METADATA.toString().equalsIgnoreCase(type)) {
                return METADATA;
            }
            if (NONE.toString().equalsIgnoreCase(type)) {
                return NONE;
            }
            return null;
        }
    }
}

