/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.model;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ActivationPlanSpec {
    private static TraceComponent _tc = Tr.register(ActivationPlanSpec.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private ObjectName _actPlanObjectName;

    public ActivationPlanSpec(String planName, String planVersion) throws OpExecutionException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "planName: " + planName + ", planVersion: " + planVersion);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("specname", planName);
        if (planVersion != null) {
            table.put("specversion", planVersion);
        }
        try {
            this._actPlanObjectName = new ObjectName("WebSphere", table);
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public ActivationPlanSpec(String planString) throws OpExecutionException {
        try {
            this._actPlanObjectName = UtilHelper.completeObjectName(planString, "specname");
        }
        catch (MalformedObjectNameException moex) {
            throw new OpExecutionException(moex);
        }
    }

    public String getSpecName() {
        return this._actPlanObjectName.getKeyProperty("specname");
    }

    public String getSpecVersion() {
        return this._actPlanObjectName.getKeyProperty("specversion");
    }

    public String toString() {
        return this._actPlanObjectName.toString();
    }

    public ObjectName toObjectName() {
        return this._actPlanObjectName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActivationPlanSpec)) {
            return false;
        }
        ActivationPlanSpec spec = (ActivationPlanSpec)o;
        return spec.getSpecName().equals(this.getSpecName()) && (spec.getSpecVersion() == null && this.getSpecVersion() == null || spec.getSpecVersion() != null && spec.getSpecVersion().equals(this.getSpecVersion()));
    }

    public int hashCode() {
        int retVal = 31 * this.getSpecName().hashCode();
        String ver = this.getSpecVersion();
        if (ver == null) {
            ver = "";
        }
        return retVal += ver.hashCode();
    }
}

