/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.cdr;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.cdr.ConfigAttribute;
import com.ibm.wsspi.management.bla.cdr.ConfigDescriptor;
import com.ibm.wsspi.management.bla.cdr.ConfigIdentifier;
import com.ibm.wsspi.management.bla.cdr.ConfigValue;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;

public class ConfigStep
extends ConfigAttribute {
    protected ConfigDescriptor[] _columns;
    protected List _data;
    protected boolean _enableAddRow = false;
    protected boolean _enableStep = true;
    private static TraceComponent tc = Tr.register(ConfigStep.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public ConfigStep(ConfigDescriptor desc, ConfigDescriptor[] columns) {
        super(desc);
        this._columns = columns;
        this._data = new ArrayList();
    }

    public ConfigDescriptor[] getColumns() {
        return this._columns;
    }

    public ConfigValue[][] getData() {
        ConfigValue[][] vals = new ConfigValue[this._data.size()][];
        for (int i = 0; i < this._data.size(); ++i) {
            vals[i] = (ConfigValue[])this._data.get(i);
        }
        return vals;
    }

    public void addRow(ConfigValue[] rowData) {
        if (rowData == null) {
            return;
        }
        if (rowData.length != this._columns.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addRow ignored as rowData not same size as cols");
            }
            return;
        }
        this._data.add(rowData);
    }

    public String toString() {
        return "<ConfigStep>" + super.toString() + "::" + this._columns + "::" + this._data + "</ConfigStep>";
    }

    public void setEnableAddRow(boolean addRow) {
        this._enableAddRow = addRow;
    }

    public boolean isEnableAddRow() {
        return this._enableAddRow;
    }

    public void setEnable(boolean enable) {
        this._enableStep = enable;
    }

    public boolean isEnable() {
        return this._enableStep;
    }

    public boolean isValid() {
        return true;
    }

    public void validate(List list, Hashtable validateOps) {
    }

    public boolean hasChanged() {
        return this.hasChanged(false);
    }

    public boolean hasChanged(boolean includedNonMutable) {
        for (int i = 0; i < this._data.size(); ++i) {
            ConfigValue[] vals = (ConfigValue[])this._data.get(i);
            for (int j = 0; j < vals.length; ++j) {
                if (!includedNonMutable && !Boolean.TRUE.equals(this._columns[j].getProperties().get("attr:mutable")) || !vals[j].hasChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public void populateMessages() {
        String idStep;
        ResourceBundle res = this._descriptor.getConfigIdentifier().getResourceBundle();
        String title = UtilHelper.getMessage(res, (idStep = this._descriptor.getConfigIdentifier().getId()) + ".title");
        if (title == null) {
            title = UtilHelper.getMessage(res, idStep + ".goalTitle");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "title: " + title);
        }
        this._descriptor.getConfigIdentifier().setTitle(title);
        String desc = UtilHelper.getMessage(res, idStep + ".description");
        if (desc == null) {
            desc = UtilHelper.getMessage(res, idStep + ".goalMessage");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "description: " + desc);
        }
        this._descriptor.getConfigIdentifier().setDescription(desc);
        for (int i = 0; i < this._columns.length; ++i) {
            ConfigIdentifier ciCol = this._columns[i].getConfigIdentifier();
            if (ciCol == null) continue;
            String idCol = ciCol.getId();
            title = UtilHelper.getMessage(res, idStep + "." + idCol + ".title");
            if (title == null) {
                title = UtilHelper.getMessage(res, idCol + ".column");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "colName: " + title);
            }
            ciCol.setTitle(title);
            desc = UtilHelper.getMessage(res, idStep + "." + idCol + ".description");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "colDesc: " + desc);
            }
            ciCol.setDescription(desc);
        }
    }
}

