/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.cdr;

import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.cdr.ConfigAttribute;
import com.ibm.wsspi.management.bla.cdr.ConfigDescriptor;
import com.ibm.wsspi.management.bla.cdr.ConfigIdentifier;
import com.ibm.wsspi.management.bla.cdr.ConfigOption;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigOptionGroup
extends ConfigAttribute {
    protected ConfigOption _lockingOption;
    protected List<ConfigOption> _configOptions;

    public ConfigOptionGroup(ConfigDescriptor desc, ConfigOption lockingOption) {
        super(desc);
        this._lockingOption = lockingOption;
        this._configOptions = new ArrayList<ConfigOption>();
    }

    public ConfigOption getLockingOption() {
        return this._lockingOption;
    }

    public List<ConfigOption> getConfigOptions() {
        return this._configOptions;
    }

    @Override
    public String toString() {
        return "<ConfigOptionGroup>" + super.toString() + "::" + this._lockingOption + "::" + this._configOptions + "</ConfigOptionGroup>";
    }

    @Override
    public boolean isValid() {
        boolean isValid = this._lockingOption.isValid();
        if (!isValid) {
            return false;
        }
        for (int i = 0; i < this._configOptions.size(); ++i) {
            if (this._configOptions.get(i).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate(List list, Hashtable validateOps) {
        this._lockingOption.validate(list, validateOps);
        for (int i = 0; i < this._configOptions.size(); ++i) {
            this._configOptions.get(i).validate(list, validateOps);
        }
    }

    @Override
    public boolean hasChanged() {
        if (this._lockingOption.hasChanged()) {
            return true;
        }
        for (int i = 0; i < this._configOptions.size(); ++i) {
            if (!this._configOptions.get(i).hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void populateMessages() {
        String id;
        ResourceBundle res = this._descriptor.getConfigIdentifier().getResourceBundle();
        String title = UtilHelper.getMessage(res, (id = this._descriptor.getConfigIdentifier().getId()) + ".title");
        if (title == null) {
            title = UtilHelper.getMessage(res, id + ".column");
        }
        this._descriptor.getConfigIdentifier().setTitle(title);
        String desc = UtilHelper.getMessage(res, id + ".description");
        this._descriptor.getConfigIdentifier().setDescription(desc);
        String lockingOptId = this._lockingOption.getDescriptor().getConfigIdentifier().getId();
        String lockingOptTitle = UtilHelper.getMessage(res, lockingOptId + ".title");
        if (lockingOptTitle == null) {
            lockingOptTitle = UtilHelper.getMessage(res, lockingOptId + ".column");
        }
        this._lockingOption.getDescriptor().getConfigIdentifier().setTitle(lockingOptTitle);
        String lockingOptDesc = UtilHelper.getMessage(res, lockingOptId + ".description");
        this._lockingOption.getDescriptor().getConfigIdentifier().setDescription(desc);
        for (int i = 0; i < this._configOptions.size(); ++i) {
            ConfigIdentifier ciOpt = this._configOptions.get((int)i)._descriptor.getConfigIdentifier();
            if (ciOpt == null) continue;
            String idOption = ciOpt.getId();
            title = UtilHelper.getMessage(res, id + "." + idOption + ".title");
            if (title == null) {
                title = UtilHelper.getMessage(res, idOption + ".column");
            }
            ciOpt.setTitle(title);
            desc = UtilHelper.getMessage(res, id + "." + idOption + ".description");
            ciOpt.setDescription(desc);
        }
    }
}

