/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.cdr;

import com.ibm.wsspi.management.bla.cdr.ConfigValue;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ConfigMultiValue
extends ConfigValue {
    protected String _delimiter;
    protected List _values;
    boolean _ignoreDups = true;

    public ConfigMultiValue(String delim, boolean iDups) {
        super(null);
        this._delimiter = delim;
        this._ignoreDups = iDups;
        this._values = new ArrayList();
    }

    public ConfigMultiValue(String[] vals, String delim, boolean iDups) {
        super(null);
        this._delimiter = delim;
        this._ignoreDups = iDups;
        this._values = this.convertToList(vals, this._ignoreDups);
    }

    private List convertToList(String[] vals, boolean iDups) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (vals == null) {
            return retVal;
        }
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null || iDups && retVal.contains(vals[i])) continue;
            retVal.add(vals[i]);
        }
        return retVal;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public String getValueStr() {
        if (this._values.size() == 0) {
            return null;
        }
        String s = "";
        String delimiter = "";
        for (int i = 0; i < this._values.size(); ++i) {
            s = i == 0 ? s + this._values.get(i) : s + this._delimiter + this._values.get(i);
        }
        return s;
    }

    public void setValueStr(String valStr) {
        if (valStr == null) {
            if (this._values.size() > 0) {
                this._values.clear();
                this._hasChanged = true;
            }
        } else {
            this.setValues(valStr.split(this._delimiter));
        }
    }

    public String[] getValues() {
        Object[] obj = this._values.toArray();
        String[] ret = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = obj[i].toString();
        }
        return ret;
    }

    public void setValues(String[] vals) {
        if (vals == null) {
            this.setValueStr(null);
            return;
        }
        List input = this.convertToList(vals, this._ignoreDups);
        if (input.size() != this._values.size()) {
            this._values = input;
            this._hasChanged = true;
            return;
        }
        ArrayList copyValues = new ArrayList(this._values);
        boolean isSame = true;
        for (int i = 0; i < input.size(); ++i) {
            int index = copyValues.indexOf(input.get(i));
            if (index == -1) {
                isSame = false;
                break;
            }
            copyValues.remove(index);
        }
        if (!isSame) {
            this._values = input;
            this._hasChanged = true;
            return;
        }
    }

    public void addValue(String val) {
        if (val == null) {
            return;
        }
        if (this._ignoreDups && this._values.contains(val)) {
            return;
        }
        this._values.add(val);
        this._hasChanged = true;
    }

    public boolean removeValue(String s) {
        int origSize = this._values.size();
        boolean b = true;
        while (b) {
            b = this._values.remove(s);
        }
        this._hasChanged = this._values.size() != origSize;
        return b;
    }

    public void validate(List list, Hashtable validateOps) {
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "<ConfigMultiValue>" + super.toString() + "::" + this._delimiter + "::" + this._values + "</ConfigMultiValue>";
    }

    public boolean isIgnoreDups() {
        return this._ignoreDups;
    }

    public void setIgnoreDups(boolean ignoreDups) {
        this._ignoreDups = ignoreDups;
    }
}

