/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.bla.cdr;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.management.bla.cdr.ConfigAttribute;
import com.ibm.wsspi.management.bla.cdr.ConfigDescriptor;
import com.ibm.wsspi.management.bla.cdr.ConfigIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigData {
    private static TraceComponent tc = Tr.register(ConfigData.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    ConfigDataUnit _currUnit = null;
    String defaultScope = "defaultScope";

    public void addData(ConfigAttribute attr, String scopeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addData  attr: " + attr + " scope: " + scopeName);
        }
        if (this._currUnit == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create new _currUnit");
            }
            this._currUnit = new ConfigDataUnit();
        }
        scopeName = scopeName == null ? this.defaultScope : scopeName;
        this._currUnit.addData(attr, scopeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addData");
        }
    }

    public boolean removeData(String idPat, String scopePat) {
        return this._currUnit == null ? false : this._currUnit.removeData(idPat, scopePat);
    }

    public void currentUICompleted() {
        this._currUnit = null;
    }

    public boolean uiOutStanding() {
        return this._currUnit != null && this._currUnit.listScopes().size() != 0;
    }

    public List<String> listScopesForUI() {
        return this._currUnit == null ? new ArrayList() : this._currUnit.listScopes();
    }

    public List<String> listAllScopes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllScopes");
        }
        ArrayList<String> retVal = new ArrayList<String>();
        List<String> scopes = this._currUnit.listScopes();
        for (int j = 0; j < scopes.size(); ++j) {
            if (retVal.contains(scopes.get(j))) continue;
            retVal.add(scopes.get(j));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllScopes");
        }
        return retVal;
    }

    public List<ConfigAttribute> getDataForUI() {
        return this.getDataForUI(".*", ".*");
    }

    public List<ConfigAttribute> getDataForUI(String idPattern, String scopePattern) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataForUI: " + idPattern + ", cdScope=" + scopePattern);
        }
        ArrayList<ConfigAttribute> retVal = new ArrayList<ConfigAttribute>();
        if (this._currUnit == null) {
            return retVal;
        }
        this._currUnit.queryData(this.getConfigAttr(idPattern), scopePattern, retVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataForUI");
        }
        return retVal;
    }

    public List<ConfigAttribute> queryData(String idPattern, String scopePattern) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryData: " + idPattern + ", cdScope=" + scopePattern);
        }
        ArrayList<ConfigAttribute> retVal = new ArrayList<ConfigAttribute>();
        ConfigAttribute attr = this.getConfigAttr(idPattern);
        this._currUnit.queryData(attr, scopePattern, retVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryData");
        }
        return retVal;
    }

    private ConfigAttribute getConfigAttr(String idPattern) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigAttr");
        }
        ConfigDescriptor desc = new ConfigDescriptor(new ConfigIdentifier(idPattern));
        desc.getProperties().clear();
        ConfigAttribute attr = new ConfigAttribute(desc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigAttr");
        }
        return attr;
    }

    public void printAllConfigData() {
        System.out.println("<ConfigData>");
        System.out.println("\t<ConfigDataUnit>");
        this._currUnit.printConfigData("\t\t");
        System.out.println("\t</ConfigDataUnit>");
        System.out.println("</ConfigData>");
    }

    public void cleanup() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigDataUnit {
        Hashtable _data = new Hashtable();
        Hashtable _orderdata = new Hashtable();

        void addData(ConfigAttribute attr, String scopeName) {
            Hashtable<String, ConfigAttribute> mTbl = (Hashtable<String, ConfigAttribute>)this._data.get(scopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mTbl: " + mTbl);
            }
            if (mTbl == null) {
                mTbl = new Hashtable<String, ConfigAttribute>();
                this._data.put(scopeName, mTbl);
            }
            mTbl.put(attr.getDescriptor().getConfigIdentifier().getId(), attr);
            Vector<String> vTbl = (Vector<String>)this._orderdata.get(scopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "vTbl: " + vTbl);
            }
            if (vTbl == null) {
                vTbl = new Vector<String>();
                this._orderdata.put(scopeName, vTbl);
            }
            vTbl.add(attr.getDescriptor().getConfigIdentifier().getId());
        }

        boolean removeData(String idPat, String scopePat) {
            boolean retVal = false;
            Enumeration mKeys = this._data.keys();
            while (mKeys.hasMoreElements()) {
                String mUri = (String)mKeys.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mUri: " + mUri);
                }
                if (!mUri.matches(scopePat)) continue;
                Hashtable iTbl = (Hashtable)this._data.get(mUri);
                Vector oTbl = (Vector)this._orderdata.get(mUri);
                Enumeration iKeys = iTbl.keys();
                ArrayList l = new ArrayList();
                ArrayList<String> orderl = new ArrayList<String>();
                while (iKeys.hasMoreElements()) {
                    String id = (String)iKeys.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "id: " + id);
                    }
                    if (!id.matches(idPat)) continue;
                    l.add(iTbl.get(id));
                    orderl.add(id);
                }
                for (int i = 0; i < l.size(); ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove id: " + l.get(i));
                    }
                    iTbl.remove(l.get(i));
                    oTbl.remove(orderl.get(i));
                    retVal = true;
                }
            }
            return retVal;
        }

        List<String> listScopes() {
            ArrayList<String> retVal = new ArrayList<String>();
            retVal.addAll(this._data.keySet());
            return retVal;
        }

        public void printConfigData(String indent) {
            Enumeration mKeys = this._data.keys();
            while (mKeys.hasMoreElements()) {
                String mUri = (String)mKeys.nextElement();
                System.out.println(indent + "\t\t<Scope=" + mUri + ">");
                Hashtable iTbl = (Hashtable)this._data.get(mUri);
                Enumeration iKeys = iTbl.keys();
                while (iKeys.hasMoreElements()) {
                    String id = (String)iKeys.nextElement();
                    System.out.println(indent + "\t\t\t<id=" + id + ">");
                    System.out.println(iTbl.get(id));
                    System.out.println(indent + "\t\t\t</id=" + id + ">");
                }
                System.out.println("\t\t</Scope=" + mUri + ">");
            }
        }

        List<ConfigAttribute> queryData(ConfigAttribute attrPattern, String scopePattern, List<ConfigAttribute> retVal) {
            String idPattern;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "queryData: " + attrPattern + ", scopePattern=" + scopePattern);
            }
            if ((idPattern = attrPattern.getDescriptor().getConfigIdentifier().getId()) == null) {
                idPattern = ".*";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "idPattern: " + idPattern);
            }
            if (scopePattern.indexOf("\\") != -1) {
                scopePattern = scopePattern.replace("\\", "\\\\");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopePattern: " + scopePattern);
            }
            Enumeration mKeys = this._data.keys();
            while (mKeys.hasMoreElements()) {
                String mUri = (String)mKeys.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mUri: " + mUri);
                }
                if (!mUri.matches(scopePattern)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches scope " + mUri);
                }
                Vector iVals = (Vector)this._orderdata.get(mUri);
                for (int j = 0; j < iVals.size(); ++j) {
                    Hashtable<String, Boolean> propPattern;
                    String id = (String)iVals.get(j);
                    if (!id.matches(idPattern)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "matches id " + id);
                    }
                    Hashtable tbl = (Hashtable)this._data.get(mUri);
                    ConfigAttribute attr = (ConfigAttribute)tbl.get(id);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attr:  " + attr);
                    }
                    if (!attr.getDescriptor().getConfigIdentifier().getId().matches(idPattern)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "id and scope match:" + attr);
                    }
                    if ((propPattern = attrPattern.getDescriptor().getProperties()).size() == 0) {
                        retVal.add(attr);
                        continue;
                    }
                    Enumeration<String> en = propPattern.keys();
                    boolean shouldAdd = true;
                    while (en.hasMoreElements()) {
                        String key = en.nextElement();
                        Boolean valPattern = propPattern.get(key);
                        Boolean val = attr.getDescriptor().getProperties().get(key);
                        if (valPattern instanceof String && val instanceof String) {
                            if (((String)((Object)val)).matches((String)((Object)valPattern))) continue;
                            shouldAdd = false;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "string val doesn't match: " + attr);
                            break;
                        }
                        if (((Object)valPattern).equals(val)) continue;
                        shouldAdd = false;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "val doesn't match: " + attr);
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "all matches so add: " + attr);
                    }
                    if (!shouldAdd) continue;
                    retVal.add(attr);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_queryData: " + retVal.size() + " " + retVal);
            }
            return retVal;
        }
    }
}

