/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class FileAccessorOutputStream
extends OutputStream {
    private File tempFile = null;
    private FileAccessor fa = null;
    private FileOutputStream os = null;
    private String uri = null;

    public FileAccessorOutputStream(FileAccessor fa, String uri) {
        this.fa = fa;
        this.uri = uri;
        try {
            this.tempFile = File.createTempFile("configarchive", null);
            this.os = new FileOutputStream(this.tempFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    public void write(int b) throws IOException {
        this.os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public FileDescriptor getFD() throws IOException {
        return this.os.getFD();
    }

    public FileChannel getChannel() {
        return this.os.getChannel();
    }

    public void close() throws IOException {
        FileInputStream is = new FileInputStream(this.tempFile);
        if (this.fa.exists(this.uri)) {
            this.fa.save(this.uri, is);
        } else {
            String dirUri = this.uri.substring(0, this.uri.lastIndexOf("/"));
            if (!this.fa.exists(dirUri)) {
                this.fa.makeDir(dirUri);
            }
            this.fa.create(this.uri, is);
        }
        this.os.close();
        this.tempFile.delete();
    }
}

