/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DefaultFileAccessor
extends FileAccessor {
    private File rootDir;
    private static TraceComponent tc = Tr.register(DefaultFileAccessor.class, "DefaultFileAccessor", "com.ibm.ws.management.resources.bundle");
    private static final String DFA_FILE_NOT_FOUND = "The system cannot find the specified file, either the filename is too long on Windows system or run out of file descriptor on UNIX platform. ";
    private static final int MAXBYTES = 2048;

    public DefaultFileAccessor(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void create(String uri, InputStream ins) throws IOException {
        int nbytes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (" + uri + " " + ins + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating file " + fileName);
        }
        File newFile = new File(fileName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating parent dirs " + fileName);
        }
        File parent = newFile.getParentFile();
        parent.mkdirs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing to file " + fileName);
        }
        byte[] buffer = new byte[2048];
        FileOutputStream os2 = null;
        try {
            os2 = new FileOutputStream(newFile);
        }
        catch (IOException e) {
            throw new IOException(DFA_FILE_NOT_FOUND + e);
        }
        while ((nbytes = ins.read(buffer, 0, 2048)) != -1) {
            os2.write(buffer, 0, nbytes);
        }
        os2.flush();
        os2.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
    }

    public void delete(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (" + uri + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        File filePath = new File(fileName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleting file " + fileName);
        }
        if (filePath.exists() && !filePath.delete() && tc.isDebugEnabled()) {
            Tr.debug(tc, "delete failed " + fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
    }

    public InputStream load(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load (" + uri + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        FileInputStream is = null;
        File fil = new File(fileName);
        try {
            is = new FileInputStream(fil);
        }
        catch (IOException e) {
            throw new IOException(DFA_FILE_NOT_FOUND + e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
        return is;
    }

    public void save(String uri, InputStream ins) throws IOException {
        int nbytes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save (" + uri + " " + ins + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        File newFile = new File(fileName);
        newFile.getParentFile().mkdirs();
        FileOutputStream os2 = null;
        try {
            os2 = new FileOutputStream(newFile);
        }
        catch (IOException e) {
            throw new IOException(DFA_FILE_NOT_FOUND + e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing to file " + fileName);
        }
        byte[] buffer = new byte[2048];
        while ((nbytes = ins.read(buffer, 0, 2048)) != -1) {
            os2.write(buffer, 0, nbytes);
        }
        os2.flush();
        os2.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
    }

    public List listFolders(String parentUri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFolders (" + parentUri + ")");
        }
        List<String> lst = new ArrayList();
        String fileName = this.rootDir.getPath() + File.separator + parentUri;
        File fil = new File(fileName);
        File[] list = fil.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isDirectory()) continue;
                lst.add(list[i].getPath());
            }
        }
        lst = this.adjustPaths(lst);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFolders");
        }
        return lst;
    }

    public List listFiles(String parentUri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + parentUri + ")");
        }
        List<String> lst = new ArrayList();
        String fileName = this.rootDir.getPath() + "/" + parentUri;
        File fil = new File(fileName);
        File[] list = fil.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) continue;
                lst.add(list[i].getPath());
            }
        }
        lst = this.adjustPaths(lst);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
        return lst;
    }

    public boolean exists(String uri) throws IOException {
        File fil;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists (" + uri + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exists (" + fileName + ")");
        }
        if ((fil = new File(fileName)).exists()) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists false");
        }
        return false;
    }

    public OutputStream getOutputStream(String uri) throws IOException {
        String fileName;
        File newFile;
        File parent;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (" + uri + ")");
        }
        if (!(parent = (newFile = new File(fileName = this.rootDir.getPath() + File.separator + uri)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        FileOutputStream os2 = null;
        try {
            os2 = new FileOutputStream(newFile);
        }
        catch (IOException e) {
            throw new IOException(DFA_FILE_NOT_FOUND + e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        return os2;
    }

    public void makeDir(String uri) throws IOException {
        String fileName;
        File dir;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDir (" + uri + ")");
        }
        if (!(dir = new File(fileName = this.rootDir.getPath() + File.separator + uri)).exists()) {
            dir.mkdirs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDir");
        }
    }

    private List adjustPaths(List lst) {
        ArrayList<String> paths = new ArrayList<String>(lst.size());
        for (String str : lst) {
            str = str.substring(this.rootDir.getPath().length() + 1);
            paths.add(str);
        }
        return paths;
    }

    public void createNewFile(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewFile (" + uri + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createNewFile (" + fileName + ")");
        }
        File newFile = new File(fileName);
        File parent = newFile.getParentFile();
        parent.mkdirs();
        newFile.createNewFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewFile");
        }
    }

    public void deleteRootDir() {
        String rootPath = this.rootDir.getPath();
        String userPath = rootPath.substring(0, rootPath.lastIndexOf(File.separatorChar));
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "deleteRootDir (" + userPath + ")");
        }
        File filePath = new File(userPath);
        filePath.delete();
    }

    public long getLength(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLength (" + uri + ")");
        }
        String fileName = this.rootDir.getPath() + File.separator + uri;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLength (" + fileName + ")");
        }
        File fil = new File(fileName);
        long len = fil.length();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLength " + len);
        }
        return len;
    }

    public String getFullPath(String uri) {
        return this.rootDir.getPath() + File.separator + uri;
    }
}

