/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TranAffinityMap;
import com.ibm.ws390.tx.TranAffinityMarker;
import com.ibm.ws390.tx.TranAffinityRouterHelper;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.iiop.channel.StateElement;
import java.nio.ByteBuffer;
import java.util.Map;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransIdentityHelper;
import org.omg.PortableInterceptor.ForwardRequest;

public class TranAffinityRouterHelper {
    private static final TraceComponent tc = Tr.register(TranAffinityRouterHelper.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final String JTS_CONN_STATE = "JTS_CONN_STATE";
    public static final String JTS_PC_KEY = "JTS_PC_KEY";
    public static final String JTS_XID_CACHE_KEY = "JTS_XID_CACHE_KEY";
    public static final String JTS_AFF_MARKER_KEY = "JTS_AFF_MARKER_KEY";
    private static TranAffinityRouterHelper _instance = new TranAffinityRouterHelper();
    private TranAffinityMap _tm = null;

    public static TranAffinityRouterHelper instance() {
        return _instance;
    }

    public static boolean isTransactionalSystemObject(String typeId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isTransactionalSystemObject", (java.lang.Object)typeId);
        }
        boolean systemObj = false;
        if (RecoveryCoordinatorHelper.id().equals(typeId) || CoordinatorHelper.id().equals(typeId) || ResourceHelper.id().equals(typeId) || TerminatorHelper.id().equals(typeId) || ControlHelper.id().equals(typeId)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JTS System object", (java.lang.Object)typeId);
            }
            systemObj = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isTransactionalSystemObject", (java.lang.Object)new Boolean(systemObj));
        }
        return systemObj;
    }

    private TranAffinityRouterHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
            Tr.exit((TraceComponent)tc, (String)"<init>", (java.lang.Object)this);
        }
    }

    void setTranAffinityMap(TranAffinityMap map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTranAffinityMap", (java.lang.Object)map);
        }
        if (this._tm != null) {
            String message = "TransactionManager already set";
            throw new IllegalStateException(message);
        }
        this._tm = map;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTranAffinityMap");
        }
    }

    public boolean seenDistributedTran(byte[] gtrid) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"seenDistributedTran", (java.lang.Object)gtrid);
        }
        if (this._tm == null) {
            String message = "TransactionManager not initialized yet";
            throw new IllegalStateException(message);
        }
        boolean seenTran = this._tm.seenDistributedTran(gtrid);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"seenDistributedTran", (java.lang.Object)new Boolean(seenTran));
        }
        return seenTran;
    }

    private Throwable createForwardException(ByteBuffer iorBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createForwardException", (java.lang.Object)iorBytes);
        }
        byte[] iorByteArray = new byte[iorBytes.capacity()];
        iorBytes.get(iorByteArray);
        ORB orb = GlobalORBFactory.globalORB();
        CDRInputStream iorInputStream = ORB.createCDRInputStream((ORB)orb, (byte[])iorByteArray, (int)iorByteArray.length);
        iorInputStream.consumeEndian();
        IOR ior = ORB.createIOR((ORB)orb);
        ior.read((InputStream)iorInputStream);
        Object o = orb.IORToObject(ior);
        ForwardRequest forwardException = new ForwardRequest("Transactional Affinity is elsewhere", o);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createForwardException", (java.lang.Object)((java.lang.Object)forwardException));
        }
        return forwardException;
    }

    public PropagationContext extractPropagationContext(ServiceContextList serviceContexts) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractPropagationContext", (java.lang.Object)serviceContexts);
        }
        PropagationContext propContext = null;
        ServiceContext otsContext = serviceContexts.get(0);
        if (otsContext != null) {
            byte[] propBytes = otsContext.getContextData();
            ORB orb = GlobalORBFactory.globalORB();
            CDRInputStream is = ORB.createCDRInputStream((ORB)orb, (byte[])propBytes, (int)propBytes.length);
            is.consumeEndian();
            propContext = new PropagationContext();
            propContext.timeout = is.read_ulong();
            propContext.current = TransIdentityHelper.read((InputStream)is);
            propContext.parents = new TransIdentity[is.read_long()];
            for (int i = 0; i < propContext.parents.length; ++i) {
                propContext.parents[i] = TransIdentityHelper.read((InputStream)is);
            }
            propContext.implementation_specific_data = is.read_any();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractPropagationContext", propContext);
        }
        return propContext;
    }

    public byte[] extractGtrid(PropagationContext propContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractGtrid", (java.lang.Object)propContext);
        }
        byte[] gtrid = null;
        if (propContext != null && propContext.current.otid != null && propContext.current.otid.tid.length != 0) {
            int gtridLength = propContext.current.otid.tid.length - propContext.current.otid.bqual_length;
            gtrid = new byte[gtridLength];
            System.arraycopy(propContext.current.otid.tid, 0, gtrid, 0, gtridLength);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractGtrid", gtrid);
        }
        return gtrid;
    }

    public void cacheTransactionalObjects(Map requestMap, PropagationContext propContext, TranAffinityMarker marker) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cacheTransactionalObjects", (java.lang.Object)new java.lang.Object[]{requestMap, propContext, marker});
        }
        if (marker != null) {
            if (requestMap.containsKey(JTS_AFF_MARKER_KEY)) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Marker is already present in state map", (java.lang.Object)requestMap);
                }
                throw new INTERNAL("Internal error - duplicate tran routing marker");
            }
            requestMap.put(JTS_AFF_MARKER_KEY, marker);
        }
        if (propContext != null) {
            if (requestMap.containsKey(JTS_PC_KEY)) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"PC is already present in state map", (java.lang.Object)new java.lang.Object[]{requestMap, requestMap.get(JTS_PC_KEY)});
                }
                throw new INTERNAL("Internal error - PC conflict");
            }
            requestMap.put(JTS_PC_KEY, propContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheTransactionalObjects");
        }
    }

    public Map getStateMap(ConnectionStateElement element, int id) {
        String key;
        Map requestMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStateMap", (java.lang.Object)new java.lang.Object[]{element, new Integer(id)});
        }
        if ((requestMap = (Map)element.getConnectionElement(key = JTS_CONN_STATE + id)) == null) {
            requestMap = new TransactionRequestStateMap(this, id);
            element.setConnectionElement(key, (StateElement)requestMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStateMap", (java.lang.Object)requestMap);
        }
        return requestMap;
    }

    public void removeRequestFromStateElementMap(ConnectionStateElement element, int id) {
        java.lang.Object o;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRequestFromStateElementMap", (java.lang.Object)new java.lang.Object[]{element, new Integer(id)});
        }
        String key = JTS_CONN_STATE + id;
        Map requestMap = this.getStateMap(element, id);
        if (requestMap.get(JTS_AFF_MARKER_KEY) != null || requestMap.get(JTS_XID_CACHE_KEY) != null) {
            RasHelper.exit((int)-910026168, (boolean)false);
        }
        if ((o = element.removeConnectionElement(key)) == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Connection stale or Request not found. Request was not removed from state elemennt map", (java.lang.Object)new java.lang.Object[]{o, key});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRequestFromStateElementMap");
        }
    }

    private native boolean checkEnqsNative(byte[] var1, byte[] var2, boolean var3) throws ForwardRequest;

    static /* synthetic */ TraceComponent access$000() {
        return tc;
    }
}

