/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ws.Transaction.JTS.WSCascadedPropagationData;
import com.ibm.ws.Transaction.JTS.WSCascadedPropagationDataHelper;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.tx.CascadedTranInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class CascadedClientReqInterceptor
extends LocalObject
implements ClientRequestInterceptor,
ORBInitializer {
    private static final String header;
    private static final String nativeLibName;
    private static final int TAG_TransactionService = 1229081860;
    private static final boolean debug;
    private static final boolean generateXid;
    private static final int timeout;

    public void send_request(ClientRequestInfo cri) throws ForwardRequest {
        if (debug) {
            System.out.println(header + "PI send_request entered");
        }
        TaggedComponent taggedComponent = ((ExtendedClientRequestInfo)cri).getEffectiveComponent(1229081860);
        if (debug) {
            System.out.println(header + "taggedComponent: " + taggedComponent);
            if (taggedComponent != null && taggedComponent.component_data != null) {
                System.out.println(header + "taggedComponent.component_data[2] -> " + taggedComponent.component_data[2]);
            }
        }
        if (taggedComponent != null && taggedComponent.component_data[2] == 3) {
            if (debug) {
                System.out.println(header + "Talking to an IBM4 " + "Version 3 server");
            }
            CascadedTranInfo cti = new CascadedTranInfo();
            int nativeRc = 0;
            if (debug) {
                System.out.println(header + "calling native...");
            }
            try {
                nativeRc = CascadedClientReqInterceptor.obtainOTSContextData(cti, generateXid, debug);
            }
            catch (Throwable e) {
                System.out.println(header + "Exception message -> " + e.getMessage());
                e.printStackTrace();
                throw new INTERNAL(e.getMessage());
            }
            if (debug) {
                System.out.println(header + "back from native, RC=" + Integer.toHexString(nativeRc));
            }
            if (nativeRc != 0) {
                String errorMessage = new String("WebSphere CascadedClientRequestInterceptor failed with RC=" + Integer.toHexString(nativeRc));
                throw new INTERNAL(errorMessage);
            }
            byte[] urid = cti.getURID();
            byte[] urtok = cti.getURTOK();
            byte[] xidBytes = cti.getXID();
            if (xidBytes != null) {
                int bqualLength;
                int formatID;
                ByteArrayInputStream bis = new ByteArrayInputStream(xidBytes);
                DataInputStream dis = new DataInputStream(bis);
                byte[] tid = null;
                try {
                    formatID = dis.readInt();
                    int gtridLength = dis.readInt();
                    bqualLength = dis.readInt();
                    tid = new byte[gtridLength + bqualLength];
                    dis.readFully(tid);
                    dis.close();
                }
                catch (Throwable t) {
                    String errorMessage = new String("Error encountered parsing the current XID, " + t.getMessage());
                    throw new INTERNAL(errorMessage);
                }
                otid_t otid = new otid_t(formatID, bqualLength, tid);
                ServiceContext serviceContext = CascadedClientReqInterceptor.buildServiceContext((ORB)((LocalObject)cri)._orb(), urid, urtok, otid);
                cri.add_request_service_context(serviceContext, true);
            } else if (debug) {
                System.out.println(header + "There is no " + "current UR");
            }
        } else if (debug) {
            System.out.println(header + "Tag IBM4 not encountered");
        }
    }

    public void send_poll(ClientRequestInfo arg0) {
        if (debug) {
            System.out.println(header + "PI send_poll entered");
        }
    }

    public void receive_reply(ClientRequestInfo arg0) {
        if (debug) {
            System.out.println(header + "PI receive_reply entered");
        }
    }

    public void receive_exception(ClientRequestInfo arg0) throws ForwardRequest {
        if (debug) {
            System.out.println(header + "PI receive_exception entered");
        }
    }

    public void receive_other(ClientRequestInfo arg0) throws ForwardRequest {
        if (debug) {
            System.out.println(header + "PI receive_other entered");
        }
    }

    public String name() {
        if (debug) {
            System.out.println(header + "PI name entered");
        }
        return "CascadedClientReqInterceptor";
    }

    public void destroy() {
        if (debug) {
            System.out.println(header + "PI destroy entered");
        }
    }

    public void pre_init(ORBInitInfo info) {
        if (debug) {
            System.out.println(header + "PI pre_init entered");
        }
        CascadedClientReqInterceptor interceptor = new CascadedClientReqInterceptor();
        try {
            ((ExtendedORBInitInfo)info).add_client_request_interceptor((ClientRequestInterceptor)interceptor, false);
            if (debug) {
                System.out.println(header + "registered the interceptor");
            }
        }
        catch (Throwable e) {
            System.out.println(header + "Failed trying to register the " + "interceptor, " + e.toString());
            e.printStackTrace();
        }
        if (debug) {
            System.out.println(header + "PI pre_init exited");
        }
    }

    public void post_init(ORBInitInfo info) {
        if (debug) {
            System.out.println(header + "PI post_init entered");
        }
    }

    private static ServiceContext buildServiceContext(ORB orb, byte[] urid, byte[] urtok, otid_t otid) {
        PropagationContext propagationContext = null;
        Any emptyAny = orb.create_any();
        emptyAny.insert_boolean(false);
        Any propContextAny = orb.create_any();
        WSCascadedPropagationData pdata = new WSCascadedPropagationData(1, urid, urtok, emptyAny);
        WSCascadedPropagationDataHelper.insert(propContextAny, pdata);
        propagationContext = new PropagationContext(timeout, new TransIdentity(null, null, otid), new TransIdentity[0], propContextAny);
        byte[] result = null;
        CDROutputStream outputStream = ORB.createCDROutputStream((ORB)orb);
        outputStream.putEndian();
        PropagationContextHelper.write((OutputStream)outputStream, propagationContext);
        result = outputStream.toByteArray();
        outputStream.releaseBuffer();
        byte[] marshaledContext = result;
        ServiceContext serviceContext = new ServiceContext(0, marshaledContext);
        return serviceContext;
    }

    private static ByteBuffer buildServiceContext(ByteBuffer input) {
        byte[] urid = new byte[16];
        byte[] urtoken = new byte[16];
        int formatID = 0;
        int gtridLen = 0;
        int bqualLen = 0;
        byte[] tid = null;
        input.get(urid);
        input.get(urtoken);
        formatID = input.getInt();
        gtridLen = input.getInt();
        bqualLen = input.getInt();
        tid = new byte[gtridLen + bqualLen];
        input.get(tid);
        otid_t otid = new otid_t(formatID, bqualLen, tid);
        ORB orb = GlobalORBFactory.globalORB();
        ServiceContext serviceContext = CascadedClientReqInterceptor.buildServiceContext(orb, urid, urtoken, otid);
        ByteBuffer output = ByteBuffer.allocateDirect(serviceContext.context_data.length + 4 + 4);
        output.putInt(serviceContext.context_id);
        output.putInt(serviceContext.context_data.length);
        output.put(serviceContext.context_data);
        return output;
    }

    public static native int obtainOTSContextData(CascadedTranInfo var0, boolean var1, boolean var2);

    static {
        int bitmode;
        header = new String(" CascadedClientRequestInterceptor: ");
        nativeLibName = new String("bbotccri");
        String currentBitmode = System.getProperty("com.ibm.vm.bitmode");
        if (currentBitmode != null && (bitmode = Integer.parseInt(currentBitmode)) < 64) {
            try {
                System.loadLibrary(nativeLibName);
            }
            catch (Throwable e) {
                System.out.println(header + "Tried to load " + nativeLibName + " but failed");
                e.printStackTrace();
            }
        }
        debug = Boolean.getBoolean("was.ccri.debug");
        generateXid = Boolean.getBoolean("was.ccri.generateXid");
        timeout = Integer.getInteger("was.ccri.timeout", 360);
    }
}

