/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.client;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.corba.AnyImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.wlm.PMIManager;
import com.ibm.ws.wlm.TargetForwardedListener;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.WLMServiceClientContextListener;
import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;

public class WLMClientRequestInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final TraceComponent tc = Tr.register(WLMClientRequestInterceptor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String name = "WLMClientRequestInterceptor";
    private int slotid_context = 0;
    private int slotid_context_listener = 0;
    private static TargetForwardedListener[] tfListeners;

    public void pre_init(ORBInitInfo info) {
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "pre_init", info);
                }
                try {
                    ((ExtendedORBInitInfo)info).add_client_request_interceptor((ClientRequestInterceptor)this, false);
                    info.register_initial_reference(name, (Object)this);
                }
                catch (DuplicateName dn) {
                    FFDCFilter.processException((Throwable)dn, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.pre_init", "119", (java.lang.Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception", (java.lang.Object)dn);
                    }
                }
                catch (InvalidName in) {
                    FFDCFilter.processException((Throwable)in, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.pre_init", "125", (java.lang.Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception", (java.lang.Object)in);
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.pre_init", "131", (java.lang.Object)this);
                    if (!tc.isEventEnabled()) break block11;
                    Tr.event(tc, "Unexpected exception", t);
                }
            }
            try {
                this.slotid_context = info.allocate_slot_id();
                this.slotid_context_listener = info.allocate_slot_id();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "slot ids", new java.lang.Object[]{String.valueOf(this.slotid_context), String.valueOf(this.slotid_context_listener)});
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.pre_init", "145", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Unexpected exception", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "post_init", info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "post_init");
        }
    }

    public void send_request(ClientRequestInfo cri) throws ForwardRequest {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "send_request");
            }
            if (WorkloadController.inQuiesceMode()) {
                ConnectionInformation connInfo = (ConnectionInformation)((ExtendedClientRequestInfo)cri).getConnectionData();
                ConnectionData connData = (ConnectionData)connInfo.getConnectionData();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConnectionInformation: " + connInfo.toString());
                    Tr.debug(tc, "remotePort = " + connData.getRemotePort());
                    Tr.debug(tc, "localPort = " + connData.getLocalPort());
                }
                int localPort = connData.getLocalPort();
                WLMProperties.setLocalPort((int)localPort);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting local port for outbound request in quiesce mode " + localPort);
                }
            }
            try {
                Any thread_context = cri.get_slot(this.slotid_context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "thread_context", thread_context);
                }
                if (thread_context != null && thread_context.type().kind() != TCKind.tk_null) {
                    byte[] context_data = (byte[])thread_context.extract_Value();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sending context", context_data);
                    }
                    ServiceContext ctx = new ServiceContext(1229081865, context_data);
                    cri.add_request_service_context(ctx, true);
                }
                if (PMIManager.clientModule != null) {
                    PMIManager.clientModule.onOutgoingWLMRequest(cri);
                }
            }
            catch (InvalidSlot is) {
                FFDCFilter.processException((Throwable)is, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.send_request", "231", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InvalidSlot exception", new java.lang.Object[]{String.valueOf(this.slotid_context), is});
                }
            }
            catch (MARSHAL m) {
                FFDCFilter.processException((Throwable)m, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.send_request", "237", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MARSHAL exception", (java.lang.Object)m);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.send_request", "243", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Unexpected exception", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request");
        }
    }

    public void receive_reply(ClientRequestInfo cri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_reply");
        }
        this.receive_common(cri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
            Tr.exit(tc, "destroy");
        }
    }

    public String name() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "name");
            Tr.exit(tc, "name", name);
        }
        return name;
    }

    public void send_poll(ClientRequestInfo cri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_poll", cri);
            Tr.exit(tc, "send_poll");
        }
    }

    public void receive_exception(ClientRequestInfo cri) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_exception", cri);
        }
        this.receive_common(cri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_exception");
        }
    }

    public void receive_other(ClientRequestInfo cri) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_other", new java.lang.Object[]{String.valueOf(cri.reply_status()), cri.operation()});
        }
        if (cri.reply_status() == 4 || cri.reply_status() == 3) {
            for (int i = 0; i < tfListeners.length; ++i) {
                tfListeners[i].targetForwarded(cri.forward_reference());
            }
        }
        this.receive_common(cri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_other");
        }
    }

    public void registerServiceContextListener(ORB orb, WLMServiceClientContextListener context_listener) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerServiceContextListener", context_listener);
            }
            try {
                Current picurrent = (Current)orb.resolve_initial_references("PICurrent");
                AnyImpl any_data = new AnyImpl((org.omg.CORBA.ORB)orb);
                byte[] context_data = context_listener.sendClientContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "context_data", context_data);
                }
                any_data.insert_Value((Serializable)context_data);
                AnyImpl any_listener = new AnyImpl((org.omg.CORBA.ORB)orb);
                any_listener.insert_Value((Serializable)context_listener);
                picurrent.set_slot(this.slotid_context, (Any)any_data);
                picurrent.set_slot(this.slotid_context_listener, (Any)any_listener);
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName in) {
                FFDCFilter.processException((Throwable)in, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.registerServiceContextListener", "402", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception", (java.lang.Object)in);
                }
            }
            catch (InvalidSlot is) {
                FFDCFilter.processException((Throwable)is, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.registerServiceContextListener", "408", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unexpected exception", (java.lang.Object)is);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServiceContextListener");
        }
    }

    public void deregisterServiceContextListener(ORB orb, WLMServiceClientContextListener context_listener) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterServiceContextListener", context_listener);
            }
            try {
                Current picurrent = (Current)orb.resolve_initial_references("PICurrent");
                AnyImpl any_data = new AnyImpl((org.omg.CORBA.ORB)orb);
                picurrent.set_slot(this.slotid_context, (Any)any_data);
                picurrent.set_slot(this.slotid_context_listener, (Any)any_data);
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName in) {
                FFDCFilter.processException((Throwable)in, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.deregisterServiceContextListener", "432", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception", (java.lang.Object)in);
                }
            }
            catch (InvalidSlot is) {
                FFDCFilter.processException((Throwable)is, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.deregisterServiceContextListener", "438", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Unexpected exception", (java.lang.Object)is);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterServiceContextListener");
        }
    }

    protected void receive_common(ClientRequestInfo cri) {
        block10: {
            try {
                byte[] replyData = null;
                ServiceContext ctx = ((ExtendedClientRequestInfo)cri).getReplyServiceContext(1229081865);
                if (ctx != null && (replyData = ctx.context_data) != null && replyData.length > 0) {
                    Any any_listener;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "context data", replyData);
                    }
                    if ((any_listener = cri.get_slot(this.slotid_context_listener)).type().kind() != TCKind.tk_null) {
                        WLMServiceClientContextListener listener = (WLMServiceClientContextListener)any_listener.extract_Value();
                        listener.receiveClientContext(replyData);
                    }
                }
                if (PMIManager.clientModule != null) {
                    PMIManager.clientModule.onIncomingWLMReply(cri);
                }
            }
            catch (BAD_PARAM bp) {
                FFDCFilter.processException((Throwable)bp, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.receive_reply", "491", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BAD_PARAM exception", (java.lang.Object)bp);
                }
            }
            catch (NullPointerException npe) {
                FFDCFilter.processException((Throwable)npe, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.receive_reply", "498", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WLMServiceClientContextListener was not set correctly!", npe);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.wlm.client.WLMClientRequestInterceptor.receive_reply", "504", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Unexpected exception", t);
            }
        }
    }

    public static synchronized void registerTargetForwardedListener(TargetForwardedListener tfListener) {
        int count = tfListeners.length;
        TargetForwardedListener[] tmp = new TargetForwardedListener[count + 1];
        System.arraycopy(tfListeners, 0, tmp, 0, count);
        tmp[count] = tfListener;
        tfListeners = tmp;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.17 : none");
        }
        tfListeners = new TargetForwardedListener[0];
    }
}

