/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WLMPerf;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.pmi.server.PmiFactory;

public class PMIManager {
    private static final TraceComponent tc = Tr.register(PMIManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static int clientId;
    public static WLMPerf clientModule;
    public static WLMPerf serverModule;
    private static ThreadLocal pmiContext;

    private PMIManager() {
    }

    public static void initializePMI(String moduleName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePMI: moduleName=" + moduleName);
        }
        try {
            if (moduleName.equals("wlmModule.client")) {
                clientModule = PmiFactory.createWLMPerf("wlmModule.client");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "initializePMI: PmiFactory.createWLMPerf() clientModule=" + clientModule);
                }
            } else {
                serverModule = PmiFactory.createWLMPerf("wlmModule.server");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "initializePMI: PmiFactory.createWLMPerf() serverModule=" + serverModule);
                }
            }
        }
        catch (Throwable t) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initializePMI: PmiFactory.createWLMPerf() failed t=" + t);
            }
            if (moduleName.equals("wlmModule.client")) {
                clientModule = null;
            }
            serverModule = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePMI");
        }
    }

    public static void setClientId(int orbId) {
        clientId = orbId;
    }

    public static int getClientId() {
        if (clientId == -1) {
            clientId = GlobalORBFactory.globalORB().getServerId();
        }
        return clientId;
    }

    public static void putAffinityType(byte affinityType) {
        pmiContext.set(new Byte(affinityType));
    }

    public static byte getAffinityType() {
        Byte affinityType = (Byte)pmiContext.get();
        if (affinityType == null) {
            return 0;
        }
        return affinityType;
    }

    public static void removeEntry() {
        pmiContext.set(null);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.9 : none");
        }
        clientId = -1;
        pmiContext = new ThreadLocal();
    }
}

