/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessor;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorFactory;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCache;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCacheMgr;
import com.ibm.ws.webservices.shared.cache.jaxb.JaxwsWebServiceInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WebServiceClientInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsClientType;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.deploy.WSCacheWriter;
import com.ibm.ws.websvcs.deployment.CachedFileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder;
import com.ibm.ws.websvcs.deployment.WSServerMetadataMerger;
import com.ibm.ws.websvcs.desc.DDClientServiceDescriptorImpl;
import com.ibm.ws.websvcs.desc.JAXRPCEndpointDescriptorImpl;
import com.ibm.ws.websvcs.desc.JAXRPCServiceDescriptorImpl;
import com.ibm.ws.websvcs.desc.JAXWSEndpointDescriptorImpl;
import com.ibm.ws.websvcs.desc.JAXWSServiceDescriptorImpl;
import com.ibm.ws.websvcs.desc.MDQServiceDescriptorImpl;
import com.ibm.ws.websvcs.desc.ServiceRefInfoImpl;
import com.ibm.ws.websvcs.desc.WSClientServiceDescriptorDBC;
import com.ibm.ws.websvcs.desc.WSClientServiceDescriptorImpl;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.BaseWSDLGenerator;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import com.ibm.wsspi.webservices.WSDescriptionUtils;
import com.ibm.wsspi.webservices.WebServiceClientType;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSModuleDescriptorImpl
implements WSModuleDescriptor,
Constants {
    private ModuleFile moduleFile;
    private boolean jaxwsServicesBuilt = false;
    private boolean jaxrpcServicesBuilt = false;
    private boolean jaxwsServiceRefsBuilt = false;
    private boolean ddServiceRefsBuilt = false;
    private boolean jaxrpcServicesInitialized = false;
    private boolean ddServiceRefsInitialized = false;
    private boolean dbcMapInitialized = false;
    private int jaxwsServiceCount = 0;
    private int jaxrpcServiceCount = 0;
    private int serviceClientCount = 0;
    private ArrayList<WSServiceDescriptor> serviceDescList = new ArrayList();
    private Map<javax.xml.namespace.QName, WSClientServiceDescriptor> serviceRefMap = new HashMap<javax.xml.namespace.QName, WSClientServiceDescriptor>();
    private List<ClassDataObject> moduleCDOs;
    private WebServices jaxrpcServices;
    private List ddServiceRefs = new ArrayList();
    private ClassLoader classLoader;
    private WebServicesModuleCache cache;
    private static Map<String, SoftReference<ModuleInfo>> moduleInfoMap = new HashMap<String, SoftReference<ModuleInfo>>();
    private HashMap<String, DescriptionBuilderComposite> dbcMap = new HashMap();
    private static Object staticLock = new Object();
    private static Map<String, Object> moduleAppLocks = new HashMap<String, Object>();
    private FileExplorer fileExplorer;
    private List<String> jaxrpcPortComponents = new ArrayList<String>();
    private JaxWSCatalogAccessor catalogAccessor;
    private static final TraceComponent _tc = Tr.register(WSModuleDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    WSModuleDescriptorImpl(ModuleFile mFile) {
        this(mFile, null);
    }

    WSModuleDescriptorImpl(ModuleFile mFile, ClassLoader cl) {
        this.moduleFile = mFile;
        if (cl != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Using the supplied classloader: " + cl);
            }
            this.classLoader = cl;
            this.moduleFile.getOptions().setUseJavaReflection(true);
            if (_tc.isDebugEnabled()) {
                if (this.moduleFile.getArchiveClassLoader() != null) {
                    boolean temp = this.moduleFile.getOptions().useJavaReflection();
                    boolean temp1 = this.moduleFile.shouldUseJavaReflection();
                    Tr.debug(_tc, "reflection : " + temp + " shouldUseJavaReflection : " + temp1);
                } else {
                    Tr.debug(_tc, "moduleFile.getArchiveClassLoader() is null.");
                }
            }
        } else {
            this.initializeClassLoader();
        }
        this.initCache();
        this.moduleCDOs = null;
        this.catalogAccessor = new JaxWSCatalogAccessor(this.classLoader);
    }

    @Override
    public boolean containsJAXRPCWebServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "containsJAXRPCWebServices, module= " + this.moduleFile.getName());
        }
        boolean contains = false;
        if (this.cache.jaxrpcCacheExists()) {
            contains = true;
        } else if (this.cache.exists()) {
            contains = false;
        } else {
            if (!this.jaxrpcServicesInitialized) {
                this.initJAXRPCServices();
                this.buildJAXRPCServices();
            } else if (!this.jaxrpcServicesBuilt) {
                this.buildJAXRPCServices();
            }
            boolean bl = contains = this.jaxrpcServiceCount > 0;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "containsJAXRPCWebServices, module= " + this.moduleFile.getName() + ": " + String.valueOf(contains));
        }
        return contains;
    }

    @Override
    public boolean containsJAXWSWebServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "containsJAXWSWebServices, module= " + this.moduleFile.getName());
        }
        boolean contains = false;
        if (this.cache.jaxwsCacheExists()) {
            contains = true;
        } else if (this.cache.exists()) {
            contains = false;
        } else {
            if (!this.jaxwsServicesBuilt) {
                this.buildJAXWSServices();
            }
            boolean bl = contains = this.jaxwsServiceCount > 0;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "containsJAXWSWebServices, module= " + this.moduleFile.getName() + ": " + String.valueOf(contains));
        }
        return contains;
    }

    @Override
    public boolean containsWebServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "containsWebServices, module= " + this.moduleFile.getName());
        }
        boolean contains = false;
        if (this.containsJAXWSWebServices()) {
            contains = true;
        } else if (this.containsJAXRPCWebServices()) {
            contains = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "containsWebServices, module= " + this.moduleFile.getName() + ": " + String.valueOf(contains));
        }
        return contains;
    }

    @Override
    public boolean containsWebServiceClients() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "containsWebServiceClients, module= " + this.moduleFile.getName());
        }
        boolean contains = false;
        if (this.cache.wsClientCacheExists()) {
            contains = true;
        } else if (this.cache.exists()) {
            contains = false;
        } else {
            if (!this.ddServiceRefsInitialized) {
                this.initDDServiceRefs();
            }
            if (!this.ddServiceRefsBuilt || !this.jaxwsServiceRefsBuilt) {
                this.buildDDServiceRefs();
                this.buildJAXWSServiceRefs();
            }
            boolean bl = contains = this.serviceClientCount > 0;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "containsWebServiceClients, module= " + this.moduleFile.getName() + ": " + String.valueOf(contains));
        }
        return contains;
    }

    @Override
    public String getModuleName() {
        return this.moduleFile.getName();
    }

    @Override
    public Iterator getServices() {
        this.buildServices();
        return this.serviceDescList.iterator();
    }

    @Override
    public Iterator getServiceRefs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceRefs= " + this.moduleFile.getName());
        }
        this.buildServiceRefs();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServiceRefs= " + this.moduleFile.getName() + " size= " + this.serviceRefMap.values().size());
        }
        return this.serviceRefMap.values().iterator();
    }

    @Override
    public boolean isEJBJar() {
        return this.moduleFile.isEJBJarFile();
    }

    @Override
    public boolean isWARFile() {
        return this.moduleFile.isWARFile();
    }

    private void buildServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildServices");
        }
        if (!this.jaxwsServicesBuilt) {
            this.buildJAXWSServices();
        }
        if (!this.jaxrpcServicesBuilt) {
            this.buildJAXRPCServices();
        }
        if (_tc.isDebugEnabled() && (this.jaxwsServiceCount > 0 || this.jaxrpcServiceCount > 0)) {
            Tr.debug(_tc, "Built the following DescriptionBuilder services for module: " + this.moduleFile.getName());
            Iterator<WSServiceDescriptor> sdIter = this.serviceDescList.iterator();
            while (sdIter.hasNext()) {
                Tr.debug(_tc, sdIter.next().toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildServices");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildJAXRPCServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildJAXRPCServices= " + this.moduleFile.getName());
        }
        try {
            block31: {
                try {
                    if (!this.jaxrpcServicesInitialized) {
                        this.initJAXRPCServices();
                    }
                    if (this.jaxrpcServices != null && this.jaxrpcPortComponents != null && !this.jaxrpcPortComponents.isEmpty()) {
                        HashMap serviceDescMap = new HashMap();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Module: " + this.moduleFile.getName() + " contains JAX-RPC web service endpoints");
                        }
                        Iterator wsdIter = this.jaxrpcServices.getWebServiceDescriptions().iterator();
                        while (wsdIter.hasNext()) {
                            Definition def = null;
                            WebServiceDescription wsd = (WebServiceDescription)wsdIter.next();
                            WSDLLocator wsdlLocator = this.getWsdlLocator(wsd.getWsdlFile(), false);
                            if (wsdlLocator != null) {
                                WSDLReader reader = this.getWSDLReader();
                                def = reader.readWSDL(wsdlLocator);
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "The WSDL file: " + wsd.getWsdlFile() + " could not be loaded. " + "JAX-RPC service metadata cannot be built for this service.");
                            }
                            if (def != null) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Setting WSDL definition base document URI: " + wsd.getWsdlFile());
                                }
                                def.setDocumentBaseURI(wsd.getWsdlFile());
                                for (PortComponent pc : wsd.getPortComponents()) {
                                    String seiName = pc.getServiceEndpointInterface();
                                    if (seiName != null && this.jaxrpcPortComponents.contains(pc.getPortComponentName())) {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Found JAX-RPC port-component: " + pc.getPortComponentName() + " with SEI: " + seiName);
                                        }
                                        Service service = null;
                                        if (pc.getWsdlService() != null) {
                                            javax.xml.namespace.QName sQName = new javax.xml.namespace.QName(pc.getWsdlService().getNamespaceURI(), pc.getWsdlService().getLocalPart());
                                            service = def.getService(sQName);
                                        }
                                        if (pc.getWsdlPort() != null) {
                                            service = this.findWSDLService(pc, def);
                                        }
                                        if (service != null) {
                                            JAXRPCServiceDescriptorImpl serviceDesc = (JAXRPCServiceDescriptorImpl)serviceDescMap.get(service.getQName());
                                            if (serviceDesc != null) {
                                                Port wsdlPort;
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, "Already built JAXRPCServiceDescriptorImpl for service: " + service);
                                                }
                                                if ((wsdlPort = service.getPort(pc.getWsdlPort().getLocalPart())) != null) {
                                                    if (_tc.isDebugEnabled()) {
                                                        Tr.debug(_tc, "Constructed JAXRPCEndpointDescriptor Impl for port: " + wsdlPort.getName());
                                                    }
                                                    JAXRPCEndpointDescriptorImpl endpoint = new JAXRPCEndpointDescriptorImpl(wsdlPort, pc, serviceDesc);
                                                    endpoint.setParent(serviceDesc);
                                                    serviceDesc.addEndpoint(endpoint);
                                                    continue;
                                                }
                                                if (!_tc.isDebugEnabled()) continue;
                                                Tr.debug(_tc, "Could not construct JAXRPCEndpointDescriptorImpl for port: " + pc.getWsdlPort().getLocalPart() + " because a wsdl:port could not be found.");
                                                continue;
                                            }
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Building JAXRPCServiceDescriptorImpl for: " + service.getQName());
                                            }
                                            serviceDesc = new JAXRPCServiceDescriptorImpl(service, def, pc, this);
                                            this.serviceDescList.add(serviceDesc);
                                            ++this.jaxrpcServiceCount;
                                            continue;
                                        }
                                        if (!_tc.isDebugEnabled()) continue;
                                        Tr.debug(_tc, "Could not find wsdl:service for port: " + pc.getWsdlPort().getLocalPart());
                                        continue;
                                    }
                                    if (!_tc.isDebugEnabled()) continue;
                                    Tr.debug(_tc, "The port-component: " + pc.getPortComponentName() + " refers to a JAX-WS webservice");
                                }
                                continue;
                            }
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "WSDL definition could not be read for JAX-RPC web service: " + wsd.getWebServiceDescriptionName() + ". " + "The associated descriptor objects will not be built.");
                        }
                        break block31;
                    }
                    if (!_tc.isDebugEnabled()) break block31;
                    Tr.debug(_tc, "Module: " + this.moduleFile.getName() + " does not contain JAX-RPC " + "web service endpoints");
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.buildJAXRPCServices", "490", this);
                    Object[] inserts = new Object[]{this.moduleFile.getName(), t};
                    Tr.error(_tc, "buildSvcDescFail01", inserts);
                    Object var14_16 = null;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "buildJAXRPCServices= " + this.moduleFile.getName() + ", size= " + this.jaxrpcServiceCount);
                    }
                    this.jaxrpcServicesBuilt = true;
                    return;
                }
            }
            Object var14_15 = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "buildJAXRPCServices= " + this.moduleFile.getName() + ", size= " + this.jaxrpcServiceCount);
            }
            this.jaxrpcServicesBuilt = true;
            return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "buildJAXRPCServices= " + this.moduleFile.getName() + ", size= " + this.jaxrpcServiceCount);
            }
            this.jaxrpcServicesBuilt = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildJAXWSServices() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildJAXWSServices= " + this.moduleFile.getName());
        }
        try {
            block12: {
                try {
                    if (this.moduleFile.containsFile("WEB-INF/ibmservices.xml")) {
                        Object[] inserts = new Object[]{this.moduleFile.getName()};
                        Tr.error(_tc, "ibmSvcsFile00", inserts);
                    }
                    this.initDBCMap();
                    if (this.dbcMap == null || this.dbcMap.isEmpty()) break block12;
                    List sdList = new LinkedList();
                    WASAxis2DescriptionBuilder descBuilder = new WASAxis2DescriptionBuilder(this.moduleFile, this.classLoader);
                    sdList = DescriptionFactory.createServiceDescriptionFromDBCMap(this.dbcMap);
                    AxisServiceGroup serviceGroup = descBuilder.buildAxisServiceGroup(sdList);
                    if (serviceGroup == null) break block12;
                    this.updateEndpointURLS(serviceGroup);
                    this.buildJAXWSServiceList(serviceGroup, sdList);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.buildServices", "159", this);
                    Object[] inserts = new Object[]{t};
                    Tr.error(_tc, "buildSvcDescFail00", inserts);
                    Object var5_7 = null;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "buildJAXWSServices= " + this.moduleFile.getName());
                    }
                    this.jaxwsServicesBuilt = true;
                    return;
                }
            }
            Object var5_6 = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "buildJAXWSServices= " + this.moduleFile.getName());
            }
            this.jaxwsServicesBuilt = true;
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting web services temp cache directory to null on thread local storage");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "buildJAXWSServices= " + this.moduleFile.getName());
            }
            this.jaxwsServicesBuilt = true;
            throw throwable;
        }
    }

    private void getClassDataObjects() throws DeploymentException {
        List<FileLocator> locators;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClassDataObjects");
        }
        WASAnnotationCollector collector = new WASAnnotationCollector();
        collector.setClassLoader(this.classLoader);
        this.moduleCDOs = new ArrayList<ClassDataObject>();
        if (this.cache.jaxwsCacheExists() || this.cache.jaxwsClientCacheExists()) {
            List<WebServiceClientInfo> clientInfoList;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Loading JAXWS metadata from cache");
            }
            List<JaxwsWebServiceInfo> jaxwsInfoList = this.cache.getWsCacheInfo().getJaxwsServices();
            LinkedList<String> classNames = new LinkedList<String>();
            if (jaxwsInfoList != null && !jaxwsInfoList.isEmpty()) {
                this.addServiceClassNames(jaxwsInfoList, classNames);
            }
            if ((clientInfoList = this.cache.getWsCacheInfo().getWebServiceClient()) != null && !clientInfoList.isEmpty()) {
                this.addClientClassNames(clientInfoList, classNames);
            }
            try {
                List<FileLocator> locators2 = this.buildLocators(classNames);
                this.moduleCDOs = collector.collectCachedList(locators2);
            }
            catch (Exception e) {
                List<FileLocator> locators2 = this.getLocatorsFromModule();
                if (locators2 != null && !locators2.isEmpty()) {
                    this.moduleCDOs = collector.collect(locators2);
                }
            }
        } else if (!this.cache.exists() && (locators = this.getLocatorsFromModule()) != null && !locators.isEmpty()) {
            this.moduleCDOs = collector.collect(locators);
        }
        if (this.fileExplorer != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Performing cleanup on FileExplorer instance");
            }
            this.fileExplorer.cleanUp();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClassDataObjects");
        }
    }

    void addServiceClassNames(List<JaxwsWebServiceInfo> jaxwsInfoList, List<String> classNames) {
        for (JaxwsWebServiceInfo info : jaxwsInfoList) {
            classNames.add(info.getClassName());
        }
    }

    void addClientClassNames(List<WebServiceClientInfo> clientInfoList, List<String> classNames) {
        for (WebServiceClientInfo info : clientInfoList) {
            String className;
            if (info.getClientType() != null && !info.getClientType().equals((Object)WsClientType.JAX_WS) || (className = info.getServiceClassName()) == null) continue;
            if (!(className = className.replace(".", "/")).endsWith(".class")) {
                className = className + ".class";
            }
            classNames.add(className);
        }
    }

    private List<FileLocator> getLocatorsFromModule() throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLocatorsFromModule");
        }
        this.fileExplorer = FileExplorerFactory.getFileExplorer((Archive)this.moduleFile, (ClassLoader)this.classLoader);
        List locators = null;
        if (this.fileExplorer != null) {
            locators = this.fileExplorer.explore();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLocatorsFromModule");
        }
        return locators;
    }

    private void updateEndpointURLS(AxisServiceGroup serviceGroup) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateEndpointURLS, moduleFile=" + this.moduleFile.getName());
        }
        WebApp webApp = null;
        if (this.moduleFile.isEJBJarFile()) {
            WARFile wf = Axis2Utils.getRouterWAR((EJBJarFile)((EJBJarFile)this.moduleFile));
            if (wf != null) {
                webApp = wf.getDeploymentDescriptor();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Module is an EJB jar, using router module: " + wf.getName());
                }
            }
        } else if (this.moduleFile.isWARFile()) {
            webApp = ((WARFile)this.moduleFile).getDeploymentDescriptor();
        }
        if (webApp != null) {
            Iterator services = serviceGroup.getServices();
            while (services.hasNext()) {
                List mappingList;
                Servlet servlet;
                AxisService service = (AxisService)services.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing service: " + service.getName());
                }
                String serviceImplClass = Axis2Utils.getServiceImplClass((AxisService)service);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Service implementation class: " + serviceImplClass);
                }
                String servletLink = Axis2Utils.getLinkValue((AxisService)service);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for servlet for class: " + serviceImplClass + " with " + "link value: " + servletLink);
                }
                if ((servlet = Axis2Utils.locateServlet((WebApp)webApp, (String)servletLink)) == null && !servletLink.equals(serviceImplClass)) {
                    servlet = Axis2Utils.locateServlet((WebApp)webApp, (String)serviceImplClass);
                }
                if (servlet == null) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found matching servlet: " + servlet.getServletName());
                }
                if ((mappingList = servlet.getMappings()) != null && !mappingList.isEmpty()) {
                    if (mappingList.size() > 1) {
                        Object[] inserts = new Object[]{servlet.getServletName()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("servletMapNum00", inserts, "Servlet {0} contains more than one servlet mapping, which is a violation of JSR 109.");
                        throw new ServletException(msg);
                    }
                    ServletMapping servletMapping = (ServletMapping)mappingList.get(0);
                    String urlPattern = servletMapping.getUrlPattern();
                    if (urlPattern != null & (urlPattern.equals("/*") || urlPattern.equals("*"))) {
                        Object[] inserts = new Object[]{servlet.getServletName()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("illegalUrlPattern00", inserts, "Servlet {0} cannot specify \"*\" as a URL pattern.");
                        throw new ServletException(msg);
                    }
                    if (!urlPattern.startsWith("/")) {
                        urlPattern = "/" + urlPattern;
                    }
                    Axis2Utils.setURLPattern((AxisService)service, (String)urlPattern);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Setting URL pattern to: " + urlPattern + " for service: " + service.getName());
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "No servlet mappings were specified for the " + serviceImplClass + " implementation class");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Could not obtain web.xml to check for user mappings for module: " + this.moduleFile.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateEndpointURLS");
        }
    }

    private void buildServiceRefs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildServiceRefs");
        }
        if (!this.ddServiceRefsBuilt) {
            this.buildDDServiceRefs();
        }
        if (!this.jaxwsServiceRefsBuilt) {
            this.buildJAXWSServiceRefs();
        }
        if (_tc.isDebugEnabled() && this.serviceClientCount > 0) {
            Tr.debug(_tc, "Built the following DescriptionBuilder service refs for module: " + this.moduleFile.getName());
            Iterator<WSClientServiceDescriptor> srIter = this.serviceRefMap.values().iterator();
            while (srIter.hasNext()) {
                Tr.debug(_tc, srIter.next().toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildServiceRefs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildDDServiceRefs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildDDServiceRefs= " + this.moduleFile.getName());
        }
        try {
            block25: {
                try {
                    if (!this.ddServiceRefsInitialized) {
                        this.initDDServiceRefs();
                    }
                    if (this.ddServiceRefs != null && this.ddServiceRefs.size() > 0) {
                        for (ServiceRef serviceRef : this.ddServiceRefs) {
                            WSDLReader reader = this.getWSDLReader();
                            String wsdlLocation = serviceRef.getWsdlFile();
                            boolean resolveWSDL = false;
                            WebServiceClientType wscType = WSDescriptionUtils.getWebServiceClientType((ServiceRef)serviceRef, (ClassLoader)this.classLoader);
                            if (wscType == null) continue;
                            if (wscType.equals((Object)WebServiceClientType.JAXWS)) {
                                resolveWSDL = true;
                            }
                            WSDLLocator wsdlLocator = this.getWsdlLocator(wsdlLocation, resolveWSDL);
                            Definition def = null;
                            if (wsdlLocator != null) {
                                def = reader.readWSDL(wsdlLocator);
                            }
                            if (def != null) {
                                QName tmpQName = serviceRef.getServiceQname();
                                if (tmpQName != null) {
                                    javax.xml.namespace.QName qName = new javax.xml.namespace.QName(tmpQName.getNamespaceURI(), tmpQName.getLocalPart());
                                    Service service = def.getService(qName);
                                    if (service != null) {
                                        WSClientType type = null;
                                        if (wscType == null) {
                                            type = WSClientType.JAX_WS;
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Designating the " + serviceRef.getServiceRefName() + " service-ref as JAX-WS because client type was returned " + "as null");
                                            }
                                        } else if (wscType.equals((Object)WebServiceClientType.JAXRPC)) {
                                            type = WSClientType.JAX_RPC;
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Designating the " + serviceRef.getServiceRefName() + " service-ref as JAX-RPC");
                                            }
                                        } else if (wscType.equals((Object)WebServiceClientType.JAXWS)) {
                                            type = WSClientType.JAX_WS;
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Designating the " + serviceRef.getServiceRefName() + " service-ref as JAX-WS");
                                            }
                                        }
                                        String serviceClassName = serviceRef.getServiceInterface() != null ? serviceRef.getServiceInterface().getQualifiedName() : null;
                                        ServiceRefInfoImpl srInfo = new ServiceRefInfoImpl(serviceClassName, serviceRef.getServiceRefName());
                                        DDClientServiceDescriptorImpl serviceDesc = new DDClientServiceDescriptorImpl(service, type, srInfo);
                                        this.serviceRefMap.put(service.getQName(), serviceDesc);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Built DDClientServiceDescriptorImpl: " + serviceDesc.getQName());
                                        }
                                        ++this.serviceClientCount;
                                        continue;
                                    }
                                    if (!_tc.isDebugEnabled()) continue;
                                    Tr.debug(_tc, "Could not build JAX-RPC client service descriptor because a wsdl:service could not be found");
                                    continue;
                                }
                                if (!_tc.isDebugEnabled()) continue;
                                Tr.debug(_tc, "Could not build JAX-RPC client service descriptor because ServiceRef did not have QName.");
                                continue;
                            }
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "Could not build JAX-RPC client service descriptor because WSDL definition could not be loaded.");
                        }
                        break block25;
                    }
                    if (!_tc.isDebugEnabled()) break block25;
                    Tr.debug(_tc, "No JAX-WS service refs in module: " + this.moduleFile.getName());
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.buildDDServiceRefs", "804", this);
                    Object[] inserts = new Object[]{this.moduleFile.getName(), t};
                    Tr.error(_tc, "buildSvcDescFail00", inserts);
                    Object var17_19 = null;
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "buildDDerviceRefs= " + this.moduleFile.getName());
                    }
                    this.ddServiceRefsBuilt = true;
                    return;
                }
            }
            Object var17_18 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "buildDDerviceRefs= " + this.moduleFile.getName());
            }
            this.ddServiceRefsBuilt = true;
            return;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "buildDDerviceRefs= " + this.moduleFile.getName());
            }
            this.ddServiceRefsBuilt = true;
            throw throwable;
        }
    }

    private void buildJAXWSServiceRefs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildJAXWSServiceRefs= " + this.moduleFile.getName());
        }
        String className = null;
        this.initDBCMap();
        if (this.dbcMap != null && !this.dbcMap.isEmpty()) {
            for (DescriptionBuilderComposite dbc : this.dbcMap.values()) {
                try {
                    javax.xml.namespace.QName serviceQName;
                    if (dbc.getWebServiceClientAnnot() == null) continue;
                    className = dbc.getClassName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "@WebServiceClient annotation being processed on class: " + className);
                    }
                    if (this.serviceRefMap.get(serviceQName = new javax.xml.namespace.QName(dbc.getWebServiceClientAnnot().targetNamespace(), dbc.getWebServiceClientAnnot().name())) == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Building new WSClientServiceDescriptor for service: " + serviceQName);
                        }
                        Service service = null;
                        String wsdlLocation = dbc.getWebServiceClientAnnot().wsdlLocation();
                        if (wsdlLocation != null && !"".equals(wsdlLocation)) {
                            WSDLLocator locator = this.getWsdlLocator(wsdlLocation, true);
                            if (locator != null) {
                                WSDLReader reader = this.getWSDLReader();
                                Definition def = reader.readWSDL(locator);
                                if (def != null) {
                                    service = def.getService(serviceQName);
                                }
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "The WSDL file: " + wsdlLocation + " could not be " + "loaded... building client metadata from annotations");
                            }
                        }
                        if (service != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Building client hierarchy from WSDL service");
                            }
                            ServiceRefInfoImpl srInfo = new ServiceRefInfoImpl(dbc.getClassName(), null);
                            this.serviceRefMap.put(serviceQName, new WSClientServiceDescriptorImpl(service, srInfo));
                            ++this.serviceClientCount;
                            continue;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Building client hierarchy from annotation metadata");
                        }
                        this.serviceRefMap.put(serviceQName, new WSClientServiceDescriptorDBC(dbc, this.dbcMap));
                        ++this.serviceClientCount;
                        continue;
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "WSClientServiceDescriptor has already been built for service: " + serviceQName);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.buildServiceRefs", "350", this);
                    Object[] inserts = new Object[]{className, t};
                    Tr.error(_tc, "useWSCAnnoDataFail00", inserts);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildJAXWSServiceRefs= " + this.moduleFile.getName());
        }
        this.jaxwsServiceRefsBuilt = true;
    }

    private void buildJAXWSServiceList(AxisServiceGroup serviceGroup, List<ServiceDescription> sdList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildServiceList, serviceCount= " + this.jaxwsServiceCount);
        }
        HashMap<javax.xml.namespace.QName, JAXWSServiceDescriptorImpl> serviceDescMap = new HashMap<javax.xml.namespace.QName, JAXWSServiceDescriptorImpl>();
        HashMap<javax.xml.namespace.QName, MDQServiceDescriptorImpl> sdServiceDescMap = new HashMap<javax.xml.namespace.QName, MDQServiceDescriptorImpl>();
        for (ServiceDescription sd : sdList) {
            for (EndpointDescription ed : sd.getEndpointDescriptions_AsCollection()) {
                AxisService axisService = ed.getAxisService();
                if (axisService == null) continue;
                if (Axis2Utils.getWSDLDefinition((AxisService)axisService) != null && this.wsdlIsFullySpecified(ed)) {
                    JAXWSEndpointDescriptorImpl endpointDesc = new JAXWSEndpointDescriptorImpl(Axis2Utils.getWSDLPort((AxisService)axisService), axisService, null);
                    javax.xml.namespace.QName serviceQName = endpointDesc.getServiceQName();
                    JAXWSServiceDescriptorImpl serviceDesc = (JAXWSServiceDescriptorImpl)serviceDescMap.get(serviceQName);
                    if (serviceDesc != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Already built JAXWSServiceDescriptorImpl for service: " + serviceQName);
                        }
                        endpointDesc.setParent(serviceDesc);
                        serviceDesc.addEndpoint(endpointDesc);
                        continue;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Building JAXWSServiceDescriptorImpl for service: " + serviceQName);
                    }
                    serviceDesc = new JAXWSServiceDescriptorImpl(axisService, Axis2Utils.getWSDLService((AxisService)axisService), this);
                    endpointDesc.setParent(serviceDesc);
                    serviceDesc.addEndpoint(endpointDesc);
                    serviceDescMap.put(serviceQName, serviceDesc);
                    this.serviceDescList.add(serviceDesc);
                    ++this.jaxwsServiceCount;
                    continue;
                }
                if (sdServiceDescMap.get(sd.getServiceQName()) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Building MDQServiceDescriptorImpl from ServiceDescription hierarchy for service: " + sd.getServiceQName());
                    }
                    MDQServiceDescriptorImpl serviceDescriptor = new MDQServiceDescriptorImpl(this, sd);
                    sdServiceDescMap.put(sd.getServiceQName(), serviceDescriptor);
                    this.serviceDescList.add(serviceDescriptor);
                    ++this.jaxwsServiceCount;
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Already built WSServiceDescriptor list from ServiceDescription hierarchy for service: " + sd.getServiceQName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildServiceList, serviceCount= " + this.jaxwsServiceCount);
        }
    }

    protected WSDLLocator getWsdlLocator(String wsdlLocation, boolean resolveWSDL) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWsdlLocator");
        }
        String redirectedLoc = null;
        if (wsdlLocation != null) {
            if (resolveWSDL) {
                wsdlLocation = this.catalogAccessor.resolveLocation(wsdlLocation);
            }
            InputStream is = null;
            LoadStrategy ls = this.moduleFile.getLoadStrategy();
            if (Axis2Utils.isAbsolutePath((String)wsdlLocation)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for @WebServiceClient absolute WSDL location " + wsdlLocation);
                }
                try {
                    is = ls.getResourceInputStream(wsdlLocation);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (is == null) {
                    try {
                        URL url = new URL(wsdlLocation);
                        final URLConnection urlConn = url.openConnection();
                        is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                            @Override
                            public InputStream run() throws IOException {
                                return urlConn.getInputStream();
                            }
                        });
                        if (wsdlLocation.endsWith("?wsdl") || wsdlLocation.endsWith("/wsdl") || wsdlLocation.endsWith("/wsdl/")) {
                            redirectedLoc = urlConn.getURL().toString();
                        }
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
                if (is == null) {
                    try {
                        URL url;
                        File file = new File(wsdlLocation);
                        if (file != null && (url = file.toURL()) != null) {
                            is = url.openStream();
                        }
                    }
                    catch (Throwable t3) {}
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for relative WSDL location " + wsdlLocation + " in module: " + this.moduleFile.getName());
                }
                try {
                    is = this.classLoader.getResourceAsStream(wsdlLocation);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (is == null) {
                    try {
                        is = ls.getInputStream(wsdlLocation);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
                if (is == null) {
                    try {
                        is = WSModels.getJavaWSDLInputStream(wsdlLocation, ls);
                    }
                    catch (Throwable t3) {
                        // empty catch block
                    }
                }
            }
            if (is != null) {
                ModuleWSDLLocator wsdlLoc = new ModuleWSDLLocator(redirectedLoc != null ? redirectedLoc : wsdlLocation, is, ls, this.catalogAccessor);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getWsdlLocator");
                }
                return wsdlLoc;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWsdlLocator");
        }
        return null;
    }

    private void initializeClassLoader() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "intializeClassLoader");
        }
        if ((this.moduleFile.isWARFile() || this.moduleFile.isEJBJarFile()) && this.moduleFile.getArchiveClassLoader() != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Module archive classloader already initialized: " + this.moduleFile.getName());
            }
            this.classLoader = this.moduleFile.getArchiveClassLoader();
            if (_tc.isDebugEnabled()) {
                boolean temp = this.moduleFile.getOptions().useJavaReflection();
                boolean temp1 = this.moduleFile.shouldUseJavaReflection();
                if (this.classLoader != null) {
                    Tr.debug(_tc, "archive classloader : " + this.classLoader + " reflection : " + temp + " shouldUseJavaReflection : " + temp1);
                } else {
                    Tr.debug(_tc, "archive classloader is NULL. reflection : " + temp + " shouldUseJavaReflection : " + temp1);
                }
            }
        } else if ((this.moduleFile.isWARFile() || this.moduleFile.isEJBJarFile()) && this.moduleFile.getArchiveClassLoader() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Initializing module archive classloader");
            }
            try {
                this.moduleFile.getOptions().setUseJavaReflection(true);
                this.classLoader = this.moduleFile.getArchiveClassLoader();
                if (_tc.isDebugEnabled()) {
                    boolean temp = this.moduleFile.getOptions().useJavaReflection();
                    boolean temp1 = this.moduleFile.shouldUseJavaReflection();
                    if (this.classLoader != null) {
                        Tr.debug(_tc, "archive classloader : " + this.classLoader + " reflection : " + temp + " shouldUseJavaReflection : " + temp1);
                    } else {
                        Tr.debug(_tc, "archive classloader is NULL. reflection : " + temp + " shouldUseJavaReflection : " + temp1);
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.initializeClassLoader", "578", this);
                Tr.warning(_tc, "An error was encountered retrieving the classloader for the module " + this.moduleFile.getName() + ". This may cause unpredictable results");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "intializeClassLoader");
        }
    }

    private void initCache() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initCache");
        }
        String applicationName = WebServiceUtils.getApplicationName(this.moduleFile);
        String moduleName = this.moduleFile.getName();
        String cacheLocation = applicationName + File.separator + moduleName + File.separator;
        this.cache = WebServicesModuleCacheMgr.getModuleCache(cacheLocation);
        this.cache.setClassLoader(this.classLoader);
        if (this.cache.oldCacheExists()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "For module: " + moduleName + " a feature pack version of " + "the web services metadata cache was found. This cache will be updated.");
            }
            try {
                WSCacheWriter writer = new WSCacheWriter(applicationName);
                writer.writeModuleCache(this.moduleFile, true, this.classLoader);
            }
            catch (Exception e) {
                Tr.info(_tc, "writeCacheFail00", new Object[]{moduleName, applicationName, e});
            }
        }
        this.cache.load();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initCache");
        }
    }

    private List<FileLocator> buildLocators(List<String> classNames) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildLocators");
        }
        ArrayList<FileLocator> locators = new ArrayList<FileLocator>();
        if (classNames != null && !classNames.isEmpty()) {
            for (String className : classNames) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Constructed FileLocator from cache: " + className);
                }
                try {
                    URL url = this.classLoader.getResource(className);
                    if (url != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found URL for class: " + className + " with classloader: " + this.classLoader.toString());
                        }
                        CachedFileLocator locator = new CachedFileLocator(url, className);
                        locators.add((FileLocator)locator);
                        continue;
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Did not find URL for class: " + className + " with classloader: " + this.classLoader.toString());
                }
                catch (Exception e) {
                    Tr.warning(_tc, "The following problem occurred when trying to load application metadata from cache: " + e.toString() + ". The " + "application metadata will now be loaded from the web module.");
                    throw e;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildLocators");
        }
        return locators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBCMap() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initDBCMap");
        }
        String key = null;
        Object moduleAppLock = null;
        Object object = staticLock;
        synchronized (object) {
            key = WebServiceUtils.getApplicationName(this.moduleFile) + this.moduleFile.getName();
            moduleAppLock = moduleAppLocks.get(key);
            if (moduleAppLock == null) {
                moduleAppLock = new Object();
                moduleAppLocks.put(key, moduleAppLock);
            }
        }
        object = moduleAppLock;
        synchronized (object) {
            try {
                ModuleInfo moduleInfo;
                SoftReference<ModuleInfo> sr = moduleInfoMap.get(key);
                ModuleInfo moduleInfo2 = moduleInfo = sr != null ? sr.get() : null;
                if (moduleInfo != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "For module: " + this.moduleFile.getName() + " retrieving DBC map from " + "cached ModuleInfo instance");
                    }
                    this.dbcMap = moduleInfo.getDBCs();
                    if (this.dbcMap != null && !this.dbcMap.isEmpty()) {
                        this.update(this.dbcMap.values().iterator());
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        String msg = null;
                        msg = moduleInfo == null ? "Cached information was not found for the module: " + this.moduleFile.getName() : "Cached information was found for the module: " + this.moduleFile.getName() + " but the timestamps in the cache and current module do not match, cachedTimeStamp= " + moduleInfo.getLastModified() + ", currentTimeStamp= " + this.moduleFile.getLastModified();
                        Tr.debug(_tc, msg);
                    }
                    if (!this.dbcMapInitialized) {
                        this.getClassDataObjects();
                        if (this.moduleCDOs != null && !this.moduleCDOs.isEmpty()) {
                            WASAnnotationInputBuilder builder = new WASAnnotationInputBuilder(this.moduleCDOs, this.classLoader, (Archive)this.moduleFile);
                            this.dbcMap = builder.buildInputs();
                            String xmlFileName = this.moduleFile.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
                            WebServices webServices = WSModels.getWebServices(this.moduleFile.getLoadStrategy(), xmlFileName);
                            WSServerMetadataMerger merger = new WSServerMetadataMerger(this.dbcMap, webServices, this.moduleFile.getLoadStrategy(), this.moduleFile.getName());
                            this.dbcMap.putAll(merger.mergeMetadata());
                            this.moduleCDOs.clear();
                        }
                    }
                    if (this.dbcMap == null) {
                        this.dbcMap = new HashMap();
                    }
                    if ("unknown_ws_app_name".equals(WebServiceUtils.getApplicationName(this.moduleFile))) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "ModuleInfo will not be cached because the application name is unknown");
                        }
                    } else {
                        ModuleInfo info = new ModuleInfo(this.dbcMap, this.moduleFile.getLastModified());
                        moduleInfoMap.put(key, new SoftReference<ModuleInfo>(info));
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Inserted ModuleInfo into cache for WSModuleDescriptor by key: " + key);
                            Tr.debug(_tc, "ModuleInfo map size after insertion: " + moduleInfoMap.size());
                        }
                    }
                }
                this.dbcMapInitialized = true;
            }
            catch (Throwable t) {
                Object[] inserts = new Object[]{this.moduleFile.getName(), t};
                Tr.error(_tc, "loadAppMetaFail00", inserts);
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.initDBCMap", "1584", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initDBCMap");
        }
    }

    private void update(Iterator<DescriptionBuilderComposite> dbcIter) {
        while (dbcIter.hasNext()) {
            DescriptionBuilderComposite dbc = dbcIter.next();
            dbc.setClassLoader(this.classLoader);
            this.catalogAccessor = new JaxWSCatalogAccessor(this.classLoader);
            if (dbc.getCustomWsdlGenerator() == null || !(dbc.getCustomWsdlGenerator() instanceof BaseWSDLGenerator)) continue;
            ((BaseWSDLGenerator)dbc.getCustomWsdlGenerator()).setModuleFile(this.moduleFile);
        }
    }

    private boolean wsdlIsFullySpecified(EndpointDescription ed) {
        if (ed instanceof EndpointDescriptionWSDL) {
            return ((EndpointDescriptionWSDL)ed).isWSDLFullySpecified();
        }
        return true;
    }

    private void initJAXRPCServices() {
        Set<String> jaxwsClassList = null;
        if (this.dbcMapInitialized && this.dbcMap != null) {
            jaxwsClassList = this.dbcMap.keySet();
        }
        if (this.moduleFile.isWARFile()) {
            JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper(this.moduleFile, this.classLoader, jaxwsClassList);
            JAXRPCMetaDataWrapper wrapper = helper.loadJAXRPCMetaData();
            this.jaxrpcServices = wrapper.getWebServices();
            this.jaxrpcPortComponents = wrapper.getJaxrpcPortComponents();
        } else if (this.moduleFile.isEJBJarFile()) {
            JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper(this.moduleFile, this.classLoader, jaxwsClassList);
            JAXRPCMetaDataWrapper wrapper = helper.loadJAXRPCMetaData();
            this.jaxrpcServices = wrapper.getWebServices();
            this.jaxrpcPortComponents = wrapper.getJaxrpcPortComponents();
        }
        this.jaxrpcServicesInitialized = true;
    }

    private void initDDServiceRefs() {
        ModuleServiceRefAccessor serviceRefAccessor = null;
        try {
            if (this.moduleFile.isWARFile()) {
                WebApp webApp = ((WARFile)this.moduleFile).getDeploymentDescriptor();
                if (webApp != null && webApp.getJ2EEVersionID() < 14 && !this.moduleFile.containsFile("WEB-INF/webservicesclient.xml")) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The module: " + this.moduleFile.getName() + " is at an earlier " + "version than J2EE 1.4, and it does not contain a WEB-INF/" + "webservicesclient.xml file. No service-ref processing will " + "be done during cache writing.");
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Creating ServiceRef accessor for WAR module: " + this.moduleFile.getName());
                    }
                    if ((serviceRefAccessor = ModuleServiceRefAccessorFactory.createModuleServiceRefAccessorWeb(this.moduleFile.getLoadStrategy().getResourceSet(), null)) != null && serviceRefAccessor.getServiceReferences() != null && serviceRefAccessor.getServiceReferences().size() > 0) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding service refs found in WAR module: " + this.moduleFile.getName());
                        }
                        this.ddServiceRefs.addAll(serviceRefAccessor.getServiceReferences());
                    }
                }
            } else if (this.moduleFile.isEJBJarFile()) {
                EJBJarFile ejbJarFile;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Creating ServiceRef accessor for EJBJar module: " + this.moduleFile.getName());
                }
                if ((ejbJarFile = (EJBJarFile)this.moduleFile).getDeploymentDescriptor() != null) {
                    EJBJar ejbDD = ejbJarFile.getDeploymentDescriptor();
                    if (ejbDD.getJ2EEVersionID() < 14 && !ejbJarFile.containsFile("META-INF/webservicesclient.xml")) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The module: " + this.moduleFile.getName() + " is at an earlier " + "version than J2EE 1.4, and it does not contain a META-INF/" + "webservicesclient.xml file. No service-ref processing " + "will be done during cache writing.");
                        }
                    } else {
                        for (EnterpriseBean bean : ejbDD.getEnterpriseBeans()) {
                            serviceRefAccessor = ModuleServiceRefAccessorFactory.createModuleServiceRefAccessorEJB(this.moduleFile.getLoadStrategy().getResourceSet(), null, bean.getName());
                            if (serviceRefAccessor == null || serviceRefAccessor.getServiceReferences() == null || serviceRefAccessor.getServiceReferences().size() <= 0) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Adding service refs found in EJB module: " + this.moduleFile.getName() + " for bean: " + bean.getName());
                            }
                            this.ddServiceRefs.addAll(serviceRefAccessor.getServiceReferences());
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl.initDDServiceRefs", "1362", this);
            Object[] inserts = new Object[]{this.moduleFile.getName(), t};
            Tr.error(_tc, "buildSvcDescFail00", inserts);
        }
        this.ddServiceRefsInitialized = true;
    }

    protected WSDLReader getWSDLReader() throws Exception {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("com.ibm.wsdl.useWSDLLocatorAsEntityResolver", true);
        return reader;
    }

    private Service findWSDLService(PortComponent pc, Definition def) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "findWSDLService");
        }
        if (def.getServices() == null || def.getServices().isEmpty()) {
            return null;
        }
        Service targetService = null;
        for (Service service : def.getServices().values()) {
            javax.xml.namespace.QName sQName = service.getQName();
            if (sQName == null || sQName.getNamespaceURI() == null && pc.getWsdlPort().getNamespaceURI() != null || sQName.getNamespaceURI() != null && pc.getWsdlPort().getNamespaceURI() == null || (sQName.getNamespaceURI() != null || pc.getWsdlPort().getNamespaceURI() != null) && !sQName.getNamespaceURI().equals(pc.getWsdlPort().getNamespaceURI()) || service.getPort(pc.getWsdlPort().getLocalPart()) == null) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found service: " + service.getQName() + " for wsdl:port: " + pc.getWsdlPort().getLocalPart());
            }
            targetService = service;
            break;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findWSDLService= " + targetService);
        }
        return targetService;
    }

    protected ModuleFile getModuleFile() {
        return this.moduleFile;
    }

    public HashMap<String, DescriptionBuilderComposite> getDBCs() throws Exception {
        this.initDBCMap();
        return this.dbcMap;
    }

    public static void clearCache(ModuleFile moduleFile) {
        String key = WebServiceUtils.getApplicationName(moduleFile) + moduleFile.getName();
        SoftReference<ModuleInfo> obj = moduleInfoMap.remove(key);
        if (obj != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed DBC map for key: " + key);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Did not find DBC map to remove for key: " + key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModuleInfo {
        private HashMap<String, DescriptionBuilderComposite> dbcs;
        private Long lastModified;

        ModuleInfo(HashMap<String, DescriptionBuilderComposite> dbcs, Long lastModified) {
            this.dbcs = dbcs;
            this.lastModified = lastModified;
        }

        public HashMap<String, DescriptionBuilderComposite> getDBCs() {
            return this.dbcs;
        }

        public Long getLastModified() {
            return this.lastModified;
        }
    }
}

