/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.wsspi.websvcs.desc.ServiceBeanInfo;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.Service;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtils {
    private static final TraceComponent _tc = Tr.register(DBUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static String printDBObject(Object dbInstance) {
        String dbToString = null;
        dbToString = dbInstance instanceof WSServiceDescriptor ? DBUtils.printWSServiceDescriptor((WSServiceDescriptor)dbInstance) : (dbInstance instanceof WSEndpointDescriptor ? DBUtils.printWSEndpointDescriptor((WSEndpointDescriptor)dbInstance) : (dbInstance instanceof WSOperationDescriptor ? DBUtils.printWSOperationDescriptor((WSOperationDescriptor)dbInstance) : (dbInstance instanceof WSClientServiceDescriptor ? DBUtils.printWSClientServiceDescriptor((WSClientServiceDescriptor)dbInstance) : (dbInstance instanceof WSClientEndpointDescriptor ? DBUtils.printWSClientEndpointDescriptor((WSClientEndpointDescriptor)dbInstance) : (dbInstance instanceof WSClientOperationDescriptor ? DBUtils.printWSClientOperationDescriptor((WSClientOperationDescriptor)dbInstance) : (dbInstance instanceof ServiceBeanInfo ? DBUtils.printServiceBeanInfo((ServiceBeanInfo)dbInstance) : "Unknown type of DescriptionBuilder hierarchy"))))));
        return dbToString;
    }

    private static String printWSServiceDescriptor(WSServiceDescriptor serviceDesc) {
        String sdToString = "\n";
        String className = serviceDesc.getClass().getSimpleName();
        sdToString = sdToString + className + "\n Name: " + serviceDesc.getName() + "\n QName: " + serviceDesc.getQName() + "\n WSDL location base name: " + serviceDesc.getWSDLLocationBaseName() + "\n WSDL location URI: " + serviceDesc.getWSDLLocationURI() + "\n";
        Iterator endpointIter = serviceDesc.getEndpoints();
        while (endpointIter.hasNext()) {
            sdToString = sdToString + endpointIter.next().toString() + "\n";
        }
        return sdToString;
    }

    private static String printWSEndpointDescriptor(WSEndpointDescriptor endpointDesc) {
        String edToString = null;
        String className = endpointDesc.getClass().getSimpleName();
        edToString = className + "\n Name: " + endpointDesc.getName() + "\n Port component name: " + endpointDesc.getPortComponentName() + "\n QName: " + endpointDesc.getQName() + "\n Binding: " + endpointDesc.getBindingQName() + "\n Port Type: " + endpointDesc.getPortTypeQName() + "\n URL pattern: " + endpointDesc.getURLPattern() + "\n" + endpointDesc.getServiceBeanInfo().toString() + "\n";
        Iterator operationIter = endpointDesc.getOperations();
        while (operationIter.hasNext()) {
            edToString = edToString + operationIter.next().toString() + "\n";
        }
        return edToString;
    }

    private static String printWSOperationDescriptor(WSOperationDescriptor operationDesc) {
        String odToString = null;
        String className = operationDesc.getClass().getSimpleName();
        odToString = className + "\n Name: " + operationDesc.getName() + "\n";
        return odToString;
    }

    private static String printWSClientServiceDescriptor(WSClientServiceDescriptor clientServiceDesc) {
        String csdToString = "\n";
        String className = clientServiceDesc.getClass().getSimpleName();
        csdToString = csdToString + className + "\n QName: " + clientServiceDesc.getQName() + "\n Client type: " + (Object)((Object)clientServiceDesc.getClientType()) + "\n";
        Iterator endpointIter = clientServiceDesc.getEndpoints();
        while (endpointIter.hasNext()) {
            csdToString = csdToString + endpointIter.next().toString() + "\n";
        }
        return csdToString;
    }

    private static String printWSClientEndpointDescriptor(WSClientEndpointDescriptor clientEndpointDesc) {
        String cedToString = null;
        String className = clientEndpointDesc.getClass().getSimpleName();
        cedToString = className + "\n Name: " + clientEndpointDesc.getName() + "\n Binding: " + clientEndpointDesc.getBindingQName() + "\n Port Type:" + clientEndpointDesc.getPortTypeQName();
        cedToString = cedToString + "\n";
        Iterator operationIter = clientEndpointDesc.getOperations();
        while (operationIter.hasNext()) {
            cedToString = cedToString + operationIter.next().toString() + "\n";
        }
        return cedToString;
    }

    private static String printWSClientOperationDescriptor(WSClientOperationDescriptor clientOperationDesc) {
        String oedToString = null;
        String className = clientOperationDesc.getClass().getSimpleName();
        oedToString = className + "\n Name: " + clientOperationDesc.getName() + "\n";
        return oedToString;
    }

    private static String printServiceBeanInfo(ServiceBeanInfo beanInfo) {
        String sbToString = null;
        String className = beanInfo.getClass().getSimpleName();
        sbToString = className + "\n Implementation class: " + beanInfo.getImplClassName() + "\n Bean type: " + (Object)((Object)beanInfo.getBeanType()) + "\n Link value: " + beanInfo.getLinkValue();
        return sbToString;
    }

    public static String getWebServiceRefService(WebServiceRefAnnot wsrAnnot, String fieldClassName, Map<String, DescriptionBuilderComposite> dbcMap) {
        String serviceClassName = null;
        DescriptionBuilderComposite dbc = null;
        if (fieldClassName != null) {
            dbc = dbcMap.get(fieldClassName);
            if (dbc != null && dbc.getWebServiceClientAnnot() != null) {
                serviceClassName = fieldClassName;
            } else if (dbc != null && dbc.getWebServiceAnnot() != null) {
                serviceClassName = wsrAnnot.getValueString();
            }
        } else if (wsrAnnot.getTypeString() != null) {
            dbc = dbcMap.get(wsrAnnot.getTypeString());
            if (dbc != null && dbc.getWebServiceAnnot() != null) {
                serviceClassName = wsrAnnot.getValueString();
            } else if (dbc != null && dbc.getWebServiceClientAnnot() != null) {
                serviceClassName = wsrAnnot.getTypeString();
            }
        }
        if (serviceClassName.startsWith("L") && (serviceClassName = serviceClassName.substring(1)).endsWith(";")) {
            serviceClassName = serviceClassName.substring(0, serviceClassName.length() - 1);
        }
        if (serviceClassName.indexOf("/") != -1) {
            serviceClassName = serviceClassName.replace("/", ".");
        }
        if (_tc.isDebugEnabled() && serviceClassName != null) {
            Tr.debug(_tc, "Found @WebServiceRef service class: " + serviceClassName);
        } else if (_tc.isDebugEnabled() && serviceClassName == null) {
            Tr.debug(_tc, "Did not find @WebServiceRef service class");
        }
        return serviceClassName;
    }

    public static String getWebServiceRefSEI(WebServiceRefAnnot wsrAnnot, String fieldClassName, Map<String, DescriptionBuilderComposite> dbcMap) {
        String seiClassName = null;
        DescriptionBuilderComposite dbc = null;
        if (fieldClassName != null) {
            dbc = dbcMap.get(fieldClassName);
            if (dbc != null && dbc.getWebServiceAnnot() != null) {
                seiClassName = fieldClassName;
            }
        } else {
            dbc = dbcMap.get(wsrAnnot.getTypeString());
            if (dbc != null && dbc.getWebServiceAnnot() != null) {
                seiClassName = fieldClassName;
            }
        }
        if (_tc.isDebugEnabled() && seiClassName != null) {
            Tr.debug(_tc, "Found @WebServiceRef SEI class: " + seiClassName);
        } else if (_tc.isDebugEnabled() && seiClassName == null) {
            Tr.debug(_tc, "Did not find @WebServiceRef SEI class");
        }
        return seiClassName;
    }

    public static WSClientType getServiceRefType(ServiceRef serviceRef, ClassLoader classLoader) {
        WSClientType clientType = null;
        String siName = serviceRef.getServiceInterface().getQualifiedName();
        try {
            Class siClass = ClassUtils.forName((String)siName, (boolean)false, (ClassLoader)classLoader);
            if (Service.class.isAssignableFrom(siClass)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found JAX-WS service reference with name: " + serviceRef.getServiceRefName() + " and service interface class: " + siName);
                }
                clientType = WSClientType.JAX_WS;
            } else if (javax.xml.rpc.Service.class.isAssignableFrom(siClass)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found JAX-RPC service reference with name: " + serviceRef.getServiceRefName() + " and service interface class: " + siName);
                }
                clientType = WSClientType.JAX_RPC;
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found unknown service reference with name: " + serviceRef.getServiceRefName());
                }
                clientType = WSClientType.UNKNOWN;
            }
        }
        catch (ClassNotFoundException cnfe) {
            Tr.warning(_tc, "For service ref: " + serviceRef.getServiceRefName() + " the " + "type of programming model in use could not be determined " + "because the service interface class: " + siName + " could not " + "be loaded.");
            clientType = WSClientType.UNKNOWN;
        }
        return clientType;
    }
}

