/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.deploy.PersistentStorageInstallSaveTask;
import com.ibm.ws.websvcs.deploy.PersistentStorageInstallTask;
import com.ibm.ws.websvcs.deploy.PersistentStorageUninstallSaveTask;
import com.ibm.ws.websvcs.deploy.PersistentStorageUninstallTask;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PersistentStorageTaskProvider
implements AppManagementExtensions.AppDeploymentTaskProvider,
AppManagementExtensions.AppUpdateTaskProvider,
AppManagementExtensions.AppSyncTaskProvider,
Constants {
    private static final TraceComponent tc = Tr.register(PersistentStorageTaskProvider.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void provideAppAddedSyncTasks(Vector appAddedTasks) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Providing WSFP cache install task");
        }
        WASAnnotationCollector.registerAnnotationAdapters();
        appAddedTasks.add(PersistentStorageInstallSaveTask.class.getName());
    }

    public void provideAppModifiedSyncTasks(Vector appModifiedTasks) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Providing WSFP cache uninstall task");
        }
        WASAnnotationCollector.registerAnnotationAdapters();
        int index = this.getIndexForUpdateTaskInsertion(appModifiedTasks);
        appModifiedTasks.insertElementAt(PersistentStorageUninstallSaveTask.class.getName(), index);
        appModifiedTasks.insertElementAt(PersistentStorageInstallSaveTask.class.getName(), index + 1);
    }

    public void provideAppRemovedSyncTasks(Vector appRemovedTasks) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Providing WSFP cache uninstall task");
        }
        appRemovedTasks.add(PersistentStorageUninstallSaveTask.class.getName());
    }

    public void provideUpdateTasks(Vector updateTasks, UpdateScheduler scheduler) throws AdminException {
        WASAnnotationCollector.registerAnnotationAdapters();
        updateTasks.insertElementAt(PersistentStorageUninstallTask.class.getName(), 0);
    }

    public void provideExtensionsForInstallFailure(Vector failureTasks, InstallScheduler scheduler) throws AppDeploymentException {
        failureTasks.add(PersistentStorageUninstallTask.class.getName());
    }

    public void provideServerExtensionsForEdit(Vector editTasks, Scheduler scheduler) throws AppDeploymentException {
        WASAnnotationCollector.registerAnnotationAdapters();
        editTasks.insertElementAt(PersistentStorageUninstallTask.class.getName(), 0);
    }

    public void provideServerInstallExtensions(Vector installTasks, InstallScheduler scheduler) throws AppDeploymentException {
        WASAnnotationCollector.registerAnnotationAdapters();
        installTasks.insertElementAt(PersistentStorageUninstallTask.class.getName(), 0);
        installTasks.insertElementAt(PersistentStorageInstallTask.class.getName(), 1);
    }

    public void provideServerUninstallExtensions(Vector uninstallTasks, Scheduler scheduler) throws AppDeploymentException {
    }

    public void getAppDeploymentTaskInfoToTaskMapping(Vector arg0, Hashtable arg1) throws AppDeploymentException {
        WASAnnotationCollector.registerAnnotationAdapters();
    }

    public void provideClientDeploymentTasks(Vector arg0, AppDeploymentInfo arg1, Hashtable arg2) throws AppDeploymentException {
        WASAnnotationCollector.registerAnnotationAdapters();
    }

    public void provideClientDeploymentTasksForEdit(Vector arg0, AppDeploymentInfo arg1, Hashtable arg2) throws AppDeploymentException {
        WASAnnotationCollector.registerAnnotationAdapters();
    }

    public void provideExtensionsForUninstallFailure(Vector arg0, InstallScheduler arg1) throws AppDeploymentException {
    }

    public void providePreUpdateTasks(Vector tasks, UpdateScheduler scheduler) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pre-Update tasks setting cache root directory on TLS: " + scheduler.getTempDir());
        }
        CacheRootDirectoryTLS.set(scheduler.getTempDir());
    }

    int getIndexForUpdateTaskInsertion(Vector appModifiedTasks) {
        int index = 0;
        if (appModifiedTasks != null) {
            Iterator tIter = appModifiedTasks.iterator();
            int count = 0;
            String addBinaryTask = "com.ibm.ws.management.application.sync.AddBinaryTask";
            while (tIter.hasNext()) {
                String currentTask = (String)tIter.next();
                if (addBinaryTask.equals(currentTask)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found AddBinaryTask at index: " + count);
                    }
                    index = count + 1;
                    break;
                }
                ++count;
            }
        }
        return index;
    }
}

