/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.wssecurity.xss4j.domutil.ExclusiveCanonicalizer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil
extends com.ibm.xml.soapsec.util.DOMUtil {
    private static final TraceComponent tc = Tr.register(DOMUtil.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DOMUtil.class.getName();
    private static Stack soapFactoryPool = new Stack();
    private static final int soapFactoryPoolSize = 50;
    private static final HashSet INDENT_NS = new HashSet();

    public static Document getPrivateConfig() {
        String file = "config/ibm-wssecurity-config-private.xml";
        return DOMUtil.getPrivateConfig((String)file);
    }

    public static void indent(Element element, int init, int diff) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("indent(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "int init[" + init + "]," + "int diff[" + diff + "])"));
        }
        int sp = init + diff;
        if (INDENT_NS.contains(element.getNamespaceURI()) && element.hasChildNodes()) {
            element.normalize();
            Document factory = element.getOwnerDocument();
            Node prev = null;
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() == 1) {
                    if (prev == null || prev.getNodeType() != 3) {
                        element.insertBefore(DOMUtil.createTextNode((Document)factory, (int)sp), child);
                    } else if (DOMUtil.isAllSpace((Node)prev)) {
                        element.replaceChild(DOMUtil.createTextNode((Document)factory, (int)sp), prev);
                    }
                    DOMUtil.indent((Element)child, sp, diff);
                }
                prev = child;
            }
            if (prev == null || prev.getNodeType() != 3) {
                element.appendChild(DOMUtil.createTextNode((Document)factory, (int)init));
            } else if (DOMUtil.isAllSpace((Node)prev)) {
                element.replaceChild(DOMUtil.createTextNode((Document)factory, (int)init), prev);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"indent(Element element,int init,int diff)");
        }
    }

    public static QName getQName(Element element, String qNameStr, int wssVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getQName(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String qNameStr[" + qNameStr + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        QName qn = null;
        qn = wssVersion == 0 && qNameStr.startsWith("http://") ? new QName("", qNameStr) : DOMUtil.getQName((Element)element, (String)qNameStr);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getQName(Element element,String qNameStr,int wssVersion) returns QName[" + qn + "]"));
        }
        return qn;
    }

    public static void setQNameAttr(Element element, String attrNameNS, String attrName, QName attrValue, int wssVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setQNameAttr(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        String strQName = DOMUtil.setQName0(element, attrValue, wssVersion);
        element.setAttributeNS(attrNameNS, attrName, strQName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setQNameAttr(Element element,String attrNameNS,String attrName,QName attrValue,int wssVersion)");
        }
    }

    public static void setQNameAttr(Element element, String attrNameNS, String attrName, QName attrValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setQNameAttr(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "])"));
        }
        String strQName = DOMUtil.setQName0(element, attrValue, -1);
        element.setAttributeNS(attrNameNS, attrName, strQName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setQNameAttr(Element element,String attrNameNS,String attrName,QName attrValue)");
        }
    }

    public static void setQNameText(Element element, QName text, int wssVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setQNameText(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "QName text[" + text + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        String strQName = DOMUtil.setQName0(element, text, wssVersion);
        Document doc = element.getOwnerDocument();
        element.appendChild(doc.createTextNode(strQName));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setQNameText(Element element,QName text,int wssVersion)");
        }
    }

    private static String setQName0(Element elem, QName qName, int wssVersion) {
        String nsURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        if (nsURI == null || nsURI.length() == 0 && wssVersion == 0) {
            return localPart;
        }
        Node n = elem;
        String prefix = null;
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (n instanceof Element) {
            NamedNodeMap map = n.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node attr = map.item(i);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if (!name.startsWith("xmlns")) continue;
                String tmpPrefix = null;
                int index = name.indexOf(":");
                tmpPrefix = index == -1 ? "" : name.substring(index + 1);
                if (value.equals(nsURI) && prefix == null && !usedPrefixes.contains(tmpPrefix)) {
                    prefix = tmpPrefix;
                }
                usedPrefixes.add(tmpPrefix);
            }
            n = n.getParentNode();
        }
        if (prefix == null) {
            while (usedPrefixes.contains(prefix = "ns" + DOMUtil.makeRandomStr())) {
            }
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        }
        return prefix.equals("") ? localPart : prefix + ":" + localPart;
    }

    public static boolean includeNodeset(NodeList nlA, NodeList nlB) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("includeNodeset(NodeList nlA[" + nlA + "]," + "NodeList nlB[" + nlB + "])"));
        }
        boolean ret = true;
        if (nlA == null || nlA.getLength() == 0 || nlB == null || nlB.getLength() == 0 || nlB.getLength() > nlA.getLength()) {
            ret = false;
        } else {
            Node nB = nlB.item(0);
            if (nB.getNodeType() != 1) {
                ret = false;
            } else {
                Node t1;
                int posA;
                int lenA = nlA.getLength();
                int lenB = nlB.getLength();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The count of all nodes in nlA is [" + lenA + "]."));
                    Tr.debug((TraceComponent)tc, (String)("The count of all nodes in nlB is [" + lenB + "]."));
                }
                int posB = 0;
                ArrayList<Node> elems = new ArrayList<Node>();
                ArrayList attrs = null;
                ArrayList texts = null;
                ArrayList others = null;
                ArrayList<Integer> posElems = new ArrayList<Integer>();
                HashMap as = new HashMap();
                HashMap ts = new HashMap();
                HashMap os2 = new HashMap();
                block10: for (posA = 0; posA < lenA; ++posA) {
                    t1 = nlA.item(posA);
                    switch (t1.getNodeType()) {
                        case 1: {
                            if (elems.size() > 0) {
                                int lindex = elems.size() - 1;
                                as.put(elems.get(lindex), attrs);
                                ts.put(elems.get(lindex), texts);
                                os2.put(elems.get(lindex), others);
                            }
                            elems.add(t1);
                            posElems.add(new Integer(posA));
                            attrs = new ArrayList();
                            texts = new ArrayList();
                            others = new ArrayList();
                            continue block10;
                        }
                        case 2: {
                            attrs.add(t1);
                            continue block10;
                        }
                        case 3: 
                        case 4: 
                        case 7: 
                        case 8: {
                            texts.add(t1);
                            continue block10;
                        }
                        default: {
                            others.add(t1);
                        }
                    }
                }
                int lenElems = elems.size();
                int indexElems = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The count of elements in nlA is [" + lenElems + "]."));
                }
                if (lenElems == 0) {
                    ret = false;
                } else {
                    int lindex = elems.size() - 1;
                    as.put(elems.get(lindex), attrs);
                    ts.put(elems.get(lindex), texts);
                    os2.put(elems.get(lindex), others);
                }
                block11: while (indexElems < lenElems && nB != null) {
                    Node nA = null;
                    while (indexElems < lenElems) {
                        t1 = (Node)elems.get(indexElems);
                        if (DOMUtil.equals((Node)t1, (Node)nB)) {
                            nA = t1;
                            posA = (Integer)posElems.get(indexElems);
                            break;
                        }
                        ++indexElems;
                    }
                    if (nA == null || lenA - posA < lenB - posB) {
                        ret = false;
                        break;
                    }
                    while (nA != null) {
                        ++posB;
                        attrs = (ArrayList)as.get(nA);
                        texts = (ArrayList)ts.get(nA);
                        others = (ArrayList)os2.get(nA);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The element is [" + nA + "]"));
                            Tr.debug((TraceComponent)tc, (String)("The position of the element is [" + posA + "]"));
                        }
                        nA = null;
                        if (++indexElems < lenElems) {
                            nA = (Node)elems.get(indexElems);
                        }
                        nB = null;
                        while (posB < lenB) {
                            boolean found = false;
                            boolean elemFound = false;
                            t1 = nlB.item(posB);
                            block5 : switch (t1.getNodeType()) {
                                case 1: {
                                    nB = t1;
                                    elemFound = true;
                                    found = true;
                                    break;
                                }
                                case 2: {
                                    int i;
                                    if (attrs.contains(t1)) {
                                        found = true;
                                        break;
                                    }
                                    for (i = 0; i < attrs.size(); ++i) {
                                        if (!DOMUtil.equals((Node)t1, (Node)((Node)attrs.get(i)))) continue;
                                        found = true;
                                        break block5;
                                    }
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 7: 
                                case 8: {
                                    int i;
                                    if (texts.contains(t1)) {
                                        found = true;
                                        break;
                                    }
                                    for (i = 0; i < texts.size(); ++i) {
                                        if (!DOMUtil.equals((Node)t1, (Node)((Node)texts.get(i)))) continue;
                                        found = true;
                                        break block5;
                                    }
                                    break;
                                }
                                default: {
                                    int i;
                                    if (others.contains(t1)) {
                                        found = true;
                                        break;
                                    }
                                    for (i = 0; i < others.size(); ++i) {
                                        if (!DOMUtil.equals((Node)t1, (Node)((Node)others.get(i)))) continue;
                                        found = true;
                                        break block5;
                                    }
                                }
                            }
                            if (!found) {
                                ret = false;
                                break;
                            }
                            if (elemFound) break;
                            ++posB;
                        }
                        if (!ret || nB == null) continue block11;
                        if (nA == null && nB != null) {
                            ret = false;
                            continue block11;
                        }
                        nA = null;
                        while (indexElems < lenElems) {
                            t1 = (Node)elems.get(indexElems);
                            if (DOMUtil.equals((Node)t1, (Node)nB)) {
                                nA = t1;
                                posA = (Integer)posElems.get(indexElems);
                                break;
                            }
                            ++indexElems;
                        }
                        if (nA != null && lenA - posA >= lenB - posB) continue;
                        ret = false;
                        continue block11;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("includeNodeset(NodeList nlA,NodeList nlB) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    public static boolean equalsc14n(Node node1, Node node2, boolean useInclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("equalsc14n(Node node1[" + DOMUtil.getDisplayName((Node)node1) + "]," + "Node node2[" + DOMUtil.getDisplayName((Node)node2) + "]," + "boolean useInclusive[" + useInclusive + "])"));
        }
        boolean ret = false;
        Hashtable h1 = null;
        Hashtable h2 = null;
        if (useInclusive) {
            h1 = DOMUtil.getPrefixList(node1);
            h2 = DOMUtil.getPrefixList(node2);
        }
        byte[] e14n1 = ExclusiveCanonicalizer.serializeSubset((Hashtable)h1, (Node)node1, (boolean)false);
        byte[] e14n2 = ExclusiveCanonicalizer.serializeSubset((Hashtable)h2, (Node)node2, (boolean)false);
        if (e14n1 != null && e14n2 != null && e14n1.length == e14n2.length) {
            ret = true;
            for (int i = 0; i < e14n1.length; ++i) {
                if (e14n1[i] == e14n2[i]) continue;
                ret = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("equalsc14n(Node node1,Node node2,boolean useInclusive) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    private static Hashtable getPrefixList(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Hashtable<String, String> prefixList = new Hashtable<String, String>();
        for (Node cur = node; cur != null && cur.getNodeType() == 1; cur = cur.getParentNode()) {
            NamedNodeMap map = cur.getAttributes();
            int len = map == null ? 0 : map.getLength();
            for (int i = 0; i < len; ++i) {
                String value;
                String attrn = map.item(i).getNodeName();
                if (attrn.equals("xmlns")) {
                    value = "#default";
                    prefixList.put(value, value);
                    continue;
                }
                if (!attrn.startsWith("xmlns:")) continue;
                value = attrn.substring(6);
                prefixList.put(value, value);
            }
        }
        DOMUtil.scanNamespaceDecls(node, prefixList);
        if (prefixList.size() == 0) {
            prefixList = null;
        }
        return prefixList;
    }

    private static void scanNamespaceDecls(Node node, Hashtable prefixList) {
        NamedNodeMap map = node.getAttributes();
        int len = map == null ? 0 : map.getLength();
        for (int i = 0; i < len; ++i) {
            String value;
            String attrn = map.item(i).getNodeName();
            if (attrn.equals("xmlns")) {
                value = "#default";
                prefixList.put(value, value);
                continue;
            }
            if (!attrn.startsWith("xmlns:")) continue;
            value = attrn.substring(6);
            prefixList.put(value, value);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            DOMUtil.scanNamespaceDecls(n, prefixList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPFactory getSOAPFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSOAPFactory()");
        }
        SOAPFactory factory = null;
        Stack stack = soapFactoryPool;
        synchronized (stack) {
            if (!soapFactoryPool.empty()) {
                factory = (SOAPFactory)soapFactoryPool.pop();
            }
        }
        if (factory == null) {
            factory = new SOAPFactory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSOAPFactory()");
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void releaseSOAPFactory(SOAPFactory soapFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseSOAPFactory(SOAPFactory soapFactory)");
        }
        Stack stack = soapFactoryPool;
        synchronized (stack) {
            if (soapFactoryPool.size() < 50) {
                soapFactoryPool.push(soapFactory);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseSOAPFactory(SOAPFactory soapFactory)");
        }
    }

    public static Hashtable getAncestorsNamespaceDeclaration(Node part) {
        Hashtable<String, String> prefixes = new Hashtable<String, String>();
        for (Node cur = part; cur != null && cur.getNodeType() == 1; cur = cur.getParentNode()) {
            NamedNodeMap map = cur.getAttributes();
            int len = map == null ? 0 : map.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = map.item(i);
                String attrn = node.getNodeName();
                String ns = node.getNamespaceURI();
                if (attrn.equals("xmlns")) {
                    prefixes.put("#default", ns);
                    continue;
                }
                if (!attrn.startsWith("xmlns:")) continue;
                prefixes.put(attrn.substring(6), ns);
            }
        }
        return prefixes;
    }

    public static void copyAncestorsNamespaceDeclaration(Element parent, Element part) {
        Hashtable ns1 = DOMUtil.getAncestorsNamespaceDeclaration(parent);
        Hashtable ns2 = DOMUtil.getAncestorsNamespaceDeclaration(part);
        if (!ns1.isEmpty()) {
            Enumeration e = ns1.keys();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                String ns = (String)ns1.get(prefix);
                if (ns2.containsKey(prefix)) continue;
                part.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
            }
        }
    }

    public static Element clone(Element targetElem) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("clone(Element targetElem):" + targetElem.getLocalName()));
        }
        SOAPFactory factory = DOMUtil.getSOAPFactory();
        SOAPElement clone = null;
        try {
            clone = factory.createElementFromDOMElement(targetElem, SOAPElement.class);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Fail to decouple Token: " + targetElem.getLocalName()), (Object)e.getMessage());
            }
            throw new SoapSecurityException("Fail to decouple Token: " + targetElem.getLocalName());
        }
        clone.getValue();
        DOMUtil.releaseSOAPFactory(factory);
        DOMUtil.copyAncestorsNamespaceDeclaration(targetElem, (Element)clone);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("clone(Element targetElem):" + targetElem.getLocalName()));
        }
        return clone;
    }

    static {
        INDENT_NS.add(Constants.NS_WSSE);
        INDENT_NS.add(Constants.NS_WSSE200306);
        INDENT_NS.add(Constants.NS_WSU);
        INDENT_NS.add(Constants.NS_WSU200306);
        INDENT_NS.add(Constants.NS_DSIG);
        INDENT_NS.add(Constants.NS_ENC);
        INDENT_NS.add(Constants.NS_WSU);
    }
}

