/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfidentialDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(ConfidentialDialectElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfidentialDialectElementSelector.class.getName();
    public static final int BODYCONTENT = 0;
    public static final int USERNAMETOKEN = 1;
    public static final int DIGESTVALUE = 2;
    public static final int SIGNATURE = 3;
    public static final int WSCONTEXTCONTENT = 4;
    public static final String[] WASDIALECTS = new String[]{"bodycontent".intern(), "usernametoken".intern(), "digestvalue".intern(), "signature".intern(), "wscontextcontent".intern()};

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + node + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        if (!(node instanceof Document)) {
            throw SoapSecurityException.format("security.wssecurity.IntegralDialectElementSelector.s01", node.getClass().getName(), "Document");
        }
        String dialect = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Dialect [" + dialect + "]"));
        }
        if (dialect == null) {
            throw SoapSecurityException.format("Null is not allowed as the WAS dialect");
        }
        if (!Constants.DIALECT_WAS.equals(dialect)) {
            throw SoapSecurityException.format(clsName + " does not allow the dialect: " + dialect + ".");
        }
        String keyword = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Keyword [" + keyword + "]"));
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Mode [" + obj + "]"));
        }
        String processType = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Process type [" + processType + "]"));
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Elements [" + elements + "]"));
        }
        Set configs = (Set)context.get("com.ibm.ws.webservices.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Token configurations [" + configs + "]"));
        }
        Duration duration = (Duration)context.get("security.wssecurity.integraldialectelementselector.duration");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Duration [" + duration + "]"));
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce manager [" + nonceManager + "]"));
        }
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        Document doc = (Document)node;
        Element el = doc.getDocumentElement();
        Object list = null;
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[0] + "]"));
            }
            list = new XPathCanonicalizer.NodeListImpl();
            Object body = null;
            try {
                body = el instanceof SOAPEnvelope ? ((SOAPEnvelope)el).getBody() : DOMUtil.getOneChildElement((Element)el, (String)nsSoap, (String)"Body");
            }
            catch (SOAPException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception from SOAPEnvelope.getBody()" + (Object)((Object)e)));
                }
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getElements", "194", this);
                throw new SoapSecurityException(e);
            }
            list.add((Node)body);
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Content", (NodeList)list);
        } else if (WASDIALECTS[1].equals(keyword)) {
            Element security2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[1] + "]"));
            }
            if ((security2 = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null) {
                list = DOMUtil.getOneOrMoreChildElements((Element)security2, (String)nsWsse, (String)"UsernameToken");
            }
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", (NodeList)list);
        } else if (WASDIALECTS[2].equals(keyword)) {
            Element security3;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[2] + "]"));
            }
            if ((security3 = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null) {
                list = DOMUtil.getOneOrMoreElements((Element)security3, (String)Constants.NS_DSIG, (String)"DigestValue");
            }
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", (NodeList)list);
        } else if (WASDIALECTS[3].equals(keyword)) {
            Element security4;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[3] + "]"));
            }
            if ((security4 = IntegralDialectElementSelector.getSecurityHeader(context, doc)) != null) {
                list = DOMUtil.getOneOrMoreChildElements((Element)security4, (String)Constants.NS_DSIG, (String)"Signature");
            }
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Element", (NodeList)list);
        } else if (WASDIALECTS[4].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing the keyword [" + WASDIALECTS[4] + "]"));
            }
            list = IntegralDialectElementSelector.getWSContextHeaderElement(doc);
            list = new PartList("http://www.w3.org/2001/04/xmlenc#Content", (NodeList)list);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", keyword);
        }
        if (processType != null && encryption && (list = IntegralDialectElementSelector.postprocess(doc, processType, (NodeList)list, elements, duration, nsWsse, nsWsu, nonceManager, false, encryption, dialect, keyword)) != null && list.getLength() > 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", keyword);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElements(Node node,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }
}

