/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public final class ClientVariableMap
implements com.ibm.ws.runtime.service.VariableMap {
    private Map variables;
    private String state = "state";
    private static final String comp = "security.wssecurity";
    private static final String clsName = ClientVariableMap.class.getName();
    private static final TraceComponent tc = Tr.register(ClientVariableMap.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final com.ibm.ws.runtime.service.VariableMap instance = new ClientVariableMap();

    public static com.ibm.ws.runtime.service.VariableMap getInstance() {
        return instance;
    }

    public String expand(String variable) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientVariableMap", variable);
        }
        String retval = variable;
        try {
            retval = this.substitute(variable, this.variables);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".expand", "64", this);
            Tr.warning(tc, "security.wssecurity.variable.cannot.expanded", new Object[]{variable, e});
            retval = variable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientVariableMap", retval);
        }
        return retval;
    }

    public boolean refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
            Tr.exit(tc, "refresh");
        }
        return true;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName");
            Tr.exit(tc, "getName");
        }
        return clsName;
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getState");
            Tr.exit(tc, "getState");
        }
        return this.state;
    }

    public void initialize(Object config) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.state = "initialize";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.state = "destroy";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.state = "start";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.state = "stop";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void addVariableMap(Resource r) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addVariableMap");
        }
        if (r != null) {
            EList extent = r.getContents();
            for (int i = 0; i < extent.size(); ++i) {
                VariableMap varMap = (VariableMap)extent.get(i);
                EList varMapEntries = varMap.getEntries();
                for (int j = 0; j < varMapEntries.size(); ++j) {
                    VariableSubstitutionEntry vse = (VariableSubstitutionEntry)varMapEntries.get(j);
                    this.variables.put(vse.getSymbolicName(), vse.getValue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addVariableMap");
        }
    }

    public void addVariableMap(List listOfConfigObjects) {
    }

    private String substitute(String line, Map vars) throws IllegalArgumentException {
        if (line == null) {
            return null;
        }
        return this.expand(line, 0, line.length(), vars, new HashMap());
    }

    private String expand(String line, int startIdx, int endIdx, Map vars, Map varsInUse) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        block4: for (int curIdx = startIdx; curIdx < endIdx; ++curIdx) {
            int idx = line.indexOf(36, curIdx);
            this.append(result, line, curIdx, idx - curIdx);
            if (idx == -1) break;
            curIdx = idx + 1;
            if (curIdx >= endIdx) continue;
            switch (line.charAt(curIdx)) {
                case '$': {
                    result.append('$');
                    continue block4;
                }
                case '(': 
                case '{': {
                    char openParen = line.charAt(curIdx);
                    char closeParen = openParen == '(' ? (char)')' : '}';
                    int beg = curIdx + 1;
                    int end = line.indexOf(closeParen, beg);
                    if (end == -1) {
                        throw new IllegalArgumentException("unterminated variable reference");
                    }
                    curIdx = this.indexOf(line, '$', beg, end);
                    if (curIdx != -1) {
                        beg = curIdx + 1;
                        int count = 0;
                        for (curIdx = beg; curIdx < line.length(); ++curIdx) {
                            char c = line.charAt(curIdx);
                            if (c == openParen) {
                                ++count;
                                continue;
                            }
                            if (c == closeParen && --count < 0) break;
                        }
                        if (count < 0) {
                            this.expand(line, beg, curIdx, vars, varsInUse);
                        }
                    } else {
                        curIdx = end;
                    }
                    this.referenceVariable(result, line, beg, end - beg, vars, varsInUse);
                    continue block4;
                }
                default: {
                    char c = line.charAt(curIdx);
                    if (Character.isWhitespace(c)) continue block4;
                    this.referenceVariable(result, line, curIdx, 1, vars, varsInUse);
                }
            }
        }
        return result.toString();
    }

    private void append(StringBuffer result, String src, int offset, int len) {
        if (len < 0) {
            len = src.length() - offset;
        }
        result.ensureCapacity(result.length() + len);
        len += offset;
        for (int i = offset; i < len; ++i) {
            result.append(src.charAt(i));
        }
    }

    private int indexOf(String s, char c, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private String expand(String line, Map vars, Map varsInUse) throws IllegalArgumentException {
        return this.expand(line, 0, line.length(), vars, varsInUse);
    }

    private String recursivelyExpand(String varName, Map vars, Map varsInUse) throws IllegalArgumentException {
        if (varsInUse.get(varName) != null) {
            throw new IllegalArgumentException("Recursive variable: " + varName);
        }
        varsInUse.put(varName, varName);
        String value = (String)vars.get(varName);
        String s = this.expand(value, vars, varsInUse);
        varsInUse.remove(varName);
        return s;
    }

    private void referenceVariable(StringBuffer sb, String line, int beg, int len, Map vars, Map varsInUse) throws IllegalArgumentException {
        String varName = line.substring(beg, beg + len);
        String value = (String)vars.get(varName);
        if (value == null) {
            throw new IllegalArgumentException("undefined variable: " + varName);
        }
        String s = this.recursivelyExpand(varName, vars, varsInUse);
        sb.append(s);
    }

    private ClientVariableMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientVariableMap");
        }
        this.variables = new HashMap<Object, Object>(System.getProperties());
        Iterator it = this.variables.keySet().iterator();
        HashMap newMap = new HashMap(this.variables.size());
        while (it.hasNext()) {
            String key = (String)it.next();
            String newKey = key.replace('.', '_');
            newMap.put(newKey, this.variables.get(key));
        }
        this.variables.putAll(newMap);
        String userInstallRoot = (String)this.variables.get("USER_INSTALL_ROOT");
        if (userInstallRoot == null || userInstallRoot.length() == 0) {
            userInstallRoot = (String)this.variables.get("user_install_root");
            if (userInstallRoot == null || userInstallRoot.length() == 0) {
                String wasInstallRoot = (String)this.variables.get("WAS_INSTALL_ROOT");
                if (wasInstallRoot == null || wasInstallRoot.length() == 0) {
                    wasInstallRoot = (String)this.variables.get("was_install_root");
                }
                if (wasInstallRoot == null || wasInstallRoot.length() == 0) {
                    Tr.error(tc, "security.wssecurity.was.install.root.isnull");
                } else {
                    this.variables.put("WAS_INSTALL_ROOT", wasInstallRoot);
                    this.variables.put("USER_INSTALL_ROOT", wasInstallRoot);
                    this.variables.put("user_install_root", wasInstallRoot);
                    this.variables.put("user.install.root", wasInstallRoot);
                }
            } else {
                this.variables.put("USER_INSTALL_ROOT", userInstallRoot);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Variables:", this.variables);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientVariableMap");
        }
    }
}

