/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class UserRegistryProcessor {
    private static final TraceComponent tc = Tr.register(UserRegistryProcessor.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UserRegistryProcessor.class.getName();
    private static UserMapping _userMapping;
    private static final String USERMAPPING_IMPL = "com.ibm.ws.security.core.UserMappingImpl";
    private static final Permission PERM;

    public static boolean checkRegistry(String username, char[] password) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkRegistry()");
        }
        boolean ret = false;
        try {
            ContextManager manager = ContextManagerFactory.getInstance();
            if (manager != null) {
                Subject subject;
                if (tc.isDebugEnabled()) {
                    String pwd = password == null ? "null" : "not mull";
                    Tr.debug((TraceComponent)tc, (String)("Username [" + username + "], password [" + pwd + "]"));
                }
                if ((subject = manager.login(manager.getDefaultRealm(), username, new String(password))) != null) {
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, (String)(clsName + ".checkRegistry"), (String)"%C");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.UserRegistryProcessor.s01", (Object)new Object[]{username, e});
            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.UserRegistryProcessor.s01", (String[])new String[]{username, e.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkRegistry() returns boolean[" + ret + "]"));
        }
        return ret;
    }

    public static boolean checkUsername(String username) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkUsername(String username[" + username + "])"));
        }
        boolean ret = false;
        try {
            ContextManager manager = ContextManagerFactory.getInstance();
            if (manager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Username [" + username + "]"));
                }
                UserRegistry registry = manager.getRegistry(manager.getDefaultRealm());
                ret = registry.isValidUser(username);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + username + "] = " + ret));
                }
                if (!ret) {
                    String userSecurityName = registry.getUserSecurityName(username);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.getUserSecurityName()=" + userSecurityName));
                    }
                    ret = registry.isValidUser(userSecurityName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + userSecurityName + "] = " + ret));
                    }
                }
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, (String)(clsName + ".checkUsername"), (String)"%C");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.UserRegistryProcessor.s02", (Object)new Object[]{username, e});
            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.UserRegistryProcessor.s02", (String[])new String[]{username, e.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkUsername(String username) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    static String mapCertificate(X509Certificate cert) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapCertificate(X509Certificate [" + cert + "])"));
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(PERM);
        }
        String securityName = null;
        UserMapping um = _userMapping;
        if (um != null) {
            try {
                securityName = um.mapCertificateToName(new X509Certificate[]{cert});
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(clsName + ".mapCertificate"), (String)"84");
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5185W", (Object)new Object[]{cert.getSubjectDN().getName(), e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapCertificate(X509Certificate) returns " + securityName));
        }
        return securityName;
    }

    static {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UserMapping Init");
        }
        if (ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            try {
                Class<?> clazz = Class.forName(USERMAPPING_IMPL);
                _userMapping = (UserMapping)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                Tr.processException((Throwable)cnfe, (String)(clsName + ".getUserMapping"), (String)"183");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5186E", (Object)new Object[]{USERMAPPING_IMPL, cnfe});
            }
            catch (IllegalAccessException iae) {
                Tr.processException((Throwable)iae, (String)(clsName + ".getUserMapping"), (String)"186");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5188E", (Object)new Object[]{USERMAPPING_IMPL, iae});
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(clsName + ".getUserMapping"), (String)"189");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5187E", (Object)new Object[]{USERMAPPING_IMPL, e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UserMapping Init");
        }
        PERM = new WebSphereRuntimePermission("wssecurity.WSUserRegistry.mapCertificate");
    }
}

