/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.security.Key;
import java.text.ParseException;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509IssuerContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(X509IssuerContentConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509IssuerContentConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Element target, Map type, Map context) throws SoapSecurityException {
        KeyLocator klocator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentConsumerConfig config = (KeyInfoContentConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentConsumerConfig [" + config + "]."));
        }
        KeyInfoResult result = new KeyInfoResult(config);
        ResultPool.add((Map)context, (Result)result);
        if (!ConfigUtil.isKeyInfoX509issuer((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [X509ISSUER],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("VerifyingKey".equals(keyType)) {
                buf.append(" siganture verification");
            } else {
                buf.append(" decryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" request consumer configuration.");
            } else {
                buf.append(" response consumer configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, keyType);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The type of a key is [" + keyType + "]."));
        }
        String[] data = this.getX509Data(target);
        String iname = data[0];
        String inum = data[1];
        result.setIdInSubject(iname + ":" + inum);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME, iname);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL, inum);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME, iname);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL, inum);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Issuer name of a certificate is [" + iname + "]."));
            Tr.debug((TraceComponent)tc, (String)("Issuer serial of a certificate is [" + inum + "]."));
        }
        if ((klocator = config.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        context.put("com.ibm.wsspi.wssecurity.token.x509.keyLocator", config.getKeyLocator());
        context.remove(klocator.getClass());
        if (config.getTokenConsumer() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE, config.getTokenConsumer());
        }
        TokenConsumerConfig tconfig = config.getTokenConsumer();
        if (tconfig != null) {
            TokenConsumerComponent tcon = tconfig.getInstance();
            if (tcon == null) {
                throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
            }
            context.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tconfig);
            tcon.invoke(target.getOwnerDocument(), context);
        }
        context.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        klocator = config.getKeyLocator();
        Key key = klocator.getKey(type, context);
        context.remove(klocator.getClass());
        context.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED)) {
            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "TokenId", iname + ":" + inum);
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "KeyInfoType", type.toString());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Algorithm", key.getAlgorithm());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Element target,Map type,Map context)returns Key[" + key + "]"));
        }
        return key;
    }

    private String[] getX509Data(Element elem) throws SoapSecurityException {
        String issuerSerial;
        Element child;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getX509Data(Element elem[" + DOMUtil.getDisplayName((Node)elem) + "])"));
        }
        if ((child = DOMUtil.getOneElement((Element)elem, (String)Constants.NS_DSIG, (String)"X509Data")) == null) {
            throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
        }
        Element serial = DOMUtil.getOneChildElement((Element)child, (String)Constants.NS_DSIG, (String)"X509IssuerSerial");
        if (serial == null) {
            throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
        }
        Element name = DOMUtil.getOneChildElement((Element)serial, (String)Constants.NS_DSIG, (String)"X509IssuerName");
        if (name == null) {
            throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
        }
        Element number = DOMUtil.getOneChildElement((Element)serial, (String)Constants.NS_DSIG, (String)"X509SerialNumber");
        if (number == null) {
            throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
        }
        String issuerName = DOMUtil.getStringValue((Node)name);
        String in = KeyInfo.X509Data.encodeDName((String)issuerName);
        if (in != null) {
            issuerName = in;
        }
        if ((issuerSerial = DOMUtil.getStringValue((Node)number)) != null) {
            try {
                BigInteger bint = new BigInteger(issuerSerial);
            }
            catch (NumberFormatException nfee) {
                try {
                    BigInteger bint = CertificateUtil.convertSerialNumber((String)issuerSerial);
                    issuerSerial = bint.toString();
                }
                catch (ParseException pe) {
                    throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", issuerSerial, (Throwable)pe);
                }
            }
        }
        String[] data = new String[]{issuerName, issuerSerial};
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getX509Data(Element elem) returns String[][" + data + "]"));
        }
        return data;
    }
}

