/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestReceiverConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseReceiverConfig;
import com.ibm.ws.webservices.wssecurity.util.CORBAHelper;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.SoapSecurityReceiver;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;

public class WSSoapSecurityReceiverBase
extends SoapSecurityReceiver {
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    private static final TraceComponent tc = Tr.register(WSSoapSecurityReceiverBase.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSoapSecurityReceiverBase.class.getName();

    public void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    protected void initConfig(MessageContextProxy context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initConfig(" + context + ")"));
        }
        boolean isServer = true;
        String value = (String)this.getHandlerOption(GenericHandler.HANDLER_PARAM_ROLE);
        if (value != null && value.length() != 0) {
            isServer = value.equals(GenericHandler.HANDLER_PARAM_ROLE_SERVER);
        } else {
            boolean bl = isServer = !context.getPastPivot();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isServer=" + isServer));
        }
        try {
            if (isServer) {
                ReceiverConfig config = (ReceiverConfig)context.getConfig("RequestReceiverConfig");
                if (config == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.request.receiver.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("ReceiverConfig class name=");
                    buf.append(config.getClass().getName());
                    buf.append(", source=");
                    if (config instanceof WSEMFRequestReceiverConfig) {
                        buf.append(((WSEMFRequestReceiverConfig)config).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    buf.append(", ReceiverConfig=").append(config);
                    Tr.debug((TraceComponent)tc, (String)buf.toString());
                }
                if (config instanceof WSEMFRequestReceiverConfig) {
                    WSEMFRequestReceiverConfig xConfig = (WSEMFRequestReceiverConfig)config;
                    String tmp = xConfig.getWSSENS();
                    if (tmp != null && tmp.length() != 0) {
                        context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", (Object)tmp);
                    }
                    if ((tmp = xConfig.getWSUNS()) != null && tmp.length() != 0) {
                        context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", (Object)tmp);
                    }
                }
                this.setMessageOption(CONFIG_KEY, config);
            } else {
                ReceiverConfig config = (ReceiverConfig)context.getConfig("ResponseReceiverConfig");
                if (config == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.reponse.receiver.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("ReceiverConfig class name=");
                    buf.append(config.getClass().getName());
                    buf.append(", source=");
                    if (config instanceof WSEMFResponseReceiverConfig) {
                        buf.append(((WSEMFResponseReceiverConfig)config).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    buf.append(", ReceiverConfig=").append(config);
                    Tr.debug((TraceComponent)tc, (String)buf.toString());
                }
                this.setMessageOption(CONFIG_KEY, config);
            }
            super.initConfig(context);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            Tr.processException((Throwable)e, (String)(clsName + ".init"), (String)"96", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.FileConfigSSR.init", (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initConfig(MessageContextProxy context)");
        }
    }

    public void invoke(MessageContextProxy context) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(" + context + ")"));
        }
        if (WSSoapSecurityUtil.getServiceHandler((MessageContext)context.get()) != null) {
            super.invoke(context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(MessageContextProxy context)");
        }
    }

    protected void processLoginResults(Result[] results, MessageContextProxy context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processLoginResults(" + results + "," + context + ")"));
        }
        if (results.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No results, no initial sender is set");
            }
        } else {
            for (int i = 0; i < results.length; ++i) {
                if (results[i] instanceof LoginResult) {
                    Subject subject = ((LoginResult)results[i]).getSubject();
                    CORBAHelper.pushCredential(subject, (MessageContext)context.get());
                    ContextManager ctxMgr = ContextManagerFactory.getInstance();
                    if (ctxMgr == null) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
                    } else {
                        ctxMgr.put("wssecurity.initial.sender.id", subject);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Initial Sender", (Object)subject);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"processLoginResults(Result[] results, MessageContext context)");
                    }
                    return;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"None of the results has a LoginResult, no initial sender is set");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLoginResults(Result[] results, MessageContext context)");
        }
    }

    protected void processCertificateResults(Result[] resultSign, Result[] resultToken, MessageContextProxy context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processCertificateResults(" + resultSign + "," + resultToken + "," + context + ")"));
        }
        if (resultSign.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No resultSign, no signer certificate is set");
            }
        } else if (resultToken.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No resultToken, no initial sender certificate is set");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("result Sign length: " + resultSign.length));
                Tr.debug((TraceComponent)tc, (String)("result Token length: " + resultToken.length));
            }
            X509Certificate cert = null;
            for (int j = 0; j < resultSign.length; ++j) {
                if (!(resultSign[j] instanceof SignatureResult)) continue;
                SignatureResult sigResult = (SignatureResult)resultSign[j];
                if (sigResult.isAuthenticatedId()) {
                    cert = sigResult.getCertificate();
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Found signer cert: " + cert));
                    break;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Signature result found, but it is not used as authenticated identity, therefore, original certificate is not saved");
            }
            if (cert != null) {
                Tr.debug((TraceComponent)tc, (String)("Signer Cert: " + cert));
            } else {
                Tr.debug((TraceComponent)tc, (String)"Signer Cert is null!");
                for (int k = 0; k < resultToken.length; ++k) {
                    if (!(resultToken[k] instanceof TokenResult.X509)) continue;
                    TokenResult.X509 x509Result = (TokenResult.X509)resultToken[k];
                    if (x509Result.isAuthenticatedId()) {
                        cert = x509Result.getCertificate();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("Found sender cert: " + cert));
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"X509 Token result found, but it is not used as authenticated identity, therefore, original certificate is not saved");
                }
            }
            if (cert != null) {
                ContextManager ctxMgr = ContextManagerFactory.getInstance();
                if (ctxMgr == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
                } else {
                    ctxMgr.put("com.ibm.ws.wssecurity.OriginalCert", cert);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Initial Cert", (Object)cert);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Initial Cert found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processCertificateResults(Result[] resultSign, Result[] resultToken, MessageContext context)");
        }
    }

    public String toString() {
        return "WSSoapSecurityReceiverBase(config=" + this.getMessageOption(CONFIG_KEY) + ")";
    }
}

