/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.CRL;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.Consumerbindingref;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.JAASConfig;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyInfoSignature;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonext.AddTimestamp;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.Nonce;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wscommonext.RequiredSecurityToken;
import com.ibm.etools.webservice.wscommonext.Timestamp;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.CertManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.EngineFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSEMFResponseConsumerConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSEMFResponseConsumerConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFResponseConsumerConfig.class.getName();
    private String origin = "non-ws-security";

    public WSEMFResponseConsumerConfig(SecurityResponseConsumerBindingConfig resConBnd, SecurityResponseConsumerServiceConfig resConExt, String actorURI, VariableMap varMap, WSSecurityService service) throws SoapSecurityException {
        this(resConBnd, resConExt, actorURI, varMap, service, null);
    }

    public WSEMFResponseConsumerConfig(SecurityResponseConsumerBindingConfig resConBnd, SecurityResponseConsumerServiceConfig resConExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseConsumerConfig(SecurityResponseConsumerBindingConfig, SecurityResponseConsumerServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{resConBnd, resConExt, actorURI, varMap, service, appClassLoader});
        }
        this.init(resConBnd, resConExt, actorURI, varMap, service, appClassLoader);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseConsumerConfig(SecurityResponseConsumerBindingConfig, SecurityResponseConsumerServiceConfig, actorURI, VariableMap, Object, ClassLoader)");
        }
    }

    protected WSEMFResponseConsumerConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseConsumerConfig()");
            Tr.exit(tc, "WSEMFResponseConsumerConfig()");
        }
    }

    protected final void init(SecurityResponseConsumerBindingConfig resConBnd, SecurityResponseConsumerServiceConfig resConExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        PrivateConsumerConfig.KeyInfoConsumerConfImpl kicconfig;
        PrivateCommonConfig.AlgorithmConfImpl aconfig;
        String keyStoreName;
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl kiccconfig;
        int k;
        int kMax;
        Set mappings;
        PrivateConsumerConfig.TimestampConsumerConfImpl tsconfig;
        PrivateConsumerConfig.TokenConsumerConfImpl tconfig;
        Nonce nonce;
        EList nonces;
        Timestamp timestamp;
        EList timestamps;
        PrivateCommonConfig.PartConfImpl pconfig;
        MessageParts messagePart;
        int j;
        int jMax;
        EList messageParts;
        UsageType usageType;
        PrivateCommonConfig.ReferencePartConfImpl rpconfig;
        int i;
        int iMax;
        EList p;
        String value;
        Consumerbindingref gref;
        boolean useDefault;
        Object dconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityResponseConsumerBindingConfig, SecurityResponseConsumerServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{resConBnd, resConExt, actorURI, varMap, service, appClassLoader});
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig());
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<String, Object> type = new HashMap<String, Object>();
        HashMap<String, PrivateCommonConfig.ReferencePartConfImpl> nameIntegrity = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
        HashMap<String, PrivateCommonConfig.ReferencePartConfImpl> nameConfidentiality = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
        HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl> nameToken = new HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl>();
        HashMap<String, PrivateCommonConfig.KeyLocatorConfImpl> nameKeyLocator = new HashMap<String, PrivateCommonConfig.KeyLocatorConfImpl>();
        HashMap<String, PrivateConsumerConfig.KeyInfoContentConsumerConfImpl> nameKeyInfo = new HashMap<String, PrivateConsumerConfig.KeyInfoContentConsumerConfImpl>();
        EList requiredIntegrities = null;
        EList requiredConfidentialities = null;
        EList requiredSecurityTokens = null;
        AddTimestamp addTimestamp = null;
        String hwConfigName = null;
        String hwKeyStoreName = null;
        if (varMap == null) {
            varMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration config = null;
        if (service != null && (dconfig = service.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            config = (WSSecurityDefaultConfiguration)dconfig;
        }
        boolean bl = useDefault = resConBnd == null;
        if (!useDefault && (gref = resConBnd.getConsumerbindingref()) != null && "DEFAULT".equals(value = ConfigUtil.trim((String)gref.getRef()))) {
            useDefault = true;
        }
        WSSConsumerConfig dcconfig = null;
        Map defaultProps = null;
        Map extProperties = null;
        Map bndProperties = null;
        this._properties = new HashMap();
        if (config != null) {
            dcconfig = config.getDefaultConsumerBinding();
            if (dcconfig != null) {
                defaultProps = dcconfig.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            } else {
                defaultProps = config.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            }
        }
        if (resConExt != null && (p = resConExt.getProperties()) != null && (extProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(extProperties);
        }
        if (!useDefault && (p = resConBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndProperties);
        }
        if (resConExt != null) {
            requiredIntegrities = resConExt.getRequiredIntegrity();
            requiredConfidentialities = resConExt.getRequiredConfidentiality();
            requiredSecurityTokens = resConExt.getRequiredSecurityToken();
            addTimestamp = resConExt.getAddTimestamp();
            if (tc.isDebugEnabled()) {
                if (extProperties != null) {
                    Tr.debug(tc, "Response Consumer Deployment Descriptor (RequiredIntegrities, RequiredConfidentialities, RequiredSecurityTokens, AddTimestamp, Property):", new Object[]{requiredIntegrities, requiredConfidentialities, requiredSecurityTokens, addTimestamp, extProperties});
                } else {
                    Tr.debug(tc, "Response Consumer Deployment Descriptor (RequiredIntegrities, RequiredConfidentialities, RequiredSecurityTokens, AddTimestamp):", new Object[]{requiredIntegrities, requiredConfidentialities, requiredSecurityTokens, addTimestamp});
                }
            }
        }
        if (actorURI != null) {
            String tmpActor = actorURI.trim();
            if (tmpActor.length() != 0) {
                this._myActor = tmpActor;
            }
        } else {
            this._myActor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this._myActor);
        }
        if (requiredIntegrities != null) {
            iMax = requiredIntegrities.size();
            for (i = 0; i < iMax; ++i) {
                this._verificationRequired = true;
                RequiredIntegrity requiredIntegrity = (RequiredIntegrity)requiredIntegrities.get(i);
                rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                rpconfig._oneOfIntegralParts = true;
                usageType = requiredIntegrity.getUsage();
                if (usageType != null) {
                    rpconfig._usage = ConfigUtil.trim((String)usageType.getName());
                }
                rpconfig._order = 0;
                messageParts = requiredIntegrity.getMessageParts();
                if (messageParts != null) {
                    jMax = messageParts.size();
                    for (j = 0; j < jMax; ++j) {
                        messagePart = (MessageParts)messageParts.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._dialect = ConfigUtil.trim((String)messagePart.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)messagePart.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((timestamps = requiredIntegrity.getTimestamp()) != null) {
                    jMax = timestamps.size();
                    for (j = 0; j < jMax; ++j) {
                        timestamp = (Timestamp)timestamps.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._timestamp = true;
                        pconfig._dialect = ConfigUtil.trim((String)timestamp.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)timestamp.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((nonces = requiredIntegrity.getNonce()) != null) {
                    jMax = nonces.size();
                    for (j = 0; j < jMax; ++j) {
                        nonce = (Nonce)nonces.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._nonce = true;
                        pconfig._dialect = ConfigUtil.trim((String)nonce.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)nonce.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                this._requiredIntegralParts.add(rpconfig);
                value = ConfigUtil.trim((String)requiredIntegrity.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                }
                if (nameIntegrity.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: required integrity [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding required integrity: " + value);
                }
                nameIntegrity.put(value, rpconfig);
            }
        }
        if (requiredConfidentialities != null) {
            iMax = requiredConfidentialities.size();
            for (i = 0; i < iMax; ++i) {
                this._decryptionRequired = true;
                RequiredConfidentiality requiredConfidentiality = (RequiredConfidentiality)requiredConfidentialities.get(i);
                rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                usageType = requiredConfidentiality.getUsage();
                if (usageType != null) {
                    rpconfig._usage = ConfigUtil.trim((String)usageType.getName());
                }
                rpconfig._order = 0;
                messageParts = requiredConfidentiality.getMessageParts();
                if (messageParts != null) {
                    jMax = messageParts.size();
                    for (j = 0; j < jMax; ++j) {
                        messagePart = (MessageParts)messageParts.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._dialect = ConfigUtil.trim((String)messagePart.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)messagePart.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((timestamps = requiredConfidentiality.getTimestamp()) != null) {
                    jMax = timestamps.size();
                    for (j = 0; j < jMax; ++j) {
                        timestamp = (Timestamp)timestamps.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._timestamp = true;
                        pconfig._dialect = ConfigUtil.trim((String)timestamp.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)timestamp.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                if ((nonces = requiredConfidentiality.getNonce()) != null) {
                    jMax = nonces.size();
                    for (j = 0; j < jMax; ++j) {
                        nonce = (Nonce)nonces.get(j);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._usage = rpconfig._usage;
                        pconfig._nonce = true;
                        pconfig._dialect = ConfigUtil.trim((String)nonce.getDialect());
                        pconfig._keyword = ConfigUtil.trim((String)nonce.getKeyword());
                        rpconfig._parts.add(pconfig);
                    }
                }
                this._requiredConfidentialParts.add(rpconfig);
                value = ConfigUtil.trim((String)requiredConfidentiality.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                }
                if (nameConfidentiality.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: required confidentiality [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding required confidentiality: " + value);
                }
                nameConfidentiality.put(value, rpconfig);
            }
        }
        if (requiredSecurityTokens != null) {
            iMax = requiredSecurityTokens.size();
            for (i = 0; i < iMax; ++i) {
                this._tokenRequired = true;
                RequiredSecurityToken requiredSecurityToken = (RequiredSecurityToken)requiredSecurityTokens.get(i);
                tconfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
                tconfig._type = new QName(ConfigUtil.trim((String)requiredSecurityToken.getUri()), ConfigUtil.trim((String)requiredSecurityToken.getLocalName()));
                usageType = requiredSecurityToken.getUsage();
                if (usageType != null) {
                    tconfig._usage = ConfigUtil.trim((String)usageType.getName());
                }
                this._requiredSecurityTokens.add(tconfig);
                value = ConfigUtil.trim((String)requiredSecurityToken.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                }
                if (nameToken.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: required security token [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding required security token: " + value);
                }
                nameToken.put(value, tconfig);
                tconfig._name = value;
            }
        }
        if (addTimestamp != null) {
            this._timestampRequired = true;
            tsconfig = new PrivateConsumerConfig.TimestampConsumerConfImpl();
            tsconfig._actor = this._myActor;
            ConfigConstants.getProperties(tsconfig._properties, addTimestamp.getProperties(), varMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding timestamp: " + this._timestampRequired);
            }
            this._timestampConsumer = tsconfig;
        }
        this._nonceManager = NonceManagerFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NonceManager = " + this._nonceManager);
        }
        this._certManager = CertManagerFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CertManager = " + this._certManager);
        }
        if (config != null && (mappings = config.getAlgorithmMappings()) != null && !mappings.isEmpty()) {
            for (PrivateCommonConfig.AlgorithmMappingConfImpl amconfig : mappings) {
                EngineFactory efactory;
                String factoryName = amconfig.getFactoryName();
                Set algorithmURIs = amconfig.getAlgorithmURIs();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instanciating a EngineFactory: " + factoryName);
                }
                if ((efactory = this._algorithmFactory.addPluggableFactory(factoryName, algorithmURIs, appClassLoader)) == null) {
                    if (ConfigValidation.isFipsEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "addPluggableFactory() returned null for factory " + factoryName + " because FIPS mode is enabled");
                        }
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0147E", new Object[]{factoryName});
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Instantiated EngineFactory: " + efactory);
                }
                if (efactory == null) continue;
                this._userDefinedComponentsUsed = true;
                Set set = efactory.getSignatureAlgorithms();
                if (set != null && !set.isEmpty()) {
                    this._allowedSignatureMethods.addAll(set);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the allowed signature algorithms: " + set);
                }
                if ((set = efactory.getDigestAlgorithms()) != null && !set.isEmpty()) {
                    this._allowedDigestMethods.addAll(set);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the allowed digest algorithms: " + set);
                }
                if ((set = efactory.getDataEncryptionAlgorithms()) != null && !set.isEmpty()) {
                    this._allowedDataEncryptionMethods.addAll(set);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the allowed data encryption algorithms: " + set);
                }
                if ((set = efactory.getKeyEncryptionAlgorithms()) != null && !set.isEmpty()) {
                    this._allowedKeyEncryptionMethods.addAll(set);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding the allowed key encryption algorithms: " + set);
            }
        }
        if (config != null) {
            hwConfigName = config.getHardwareConfigName();
            if (hwConfigName != null && hwConfigName.length() != 0) {
                this._properties.put("HWCONFIG", hwConfigName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware Acceleration is Enabled " + hwConfigName);
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.OffloadAllCryptography", config.getUseOffloadAllCrypto());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware Acceleration is Enabled :" + hwConfigName + ", OFFLOAD_ALL_CRYPTO is: " + config.getUseOffloadAllCrypto());
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.hardwareCacheSize", new Integer(config.getHardwareCacheSize()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware cache size = " + config.getHardwareCacheSize());
                }
                this._properties.put("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography", new Boolean(config.getOffloadRSAPublicKeyCrypto()));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Offload RSA Public Key crypto = " + config.getOffloadRSAPublicKeyCrypto());
                }
            }
            if ((hwKeyStoreName = config.getHardwareKeyStoreName()) != null) {
                this._properties.put("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore", hwKeyStoreName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Hardware keystore is specified in the default bindings " + hwKeyStoreName);
                }
            }
        }
        this._bypassSecurityHeader = ConfigUtil.getIsTruePropertyEnv((Map)this._properties, (String)"com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled");
        boolean checkHMACOutputLength = ConfigUtil.getIsFalseProperty((Map)this._properties, (String)Constants.WSSECURITY_CHECK_HMAC_OUTPUT_LENGTH);
        this._algorithmFactory.setCheckHMACOutputLength(checkHMACOutputLength);
        CertStoreList certStoreList = null;
        EList encryptionInfos = null;
        EList keyInfos = null;
        EList keyLocators = null;
        EList signingInfos = null;
        EList tokenConsumers = null;
        EList trustAnchors = null;
        if (useDefault) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default binding...");
            }
            if (config == null) {
                Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s25");
            } else {
                if (dcconfig == null) {
                    dcconfig = config.getDefaultConsumerBinding();
                }
                if (dcconfig != null) {
                    this.initDefaultConfig(dcconfig, nameToken);
                }
            }
            this.validate(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.getLogProperties(defaultProps, extProperties, null, "response"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "init(SecurityResponseConsumerBindingConfig, SecurityResponseConsumerServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader)");
            }
            return;
        }
        certStoreList = resConBnd.getCertStoreList();
        encryptionInfos = resConBnd.getEncryptionInfo();
        keyInfos = resConBnd.getKeyInfo();
        keyLocators = resConBnd.getKeyLocator();
        signingInfos = resConBnd.getSigningInfo();
        tokenConsumers = resConBnd.getTokenConsumer();
        trustAnchors = resConBnd.getTrustAnchor();
        if (tc.isDebugEnabled()) {
            if (bndProperties != null) {
                Tr.debug(tc, "Response Consumer Binding (CertStoreList, EncryptionInfos, KeyInfos, KeyLocators, SigningInfos, TokenConsumers, TrustAnchors, Property):", new Object[]{certStoreList, encryptionInfos, keyInfos, keyLocators, signingInfos, tokenConsumers, trustAnchors, bndProperties});
            } else {
                Tr.debug(tc, "Response Consumer Binding (CertStoreList, EncryptionInfos, KeyInfos, KeyLocators, SigningInfos, TokenConsumers, TrustAnchors):", new Object[]{certStoreList, encryptionInfos, keyInfos, keyLocators, signingInfos, tokenConsumers, trustAnchors});
            }
        }
        int timeout = 0;
        String v = (String)this._properties.get(Constants.WSSECURITY_TIMESTAMP_TIMEOUT);
        if (v != null) {
            if ((v = v.trim()).length() != 0) {
                try {
                    int l = Integer.parseInt(v);
                    timeout = ConfigConstants.validTimestampTimeout(l);
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".init", "631", this);
                    Tr.warning(tc, "security.wssecurity.WSEC0144W", new Object[]{v, new Integer(600)});
                    timeout = 600;
                }
            }
        } else {
            timeout = 600;
        }
        int maxAge = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_TIMESTAMP_MAX_AGE);
        maxAge = v != null ? ConfigConstants.processTimestampMaxAge(v, timeout) : 300;
        this._timestampMaxAge = maxAge;
        int clockSkew = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_TIMESTAMP_CLOCK_SKEW);
        clockSkew = v != null ? ConfigConstants.processTimestampClockSkew(v, this._timestampMaxAge) : 0;
        this._timestampClockSkew = clockSkew;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "timestamp.maxAge = " + this._timestampMaxAge * 1000 + " ms, " + "timestamp.clockSkew = " + this._timestampClockSkew * 1000 + " ms");
        }
        if (this._timestampRequired && this._timestampConsumer != null) {
            tsconfig = this._timestampConsumer;
            tsconfig._timestampMaxAge = this._timestampMaxAge;
            tsconfig._timestampClockSkew = this._timestampClockSkew;
        }
        if ((v = (String)this._properties.get(Constants.WSSECURITY_NONCE_CACHE_TIMEOUT)) != null) {
            if ((v = v.trim()).length() != 0) {
                try {
                    int l = Integer.parseInt(v);
                    timeout = ConfigConstants.validNonceCacheTimeout(l);
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".init", "686", this);
                    Tr.warning(tc, "security.wssecurity.WSEC0115W", new Object[]{v, new Integer(600)});
                    timeout = 600;
                }
            }
        } else {
            timeout = config != null ? config.getNonceCacheTimeout() : 600;
        }
        maxAge = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_NONCE_MAX_AGE);
        maxAge = v != null ? ConfigConstants.processNonceMaxAge(v, timeout) : (config != null ? config.getNonceMaxAge() : 300);
        clockSkew = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        clockSkew = v != null ? ConfigConstants.processNonceClockSkew(v, maxAge) : (config != null ? config.getNonceClockSkew() : 0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nonce.maxAge = " + maxAge * 1000 + " ms, " + "nonce.clockSkew = " + clockSkew * 1000 + " ms");
        }
        if (tokenConsumers != null) {
            HashMap nameToken2 = new HashMap(nameToken);
            iMax = tokenConsumers.size();
            for (i = 0; i < iMax; ++i) {
                CertPathSettings certPathSettings;
                JAASConfig jaasConfig;
                TokenConsumer tokenConsumer = (TokenConsumer)tokenConsumers.get(i);
                ValueType valueType = tokenConsumer.getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token consumer named " + tokenConsumer.getName() + " is missing");
                }
                QName qn = new QName(ConfigUtil.trim((String)valueType.getUri()), ConfigUtil.trim((String)valueType.getLocalName()));
                PartReference pref = tokenConsumer.getPartReference();
                tconfig = null;
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)nameToken2.get(value);
                    if (tconfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (!tconfig.getType().equals(qn)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s30", tconfig.getType().toString(), qn.toString());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                if (tconfig == null) {
                    tconfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    tconfig._type = qn;
                }
                tconfig._name = ConfigUtil.trim((String)tokenConsumer.getName());
                ConfigConstants.getProperties(tconfig._properties, tokenConsumer.getProperties(), varMap);
                tconfig._className = ConfigUtil.trim((String)tokenConsumer.getClassname());
                if (!this._defaultTokenConsumers.contains(tconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                if ((jaasConfig = tokenConsumer.getJAASConfig()) != null) {
                    tconfig._jaasConfig = ConfigUtil.trim((String)jaasConfig.getConfigName());
                    if (!this._defaultJAASConfigs.contains(tconfig._jaasConfig)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    ConfigConstants.getProperties(tconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                }
                if ((certPathSettings = tokenConsumer.getCertPathSettings()) != null) {
                    TrustAnyCertificate trustAnyCertificate = certPathSettings.getTrustAnyCertificate();
                    if (trustAnyCertificate != null) {
                        tconfig._trustAny = true;
                    } else {
                        TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                        CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                        if (trustAnchorRef != null || certStoreRef != null) {
                            String msgKey;
                            KeyStore kstore = null;
                            String keyStoreName2 = null;
                            if (trustAnchorRef != null) {
                                tconfig._trustAnchorRef = value = ConfigUtil.trim((String)trustAnchorRef.getRef());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "TrustAnchorRef = " + value);
                                }
                                boolean foundTA = false;
                                for (j = 0; j < trustAnchors.size(); ++j) {
                                    TrustAnchor trustAnchor = (TrustAnchor)trustAnchors.get(j);
                                    if (value == null || !value.equals(ConfigUtil.trim((String)trustAnchor.getName()))) continue;
                                    com.ibm.etools.webservice.wscommonbnd.KeyStore keystore = trustAnchor.getKeyStore();
                                    keyStoreName2 = keystore.getKeyStoreRef();
                                    if (keyStoreName2 != null && keyStoreName2.length() != 0) {
                                        kstore = ConfigUtil.getKeyStore((String)ConfigUtil.trim((String)keyStoreName2));
                                    } else {
                                        String file = null;
                                        file = varMap == null ? keystore.getPath() : varMap.expand(keystore.getPath());
                                        kstore = ConfigUtil.getKeyStore((String)ConfigUtil.trim((String)keystore.getType()), (String)file, (char[])ConfigUtil.trim((String)keystore.getStorepass()).toCharArray());
                                    }
                                    foundTA = true;
                                    break;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(from application binding) Keystore for TrustAnchor: " + value + " = " + kstore + "Found = " + foundTA);
                                }
                                if (!foundTA && config != null) {
                                    com.ibm.ws.webservices.wssecurity.config.KeyStore ks = config.getTrustAnchorKeyStoreConfig(value);
                                    if (ks != null) {
                                        keyStoreName2 = ks.getKeyStoreRef();
                                    }
                                    kstore = config.getTrustAnchor(value);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(from default binding) Keystore for TrustAnchor: " + value + " = " + kstore);
                                    }
                                }
                                if (kstore == null) {
                                    throw SoapSecurityException.format("security.wssecurity.ConfigValidation.keystore.taref.open", value);
                                }
                            }
                            if (kstore == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s32");
                            }
                            if (keyStoreName2 != null && keyStoreName2.length() != 0) {
                                tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName2);
                            }
                            PKIXBuilderParameters pkixBuilderParams = null;
                            Provider provider = null;
                            try {
                                X509CertSelector selector = new X509CertSelector();
                                pkixBuilderParams = new PKIXBuilderParameters(kstore, (CertSelector)selector);
                                pkixBuilderParams.setDate(null);
                            }
                            catch (InvalidAlgorithmParameterException e) {
                                msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                                FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "848", this);
                                Tr.error(tc, msgKey);
                                throw SoapSecurityException.format(msgKey, e);
                            }
                            catch (KeyStoreException e) {
                                msgKey = "security.wssecurity.CommonReceiverConfig.s12";
                                FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "853", this);
                                Tr.error(tc, msgKey);
                                throw SoapSecurityException.format(msgKey, e);
                            }
                            if (certStoreRef != null) {
                                value = ConfigUtil.trim((String)certStoreRef.getRef());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "CertStoreRef = " + value);
                                }
                                boolean certStoreFound = false;
                                if (certStoreList != null) {
                                    CertStore certStore;
                                    EList collectionCertStores = certStoreList.getCollectionCertStores();
                                    jMax = collectionCertStores.size();
                                    for (j = 0; j < jMax; ++j) {
                                        String msgKey2;
                                        CollectionCertStore collectionStore = (CollectionCertStore)collectionCertStores.get(j);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "collectionCertStores.get(" + j + ") = " + collectionStore.getName());
                                        }
                                        if (value == null || !value.equals(ConfigUtil.trim((String)collectionStore.getName()))) continue;
                                        provider = Security.getProvider(ConfigUtil.trim((String)collectionStore.getProvider()));
                                        HashMap<String, CertificateFactory> cache = new HashMap<String, CertificateFactory>();
                                        HashSet<X509Extension> eeCerts = new HashSet<X509Extension>();
                                        EList x509s = collectionStore.getX509Certificates();
                                        kMax = x509s.size();
                                        for (k = 0; k < kMax; ++k) {
                                            X509Certificate x509 = (X509Certificate)x509s.get(k);
                                            String path = null;
                                            path = varMap == null ? ConfigUtil.trim((String)x509.getPath()) : varMap.expand(ConfigUtil.trim((String)x509.getPath()));
                                            String provider2 = "";
                                            CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                            if (cfac == null) {
                                                cfac = ConfigUtil.createCertificateFactory((String)provider2);
                                                cache.put(provider2, cfac);
                                            }
                                            File f = new File(path);
                                            eeCerts.add(ConfigUtil.getX509Certificate((File)f, (CertificateFactory)cfac));
                                            if (!tc.isDebugEnabled()) continue;
                                            Tr.debug(tc, "Adding the X509 Certificate: " + path);
                                        }
                                        EList crls = collectionStore.getCRL();
                                        kMax = crls.size();
                                        for (k = 0; k < kMax; ++k) {
                                            CRL crl = (CRL)crls.get(k);
                                            String path = null;
                                            path = varMap == null ? ConfigUtil.trim((String)crl.getPath()) : varMap.expand(ConfigUtil.trim((String)crl.getPath()));
                                            String provider2 = "";
                                            CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                            if (cfac == null) {
                                                cfac = ConfigUtil.createCertificateFactory((String)provider2);
                                                cache.put(provider2, cfac);
                                            }
                                            eeCerts.add(ConfigUtil.getX509CRL((String)path, (CertificateFactory)cfac));
                                            if (!tc.isDebugEnabled()) continue;
                                            Tr.debug(tc, "Adding the X509 CRL: " + path);
                                        }
                                        String algorithm = "Collection";
                                        CollectionCertStoreParameters cparams = null;
                                        try {
                                            cparams = new CollectionCertStoreParameters(eeCerts);
                                            certStore = null;
                                            certStore = provider == null ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                            pkixBuilderParams.addCertStore(certStore);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Found CertStore for " + value);
                                            }
                                            certStoreFound = true;
                                            break;
                                        }
                                        catch (NoSuchAlgorithmException e) {
                                            msgKey2 = "security.wssecurity.CommonReceiverConfig.s20";
                                            Tr.error(tc, msgKey2, new Object[]{algorithm});
                                            throw SoapSecurityException.format(msgKey2, algorithm, (Throwable)e);
                                        }
                                        catch (InvalidAlgorithmParameterException e) {
                                            msgKey2 = "security.wssecurity.CommonReceiverConfig.s21";
                                            Tr.error(tc, msgKey2, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                            throw SoapSecurityException.format(msgKey2, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                                        }
                                        catch (Throwable e) {
                                            msgKey2 = "security.wssecurity.load.collectioncertstore.failed";
                                            Tr.error(tc, msgKey2, new Object[]{collectionStore.getName(), e});
                                            throw SoapSecurityException.format(msgKey2, collectionStore.getName(), e);
                                        }
                                    }
                                    if (!certStoreFound) {
                                        EList ldapCertStores = certStoreList.getLdapCertStores();
                                        int length = ldapCertStores.size();
                                        for (j = 0; j < length; ++j) {
                                            int port;
                                            LDAPCertStore ldapCertStore = (LDAPCertStore)ldapCertStores.get(j);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "ldapCertStores.get(" + j + ") = " + ldapCertStore.getName());
                                            }
                                            if (value == null || !value.equals(ConfigUtil.trim((String)ldapCertStore.getName()))) continue;
                                            LDAPServer ldapServer = ldapCertStore.getLdapServer();
                                            String host = ConfigUtil.trim((String)ldapServer.getHost());
                                            try {
                                                port = Integer.parseInt(ldapServer.getPort());
                                            }
                                            catch (NumberFormatException e) {
                                                String msgKey3 = "security.wssecurity.CommonReceiverConfig.s19";
                                                String arg = ldapServer.getPort();
                                                FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "978", this);
                                                Tr.error(tc, msgKey3, arg);
                                                throw SoapSecurityException.format(msgKey3, arg, (Throwable)e);
                                            }
                                            String algorithm = "LDAP";
                                            provider = Security.getProvider(ConfigUtil.trim((String)ldapCertStore.getProvider()));
                                            LDAPCertStoreParameters ldapParams = new LDAPCertStoreParameters(host, port);
                                            try {
                                                certStore = provider == null ? CertStore.getInstance(algorithm, ldapParams) : CertStore.getInstance(algorithm, (CertStoreParameters)ldapParams, provider);
                                            }
                                            catch (NoSuchAlgorithmException e) {
                                                String msgKey4 = "security.wssecurity.CommonReceiverConfig.s20";
                                                FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "995", this);
                                                Tr.error(tc, msgKey4, algorithm);
                                                throw SoapSecurityException.format(msgKey4, algorithm);
                                            }
                                            catch (InvalidAlgorithmParameterException e) {
                                                String msgKey5 = "security.wssecurity.CommonReceiverConfig.s21";
                                                FFDCFilter.processException((Throwable)e, clsName + ".WSEMFRequestConsumerConfig", "1000", this);
                                                Tr.error(tc, msgKey5, ldapParams.toString());
                                                throw SoapSecurityException.format(msgKey5, ldapParams.toString());
                                            }
                                            pkixBuilderParams.addCertStore(certStore);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Found CertStore for " + value);
                                            }
                                            certStoreFound = true;
                                            break;
                                        }
                                    }
                                }
                                if (!certStoreFound && value != null && config != null) {
                                    Object cs = config.getWSCertStore(value);
                                    if (cs == null) {
                                        String msgKey6 = "security.wssecurity.ConfigValidation.csref.notfound";
                                        Tr.error(tc, msgKey6, new Object[]{value});
                                        throw SoapSecurityException.format(msgKey6, value);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found CertStore for " + value);
                                    }
                                    tconfig._certStores.add(cs);
                                }
                            }
                            if (trustAnchorRef != null && provider == null) {
                                provider = ConfigUtil.setupCertStoreProvider((Map)this._properties, (Map)tconfig._properties, (String)tconfig._name);
                            }
                            tconfig._provider = provider;
                            tconfig._pkixBuilderParams = pkixBuilderParams;
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "init(): Storing the following, maxAge = " + maxAge + ", clockSkew = " + clockSkew);
                }
                tconfig._properties.put(Constants.WSSECURITY_NONCE_MAX_AGE, new Integer(maxAge));
                tconfig._properties.put(Constants.WSSECURITY_NONCE_CLOCK_SKEW, new Integer(clockSkew));
                boolean decouple = config.getDecoupleToken();
                tconfig._properties.put("com.ibm.wsspi.wssecurity.token.decouple", new Boolean(decouple));
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tconfig._className);
                if (appClassLoader != null) {
                    type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", appClassLoader);
                }
                HashMap properties = new HashMap();
                try {
                    tconfig._instance = (TokenConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{tconfig._className});
                }
                this._tokenConsumers.add(tconfig);
                value = tconfig._name;
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (nameToken.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: token consumer [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + value);
                }
                nameToken.put(value, tconfig);
            }
        }
        if (keyLocators != null) {
            iMax = keyLocators.size();
            for (i = 0; i < iMax; ++i) {
                KeyLocator keyLocator = (KeyLocator)keyLocators.get(i);
                PrivateCommonConfig.KeyLocatorConfImpl klconfig = new PrivateCommonConfig.KeyLocatorConfImpl();
                klconfig._className = ConfigUtil.trim((String)keyLocator.getClassname());
                if (!this._defaultKeyLocators.contains(klconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                com.ibm.etools.webservice.wscommonbnd.KeyStore keystore = keyLocator.getKeyStore();
                String keyStoreName3 = null;
                if (keystore != null) {
                    PrivateCommonConfig.KeyStoreConfImpl ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                    ksconfig._type = ConfigUtil.trim((String)keystore.getType());
                    ksconfig._path = varMap == null ? ConfigUtil.trim((String)keystore.getPath()) : varMap.expand(ConfigUtil.trim((String)keystore.getPath()));
                    ksconfig._password = ConfigUtil.trim((String)keystore.getStorepass());
                    keyStoreName3 = ksconfig._ksRef = ConfigUtil.trim((String)keystore.getKeyStoreRef());
                    ksconfig.validate();
                    klconfig._keyStore = ksconfig;
                }
                if (keyStoreName3 != null && keyStoreName3.length() != 0) {
                    klconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName3);
                }
                EList keys = keyLocator.getKeys();
                jMax = keys.size();
                for (j = 0; j < jMax; ++j) {
                    Key key = (Key)keys.get(j);
                    PrivateCommonConfig.KeyInformationConfImpl kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                    kiconfig._alias = ConfigUtil.trim((String)key.getAlias());
                    kiconfig._keypass = ConfigUtil.trim((String)key.getKeypass());
                    kiconfig._name = ConfigUtil.trim((String)key.getName());
                    klconfig._keyInformationList.add(kiconfig);
                }
                ConfigConstants.getProperties(klconfig._properties, keyLocator.getProperties(), varMap);
                value = ConfigUtil.trim((String)keyLocator.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s27");
                }
                if (nameKeyLocator.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key locator [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key locator: " + value);
                }
                nameKeyLocator.put(value, klconfig);
            }
        }
        ArrayList<PrivateConsumerConfig.KeyInfoContentConsumerConfImpl> kicontentList = new ArrayList<PrivateConsumerConfig.KeyInfoContentConsumerConfImpl>();
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (i = 0; i < iMax; ++i) {
                TokenReference tokenReference;
                KeyInfo keyInfo = (KeyInfo)keyInfos.get(i);
                String keyInfoName = keyInfo.getName();
                kiccconfig = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                kiccconfig._className = ConfigUtil.trim((String)keyInfo.getClassname());
                boolean ksExist = false;
                if (!this._defaultKeyInfoContentConsumers.contains(kiccconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                kiccconfig._keyInfoType = ConfigUtil.trim((String)keyInfo.getType());
                KeyLocatorMapping keyLocatorMapping = keyInfo.getKeyLocatorMapping();
                if (keyLocatorMapping != null) {
                    value = ConfigUtil.trim((String)keyLocatorMapping.getLocatorRef());
                    if (value != null && value.length() > 0) {
                        PrivateCommonConfig.KeyLocatorConfImpl klConf = (PrivateCommonConfig.KeyLocatorConfImpl)nameKeyLocator.get(value);
                        if (klConf != null) {
                            kiccconfig._keyLocator = new KeyLocatorProxy(klConf).getKeyLocator6(appClassLoader);
                            keyStoreName = (String)klConf._properties.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                            if (keyStoreName != null && keyStoreName.length() != 0 && ConfigUtil.isHWKeyStore((String)keyStoreName)) {
                                kiccconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Hardware KeyStore is selected: " + keyStoreName);
                                }
                                ksExist = true;
                            }
                        } else if (config != null) {
                            KeyLocator kl;
                            com.ibm.etools.webservice.wscommonbnd.KeyStore ks;
                            String keyStoreName4;
                            KeyLocatorProxy klproxy = config.getKeyLocator(value);
                            if (klproxy == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            kiccconfig._keyLocator = klproxy.getKeyLocator6(appClassLoader);
                            if (kiccconfig._keyLocator != null && (keyStoreName4 = ConfigUtil.trim((String)(ks = (kl = (KeyLocator)((Object)kiccconfig._keyLocator)).getKeyStore()).getKeyStoreRef())) != null && keyStoreName4.length() != 0 && ConfigUtil.isHWKeyStore((String)keyStoreName4)) {
                                kiccconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName4);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Hardware KeyStore is selected: " + keyStoreName4);
                                }
                                ksExist = true;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key locator mapping: " + value);
                        }
                    }
                    kiccconfig._keyName = ConfigUtil.trim((String)keyLocatorMapping.getKeynameRef());
                }
                if ((tokenReference = keyInfo.getTokenReference()) != null && (value = ConfigUtil.trim((String)tokenReference.getTokenRef())) != null && value.length() > 0) {
                    kiccconfig._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)nameToken.get(value);
                    if (kiccconfig._tokenConsumer == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the token reference: " + value);
                    }
                    if (!ksExist) {
                        tconfig = kiccconfig._tokenConsumer;
                        String ksRef = (String)tconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                        if (ksRef != null && ConfigUtil.isHWKeyStore((String)ksRef)) {
                            kiccconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", ksRef);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Hardware KeyStore is selected: " + ksRef);
                            }
                        }
                    }
                }
                ConfigConstants.getProperties(kiccconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", kiccconfig._className);
                if (kiccconfig._className == null || kiccconfig._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyInfoContentConsumer classname = " + kiccconfig._className);
                }
                if (this._defaultKeyInfoContentConsumers.contains(kiccconfig._className)) {
                    type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (appClassLoader != null) {
                    type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", appClassLoader);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClassLoader used = " + type.get("com.ibm.wsspi.wssecurity.core.wssfactory.classloader"));
                }
                HashMap properties = new HashMap();
                try {
                    kiccconfig._instance = (KeyInfoContentConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{kiccconfig._className});
                }
                kicontentList.add(kiccconfig);
                value = ConfigUtil.trim((String)keyInfo.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (nameKeyInfo.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key info [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + value);
                }
                nameKeyInfo.put(value, kiccconfig);
            }
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (i = 0; i < iMax; ++i) {
                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(i);
                PrivateConsumerConfig.EncryptionConsumerConfImpl econfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                DataEncryptionMethod dataEncryption = encryptionInfo.getEncryptionMethod();
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = ConfigUtil.trim((String)dataEncryption.getAlgorithm());
                ConfigConstants.getProperties(aconfig._properties, dataEncryption.getProperties(), varMap);
                econfig._dataEncryptionMethod = aconfig;
                KeyEncryptionMethod keyEncryption = encryptionInfo.getKeyEncryptionMethod();
                if (keyEncryption != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)keyEncryption.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, keyEncryption.getProperties(), varMap);
                    econfig._keyEncryptionMethod = aconfig;
                }
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                EList encryptionKeys = encryptionInfo.getEncryptionKeyInfo();
                if (encryptionKeys == null || encryptionKeys.size() == 0) {
                    kicconfig._contentConsumers = kicontentList;
                    jMax = kicontentList.size();
                    for (j = 0; j < jMax; ++j) {
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)kicontentList.get(j);
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig == null) continue;
                        tconfig._usedForDecryption = true;
                    }
                } else {
                    kicconfig._contentConsumers = new ArrayList();
                    jMax = encryptionKeys.size();
                    for (j = 0; j < jMax; ++j) {
                        EncryptionKeyInfo encryptionKey = (EncryptionKeyInfo)encryptionKeys.get(j);
                        value = ConfigUtil.trim((String)encryptionKey.getKeyinfoRef());
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForDecryption = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                econfig._encryptionKeyInfo = kicconfig;
                PartReference pref = encryptionInfo.getPartReference();
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(value);
                    if (econfig._reference == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    econfig._reference.getBindings().add(econfig);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                this._encryptionConsumers.add(econfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption consumer.");
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (i = 0; i < iMax; ++i) {
                SigningInfo signingInfo = (SigningInfo)signingInfos.get(i);
                PrivateConsumerConfig.SignatureConsumerConfImpl sconfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                CanonicalizationMethod c14n = signingInfo.getCanonicalizationMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)c14n.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, c14n.getProperties(), varMap);
                    sconfig._canonicalizationMethod = aconfig;
                }
                SignatureMethod signature = signingInfo.getSignatureMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)signature.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, signature.getProperties(), varMap);
                    sconfig._signatureMethod = aconfig;
                }
                KeyInfoSignature kiSignature = signingInfo.getKeyInfoSignature();
                if (kiSignature != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)kiSignature.getType());
                    ConfigConstants.getProperties(aconfig._properties, kiSignature.getProperties(), varMap);
                    sconfig._keyInfoSignature = aconfig;
                }
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                EList signingKeys = signingInfo.getSigningKeyInfo();
                if (signingKeys == null || signingKeys.size() == 0) {
                    kicconfig._contentConsumers = kicontentList;
                    jMax = kicontentList.size();
                    for (j = 0; j < jMax; ++j) {
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)kicontentList.get(j);
                        keyStoreName = null;
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig == null) continue;
                        tconfig._usedForVerification = true;
                    }
                } else {
                    kicconfig._contentConsumers = new ArrayList();
                    jMax = signingKeys.size();
                    for (j = 0; j < jMax; ++j) {
                        SigningKeyInfo signingKey = (SigningKeyInfo)signingKeys.get(j);
                        value = ConfigUtil.trim((String)signingKey.getKeyinfoRef());
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForVerification = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                sconfig._signingKeyInfo = kicconfig;
                EList prefs = signingInfo.getPartReference();
                if (prefs != null) {
                    jMax = prefs.size();
                    for (j = 0; j < jMax; ++j) {
                        DigestMethod digest;
                        PartReference pref = (PartReference)prefs.get(j);
                        PrivateCommonConfig.SigningReferenceConfImpl srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        value = ConfigUtil.trim((String)pref.getPart());
                        if (value != null && value.length() > 0) {
                            srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(value);
                            if (srconfig._reference == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            srconfig._reference.getBindings().add(sconfig);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + value);
                            }
                        }
                        if ((digest = pref.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = ConfigUtil.trim((String)digest.getAlgorithm());
                            ConfigConstants.getProperties(aconfig._properties, digest.getProperties(), varMap);
                            srconfig._digestMethod = aconfig;
                        }
                        EList transforms = pref.getTransform();
                        if (transforms != null) {
                            kMax = transforms.size();
                            for (k = 0; k < kMax; ++k) {
                                Transform transform = (Transform)transforms.get(k);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = ConfigUtil.trim((String)transform.getAlgorithm());
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                    }
                }
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                this._signatureConsumers.add(sconfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature consumer.");
            }
        }
        this.validate();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties(defaultProps, extProperties, bndProperties, "response"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(SecurityResponseConsumerBindingConfig, SecurityResponseConsumerServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader)");
        }
    }

    private final void initDefaultConfig(WSSConsumerConfig dcconfig, Map nameToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSConsumerConfig, Map):", new Object[]{dcconfig, nameToken});
        }
        HashMap<QName, PrivateConsumerConfig.TokenConsumerConfImpl> key2obj = new HashMap<QName, PrivateConsumerConfig.TokenConsumerConfImpl>();
        for (Object obj : nameToken.values()) {
            if (!(obj instanceof PrivateConsumerConfig.TokenConsumerConfImpl)) continue;
            PrivateConsumerConfig.TokenConsumerConfImpl tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)obj;
            key2obj.put(tconfig.getType(), tconfig);
        }
        Set set = dcconfig.getTokenConsumers();
        for (PrivateConsumerConfig.TokenConsumerConfImpl tconfig : set) {
            PrivateConsumerConfig.TokenConsumerConfImpl tc2 = (PrivateConsumerConfig.TokenConsumerConfImpl)key2obj.get(tconfig.getType());
            if (tc2 != null) {
                tconfig._usage = tc2._usage;
            }
            this._tokenConsumers.add(tconfig);
        }
        set = dcconfig.getEncryptionConsumers();
        for (PrivateConsumerConfig.EncryptionConsumerConfImpl econfig : set) {
            Iterator j = this._requiredConfidentialParts.iterator();
            if (j.hasNext()) {
                econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)j.next();
            }
            this._encryptionConsumers.add(econfig);
        }
        set = dcconfig.getSignatureConsumers();
        for (PrivateConsumerConfig.SignatureConsumerConfImpl sconfig : set) {
            for (PrivateCommonConfig.SigningReferenceConfImpl srconfig : sconfig._references) {
                Iterator k = this._requiredIntegralParts.iterator();
                if (!k.hasNext()) continue;
                srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)k.next();
            }
            this._signatureConsumers.add(sconfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDefaultConfig(WSSConsumerConfig, Map)");
        }
    }

    final String getOrigin() {
        return this.origin;
    }
}

