/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.enc;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.wsspi.wssecurity.EngineFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(EncryptionGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionGenerator.class.getName();
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;
    private static Class PKCS11ExceptionClass = null;
    private static Method getCodeMethod = null;

    private static void _checkForPKCS11ExceptionClass() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block4: {
                    try {
                        PKCS11ExceptionClass = Class.forName("com.ibm.pkcs11.PKCS11Exception");
                        getCodeMethod = PKCS11ExceptionClass.getMethod("getCode", new Class[0]);
                    }
                    catch (ClassNotFoundException nf) {
                        if (tc.isEventEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"com.ibm.pkcs11.PKCS11Exception not found, so not running IBM SDK");
                        }
                    }
                    catch (Throwable t) {
                        if (!tc.isEventEnabled()) break block4;
                        Tr.debug((TraceComponent)tc, (String)("Unexpected exception looking for com.ibm.pkcs11.PKCS11Exception" + t));
                    }
                }
                return null;
            }
        });
        if (tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("PKCS11ExceptionClass: " + PKCS11ExceptionClass + " getCodeMethod: " + getCodeMethod));
        }
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        Provider p;
        PartList parts;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][soapVersion];
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", "Null", "the parent element");
        }
        String ln = parent.getLocalName();
        String ns = parent.getNamespaceURI();
        if (NamespaceUtil.isWsse(ns) != wssVersion || !"Security".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtil.getQualifiedName((Node)parent));
        }
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        EncryptionGeneratorConfig config = (EncryptionGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.encryptionGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("EncryptionGeneratorConfig [" + config + "]."));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Examining encrypting parts.");
        }
        boolean encryptSomething = false;
        boolean encryptNonce = false;
        HashSet<ReferencePartConfig.PartConfig> nonces = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put(NonceManager.class, gconfig.getNonceManager());
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", (Object)this._idResolver);
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<PartList> pList = new ArrayList<PartList>();
        ArrayList<Node> eList = new ArrayList<Node>();
        ReferencePartConfig rpconfig = config.getReference();
        if (rpconfig != null && rpconfig.getParts() != null && rpconfig.getParts().iterator() != null) {
            for (ReferencePartConfig.PartConfig pconfig : rpconfig.getParts()) {
                String keyword;
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    encryptNonce = true;
                    nonces.add(pconfig);
                    continue;
                }
                String dialect = pconfig.getDialect();
                parts = (PartList)SignatureGenerator.getMessagePart(doc, dialect, keyword = pconfig.getKeyword(), "encryption_mode", this._selectors, ConfidentialDialectElementSelector.class, selectorMap);
                if (parts != null && parts.getLength() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                    }
                    pList.add(parts);
                    for (int j = 0; j < parts.getLength(); ++j) {
                        eList.add(parts.item(j));
                        boolean added = false;
                        while (!added) {
                            String newid = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_encryption_id_");
                            if (idList.contains(newid)) continue;
                            idList.add(newid);
                            added = true;
                        }
                        encryptSomething = true;
                    }
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
            }
        }
        if (!encryptSomething) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
            }
            return;
        }
        HashMap<String, String> type = new HashMap<String, String>();
        EncryptionContext econtext = new EncryptionContext();
        String encAlgorithm = null;
        AlgorithmConfig encMethod = config.getKeyEncryptionMethod();
        if (encMethod != null) {
            encAlgorithm = encMethod.getAlgorithm();
        }
        econtext.setEncAlgorithm(encAlgorithm);
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", config.getDataEncryptionMethod().getAlgorithm());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Data encryption algorithm is : " + config.getDataEncryptionMethod().getAlgorithm()));
        }
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        econtext.setAlgorithmFactory((AlgorithmFactory)afactory);
        Map props = config.getProperties();
        Map gprops = gconfig.getProperties();
        String hwAcceleration = null;
        String hwKsRef = null;
        hwAcceleration = (String)gprops.get("HWCONFIG");
        econtext.setHWConfigName(hwAcceleration);
        String cryptoOffload = (String)gprops.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        econtext.setOffload((Boolean)gprops.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (econtext.shouldChangeProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Acceleration enabled, Key Store Name is: ", (Object)econtext.getHWConfigName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance((String)econtext.getHWConfigName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                econtext.setHWAccelerationProvider(p, hardwareCacheSize);
                econtext.setCryptoOffloadProperty(cryptoOffload);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for HW Acceleration" + p.getName()));
                }
            }
        }
        hwKsRef = (String)props.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        econtext.setHWKeyStoreName(hwKsRef);
        if (econtext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)econtext.getHWKeyStoreName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance((String)econtext.getHWKeyStoreName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                econtext.setHWKeyStoreProvider(p);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p.getName()));
                }
            }
        }
        type.put("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore", (String)gprops.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore"));
        if (tc.isDebugEnabled()) {
            econtext.setResourceShower((ResourceShower)ShowerImpl.getInstance());
        }
        String keyencMethod = null;
        if (config.getKeyEncryptionMethod() != null) {
            keyencMethod = config.getKeyEncryptionMethod().getAlgorithm();
        }
        boolean keygen = keyencMethod != null && keyencMethod.length() > 0;
        EncryptedData ed = EncryptionGenerator.createEncryptedData(config, doc, !keygen && gconfig.isUserDefinedComponentsUsed(), afactory);
        Element el = null;
        Element reference = null;
        Key dek = null;
        if (keygen) {
            EncryptedKey ek = EncryptionGenerator.createEncryptedKey(config, idList, afactory, doc, nsSoap, nsWsse, nsWsu, gconfig.isUserDefinedComponentsUsed());
            try {
                el = ek.createElement(doc, true);
                el = SignatureGenerator.insertElement(parent, el, nsWsu, context);
            }
            catch (StructureException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"322");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", "EncryptedKey", (Throwable)e);
            }
            Key kek = SignatureGenerator.callKeyInfoGenerator(config.getEncryptionKeyInfo(), "EncryptingKey", type, this._selectors, doc, el, context);
            String defaultHWKSRef = null;
            if (kek instanceof PKCS11Key && !econtext.shouldChangeProvider() && !econtext.useHWKeyStore()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                }
                if ((defaultHWKSRef = (String)gprops.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                    econtext.setHWKeyStoreName(defaultHWKSRef);
                    if (econtext.useHWKeyStore()) {
                        Provider p2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)econtext.getHWKeyStoreName());
                        }
                        if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)econtext.getHWKeyStoreName())) == null) {
                            Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                        } else {
                            econtext.setHWKeyStoreProvider(p2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                            }
                        }
                    } else {
                        Tr.error((TraceComponent)tc, (String)"Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                        throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                    }
                }
            }
            dek = EncryptionGenerator.generateKey(econtext, ed, doc, kek);
            EncryptionGenerator.encryptKey(context, econtext, el, doc, dek, kek);
            reference = DOMUtil.getOneChildElement((Element)el, (String)Constants.NS_ENC, (String)"ReferenceList");
        } else {
            ReferenceList rl = EncryptionGenerator.createReferenceList(idList, doc, nsSoap, nsWsse, nsWsu);
            try {
                el = rl.createElement(doc, true);
                el = SignatureGenerator.insertElement(parent, el, nsWsu, context);
            }
            catch (StructureException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"355");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", "ReferenceLost", (Throwable)e);
            }
            dek = null;
            reference = el;
        }
        if (encryptNonce) {
            Object[] objs = eList.toArray();
            for (ReferencePartConfig.PartConfig pconfig : nonces) {
                parts = (PartList)SignatureGenerator.getNoncePart(doc, objs, pconfig, "encryption_mode", this._selectors, ConfidentialDialectElementSelector.class, selectorMap);
            }
        }
        EncryptionGenerator.encrypt(config.getEncryptionKeyInfo(), type, this._selectors, doc, context, config.remainSignatureAfterEncryption(), pList, idList, econtext, el, ed, dek, gconfig.isUserDefinedComponentsUsed());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static EncryptedKey createEncryptedKey(EncryptionGeneratorConfig config, List ids, WSSAlgorithmFactory factory, Document doc, String nsSoap, String nsWsse, String nsWsu, boolean userDefinedComponentsUsed) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createEncryptedKey(EncryptionGeneratorConfig config,List ids[" + ids + "]," + "WSSAlgorithmFactory factory[" + (Object)((Object)factory) + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String nsSoap[" + nsSoap + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean userDefinedComponentsUsed[" + userDefinedComponentsUsed + "])"));
        }
        EncryptedKey ek = new EncryptedKey();
        ek.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(config.getKeyEncryptionMethod(), factory));
        if (userDefinedComponentsUsed) {
            ek.setKeyInfo(EncryptionGenerator.createKeyInfo(doc));
        }
        ek.setCipherData(EncryptionGenerator.createCipherData());
        ek.setReferenceList(EncryptionGenerator.createReferenceList(ids, doc, nsSoap, nsWsse, nsWsu));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createEncryptedKey(EncryptionGeneratorConfig config,List ids,WSSAlgorithmFactory factory,Document doc,String nsSoap,String nsWsse,String nsWsu,boolean userDefinedComponentsUsed) returns EncryptedKey[" + ek + "]"));
        }
        return ek;
    }

    private static EncryptionMethod createEncryptionMethod(AlgorithmConfig aconfig, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setEncryptionMethod(AlgorithmConfig aconfig[" + aconfig + "]," + "WSSAlgorithmFactory factory[" + (Object)((Object)factory) + "])"));
        }
        EncryptionMethod em = new EncryptionMethod();
        em.setAlgorithm(aconfig.getAlgorithm());
        try {
            AlgorithmParameterSpec spec = factory.convertParameter(aconfig.getAlgorithm(), aconfig.getProperties());
            if (spec != null) {
                em.setParameterSpec((EngineFactory)factory, spec);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".createEncryptionMethod"), (String)"493");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s14", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".createEncryptionMethod"), (String)"497");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s14", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setEncryptionMethod(AlgorithmConfig aconfig,WSSAlgorithmFactory factory) returns EncryptionMethod[" + em + "]"));
        }
        return em;
    }

    private static KeyInfo createKeyInfo(Document doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createKeyInfo(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "])"));
        }
        KeyInfo ki = new KeyInfo();
        ki.addElement((Object)doc.createElement("dummy"));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createKeyInfo(Document doc) returns KeyInfo[" + ki + "]"));
        }
        return ki;
    }

    private static CipherData createCipherData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCipherData()");
        }
        CipherValue cv = new CipherValue();
        CipherData cd = new CipherData();
        cd.setCipherValue(cv);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createCipherData() returns CipherData[" + cd + "]"));
        }
        return cd;
    }

    private static ReferenceList createReferenceList(List ids, Document doc, String nsSoap, String nsWsse, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createReferenceList(List ids[" + ids + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String nsSoap[" + nsSoap + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        ReferenceList rl = new ReferenceList();
        for (String id : ids) {
            DataReference dataRef = new DataReference();
            dataRef.setURI("#" + id);
            rl.addDataReference(dataRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createReferenceList(List ids,Document doc,String nsSoap,String nsWsse,String nsWsu) returns ReferenceList[" + rl + "]"));
        }
        return rl;
    }

    private static EncryptedData createEncryptedData(EncryptionGeneratorConfig config, Document doc, boolean createKeyInfo, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createEncryptedData(EncryptionGeneratorConfig config,Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "boolean createKeyInfo[" + createKeyInfo + "]," + "WSSAlgorithmFactory factory[" + (Object)((Object)factory) + "])"));
        }
        EncryptedData ed = new EncryptedData();
        ed.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(config.getDataEncryptionMethod(), factory));
        if (createKeyInfo) {
            ed.setKeyInfo(EncryptionGenerator.createKeyInfo(doc));
        }
        ed.setCipherData(EncryptionGenerator.createCipherData());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createEncryptedData(EncryptionGeneratorConfig config,Document doc,boolean createKeyInfo,WSSAlgorithmFactory factory) returns EncryptedData[" + ed + "]"));
        }
        return ed;
    }

    private static Key generateKey(EncryptionContext econtext, EncryptedData ed, Document doc, Key kek) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateKey(EncryptionContext econtext[" + econtext + "]," + "EncryptedData ed[" + ed + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Key kek[" + kek + "])"));
        }
        Key key = null;
        try {
            econtext.setEncryptedType(ed.createElement(doc, true), null, null, null);
            key = econtext.generateKey();
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, (String)(clsName + ".generateKey"), (String)"638");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s11", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s11", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateKey(EncryptionContext econtext,EncryptedData ed,Document doc,Key kek) returns Key[" + key + "]"));
        }
        return key;
    }

    private static void encrypt(KeyInfoGeneratorConfig config, Map type, Map properties, Document doc, Map context, boolean sigAfterEnc, List pList, List idList, EncryptionContext econtext, Element einfo, EncryptedData ed, Key dek, boolean userDefinedComponentsUsed) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Map context," + "boolean sigAfterEnc," + "List pList[" + pList + "]," + "List idList[" + idList + "]," + "EncryptionContext econtext[" + econtext + "]," + "Element einfo[" + DOMUtil.getDisplayName((Node)einfo) + "]," + "EncryptedData ed[" + ed + "]," + "Key dek[" + dek + "], " + "boolean userDefinedComponentsUsed[" + userDefinedComponentsUsed + "])"));
        }
        if (dek == null && userDefinedComponentsUsed) {
            ed.setKeyInfo(EncryptionGenerator.createKeyInfo(doc));
        }
        RequestMessagePool.addDocument(context, doc, pList, sigAfterEnc);
        try {
            int idp = idList.size() - 1;
            for (PartList parts : pList) {
                for (int j = 0; j < parts.getLength(); ++j) {
                    String encType = parts.getType();
                    Element el = (Element)parts.item(j);
                    String id = (String)idList.get(idp--);
                    ed.setId(id);
                    ed.setType(encType);
                    econtext.setData(el);
                    Element eed = ed.createElement(doc, true);
                    if (dek == null) {
                        Key key = SignatureGenerator.callKeyInfoGenerator(config, "EncryptingKey", type, properties, doc, eed, context);
                        String defaultHWKSRef = null;
                        if (key instanceof PKCS11Key && !econtext.shouldChangeProvider() && !econtext.useHWKeyStore()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                            }
                            if ((defaultHWKSRef = (String)type.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                                econtext.setHWKeyStoreName(defaultHWKSRef);
                                if (econtext.useHWKeyStore()) {
                                    Provider p2;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)econtext.getHWKeyStoreName());
                                    }
                                    if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)econtext.getHWKeyStoreName())) == null) {
                                        Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                    } else {
                                        econtext.setHWKeyStoreProvider(p2);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                                        }
                                    }
                                } else {
                                    Tr.error((TraceComponent)tc, (String)"Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                                }
                            }
                        }
                        econtext.setKey(key);
                    } else {
                        econtext.setKey(dek);
                    }
                    econtext.setEncryptedType(eed, null, null, null);
                    econtext.encrypt();
                    econtext.replace();
                    RequestMessagePool.addElement(context, el, econtext.getEncryptedTypeAsElement(), einfo);
                }
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, (String)(clsName + ".encrypt"), (String)"730");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s12", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s12", e);
        }
        finally {
            econtext.clearLocalProviderMap();
            if (econtext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance((String)econtext.getHWConfigName(), (Provider)econtext.getHWAccelerationProvider());
            }
            if (econtext.isHWKeyStoreProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance((String)econtext.getHWKeyStoreName(), (Provider)econtext.getHWKeyStoreProvider());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,Document doc,Map context,boolean sigAfterEnc,List pList,List idList,EncryptionContext econtext,Element einfo,EncryptedData ed,Document doc,Key dek, boolean userDefinedComponentsUsed)");
        }
    }

    private static void encryptKey(Map context, EncryptionContext econtext, Element ed, Document doc, Key dek, Key kek) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encryptKey(EncryptionContext econtext[" + econtext + "]," + "EncryptedData ed[" + ed + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Key dek[" + dek + "]," + "Key kek[" + kek + "])"));
        }
        try {
            econtext.setData(dek);
            econtext.setEncryptedType(ed, null, null, null);
            if (econtext.isHWAccelerationProvider()) {
                econtext.setHWKeyFromCache((PublicKey)kek);
            } else {
                econtext.setKey(kek);
            }
            econtext.encrypt();
        }
        catch (Exception e) {
            if (PKCS11ExceptionClass != null && getCodeMethod != null) {
                if (PKCS11ExceptionClass.isInstance(e)) {
                    Tr.debug((TraceComponent)tc, (String)"e is instance of PKCS11Excpetion");
                    Object retObj = null;
                    try {
                        retObj = getCodeMethod.invoke((Object)PKCS11ExceptionClass, new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("retObj: " + retObj));
                    }
                    catch (Exception e2) {
                        Tr.processException((Throwable)e, (String)(clsName + ".encryptKey"), (String)"1097");
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s13", (Object)new Object[]{e});
                        throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{e.getMessage()}, (Throwable)e);
                    }
                    if (retObj != null) {
                        String rc = retObj.toString();
                        Tr.error((TraceComponent)tc, (String)("Encrypting the key fails with PKCS11Exception and error code = " + rc));
                        Tr.processException((Throwable)e, (String)(clsName + ".encryptKeyPKCS11"), (String)"1093");
                        throw new SoapSecurityException("Encrypting the key for data encryption fails with exception " + e.getMessage() + " and error code = " + rc, e);
                    }
                }
                Tr.processException((Throwable)e, (String)(clsName + ".encryptKey"), (String)"1097");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s13", (Object)new Object[]{e});
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{e.getMessage()}, (Throwable)e);
            }
            Tr.processException((Throwable)e, (String)(clsName + ".encryptKey"), (String)"1097");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionGenerator.s13", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encryptKey(EncryptionContext econtext,EncryptedData ed,Document doc,Key dek,Key kek)");
        }
    }

    static {
        EncryptionGenerator._checkForPKCS11ExceptionClass();
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] content, Object data, Element encType) {
            String dumpData = null;
            try {
                dumpData = EncryptedData.isOfType((Element)encType) ? new String(content, "UTF-8") : Base64.encode((byte[])content);
            }
            catch (Exception e) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType((Element)encType)) {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs encrypt-" + encType.getAttribute("Id") + ": " + dumpData));
            } else {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs encrypt-EncryptedKey: " + dumpData));
            }
        }
    }
}

