/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentConsumer;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDTKeyInfoResolver
extends KeyInfoResolverBase {
    private static final TraceComponent tc = Tr.register(XMLDTKeyInfoResolver.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDTKeyInfoResolver.class.getName();
    private IDResolver _idResolver;
    private Set _tokenConsumers;
    private Set _encKIConsumers;
    private Map _context;
    private Map _selectors;
    private boolean _storedToken = false;
    private Set _stokens = null;
    private Result[] _results = null;

    protected XMLDTKeyInfoResolver() {
    }

    protected void setTokenConsumers(Set tokenConsumers) {
        this._tokenConsumers = tokenConsumers;
    }

    protected void setEncKeyInfoConsumers(Set encKIConsumers) {
        this._encKIConsumers = encKIConsumers;
    }

    protected void setContext(Map context) {
        this._context = context;
    }

    protected void setSelectors(Map selectors) {
        this._selectors = new HashMap(selectors);
    }

    public void setIdResolver(IDResolver idResolver) {
        this._idResolver = idResolver;
        super.setIdResolver(idResolver);
    }

    public Key resolve(KeyInfo keyInfo, EncryptionMethod encMethod) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve(KeyInfo keyInfo[" + keyInfo + "]," + "EncryptionMethod encMethod[" + encMethod + "])"));
        }
        Key key = null;
        if (keyInfo != null) {
            try {
                Element target = keyInfo.getBase();
                if (target != null) {
                    if (!this._storedToken) {
                        this._stokens = XMLDTKeyInfoResolver.storeSubject(this._context);
                        this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                        this._storedToken = true;
                    }
                    Document doc = target.getOwnerDocument();
                    HashMap type = new HashMap();
                    int wssVersion = 0;
                    Object obj = this._context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
                    if (obj != null && obj instanceof Integer) {
                        wssVersion = (Integer)obj;
                    }
                    String nsWsse = Constants.NAMESPACES[0][wssVersion];
                    String kitype = KeyInfoConsumer.getKeyInfoType(target, nsWsse);
                    boolean strref = "STRREF".equals(kitype);
                    String uri = null;
                    if (strref) {
                        uri = STRReferenceContentConsumer.getReferenceURI(target, nsWsse);
                    }
                    if (strref) {
                        Element tElement = this._idResolver.resolveID(doc, uri);
                        Element tEnvelope = doc.getDocumentElement();
                        boolean isUNT = XMLDTKeyInfoResolver.isUNT(tElement, wssVersion);
                        boolean isBST = isUNT ? false : XMLDTKeyInfoResolver.isBST(tElement, wssVersion);
                        WSSConsumer.callTokenConsumer(null, this._tokenConsumers, tEnvelope, null, tElement, this._context, isUNT, isBST, wssVersion);
                    }
                    key = XMLDTKeyInfoResolver.callKeyInfoConsumer(this._encKIConsumers, type, this._selectors, target, this._context);
                }
                if (key == null) {
                    key = super.resolve(keyInfo, encMethod);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (KeyInfoResolvingException e) {
                throw e;
            }
            catch (Throwable e) {
                Throwable t2;
                if (e instanceof SoapSecurityException && (t2 = ((SoapSecurityException)e).getCauseException()) != null) {
                    e = t2;
                }
                throw new KeyInfoResolvingException(e.toString());
            }
            finally {
                if (this._storedToken) {
                    XMLDTKeyInfoResolver.restoreSubject(this._context, this._stokens);
                    XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                    this._storedToken = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve(KeyInfo keyInfo,EncryptionMethod encMethod) returns Key[" + key + "]"));
        }
        return key;
    }

    private static Key callKeyInfoConsumer(Set kconfig, Map type, Map properties, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callKeyInfoConsumer(Set kconfig,Map type,Map properties,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        boolean succeeded = false;
        Exception lastException = null;
        KeyInfoConsumerConfig config2 = null;
        Key key = null;
        for (KeyInfoConsumerConfig config2 : kconfig) {
            try {
                key = SignatureConsumer.callKeyInfoConsumer(config2, "DecryptingKey", type, properties, target, context);
                succeeded = true;
                break;
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(clsName + ".callSignatureConsumer"), (String)"233");
                lastException = e;
            }
        }
        if (!succeeded) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", lastException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callKeyInfoConsumer(Set sconfig,Map type,Map properties,Element target,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    protected static Set storeSubject(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeSubject(Map context)");
        }
        Set tokens = TokenManager.getTokens(context);
        HashSet ret = new HashSet(tokens);
        TokenManager.removeTokens(context, tokens);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("storeSubject(Map context)returns Set[" + ret + "]"));
        }
        return ret;
    }

    protected static void restoreSubject(Map context, Set tokens) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("restoreSubject(Map context,Set tokens[" + tokens + "])"));
        }
        if (tokens != null) {
            TokenManager.removeAllTokens(context);
            TokenManager.setTokens(context, tokens);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreSubject(Map context,Set tolens)");
        }
    }

    protected static Result[] storeResult(Map context) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeResult(Map context)");
        }
        if ((results = ResultPool.get((Map)context, KeyInfoResult.class)) != null) {
            ResultPool.remove((Map)context, (Result[])results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeResult(Map context)");
        }
        return results;
    }

    protected static void restoreResult(Map context, Result[] results) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("restoreResult(Map context,Result[] results[" + results + "])"));
        }
        if (results != null) {
            Result[] nresults = ResultPool.get((Map)context, KeyInfoResult.class);
            if (nresults != null) {
                ResultPool.remove((Map)context, (Result[])nresults);
            }
            for (int i = 0; i < results.length; ++i) {
                ResultPool.add((Map)context, (Result)results[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreResult(Map context,Result[] results)");
        }
    }

    protected static boolean isUNT(Element element, int wssVersion) {
        return NamespaceUtil.checkWsseVersion(element, wssVersion, "UsernameToken") >= 0;
    }

    protected static boolean isBST(Element element, int wssVersion) {
        return NamespaceUtil.checkWsseVersion(element, wssVersion, "BinarySecurityToken") >= 0;
    }
}

