/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.ResultMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.PartList;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.dsig.VerificationResult;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifiedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(VerifiedPartChecker.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = VerifiedPartChecker.class.getName();
    private Map _selectors = null;
    private IDResolver _idResolver = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.VerifiedPartChecker.s05");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        Document doc = null;
        doc = target.getNodeType() == 9 ? (Document)target : target.getOwnerDocument();
        HashMap<SignatureConsumerConfig, Document> docMap = new HashMap<SignatureConsumerConfig, Document>();
        Result[] results = ResultPool.get((Map)context, VerificationResult.class);
        if (results != null && results.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(results.length + " verified results found."));
            }
            for (int i = 0; i < results.length; ++i) {
                VerificationResult result = (VerificationResult)results[i];
                docMap.put(result._sconfig, result._copiedDOM);
            }
        }
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        NonceManager nmanager = gconfig.getNonceManager();
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put(NonceManager.class, nmanager);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", this._idResolver);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.config", gconfig.getTokenConsumers());
        Set requiredParts = VerifiedPartChecker.preprocess(doc, docMap, gconfig.getRequiredIntegralParts(), gconfig.getSignatureConsumers(), this._selectors, selectorMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Processing the verified results...");
        }
        HashSet<ReferencePartConfig> rset = new HashSet<ReferencePartConfig>();
        if (results != null && results.length > 0) {
            for (int i = 0; i < results.length; ++i) {
                VerificationResult result = (VerificationResult)results[i];
                rset.clear();
                for (VerificationResult.VerifiedPart vpart : result._verifiedParts) {
                    RequiredPart rpart = VerifiedPartChecker.getRelatedPart(result, vpart, requiredParts, context);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("VerifiedPart [" + vpart + "], RequiredPart [" + rpart + "]"));
                    }
                    if (rpart == null) continue;
                    if (rpart._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking required nonce...");
                        }
                        if (vpart._nonce == null) {
                            String expression = rpart._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", expression);
                        }
                        NonceUtil.checkNonce(vpart._nonce, nsWsse, nmanager);
                    }
                    if (rpart._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking required timestamp...");
                        }
                        if (vpart._timestamp == null) {
                            String expression = rpart._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s03", expression);
                        }
                        NonceUtil.checkTimestamp(vpart._timestamp, nsWsu, gconfig.getTimestampMaxAge(), gconfig.getTimestampClockSkew(), false);
                    }
                    rpart._processed = true;
                    rpart._tokens.add(result._token);
                    rset.add(rpart._rconfig);
                }
                VerifiedPartChecker.checkCaller(result, rset, gconfig, context);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking whether all required integrity is processed...");
        }
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] rpart = rparts._parts;
            for (int j = 0; j < rpart.length; ++j) {
                String usage = rpart[j]._pconfig.getUsage();
                String keyword = rpart[j]._pconfig.getKeyword();
                if (!rpart[j]._processed) {
                    if (ConfigUtil.isUsageRequired((String)usage)) {
                        throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s01", keyword);
                    }
                    if (!ConfigUtil.isUsageOptional((String)usage) && !ConfigUtil.isUsageObserved((String)usage) || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Optionally signed message part [" + keyword + "] is not signed."));
                    continue;
                }
                if (!ConfigUtil.isUsageRejected((String)usage)) continue;
                throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s04", keyword);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static Set preprocess(Document doc, Map docMap, Set requiredIntegrity, Set sconsumers, Map selectors, Map selectorMap) throws SoapSecurityException {
        RequiredParts rparts2;
        int j;
        RequiredPart[] rpartList;
        String keyword;
        String dialect;
        NodeList parts;
        Document useDoc;
        Map cpSelectorMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("preprocess(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Map docMap[" + docMap + "]," + "Set requiredIntegrity[" + requiredIntegrity + "]," + "Set sconsumers," + "Map selectors," + "Map selectorMap)"));
        }
        HashSet<RequiredParts> requiredParts = new HashSet<RequiredParts>();
        HashSet<ReferencePartConfig.PartConfig> nonces = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap nonces2 = new HashMap();
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> nonces3 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
        HashMap<ReferencePartConfig.PartConfig, Document> nonces4 = new HashMap<ReferencePartConfig.PartConfig, Document>();
        for (ReferencePartConfig rconfig : requiredIntegrity) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing ReferencePartConfig [" + rconfig + "]..."));
            }
            cpSelectorMap = new HashMap(selectorMap);
            useDoc = VerifiedPartChecker.setNecessaryInfo(cpSelectorMap, sconsumers, rconfig, doc, docMap);
            for (ReferencePartConfig.PartConfig pconfig : rconfig.getParts()) {
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    nonces.add(pconfig);
                    nonces2.put(pconfig, cpSelectorMap);
                    nonces3.put(pconfig, rconfig);
                    nonces4.put(pconfig, useDoc);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing PartConfig [" + pconfig + "]..."));
                }
                if ((parts = SignatureGenerator.getMessagePart(useDoc, dialect = pconfig.getDialect(), keyword = pconfig.getKeyword(), "verification_mode", selectors, IntegralDialectElementSelector.class, cpSelectorMap)) != null && parts.getLength() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                    }
                    if (parts instanceof PartList) {
                        rpartList = new RequiredPart[]{new RequiredPart(rconfig, pconfig, parts)};
                    } else {
                        rpartList = new RequiredPart[parts.getLength()];
                        for (j = 0; j < rpartList.length; ++j) {
                            rpartList[j] = new RequiredPart(rconfig, pconfig, (Element)parts.item(j));
                        }
                    }
                    rparts2 = new RequiredParts(rpartList);
                    requiredParts.add(rparts2);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
            }
        }
        for (ReferencePartConfig.PartConfig pconfig : nonces) {
            ReferencePartConfig rconfig;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing PartConfig [" + pconfig + "]..."));
            }
            cpSelectorMap = (Map)nonces2.get(pconfig);
            rconfig = (ReferencePartConfig)nonces3.get(pconfig);
            useDoc = (Document)nonces4.get(pconfig);
            if (!pconfig.isTimestamp() && !pconfig.isNonce()) continue;
            parts = SignatureGenerator.getNoncePart(useDoc, null, pconfig, "verification_mode", selectors, IntegralDialectElementSelector.class, cpSelectorMap);
            if (parts != null && parts.getLength() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                }
                boolean found = false;
                for (j = 0; j < parts.getLength(); ++j) {
                    Node node = parts.item(j);
                    if (node.getNodeType() != 1) continue;
                    Element el = (Element)node;
                    block5: for (RequiredParts rparts2 : requiredParts) {
                        for (int k = 0; k < rparts2._parts.length; ++k) {
                            RequiredPart rpart = rparts2._parts[k];
                            if (!DOMUtil.equals((Node)el, (Node)rpart._element)) continue;
                            if (pconfig.isTimestamp()) {
                                rpart._requiredTimestamp = pconfig.isTimestamp();
                            }
                            if (pconfig.isNonce()) {
                                rpart._requiredNonce = pconfig.isNonce();
                            }
                            found = true;
                            continue block5;
                        }
                    }
                    if (found) continue;
                    rpartList = new RequiredPart[]{new RequiredPart(rconfig, pconfig, el)};
                    rpartList[0]._requiredTimestamp = pconfig.isTimestamp();
                    rpartList[0]._requiredNonce = pconfig.isNonce();
                    rparts2 = new RequiredParts(rpartList);
                    requiredParts.add(rparts2);
                }
                continue;
            }
            dialect = pconfig.getDialect();
            keyword = pconfig.getKeyword();
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("preprocess(Document doc,Map docMap,Set requiredIntegrity,Set sconsumers,Map selectors,Map selectorMap) returns Set[" + requiredParts + "]"));
        }
        return requiredParts;
    }

    private static Document setNecessaryInfo(Map selectorMap, Set sconsumers, ReferencePartConfig rconfig, Document doc, Map docMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setNecessaryInfo(Map selectorMap,Set sconsumers,ReferencePartConfig rconfig[" + rconfig + "]," + "Document doc[" + doc + "]," + "Map docMap)"));
        }
        boolean found = false;
        String ksMethod = null;
        Document useDoc = doc;
        SigningReferenceConfig srconfig2 = null;
        for (SignatureConsumerConfig sconfig : sconsumers) {
            Document d;
            for (SigningReferenceConfig srconfig2 : sconfig.getReferences()) {
                if (!srconfig2.getReference().equals(rconfig)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            AlgorithmConfig aconfig = sconfig.getKeyInfoSignature();
            if (aconfig != null) {
                ksMethod = aconfig.getAlgorithm();
            }
            if ((d = (Document)docMap.get(sconfig)) == null) break;
            useDoc = d;
            break;
        }
        if (ksMethod != null) {
            selectorMap.put("security.wssecurity.integraldialectelementselector.keysigntype", ksMethod);
        } else {
            selectorMap.remove("security.wssecurity.integraldialectelementselector.keysigntype");
        }
        SignatureGenerator.prepareTransform(srconfig2, selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setNecessaryInfo(Map selectorMap,Set sconsumers,ReferencePartConfig rconfig,Docoment doc,Map docMap)");
        }
        return useDoc;
    }

    private static RequiredPart getRelatedPart(VerificationResult vresult, VerificationResult.VerifiedPart vpart, Set requiredParts, Map context) throws SoapSecurityException {
        boolean isNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRelatedPart(VerificationResult vresult,VerifiedPart vpart[" + vpart + "]," + "Set requiredParts[" + requiredParts + "]," + "Map context)"));
        }
        boolean isNodeset = vpart._nodeset != null;
        boolean bl = isNode = vpart._node != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Is the verified part is nodeset?: " + isNodeset));
            Tr.debug((TraceComponent)tc, (String)("Is the verified part is node?: " + isNode));
            Tr.debug((TraceComponent)tc, (String)(requiredParts.size() + " required parts found."));
        }
        SoapSecurityException lastException = null;
        RequiredPart rpart = null;
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] part = rparts._parts;
            for (int j = 0; j < part.length; ++j) {
                if (part[j]._processed) continue;
                SoapSecurityException sse = VerifiedPartChecker.checkBinding(part[j]._rconfig.getBindings(), vresult);
                if (sse == null) {
                    Element decreptedVpart;
                    if (part[j]._isNodeset) {
                        NodeList nodeset;
                        if (isNodeset) {
                            if (part[j]._nodeset == null) {
                                part[j]._nodeset = XPathCanonicalizer.toNodeset((Node)part[j]._element, null, (boolean)false);
                            }
                            if (!DOMUtil.includeNodeset(vpart._nodeset, part[j]._nodeset)) continue;
                            rpart = part[j];
                            break;
                        }
                        if (isNode) {
                            nodeset = XPathCanonicalizer.toNodeset((Node)vpart._node, null, (boolean)false);
                            if (!DOMUtil.includeNodeset(nodeset, part[j]._nodeset)) continue;
                            rpart = part[j];
                            break;
                        }
                        nodeset = XPathCanonicalizer.toNodeset((Node)vpart._object, null, (boolean)false);
                        if (!DOMUtil.includeNodeset(nodeset, part[j]._nodeset)) continue;
                        rpart = part[j];
                        break;
                    }
                    if (isNodeset) {
                        if (part[j]._nodeset == null) {
                            part[j]._nodeset = XPathCanonicalizer.toNodeset((Node)part[j]._element, null, (boolean)false);
                        }
                        if (!DOMUtil.includeNodeset(vpart._nodeset, part[j]._nodeset)) continue;
                        rpart = part[j];
                        break;
                    }
                    if (isNode) {
                        if (VerifiedPartChecker.hasSameUri(part[j]._element, vpart._node) || DOMUtil.equals((Node)part[j]._element, (Node)vpart._node)) {
                            rpart = part[j];
                            break;
                        }
                        decreptedVpart = ResultMessagePool.getElement(context, vpart._node);
                        if (decreptedVpart == null || !VerifiedPartChecker.hasSameUri(part[j]._element, decreptedVpart) && !DOMUtil.equals((Node)part[j]._element, (Node)decreptedVpart)) continue;
                        rpart = part[j];
                        break;
                    }
                    if (VerifiedPartChecker.hasSameUri(part[j]._element, vpart._object) || DOMUtil.equals((Node)part[j]._element, (Node)vpart._object)) {
                        rpart = part[j];
                        break;
                    }
                    decreptedVpart = ResultMessagePool.getElement(context, vpart._object);
                    if (decreptedVpart == null || !VerifiedPartChecker.hasSameUri(part[j]._element, decreptedVpart) && !DOMUtil.equals((Node)part[j]._element, (Node)decreptedVpart)) continue;
                    rpart = part[j];
                    break;
                }
                lastException = sse;
            }
            if (rpart == null) continue;
            lastException = null;
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRelatedPart(VerificationResult vresult,VerifiedPart vpart,Set requiredParts,Map context) retutns RequiredPart[" + rpart + "]"));
        }
        return rpart;
    }

    private static boolean hasSameUri(Element rpart, Element vpart) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("hasSameUri(Element rpart[" + DOMUtil.getDisplayName((Node)rpart) + "]," + "Element vpart[" + DOMUtil.getDisplayName((Node)vpart) + "])"));
        }
        boolean ret = false;
        String ruri = IdUtil.getInstance().getId(rpart);
        String vuri = IdUtil.getInstance().getId(vpart);
        if (ruri != null && ruri.length() > 0 && vuri != null && vuri.length() > 0 && ruri.equals(vuri)) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("hasSameUri(Element rpart,Element vpart) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    private static void checkCaller(VerificationResult vresult, Set rpconfigs, WSSConsumerConfig gconfig, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCaller(VerificationResult vresult[" + vresult + "]," + "Set rpconfigs[" + rpconfigs + "]," + "WSSConsumerConfig gconfig," + "Map context)"));
        }
        Set cconfigs = gconfig.getCallers();
        boolean isOK = true;
        if (cconfigs != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(cconfigs.size() + " Callers found, so start to process it..."));
            }
            if (vresult._token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The token used for signature verification not found...");
                }
            } else {
                boolean trusted = vresult._token.isTrusted();
                for (WSSConsumerConfig.CallerConfig cconfig : cconfigs) {
                    if (!trusted) {
                        QName qn = cconfig.getTokenType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Checking the value type of the caller[" + qn + "]"));
                        }
                        if (qn != null && !qn.equals(vresult._token.getType())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("The value types are different: Caller config[" + qn + "] and verified result[" + vresult._token.getType() + "]"));
                            }
                            isOK = false;
                        }
                        if (isOK) {
                            ReferencePartConfig rpconfig = cconfig.getPart();
                            if (rpconfig == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ReferencePart of Caller Config is null.");
                                }
                            } else if (!rpconfig.isOneOfIntegralParts()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ReferencePart of Caller Config is not integral part.");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Checking the part of Caller config[" + rpconfig + "]"));
                                }
                                if (rpconfigs.contains(rpconfig)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Linked the token[" + vresult._token + "] and the Caller[" + cconfig + "]."));
                                    }
                                    AuthResult aresult = new AuthResult(vresult._token, cconfig);
                                    ResultPool.add((Map)context, (Result)aresult);
                                }
                            }
                        }
                    }
                    isOK = true;
                    WSSConsumerConfig.CallerConfig tmconfig = cconfig.getTrustMethod();
                    if (tmconfig == null || !trusted) continue;
                    QName qn = tmconfig.getTokenType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the value type of the TrustMethod[" + qn + "]"));
                    }
                    if (qn != null && !qn.equals(vresult._token.getType())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The value types are different: TrustMethod Config[" + qn + "] and Verified Result[" + vresult._token.getType() + "]"));
                        }
                        isOK = false;
                    }
                    if (!isOK) continue;
                    ReferencePartConfig rpconfig = tmconfig.getPart();
                    if (rpconfig == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ReferencePart of TrustMethod Config is null.");
                        continue;
                    }
                    if (!rpconfig.isOneOfIntegralParts()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ReferencePart of TrustMethod Config is not integral part.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the ReferencePart config[" + rpconfig + "]"));
                    }
                    if (!rpconfigs.contains(rpconfig)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Linked the token[" + vresult._token + "] and the TrustMethod[" + tmconfig + "]."));
                    }
                    AuthResult aresult = new AuthResult(vresult._token, tmconfig);
                    ResultPool.add((Map)context, (Result)aresult);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(VerificationResult vresult,Set rpconfigs,WSSConsumerConfig gconfig,Map context)");
        }
    }

    private static SoapSecurityException checkBinding(Set bindings, VerificationResult vresult) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkBinding(Set bindings[" + bindings + "]," + "VerificationResult vresult[" + vresult + "])"));
        }
        Throwable lastException = null;
        boolean ret = bindings.contains(vresult._sconfig);
        if (ret) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The configuration of signature consumer used for verification was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The configuration of signature consumer used for verification was NOT found in the bindings.");
            }
            Iterator i = bindings.iterator();
            block0: while (!ret && i.hasNext()) {
                SignatureConsumerConfig sconfig = (SignatureConsumerConfig)i.next();
                Iterator j = sconfig.getReferences().iterator();
                while (!ret && j.hasNext()) {
                    SigningReferenceConfig srconfig = (SigningReferenceConfig)j.next();
                    KeyInfoResult r = (KeyInfoResult)vresult._identities.get(new VerifiedConfig(sconfig, srconfig));
                    if (r == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"There is no keyinfo result corresponding to the SigningReferenceConfig.");
                        continue;
                    }
                    Exception e = r.getError();
                    if (e == null) {
                        Token t;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The keyinfo result has no exception.");
                        }
                        if ((t = (Token)vresult._kresults.get(r)) == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"There is no token corresponding to the keyinfo result.");
                            continue;
                        }
                        if (t.getError() == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("The token [" + t + "] has no exception."));
                            }
                            ret = true;
                            continue block0;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The token [" + t + "] has the exception [" + e.getMessage() + "]."));
                        }
                        lastException = t.getError();
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The keyinfo result has the exception [" + e.getMessage() + "]."));
                    }
                    if (e instanceof SoapSecurityException) {
                        lastException = (SoapSecurityException)e;
                        continue;
                    }
                    lastException = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", e);
                }
            }
            if (ret) {
                lastException = null;
            }
        }
        if (tc.isEntryEnabled()) {
            String exMes = lastException == null ? "null" : lastException.toString();
            Tr.exit((TraceComponent)tc, (String)("checkBinding(Set bindings,VerificationResult vresult) returns SoapSecurityException[" + exMes + "]"));
        }
        return lastException;
    }

    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private Element _element;
        private NodeList _nodeset;
        private Set _tokens;
        private boolean _isNodeset;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private boolean _processed;

        RequiredPart(ReferencePartConfig rconfig, ReferencePartConfig.PartConfig pconfig, Element element) {
            this._rconfig = rconfig;
            this._pconfig = pconfig;
            this._element = element;
            this._nodeset = null;
            this._isNodeset = false;
            this._tokens = new HashSet();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }

        RequiredPart(ReferencePartConfig rconfig, ReferencePartConfig.PartConfig pconfig, NodeList nodeset) {
            this._rconfig = rconfig;
            this._pconfig = pconfig;
            this._element = null;
            this._nodeset = nodeset;
            this._isNodeset = true;
            this._tokens = new HashSet();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;

        RequiredParts(RequiredPart[] parts) {
            this._parts = parts;
        }
    }
}

