/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.websphere.webservices.soap.IBMAttr;
import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.TemplateGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SignatureGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(SignatureGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureGenerator.class.getName();
    private static final String SIGNATURE_PREFIX = "ds";
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        Element c14nElem;
        Element inc;
        NodeList parts;
        SigningReferenceConfig srconfig;
        Map cpSelectorMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        Object obj2 = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj2 != null && obj2 instanceof Integer) {
            wssVersion = (Integer)obj2;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        String pWsse = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s13");
        }
        String ln = parent.getLocalName();
        String ns = parent.getNamespaceURI();
        if (NamespaceUtil.isWsse(ns) != wssVersion || !"Security".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtil.getQualifiedName((Node)parent));
        }
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        SignatureGeneratorConfig config = (SignatureGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.signatureGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SignatureGeneratorConfig [" + config + "]."));
        }
        HashMap type = new HashMap();
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", (Object)this._idResolver);
        selectorMap.put(NonceManager.class, gconfig.getNonceManager());
        if (config.getKeyInfoSignature() != null) {
            selectorMap.put("security.wssecurity.integraldialectelementselector.keysigntype", config.getKeyInfoSignature().getAlgorithm());
        }
        String canonicalizationMethod = config.getCanonicalizationMethod().getAlgorithm();
        String signatureMethod = config.getSignatureMethod().getAlgorithm();
        TemplateGenerator gen = new TemplateGenerator(doc, null, canonicalizationMethod, signatureMethod);
        gen.setPrefix(SIGNATURE_PREFIX);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Examining signing parts.");
        }
        Element root = doc.getDocumentElement();
        boolean signSomething = false;
        boolean signNonce = false;
        HashSet<ReferencePartConfig.PartConfig> nonces1 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> nonces2 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
        HashMap nonces3 = new HashMap();
        boolean signSpecial = false;
        HashSet<ReferencePartConfig.PartConfig> specials1 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> specials2 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
        HashMap specials3 = new HashMap();
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.config", gconfig.getTokenGenerators());
        ArrayList<Element> list = new ArrayList<Element>();
        Iterator i1 = null;
        if (config != null && config.getReferences() != null && config.getReferences().iterator() != null) {
            i1 = config.getReferences().iterator();
        }
        if (i1 != null) {
            while (i1.hasNext()) {
                cpSelectorMap = new HashMap(selectorMap);
                srconfig = (SigningReferenceConfig)i1.next();
                SignatureGenerator.prepareTransform(srconfig, cpSelectorMap);
                ReferencePartConfig rpconfig = srconfig.getReference();
                if (rpconfig == null || rpconfig.getParts() == null || rpconfig.getParts().iterator() == null) continue;
                for (ReferencePartConfig.PartConfig pconfig : rpconfig.getParts()) {
                    if (pconfig.isTimestamp() || pconfig.isNonce()) {
                        signNonce = true;
                        nonces1.add(pconfig);
                        nonces2.put(pconfig, srconfig);
                        nonces3.put(pconfig, cpSelectorMap);
                        continue;
                    }
                    if (Constants.DIALECT_WAS.equals(pconfig.getDialect()) && (IntegralDialectElementSelector.WASDIALECTS[2].equals(pconfig.getKeyword()) || IntegralDialectElementSelector.WASDIALECTS[3].equals(pconfig.getKeyword()))) {
                        signSpecial = true;
                        specials1.add(pconfig);
                        specials2.put(pconfig, srconfig);
                        specials3.put(pconfig, cpSelectorMap);
                        continue;
                    }
                    boolean processed = false;
                    String dialect = pconfig.getDialect();
                    String keyword = pconfig.getKeyword();
                    Document doc2 = doc;
                    int docOrder = -1;
                    while (doc2 != null) {
                        parts = SignatureGenerator.getMessagePart(doc2, dialect, keyword, "signature_mode", this._selectors, IntegralDialectElementSelector.class, cpSelectorMap);
                        if (parts != null && parts.getLength() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                            }
                            for (int j = 0; j < parts.getLength(); ++j) {
                                Element part = (Element)parts.item(j);
                                if (docOrder >= 0) {
                                    Reference ref;
                                    String idname;
                                    RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, part, docOrder);
                                    if (eobj == null) continue;
                                    if (eobj.getEncryptedData() != null) {
                                        idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getEncryptedData(), nsWsu);
                                        ref = gen.createReference(idname);
                                        ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                        SignatureGenerator.addTransforms(ref, doc, eobj.getEncryptedData(), srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                                        gen.addReference(ref);
                                        signSomething = true;
                                        list.add(part);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Added the encrypted data[" + DOMUtil.getDisplayName((Node)eobj.getEncryptedData()) + "] because the element[" + DOMUtil.getDisplayName((Node)part) + "] has already encrypted."));
                                        }
                                    }
                                    if (eobj.getHeaderInfo() == null) continue;
                                    idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getHeaderInfo(), nsWsu);
                                    ref = gen.createReference(idname);
                                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms(ref, doc, eobj.getHeaderInfo(), srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                                    gen.addReference(ref);
                                    signSomething = true;
                                    list.add(part);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("Added the header info[" + DOMUtil.getDisplayName((Node)eobj.getHeaderInfo()) + "] because the element[" + DOMUtil.getDisplayName((Node)part) + "] has already encrypted."));
                                    continue;
                                }
                                String idname = DOMUtil.equals((Node)part, (Node)root) ? "" : "#" + SignatureGenerator.addWsuId(doc, part, nsWsu);
                                Reference ref = gen.createReference(idname);
                                ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms(ref, doc, part, srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                                gen.addReference(ref);
                                signSomething = true;
                                list.add(part);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Added the element[" + DOMUtil.getDisplayName((Node)part) + "]."));
                            }
                            processed = true;
                            break;
                        }
                        doc2 = RequestMessagePool.getDocument(context, ++docOrder);
                    }
                    if (processed) continue;
                    throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
                }
            }
        }
        if (!signSomething && !signSpecial) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
            }
            return;
        }
        boolean addDummy = false;
        if (!signSomething) {
            addDummy = true;
            Reference ref = gen.createReference("#dummy001");
            gen.addReference(ref);
        }
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        AlgorithmConfig aconfig = config.getSignatureMethod();
        Element signature = null;
        try {
            AlgorithmParameterSpec spec = afactory.convertParameter(aconfig.getAlgorithm(), aconfig.getProperties());
            if (spec != null) {
                gen.setSignatureMethodParameter(spec);
            }
            signature = gen.getSignatureElement((AlgorithmFactory)afactory);
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"424");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.SignatureGenerator.s11", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"428");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.SignatureGenerator.s11", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", e);
        }
        catch (NoSuchProviderException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"432");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.SignatureGenerator.s11", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", e);
        }
        if (gconfig.isUserDefinedComponentsUsed()) {
            Element keyInfo = doc.createElementNS(Constants.NS_DSIG, "ds:KeyInfo");
            keyInfo = (Element)signature.appendChild(keyInfo);
        }
        signature = SignatureGenerator.insertElement(parent, signature, nsWsu, context);
        TimestampGeneratorConfig tgconfig = gconfig.getTimestampGenerator();
        if (tgconfig != null && !tgconfig.isDefault()) {
            TimestampGenerator.moveTimestamp(doc, gconfig.getTimestampGenerator(), this._selectors, context);
        }
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", signatureMethod);
        Key key = SignatureGenerator.callKeyInfoGenerator(config.getSigningKeyInfo(), "SigningKey", type, this._selectors, doc, signature, context);
        Element sinfo = DOMUtil.getOneChildElement((Element)signature, (String)Constants.NS_DSIG, (String)"SignedInfo");
        if (config.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(canonicalizationMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(canonicalizationMethod)) && (inc = SignatureGenerator.createInclusiveNamespaces(doc, c14nElem = DOMUtil.getOneChildElement((Element)sinfo, (String)Constants.NS_DSIG, (String)"CanonicalizationMethod"))) != null) {
            c14nElem.appendChild(inc);
        }
        if (addDummy) {
            Element reference = DOMUtil.getOneChildElement((Element)sinfo, (String)Constants.NS_DSIG, (String)"Reference");
            sinfo.removeChild(reference);
        }
        if (signSpecial) {
            for (ReferencePartConfig.PartConfig pconfig : specials1) {
                srconfig = (SigningReferenceConfig)specials2.get(pconfig);
                cpSelectorMap = (Map)specials3.get(pconfig);
                boolean processed = false;
                String dialect = pconfig.getDialect();
                String keyword = pconfig.getKeyword();
                Document doc2 = doc;
                int docOrder = -1;
                while (doc2 != null) {
                    parts = SignatureGenerator.getSpecialPart(doc2, pconfig, "signature_mode", this._selectors, cpSelectorMap);
                    if (parts != null && parts.getLength() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                        }
                        for (int j = 0; j < parts.getLength(); ++j) {
                            Element part = (Element)parts.item(j);
                            if (docOrder >= 0) {
                                Reference ref;
                                String idname;
                                RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, part, docOrder);
                                if (eobj == null) continue;
                                if (eobj.getEncryptedData() != null) {
                                    idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getEncryptedData(), nsWsu);
                                    ref = gen.createReference(idname);
                                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms(ref, doc, eobj.getEncryptedData(), srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                                    sinfo.appendChild(ref.getReferenceElement());
                                    list.add(part);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Added the encrypted data[" + DOMUtil.getDisplayName((Node)eobj.getEncryptedData()) + "] because the element[" + DOMUtil.getDisplayName((Node)part) + "] has already encrypted."));
                                    }
                                }
                                if (eobj.getHeaderInfo() == null) continue;
                                idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getHeaderInfo(), nsWsu);
                                ref = gen.createReference(idname);
                                ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms(ref, doc, eobj.getHeaderInfo(), srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                                sinfo.appendChild(ref.getReferenceElement());
                                list.add(part);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Added the header info[" + DOMUtil.getDisplayName((Node)eobj.getHeaderInfo()) + "] because the element[" + DOMUtil.getDisplayName((Node)part) + "] has already encrypted."));
                                continue;
                            }
                            String idname = DOMUtil.equals((Node)part, (Node)root) ? "" : "#" + SignatureGenerator.addWsuId(doc, part, nsWsu);
                            Reference ref = gen.createReference(idname);
                            ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                            SignatureGenerator.addTransforms(ref, doc, part, srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                            sinfo.appendChild(ref.getReferenceElement());
                            list.add(part);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Added the element[" + DOMUtil.getDisplayName((Node)part) + "]."));
                        }
                        processed = true;
                        break;
                    }
                    doc2 = RequestMessagePool.getDocument(context, ++docOrder);
                }
                if (processed) continue;
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", dialect, keyword);
            }
        }
        if (signNonce) {
            Object[] objs = list.toArray();
            for (ReferencePartConfig.PartConfig pconfig : nonces1) {
                srconfig = (SigningReferenceConfig)nonces2.get(pconfig);
                cpSelectorMap = (Map)nonces3.get(pconfig);
                parts = SignatureGenerator.getNoncePart(doc, objs, pconfig, "signature_mode", this._selectors, IntegralDialectElementSelector.class, cpSelectorMap);
                if (parts == null || parts.getLength() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(parts.getLength() + " parts found."));
                }
                for (int j = 0; j < parts.getLength(); ++j) {
                    Element part = (Element)parts.item(j);
                    String idname = DOMUtil.equals((Node)part, (Node)root) ? "" : "#" + SignatureGenerator.addWsuId(doc, part, nsWsu);
                    Reference ref = gen.createReference(idname);
                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                    SignatureGenerator.addTransforms(ref, doc, part, srconfig.getTransforms(), pWsse, nsWsse, config.addInclusiveNamespaces());
                    sinfo.appendChild(ref.getReferenceElement());
                    list.add(part);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the element[" + DOMUtil.getDisplayName((Node)part) + "]."));
                }
            }
        }
        if (gconfig.doIndentation()) {
            DOMUtil.indent(signature, 6, 2);
            parent.insertBefore(doc.createTextNode("\n      "), signature);
        }
        WSSSignatureContext scontext = new WSSSignatureContext();
        if (tc.isDebugEnabled()) {
            scontext.setResourceShower(ShowerImpl.getInstance());
        }
        scontext.setIDResolver((IDResolver)this._idResolver);
        scontext.setAlgorithmFactory(afactory);
        scontext.setDocument(doc);
        if (config.getKeyInfoSignature() != null) {
            scontext.setKeyInfoSignature(config.getKeyInfoSignature().getAlgorithm());
        } else {
            scontext.setKeyInfoSignature(null);
        }
        HashSet<KeyInfoGeneratorConfig> dsigKConfig = new HashSet<KeyInfoGeneratorConfig>();
        HashSet<KeyInfoGeneratorConfig> encKConfig = new HashSet<KeyInfoGeneratorConfig>();
        for (Object obj2 : gconfig.getOperationGenerators()) {
            if (obj2 instanceof SignatureGeneratorConfig) {
                dsigKConfig.add(((SignatureGeneratorConfig)obj2).getSigningKeyInfo());
                continue;
            }
            if (!(obj2 instanceof EncryptionGeneratorConfig)) continue;
            encKConfig.add(((EncryptionGeneratorConfig)obj2).getEncryptionKeyInfo());
        }
        STRDTKeyInfoResolver skiResolver = new STRDTKeyInfoResolver();
        skiResolver.setContext(context);
        skiResolver.setSelectors(this._selectors);
        skiResolver.setDsigKeyInfoSet(dsigKConfig);
        skiResolver.setEncKeyInfoSet(encKConfig);
        skiResolver.setGeneration(true);
        skiResolver.setIdResolver((IDResolver)this._idResolver);
        scontext.setSTRDTKeyInfoResolver(skiResolver);
        String sigAlgorithm = null;
        AlgorithmConfig sigMethod = config.getSignatureMethod();
        if (sigMethod != null) {
            sigAlgorithm = sigMethod.getAlgorithm();
        }
        scontext.setSigAlgorithm(sigAlgorithm);
        Map props = config.getProperties();
        Map gprops = gconfig.getProperties();
        String hwAcceleration = null;
        hwAcceleration = (String)gprops.get("HWCONFIG");
        scontext.setHWConfigName(hwAcceleration);
        scontext.setOffload(Boolean.TRUE);
        if (scontext.shouldChangeProvider()) {
            Provider p1;
            HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Acceleration enabled, Key Store Name is: ", (Object)scontext.getHWConfigName());
            }
            if ((p1 = ConfigUtil.getHWCryptoProviderInstance((String)scontext.getHWConfigName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                scontext.setHWAccelerationProvider(p1);
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                fHWKeyCache.setProvider(p1, hardwareCacheSize);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for HW Acceleration" + p1.getName()));
                }
            }
            try {
                key = fHWKeyCache.translate(key);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e);
            }
        }
        String hwKsRef = null;
        hwKsRef = (String)props.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("hwKsRef = " + hwKsRef));
        }
        scontext.setHWKeyStoreName(hwKsRef);
        if (scontext.useHWKeyStore()) {
            Provider p2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)scontext.getHWKeyStoreName());
            }
            if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)scontext.getHWKeyStoreName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                scontext.setHWKeyStoreProvider(p2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                }
            }
        }
        String defaultHWKSRef = null;
        if (!(!(key instanceof PKCS11Key) || hwAcceleration != null && hwAcceleration.length() != 0 || hwKsRef != null && hwKsRef.length() != 0)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
            }
            if ((defaultHWKSRef = (String)gprops.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                scontext.setHWKeyStoreName(defaultHWKSRef);
                if (scontext.useHWKeyStore()) {
                    Provider p2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)scontext.getHWKeyStoreName());
                    }
                    if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)scontext.getHWKeyStoreName())) == null) {
                        Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                    } else {
                        scontext.setHWKeyStoreProvider(p2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                        }
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for sign/verify");
                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Signing started.");
        }
        try {
            scontext.sign(signature, key);
        }
        catch (XSignatureException e) {
            Exception ex = e.getException();
            Tr.processException((Throwable)ex, (String)(clsName + ".invoke"), (String)"711");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.SignatureGenerator.s12", (Object)ex);
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s12", ex);
        }
        finally {
            if (scontext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance((String)scontext.getHWConfigName(), (Provider)scontext.getHWAccelerationProvider());
            }
            if (scontext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance((String)scontext.getHWKeyStoreName(), (Provider)scontext.getHWKeyStoreProvider());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Signing done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    public static NodeList getMessagePart(Document doc, String dialect, String keyword, String type, Map selectors, Class dialectSelector, Map selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMessagePart(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "]," + "String type[" + type + "]," + "Map selectors," + "Class dialectSelector[" + dialectSelector + "]," + "Map selectorMap)"));
        }
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", type);
        ElementSelector esel = null;
        if (Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(dialectSelector);
        } else if (Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        NodeList list = esel.getElements(doc, selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMessagePart(Document doc,String dialect,String keyword,String type,Map selectors,Class dialectSelector,Map selectorMap,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static NodeList getSpecialPart(Document doc, ReferencePartConfig.PartConfig pconfig, String type, Map selectors, Map selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSpecialPart(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "PartConfig pconfig[" + pconfig + "]," + "String type[" + type + "]," + "Map selectors," + "Map selectorMap)"));
        }
        String dialect = pconfig.getDialect();
        String keyword = pconfig.getKeyword();
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", type);
        ElementSelector esel = (ElementSelector)selectors.get(IntegralDialectElementSelector.class);
        NodeList list = esel.getElements(doc, selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSpecialPart(Document doc,PartConfig pconfig,String type,Map selectors,Map selectorMap) returns NodeList[" + list + "]"));
        }
        return list;
    }

    public static NodeList getNoncePart(Document doc, Object[] parents, ReferencePartConfig.PartConfig pconfig, String type, Map selectors, Class dialectSelector, Map selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNoncePart(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Object[] parents[" + parents + "]," + "PartConfig pconfig[" + pconfig + "]," + "String type[" + type + "]," + "Map selectors," + "Class dialectSelector[" + dialectSelector + "]," + "Map selectorMap)"));
        }
        String dialect = pconfig.getDialect();
        String keyword = pconfig.getKeyword();
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", type);
        if (parents != null) {
            selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.element", parents);
        }
        selectorMap.remove("security.wssecurity.integraldialectelementselector.duration");
        if (pconfig.isTimestamp()) {
            selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.processType", "timestamp");
            Duration obj = pconfig.getDuration();
            if (obj != null) {
                selectorMap.put("security.wssecurity.integraldialectelementselector.duration", obj);
            }
        } else if (pconfig.isNonce()) {
            selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.processType", "nonce");
        }
        NodeList list = null;
        ElementSelector esel = null;
        if (Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(dialectSelector);
        } else if (Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        list = esel.getElements(doc, selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNoncePart(Document doc,Object[] parents,PartConfig pconfig,String typeMap selectors,Class dialectSelector,Map selectorMap) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static String addWsuId(Document doc, Element part, String nsWsu) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addWsuId(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element part[" + DOMUtil.getDisplayName((Node)part) + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        String idname = null;
        String attrname = IdUtil.getInstance().getIdAttributeName(part);
        if (attrname != null) {
            idname = part.getAttribute(attrname);
        }
        if (idname == null || idname.length() == 0) {
            String ns = part.getNamespaceURI();
            String ln = part.getLocalName();
            int nsHash = ns == null ? 0 : ns.hashCode();
            int hash = nsHash * 31;
            hash += ln == null ? 0 : ln.hashCode();
            if (nsHash == Constants.HASH_DS) {
                if (hash == Constants.HASH_DS_SIGNATURE || hash == Constants.HASH_DS_SIGNATUREVALUE || hash == Constants.HASH_DS_SIGNEDINFO || hash == Constants.HASH_DS_REFERENCE || hash == Constants.HASH_DS_KEYINFO || hash == Constants.HASH_DS_OBJECT || hash == Constants.HASH_DS_MANIFEST || hash == Constants.HASH_DS_SIGNATUREPROPS || hash == Constants.HASH_DS_SIGNATUREPROP) {
                    idname = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_signature_id_");
                    part.setAttribute("Id", idname);
                }
            } else if (nsHash == Constants.HASH_ENC && (hash == Constants.HASH_ENC_ENCRYPTEDKEY || hash == Constants.HASH_ENC_ENCRYPTEDDATA || hash == Constants.HASH_ENC_ENCRYPTIONPROPS || hash == Constants.HASH_ENC_ENCRYPTIONPROP)) {
                idname = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_signature_id_");
                part.setAttribute("Id", idname);
            }
            if (idname == null) {
                idname = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_signature_id_");
                String prefix = DOMUtil.getNamespacePrefix((Element)part, (String)nsWsu);
                if (prefix == null) {
                    prefix = "wsu";
                }
                part.setAttributeNS(nsWsu, prefix + ":Id", idname);
                part.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsWsu);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addWsuId(Document doc,Element part,String nsWsu) returns String[" + idname + "]"));
        }
        return idname;
    }

    private static void addTransforms(Reference ref, Document doc, Element part, List config, String pWsse, String nsWsse, boolean addIncNS) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addTransforms(Reference gen[" + ref + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element part[" + DOMUtil.getDisplayName((Node)part) + "]," + "List config[" + config + "]," + "String pWsse[" + pWsse + "]," + "String nsWsse[" + nsWsse + "]," + "boolean addIncNS[" + addIncNS + "])"));
        }
        for (AlgorithmConfig aconfig : config) {
            String transform = aconfig.getAlgorithm();
            Map properties = aconfig.getProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding the transform [" + transform + "]..."));
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(transform)) {
                ref.addTransform(SignatureGenerator.createInclusiveTransform(doc, part, transform, addIncNS));
                continue;
            }
            if ("http://www.w3.org/2002/07/decrypt#XML".equals(transform)) {
                Set ids = SignatureGenerator.collectIdsOfEncryptedData(part, doc);
                ref.addTransform(SignatureGenerator.createDecryptionTransform(doc, ids, transform));
                continue;
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transform)) {
                ref.addTransform(SignatureGenerator.createSTRTransform(doc, part, transform, pWsse, nsWsse));
                continue;
            }
            if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(transform)) {
                ref.addTransform(SignatureGenerator.createXPathTransform(doc, transform, properties));
                continue;
            }
            if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(transform)) {
                ref.addTransform(SignatureGenerator.createXPath2Transform(doc, transform, properties));
                continue;
            }
            ref.addTransform(transform);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTransforms(Reference gen,Document doc,Element part,List config,String pWsse,String nsWsse,boolean addIncNS)");
        }
    }

    private static Element createInclusiveTransform(Document doc, Element part, String transform, boolean addIncNS) {
        Element inc;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createInclusiveTransform(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element part[" + DOMUtil.getDisplayName((Node)part) + "]," + "String transform[" + transform + "]," + "boolean addIncNS[" + addIncNS + "])"));
        }
        Element tr = doc.createElementNS(Constants.NS_DSIG, "ds:Transform");
        tr.setAttributeNS(null, "Algorithm", transform);
        if (addIncNS && (inc = SignatureGenerator.createInclusiveNamespaces(doc, part)) != null) {
            tr.appendChild(inc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createInclusiveTransform(Document doc,Element part,String transform,boolean addIncNS) returns Element[" + DOMUtil.getDisplayName((Node)tr) + "]"));
        }
        return tr;
    }

    private static Element createInclusiveNamespaces(Document doc, Element part) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createInclusiveNamespaces(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element part[" + DOMUtil.getDisplayName((Node)part) + "])"));
        }
        StringBuffer buffer = null;
        if (part != null && part instanceof IBMSOAPElement) {
            List nsList = ((IBMSOAPElement)((Object)part)).getNamespaceDeclarations(true, true, true);
            if (nsList != null) {
                TreeSet<String> prefixSet = new TreeSet<String>();
                buffer = new StringBuffer();
                ListIterator nsListIter = nsList.listIterator();
                String localName = null;
                IBMAttr attr = null;
                while (nsListIter.hasNext()) {
                    attr = (IBMAttr)nsListIter.next();
                    if (attr.getNodeName().equals("xmlns")) {
                        prefixSet.add("#default ");
                        continue;
                    }
                    localName = attr.getLocalName();
                    if (localName == null) continue;
                    prefixSet.add(localName + " ");
                }
                for (String prefix : prefixSet) {
                    buffer.append(prefix);
                }
            }
        } else {
            HashSet<String> prefixes = new HashSet<String>();
            for (Node cur = part; cur != null && cur.getNodeType() == 1; cur = cur.getParentNode()) {
                if (!cur.hasAttributes()) continue;
                NamedNodeMap map = cur.getAttributes();
                int len = map.getLength();
                for (int i = 0; i < len; ++i) {
                    String attrn = map.item(i).getNodeName();
                    if (attrn.equals("xmlns")) {
                        prefixes.add("#default");
                        continue;
                    }
                    if (!attrn.startsWith("xmlns:")) continue;
                    prefixes.add(attrn.substring(6));
                }
            }
            SignatureGenerator.scanNamespaceDecls(part, prefixes);
            if (prefixes.size() > 0) {
                buffer = new StringBuffer();
                Iterator iter = prefixes.iterator();
                while (iter.hasNext()) {
                    buffer.append(iter.next());
                    buffer.append(" ");
                }
            }
        }
        Element inc = null;
        if (buffer != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("node search generated PrefixList: " + buffer));
            }
            inc = doc.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
            inc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
            inc.setAttributeNS(null, "PrefixList", new String(buffer));
        } else if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"node search generated an empty list");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createInclusiveNamespaces(Document doc,Element part) returns Element[" + DOMUtil.getDisplayName((Node)inc) + "]"));
        }
        return inc;
    }

    private static void scanNamespaceDecls(Node node, Set prefixes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("scanNamespaceDecls(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Set prefixes[" + prefixes + "])"));
        }
        if (node.hasAttributes()) {
            NamedNodeMap map = node.getAttributes();
            int len = map.getLength();
            for (int i = 0; i < len; ++i) {
                String attrn = map.item(i).getNodeName();
                if (attrn.equals("xmlns")) {
                    prefixes.add("#default");
                    continue;
                }
                if (!attrn.startsWith("xmlns:")) continue;
                prefixes.add(attrn.substring(6));
            }
        }
        if (node.hasChildNodes()) {
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                SignatureGenerator.scanNamespaceDecls(n, prefixes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"scanNamespaceDecls(Node node,Set prefixes)");
        }
    }

    private static Set collectIdsOfEncryptedData(Node node, Document doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("collectIdsOfEncryptedData(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "])"));
        }
        HashSet ids = new HashSet();
        if (node != null) {
            Document d = doc;
            if (d == null) {
                d = node.getOwnerDocument();
            }
            SignatureGenerator.collectIdsOfEncryptedData(node, d, ids);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("collectIdsOfEncryptedData(Node node,Document doc) returns Set[" + ids + "]"));
        }
        return ids;
    }

    private static void collectIdsOfEncryptedData(Node node, Document doc, Set ids) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("collectIdsOfEncryptedData(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Set ids[" + ids + "])"));
        }
        if (node.getNodeType() == 1 && EncryptedData.isOfType((Element)((Element)node))) {
            String id;
            Element ed = (Element)node;
            if (ed.hasAttribute("Id")) {
                id = ed.getAttribute("Id");
            } else {
                id = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_encryption_id_");
                ed.setAttribute("Id", id);
            }
            ids.add(id);
        } else {
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 && n.getNodeType() != 5) continue;
                SignatureGenerator.collectIdsOfEncryptedData(n, doc, ids);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"collectIdsOfEncryptedData(Node node,Document doc,Set ids)");
        }
    }

    private static Element createDecryptionTransform(Document doc, Set ids, String transform) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDecryptionTransform(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Set ids[" + ids + "]," + "String transform[" + transform + "])"));
        }
        Element tr = doc.createElementNS(Constants.NS_DSIG, "ds:Transform");
        tr.setAttribute("Algorithm", transform);
        for (String id : ids) {
            Element ex = doc.createElementNS("http://www.w3.org/2002/07/decrypt#", "Except");
            ex.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2002/07/decrypt#");
            ex.setAttribute("URI", "#" + id);
            tr.appendChild(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDecryptionTransform(Document doc,Set ids) returns Element[" + DOMUtil.getDisplayName((Node)tr) + "]"));
        }
        return tr;
    }

    private static Element createSTRTransform(Document doc, Element part, String transform, String pWsse, String nsWsse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createSTRTransform(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element part[" + DOMUtil.getDisplayName((Node)part) + "]," + "String transform[" + transform + "]," + "String pWsse[" + pWsse + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        HashSet<String> prefixes = new HashSet<String>();
        for (Node cur = part; cur != null && cur.getNodeType() == 1; cur = cur.getParentNode()) {
            NamedNodeMap map = cur.getAttributes();
            int len = map == null ? 0 : map.getLength();
            for (int i = 0; i < len; ++i) {
                String attrn = map.item(i).getNodeName();
                if (attrn.equals("xmlns")) {
                    prefixes.add("#default");
                    continue;
                }
                if (!attrn.startsWith("xmlns:")) continue;
                prefixes.add(attrn.substring(6));
            }
        }
        SignatureGenerator.scanNamespaceDecls(part, prefixes);
        Element tr = doc.createElementNS(Constants.NS_DSIG, "ds:Transform");
        tr.setAttributeNS(null, "Algorithm", transform);
        boolean addNsDecl = false;
        String prefix = pWsse;
        if (prefix == null) {
            prefix = "wsse:";
            addNsDecl = true;
        } else if (!"".equals(prefix)) {
            prefix = prefix + ":";
        }
        Element tp = doc.createElementNS(nsWsse, prefix + "TransformationParameters");
        if (addNsDecl) {
            tp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        tp = (Element)tr.appendChild(tp);
        Element cm = doc.createElementNS(Constants.NS_DSIG, "ds:CanonicalizationMethod");
        cm.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        cm = (Element)tp.appendChild(cm);
        if (prefixes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = prefixes.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                buffer.append(" ");
            }
            Element inc = doc.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
            inc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
            inc.setAttributeNS(null, "PrefixList", new String(buffer));
            cm.appendChild(inc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createSTRTransform(Document doc,Element part,String transform,String pWsse,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)tr) + "]"));
        }
        return tr;
    }

    private static Element createXPathTransform(Document doc, String transform, Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createXPathTransform(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String transform[" + transform + "]," + "Map properties)"));
        }
        String value = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH_EXPRESSION);
        Element tr = doc.createElementNS(Constants.NS_DSIG, "ds:Transform");
        tr.setAttributeNS(null, "Algorithm", transform);
        Element xpath = doc.createElementNS(Constants.NS_DSIG, "ds:XPath");
        xpath = (Element)tr.appendChild(xpath);
        Text expression = doc.createTextNode(value);
        xpath.appendChild(expression);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createXPathTransform(Document doc,String transform,Map properties) returns Element[" + DOMUtil.getDisplayName((Node)tr) + "]"));
        }
        return tr;
    }

    private static Element createXPath2Transform(Document doc, String transform, Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createXPath2Transform(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String transform[" + transform + "]," + "Map properties)"));
        }
        Element tr = doc.createElementNS(Constants.NS_DSIG, "ds:Transform");
        tr.setAttributeNS(null, "Algorithm", transform);
        HashMap<String, Integer> id2Order = new HashMap<String, Integer>();
        HashMap<String, String> id2Filter = new HashMap<String, String>();
        HashMap<String, String> id2Expression = new HashMap<String, String>();
        String orderStr = com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH2_ORDER + "_";
        String filterStr = com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH2_FILTER + "_";
        String expressionStr = com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH2_EXPRESSION + "_";
        for (String name : properties.keySet()) {
            String value = (String)properties.get(name);
            if (name.startsWith(expressionStr)) {
                id2Expression.put(name.substring(expressionStr.length()), value);
                continue;
            }
            if (name.startsWith(filterStr)) {
                id2Filter.put(name.substring(filterStr.length()), value);
                continue;
            }
            if (!name.startsWith(orderStr)) continue;
            id2Order.put(name.substring(orderStr.length()), new Integer(value));
        }
        int size = id2Order.keySet().size();
        if (size > 0) {
            String[] ids = new String[size];
            int[] orders = new int[size];
            int pos = -1;
            Iterator i = id2Order.keySet().iterator();
            while (i.hasNext()) {
                ++pos;
                String id = (String)i.next();
                int order = (Integer)id2Order.get(id);
                boolean inserted = false;
                for (int j = 0; j < pos; ++j) {
                    if (order >= orders[j]) continue;
                    for (int k = pos - 1; k >= j; --k) {
                        ids[k + 1] = ids[k];
                        orders[k + 1] = orders[k];
                    }
                    ids[j] = id;
                    orders[j] = order;
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                ids[pos] = id;
                orders[pos] = order;
            }
            for (int i2 = 0; i2 < ids.length; ++i2) {
                String filter = (String)id2Filter.get(ids[i2]);
                String expression = (String)id2Expression.get(ids[i2]);
                Element xpath = doc.createElementNS("http://www.w3.org/2002/06/xmldsig-filter2", "dsf2:XPath");
                xpath.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsf2", "http://www.w3.org/2002/06/xmldsig-filter2");
                xpath.setAttribute("Filter", filter);
                xpath = (Element)tr.appendChild(xpath);
                Text text = doc.createTextNode(expression);
                xpath.appendChild(text);
                tr.appendChild(xpath);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createXPathTransform(Document doc,String transform,Map properties) returns Element[" + DOMUtil.getDisplayName((Node)tr) + "]"));
        }
        return tr;
    }

    protected static void prepareTransform(SigningReferenceConfig srconfig, Map selectorMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareTransform(SigningReferenceConfig srconfig],Map selectorMap)");
        }
        boolean existSTRTransform = false;
        for (AlgorithmConfig aconfig : srconfig.getTransforms()) {
            String transform = aconfig.getAlgorithm();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transform)) continue;
            existSTRTransform = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"STR-Transform transform found.");
        }
        if (existSTRTransform) {
            selectorMap.put("security.wssecurity.integraldialectelementselector.existstrtransform", Boolean.toString(existSTRTransform));
        } else {
            selectorMap.remove("security.wssecurity.integraldialectelementselector.existstrtransform");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareTransform(SigningReferenceConfig srconfig,Map selectorMap)");
        }
    }

    public static Key callKeyInfoGenerator(KeyInfoGeneratorConfig config, String keytype, Map type, Map properties, Document doc, Element parent, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype[" + keytype + "]," + "Map type," + "Map properties," + "Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        KeyInfoGenerator gen = (KeyInfoGenerator)properties.get(KeyInfoGenerator.class);
        type.clear();
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, keytype);
        context.put("com.ibm.wsspi.wssecurity.config.keyinfoGenerator.configKey", config);
        Key key = gen.getKey(doc, parent, type, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype,Map type,Map properties,Document doc,Element parent,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    public static Element insertElement(Element parent, Element elem, String nsWsu, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("insertElement(Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)"));
        }
        Set set = (Set)context.get("com.ibm.ws.webservices.wssecurity.constants.standAloneElements");
        String lnSign = "Signature";
        String lnEncKey = "EncryptedKey";
        String lnRefList = "ReferenceList";
        Node nextElem = null;
        Node lastElem = null;
        if (parent != null) {
            Element el = DOMUtil.getFirstElement((Node)parent);
            while (el != null) {
                lastElem = el;
                if (set != null && set.contains(el)) {
                    nextElem = el;
                    break;
                }
                String ns = el.getNamespaceURI();
                String ln = el.getLocalName();
                if (Constants.NS_ENC.equals(ns) && (lnEncKey.equals(ln) || lnRefList.equals(ln)) || Constants.NS_DSIG.equals(ns) && lnSign.equals(ln)) {
                    nextElem = el;
                    break;
                }
                el = DOMUtil.getNextElement((Node)el);
            }
        }
        if (nextElem == null && lastElem != null) {
            String ns = lastElem.getNamespaceURI();
            String ln = lastElem.getLocalName();
            if (nsWsu.equals(ns) && ln.equals("Timestamp")) {
                nextElem = lastElem;
            }
        }
        elem = lastElem == null ? (Element)parent.appendChild(elem) : (Element)parent.insertBefore(elem, nextElem);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("insertElement(Element parent,Element elem,String nsWsu,Map context) returns Element[" + DOMUtil.getDisplayName((Node)elem) + "]"));
        }
        return elem;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element owner, int count, String uri, String type, byte[] content, String encoding) {
            String dumpData = null;
            try {
                dumpData = encoding == null ? new String(content, "UTF-8") : new String(content, encoding);
            }
            catch (Exception e) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: An exception occured while the content is encoded with [" + encoding + "]."));
            }
            if (count < 0) {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs sign-SignedInfo: " + dumpData));
            } else if (uri == null || uri.length() == 0) {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs sign-resource_" + count + ": " + dumpData));
            } else {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs sign-" + uri + ": " + dumpData));
            }
        }
    }
}

