/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.dsig.VerificationResult;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.util.SameDocumentEncryptedKeyRetriever;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.Provider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(SignatureConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureConsumer.class.getName();
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        int hash = 0;
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11");
        }
        String ns = target.getNamespaceURI();
        String ln = target.getLocalName();
        hash = ns == null ? 0 : ns.hashCode() * 31;
        if (target.getNodeType() != 1 || (hash += ln == null ? 0 : ln.hashCode()) != Constants.HASH_DS_SIGNATURE) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)target));
        }
        Element signature = (Element)target;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        obj = context.remove("com.ibm.ws.webservices.wssecurity.constants.copiedDOMTree");
        boolean domRequired = ConfigUtil.isTrue((String)((String)obj));
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        SignatureConsumerConfig config = (SignatureConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.signatureConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SignatureConsumerConfig [" + config + "]."));
        }
        Document doc = signature.getOwnerDocument();
        VerificationResult vresult = SignatureConsumer.checkSignature(doc, signature, gconfig, config, (IDResolver)this._idResolver, nsWsse, nsWsu, domRequired, context);
        if (vresult._domRequired) {
            doc = vresult._copiedDOM;
            NodeList list = DOMUtil.getOneOrMoreElements((Element)doc.getDocumentElement(), (String)Constants.NS_DSIG, (String)"Signature");
            for (int i = 0; i < list.getLength(); ++i) {
                if (!DOMUtil.equals((Node)signature, (Node)list.item(i))) continue;
                signature = (Element)list.item(i);
                break;
            }
        }
        HashMap type = new HashMap();
        Key key = SignatureConsumer.callKeyInfoConsumer(config.getSigningKeyInfo(), "VerifyingKey", type, this._selectors, KeyInfo.searchForKeyInfo((Element)signature), context);
        SignatureConsumer.verify(signature, key, gconfig, config, (IDResolver)this._idResolver, doc, vresult, this._selectors, context);
        SignatureConsumer.setVerificationResult(vresult, config, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static VerificationResult checkSignature(Document doc, Element signature, WSSConsumerConfig gconfig, SignatureConsumerConfig config, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkSignature(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element signature[" + DOMUtil.getDisplayName((Node)signature) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "Map context)"));
        }
        VerificationResult vresult = new VerificationResult(config);
        int hash = 0;
        Element el = DOMUtil.getFirstElement((Node)signature);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_SIGNEDINFO) {
                SignatureConsumer.checkSignedInfo(doc, el, gconfig, config, vresult, idResolver, nsWsse, nsWsu, domRequired, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_DS_KEYINFO || hash == Constants.HASH_DS_SIGNATUREVALUE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_DS_OBJECT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK. But this consumer ignores it."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + DOMUtil.getQualifiedName((Node)el) + " in the " + DOMUtil.getQualifiedName((Node)signature) + " element."));
            }
            el = DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkSignature(Document doc,Element signature,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context) returns VerificationResult[" + vresult + "]"));
        }
        return vresult;
    }

    private static void checkSignedInfo(Document doc, Element sinfo, WSSConsumerConfig gconfig, SignatureConsumerConfig config, VerificationResult vresult, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkSignedInfo(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element sinfo[" + DOMUtil.getDisplayName((Node)sinfo) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "VerificationResult vresult[" + vresult + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "Map context)"));
        }
        int hash = 0;
        Element el = DOMUtil.getFirstElement((Node)sinfo);
        while (el != null) {
            String algorithm2;
            String algorithm1;
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_C14NMETHOD) {
                algorithm1 = DOMUtil.getAttribute((Element)el, (String)"Algorithm");
                algorithm2 = null;
                if (config.getCanonicalizationMethod() != null) {
                    algorithm2 = config.getCanonicalizationMethod().getAlgorithm();
                }
                if (algorithm2 == null || !algorithm2.equals(algorithm1) || !gconfig.getAllowedCanonicalizationMethods().contains(algorithm1)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s08", algorithm1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " [" + algorithm1 + "] is OK."));
                }
            } else if (hash == Constants.HASH_DS_SIGNATUREMETHOD) {
                algorithm1 = DOMUtil.getAttribute((Element)el, (String)"Algorithm");
                algorithm2 = null;
                if (config.getSignatureMethod() != null) {
                    algorithm2 = config.getSignatureMethod().getAlgorithm();
                }
                if (algorithm2 == null || !algorithm2.equals(algorithm1) || !gconfig.getAllowedSignatureMethods().contains(algorithm1)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s09", algorithm1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " [" + algorithm1 + "] is OK."));
                }
            } else if (hash == Constants.HASH_DS_REFERENCE) {
                SignatureConsumer.checkReference(doc, el, gconfig, config.getReferences(), vresult, idResolver, nsWsse, nsWsu, domRequired, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + DOMUtil.getQualifiedName((Node)el) + " in the " + DOMUtil.getQualifiedName((Node)sinfo) + " element."));
            }
            el = DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkSignedInfo(Document doc,Element sinfo,WSSConsumerConfig gconfig,SignatureConsumerConfig config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkReference(Document doc, Element reference, WSSConsumerConfig gconfig, List config, VerificationResult vresult, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkReference(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element reference[" + DOMUtil.getDisplayName((Node)reference) + "]," + "WSSConsumerConfig gconfig," + "List config," + "VerificationResult vresult[" + vresult + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "Map context)"));
        }
        boolean succeeded = false;
        Exception[] exceptions2 = new Exception[config.size()];
        int exPos = 0;
        int jFirst = 0;
        Iterator i = config.iterator();
        while (i.hasNext()) {
            try {
                SigningReferenceConfig srconfig = (SigningReferenceConfig)i.next();
                jFirst = vresult._verifiedParts.size() - 1;
                SignatureConsumer.checkReference(doc, reference, gconfig, srconfig, vresult, idResolver, nsWsse, nsWsu, domRequired, context);
                vresult._srconfig = srconfig;
                succeeded = true;
                break;
            }
            catch (Exception e) {
                exceptions2[exPos++] = e;
                for (int j = vresult._verifiedParts.size() - 1; j > jFirst; --j) {
                    vresult._verifiedParts.remove(j);
                }
            }
        }
        if (!succeeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(exPos + " exceptions were catched."));
                for (int j = 0; j < exPos; ++j) {
                    Tr.debug((TraceComponent)tc, (String)("No." + i + "'s exception: " + exceptions2[j]));
                }
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s12", exceptions2[exPos - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,List config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkReference(Document doc, Element reference, WSSConsumerConfig gconfig, SigningReferenceConfig config, VerificationResult vresult, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, Map context) throws SoapSecurityException {
        Element nonce;
        Element timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkReference(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element reference[" + DOMUtil.getDisplayName((Node)reference) + "]," + "WSSConsumerConfig gconfig," + "SigningReferenceConfig config," + "VerificationResult vresult[" + vresult + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "Map context)"));
        }
        boolean noncefirst = false;
        int hash = 0;
        Element object = null;
        VerificationResult.VerifiedPart part = new VerificationResult.VerifiedPart();
        Element el = DOMUtil.getFirstElement((Node)reference);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_TRANSFORMS) {
                SignatureConsumer.checkTransforms(el, gconfig, config.getTransforms(), part, domRequired, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_DS_DIGESTMETHOD) {
                String algorithm1 = DOMUtil.getAttribute((Element)el, (String)"Algorithm");
                String algorithm2 = null;
                if (config.getDigestMethod() != null) {
                    algorithm2 = config.getDigestMethod().getAlgorithm();
                }
                if (algorithm2 == null || !algorithm2.equals(algorithm1) || !gconfig.getAllowedDigestMethods().contains(algorithm1)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s11", algorithm1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " [" + algorithm1 + "] is OK."));
                }
            } else if (hash == Constants.HASH_DS_DIGESTVALUE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + DOMUtil.getQualifiedName((Node)el) + " in the " + DOMUtil.getQualifiedName((Node)reference) + " element."));
            }
            el = DOMUtil.getNextElement((Node)el);
        }
        if (vresult._domRequired) {
            doc = vresult._copiedDOM;
        } else if (part._domRequired) {
            Document doc2 = (Document)doc.cloneNode(true);
            vresult._domRequired = true;
            vresult._copiedDOM = doc2;
            doc = doc2;
        }
        String refUri = DOMUtil.getAttribute((Element)reference, (String)"URI");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing URI [" + refUri + "]..."));
        }
        if (refUri.length() == 0) {
            object = doc.getDocumentElement();
        } else {
            if (refUri.length() < 2 || refUri.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", refUri);
            }
            refUri = refUri.substring(1);
            object = idResolver.resolveID(doc, refUri);
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The URI [" + refUri + "] is not supported." + "  Either the id is defined in the wrong namespace or no id's have a matching value."));
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", refUri);
        }
        part._parent = object.getParentNode();
        part._object = object;
        part._timestamp = timestamp = NonceUtil.getTimestamp(object, nsWsu);
        part._nonce = nonce = NonceUtil.getNonce(object, nsWsse);
        part._noncefirst = noncefirst = NonceUtil.isNonceFirst(object, nonce, timestamp);
        vresult._verifiedParts.add(part);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added Verified part[" + part + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,SignatureConsumerConfig config,List parts,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkTransforms(Element transforms, WSSConsumerConfig gconfig, List config, VerificationResult.VerifiedPart part, boolean domRequired, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkTransform(Element transforms[" + DOMUtil.getDisplayName((Node)transforms) + "]," + "WSSConsumerConfig gconfig," + "List config[" + config + "]," + "VerifiedPart part[" + part + "]," + "boolean domRequired[" + domRequired + "]," + "Map context])"));
        }
        int hash = 0;
        Element el = DOMUtil.getFirstElement((Node)transforms);
        while (el != null) {
            Element el2 = DOMUtil.getNextElement((Node)el);
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_TRANSFORM) {
                SignatureConsumer.checkTransform(el, el2 == null, gconfig, config, part, domRequired, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + DOMUtil.getQualifiedName((Node)el) + " in the " + DOMUtil.getQualifiedName((Node)transforms) + " element."));
            }
            el = el2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTransform(Element transforms,WSSConsumerConfig gconfig,List config,VerifiedPart part,boolean domRequired,Map context)");
        }
    }

    private static void checkTransform(Element transform, boolean lastTransform, WSSConsumerConfig gconfig, List config, VerificationResult.VerifiedPart part, boolean domRequired, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkTransform(Element transform[" + DOMUtil.getDisplayName((Node)transform) + "]," + "boolean lastTransform[" + lastTransform + "]," + "WSSConsumerConfig gconfig," + "List config[" + config + "]," + "VerifiedPart part[" + part + "]," + "boolean domRequired[" + domRequired + "]," + "Map context)"));
        }
        boolean result = false;
        Iterator i = config.iterator();
        String algorithm1 = transform.getAttribute("Algorithm");
        while (i.hasNext()) {
            AlgorithmConfig aconfig = (AlgorithmConfig)i.next();
            String algorithm2 = aconfig.getAlgorithm();
            if (!algorithm2.equals(algorithm1) || !gconfig.getAllowedTransforms().contains(algorithm1)) continue;
            result = true;
            break;
        }
        if (!result) {
            throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s12", algorithm1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Transform [" + algorithm1 + "] is OK."));
        }
        if (ConfigUtil.isC14nTransform((String)algorithm1)) {
            ++part._numC14n;
            if (lastTransform) {
                part._lastIsC14n = true;
            }
        } else if (domRequired && ConfigUtil.isDOMRequiredTransform((String)algorithm1)) {
            part._domRequired = domRequired;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTransform(List config,WSSConsumerConfig gconfig,String algorithm,VerifiedPart part,boolean domRequired,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verify(Element signature, Key key, WSSConsumerConfig gconfig, SignatureConsumerConfig config, IDResolver idResolver, Document document, VerificationResult vresult, Map selectors, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("verify(Element signature[" + DOMUtil.getDisplayName((Node)signature) + "]," + "Key key[" + key + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + idResolver + "]," + "Document document[" + DOMUtil.getDisplayName((Node)document) + "]," + "VerificationResult vresult[" + vresult + "]," + "Map selectors," + "Map context)"));
        }
        WSSSignatureContext scontext = new WSSSignatureContext();
        scontext.setContext(context);
        String hwKsRef = null;
        String hwAcceleration = null;
        Map gprops = gconfig.getProperties();
        hwKsRef = (String)context.remove("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
        scontext.setHWKeyStoreName(hwKsRef);
        String sigAlgorithm = null;
        if (config.getSignatureMethod() != null) {
            sigAlgorithm = config.getSignatureMethod().getAlgorithm();
        }
        scontext.setSigAlgorithm(sigAlgorithm);
        if (scontext.useHWKeyStore()) {
            Provider p;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)scontext.getHWKeyStoreName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance((String)scontext.getHWKeyStoreName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                scontext.setHWKeyStoreProvider(p);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p.getName()));
                }
            }
        }
        hwAcceleration = (String)gprops.get("HWCONFIG");
        scontext.setHWConfigName(hwAcceleration);
        scontext.setOffload((Boolean)gprops.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (scontext.shouldChangeProvider()) {
            Provider p;
            HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Acceleration enabled, Key Store Name is: ", (Object)scontext.getHWConfigName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance((String)scontext.getHWConfigName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                scontext.setHWAccelerationProvider(p);
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                fHWKeyCache.setProvider(p, hardwareCacheSize);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for HW Acceleration" + p.getName()));
                }
            }
        }
        String defaultHWKSRef = null;
        if (!(!(key instanceof PKCS11Key) || hwAcceleration != null && hwAcceleration.length() != 0 || hwKsRef != null && hwKsRef.length() != 0)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
            }
            if ((defaultHWKSRef = (String)gprops.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                scontext.setHWKeyStoreName(defaultHWKSRef);
                if (scontext.useHWKeyStore()) {
                    Provider p2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)scontext.getHWKeyStoreName());
                    }
                    if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)scontext.getHWKeyStoreName())) == null) {
                        Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                    } else {
                        scontext.setHWKeyStoreProvider(p2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                        }
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for signing");
                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            scontext.setResourceShower(ShowerImpl.getInstance());
        }
        if (idResolver != null) {
            scontext.setIDResolver(idResolver);
        }
        HashSet<KeyInfoConsumerConfig> dsigKConfig = new HashSet<KeyInfoConsumerConfig>();
        Iterator i = gconfig.getSignatureConsumers().iterator();
        while (i.hasNext()) {
            dsigKConfig.add(((SignatureConsumerConfig)i.next()).getSigningKeyInfo());
        }
        HashSet<KeyInfoConsumerConfig> encKConfig = new HashSet<KeyInfoConsumerConfig>();
        i = gconfig.getEncryptionConsumers().iterator();
        while (i.hasNext()) {
            encKConfig.add(((EncryptionConsumerConfig)i.next()).getEncryptionKeyInfo());
        }
        Set tokenConfig = gconfig.getTokenConsumers();
        WSSAlgorithmFactory factory = gconfig.getAlgorithmFactory();
        scontext.setAlgorithmFactory(factory);
        scontext.setDocument(document);
        if (config.getKeyInfoSignature() != null) {
            scontext.setKeyInfoSignature(config.getKeyInfoSignature().getAlgorithm());
        } else {
            scontext.setKeyInfoSignature(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DecryptionTransform is used: " + config.isDecryptionTransformEnabled()));
        }
        if (config.isDecryptionTransformEnabled()) {
            SameDocumentEncryptedKeyRetriever ekRetriever = null;
            try {
                ekRetriever = new SameDocumentEncryptedKeyRetriever(document);
            }
            catch (StructureException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".verify"), (String)"826");
                throw new SoapSecurityException(e);
            }
            scontext.setEncryptedKeyRetriever((EncryptedKeyRetriever)ekRetriever);
            XMLDTKeyInfoResolver kiResolver = new XMLDTKeyInfoResolver();
            kiResolver.setAlgorithmFactory(factory);
            kiResolver.setContext(context);
            kiResolver.setSelectors(selectors);
            kiResolver.setIdResolver(idResolver);
            kiResolver.setEncKeyInfoConsumers(encKConfig);
            kiResolver.setTokenConsumers(tokenConfig);
            scontext.setKeyInfoResolver((KeyInfoResolver)kiResolver);
        }
        STRDTKeyInfoResolver skiResolver = new STRDTKeyInfoResolver();
        skiResolver.setContext(context);
        skiResolver.setSelectors(selectors);
        skiResolver.setDsigKeyInfoSet(dsigKConfig);
        skiResolver.setEncKeyInfoSet(encKConfig);
        skiResolver.setGeneration(false);
        skiResolver.setIdResolver(idResolver);
        scontext.setSTRDTKeyInfoResolver(skiResolver);
        scontext.setVerificationResult(vresult);
        Validity validity = null;
        try {
            validity = scontext.verify(signature, key);
        }
        finally {
            if (scontext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance((String)scontext.getHWConfigName(), (Provider)scontext.getHWAccelerationProvider());
            }
            if (scontext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance((String)scontext.getHWKeyStoreName(), (Provider)scontext.getHWKeyStoreProvider());
            }
        }
        boolean coreValidity = validity.getCoreValidity();
        String errMsg = null;
        if (!coreValidity || tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Core validity=");
            buf.append(coreValidity);
            buf.append(" Signed info validity=");
            buf.append(validity.getSignedInfoValidity());
            buf.append(" Signed info message='");
            buf.append(validity.getSignedInfoMessage());
            buf.append("'");
            int count = validity.getNumberOfReferences();
            for (int j = 0; j < count; ++j) {
                buf.append(" Ref[");
                buf.append(i);
                buf.append("](validity=");
                buf.append(validity.getReferenceValidity(j));
                buf.append(" message='");
                buf.append(validity.getReferenceMessage(j));
                buf.append("' uri='");
                buf.append(validity.getReferenceURI(j));
                buf.append("' type='");
                buf.append(validity.getReferenceType(j));
                buf.append("')");
            }
            errMsg = buf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)errMsg);
            }
            if (coreValidity) {
                errMsg = null;
            }
        }
        if (errMsg != null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s01", errMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"verify(Element signature,Key key,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,Document document,VerificationResult vresult,Map selectors,Map context)");
        }
    }

    public static Key callKeyInfoConsumer(KeyInfoConsumerConfig config, String keytype, Map type, Map properties, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype[" + keytype + "]," + "Map type," + "Map properties," + "Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        KeyInfoConsumer con = (KeyInfoConsumer)properties.get(KeyInfoConsumer.class);
        type.clear();
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, keytype);
        context.put("com.ibm.wsspi.wssecurity.config.keyinfoConsumer.configKey", config);
        Key key = con.getKey(target, type, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype,Map type,Map properties,Element target,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private static void setVerificationResult(VerificationResult vresult, SignatureConsumerConfig sconfig, Map context) throws SoapSecurityException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setVerificationResult(VerificationResult vresult[" + vresult + "]," + "SignatureConsumerConfig sconfig," + "Map context)"));
        }
        for (VerificationResult.VerifiedPart part : vresult._verifiedParts) {
            SignatureConsumer.removeNode(part._timestamp, "wedsig");
            SignatureConsumer.removeNode(part._nonce, "wedsig");
        }
        vresult._token = token = SignatureConsumer.getToken(vresult, sconfig, context);
        ResultPool.add((Map)context, (Result)vresult);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setVerificationResult(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context)");
        }
    }

    public static void removeNode(Element element, String type) {
        Node node;
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeNode(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String type[" + type + "])"));
        }
        if (element != null && (value = element.getAttribute("wasextention")) != null && value.equals(type) && (node = element.getParentNode()) != null) {
            node.removeChild(element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNode(Element element,String type)");
        }
    }

    protected static KeyInfoResult[] getKeyInfoResults(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] kresults = null;
        Result[] results = ResultPool.get((Map)context, KeyInfoResult.class);
        if (results != null) {
            kresults = new KeyInfoResult[results.length];
            for (int i = 0; i < results.length; ++i) {
                kresults[i] = (KeyInfoResult)results[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyInfoResults(Map context) returns KeyInfoResult[][" + kresults + "]"));
        }
        return kresults;
    }

    private static KeyInfoResult getProcessedResult(VerificationResult vresult, KeyInfoResult[] results, List kclist) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist");
        }
        KeyInfoResult result = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                if (result == null && kclist.contains(r.getKeyInfoContentConsumer()) && r.getError() == null) {
                    result = r;
                    continue;
                }
                vresult._kresults.put(r.getKeyInfoContentConsumer(), r);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + result + "]"));
        }
        return result;
    }

    private static Token getToken(VerificationResult vresult, SignatureConsumerConfig sconfig, Map context) throws SoapSecurityException {
        List vlist;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(VerificationResult vresult[" + vresult + "]," + "SignatureConsumerConfig sconfig," + "Map context)"));
        }
        Token token = null;
        Set tokens = null;
        KeyInfoResult[] results = SignatureConsumer.getKeyInfoResults(context);
        KeyInfoResult kresult = SignatureConsumer.getProcessedResult(vresult, results, sconfig.getSigningKeyInfo().getContentConsumers());
        if (kresult != null) {
            String id = kresult.getIdInSubject();
            token = TokenManager.getToken(context, kresult.getKeyInfoContentConsumer().getTokenConsumer(), id);
            if (token != null) {
                if (token.getError() != null) {
                    throw token.getError();
                }
                token.setReferenced(true);
            }
            tokens = TokenManager.getTokens(context, id);
        }
        if ((vlist = (List)sconfig.getIdentityMap().get(vresult._srconfig)) != null && vlist.size() > 0) {
            for (VerifiedConfig vconfig : vlist) {
                block1: for (KeyInfoContentConsumerConfig kiconfig : vconfig._sconfig.getSigningKeyInfo().getContentConsumers()) {
                    for (int k = 0; k < results.length; ++k) {
                        if (!kiconfig.equals(results[k].getKeyInfoContentConsumer())) continue;
                        vresult._identities.put(vconfig, results[k]);
                        continue block1;
                    }
                }
            }
        }
        if (tokens != null && tokens.size() > 0) {
            block3: for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                TokenConsumerConfig tconfig = r.getKeyInfoContentConsumer().getTokenConsumer();
                if (tconfig == null) continue;
                for (Token t : tokens) {
                    if (!tconfig.equals(t.getUsedTokenConsumer())) continue;
                    vresult._kresults.put(r, t);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context)returns Token[" + token + "]"));
        }
        return token;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element owner, int count, String uri, String type, byte[] content, String encoding) {
            String dumpData = null;
            try {
                dumpData = encoding == null ? new String(content, "UTF-8") : new String(content, encoding);
            }
            catch (Exception e) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: An exception occured while the content is encoded with [" + encoding + "]."));
            }
            if (count < 0) {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs verify-SignedInfo: " + dumpData));
            } else if (uri == null || uri.length() == 0) {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs verify-resource_" + count + ": " + dumpData));
            } else {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs verify-" + uri + ": " + dumpData));
            }
        }
    }
}

