/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STRDTKeyInfoResolver {
    private static final TraceComponent tc = Tr.register(STRDTKeyInfoResolver.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRDTKeyInfoResolver.class.getName();
    private IDResolver _idResolver;
    private Set _tokenSet;
    private Set _dsigKinfoSet;
    private Set _encKinfoSet;
    private boolean _generation = false;
    private Map _context;
    private Map _selectors;
    private Set _stokens = null;
    private Result[] _results = null;
    private boolean _storedToken = false;

    protected STRDTKeyInfoResolver() {
    }

    protected void setDsigKeyInfoSet(Set dsigKinfoSet) {
        this._dsigKinfoSet = dsigKinfoSet;
    }

    protected void setEncKeyInfoSet(Set encKInfoSet) {
        this._encKinfoSet = encKInfoSet;
    }

    protected void setGeneration(boolean generation) {
        this._generation = generation;
    }

    protected void setContext(Map context) {
        this._context = context;
    }

    protected void setSelectors(Map selectors) {
        this._selectors = selectors;
    }

    protected void setIdResolver(IDResolver idResolver) {
        this._idResolver = idResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element resolve(Element secTokenRef, String keyInfoType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "]," + "String keyInfoType[" + keyInfoType + "])"));
        }
        Element element = null;
        try {
            HashMap type = new HashMap();
            int wssVersion = 0;
            Object obj = this._context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            String nsWsse = Constants.NAMESPACES[0][wssVersion];
            if (this._generation) {
                element = STRDTKeyInfoResolver.getElementInSubject(secTokenRef, keyInfoType, nsWsse, this._context);
            } else {
                if (!this._storedToken) {
                    this._stokens = XMLDTKeyInfoResolver.storeSubject(this._context);
                    this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                    this._storedToken = true;
                }
                if ((element = STRDTKeyInfoResolver.getElementInSubject(secTokenRef, keyInfoType, nsWsse, this._context)) == null) {
                    element = STRDTKeyInfoResolver.getElement(secTokenRef, this._dsigKinfoSet, this._encKinfoSet, type, this._selectors, this._context);
                }
            }
        }
        finally {
            if (this._storedToken) {
                XMLDTKeyInfoResolver.restoreSubject(this._context, this._stokens);
                XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                this._storedToken = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve(Element secTokenRef,String keyInfoType) returns Element[" + DOMUtil.getDisplayName((Node)element) + "]"));
        }
        return element;
    }

    private static Element getElementInSubject(Element secTokenRef, String keyInfoType, String nsWsse, Map context) throws SoapSecurityException {
        String id;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElementInSubject(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "]," + "String keyInfoType[" + keyInfoType + "]," + "String nsWsse[" + nsWsse + "]," + "Map context)"));
        }
        Element element = null;
        Set tokens = TokenManager.getTokens(context);
        if (tokens != null && (id = STRDTKeyInfoResolver.getIdInSubject(secTokenRef, keyInfoType, nsWsse)) != null) {
            for (Token token : tokens) {
                if (!id.equals(token.getId())) continue;
                element = token.getElement();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getElementInSubject(Element secTokenRef,String keyInfoType,String nsWsse", (Object)("Map context) returns Element[" + DOMUtil.getDisplayName(element) + "]"));
        }
        return element;
    }

    private static String getIdInSubject(Element secTokenRef, String keyInfoType, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIdInSubject(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "]," + "String keyInfoType[" + keyInfoType + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        String id = null;
        Element element = null;
        if (ConfigUtil.isKeyInfoKeyid((String)keyInfoType)) {
            element = DOMUtil.getOneElement((Element)secTokenRef, (String)nsWsse, (String)"KeyIdentifier");
            id = DOMUtil.getStringValue((Node)element);
        } else if (ConfigUtil.isKeyInfoX509issuer((String)keyInfoType)) {
            String issuerSerial;
            element = DOMUtil.getOneElement((Element)secTokenRef, (String)Constants.NS_DSIG, (String)"X509IssuerName");
            String issuerName = DOMUtil.getStringValue((Node)element);
            if (issuerName != null) {
                issuerName = KeyInfo.X509Data.encodeDName((String)issuerName);
            }
            if ((issuerSerial = DOMUtil.getStringValue((Node)(element = DOMUtil.getOneElement((Element)secTokenRef, (String)Constants.NS_DSIG, (String)"X509SerialNumber")))) != null) {
                try {
                    BigInteger bint = new BigInteger(issuerSerial);
                }
                catch (NumberFormatException nfee) {
                    try {
                        BigInteger bint = CertificateUtil.convertSerialNumber((String)issuerSerial);
                        issuerSerial = bint.toString();
                    }
                    catch (ParseException pe) {
                        throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", issuerSerial, (Throwable)pe);
                    }
                }
            }
            id = issuerName + ":" + issuerSerial;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIdInSubject(Element secTokenRef,String keyInfoType,String nsWsse) returns String[" + id + "]"));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getElement(Element secTokenRef, Set dsigKinfoSet, Set encKinfoSet, Map type, Map properties, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElement(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "]," + "Set dsigKinfoSet[" + dsigKinfoSet + "]," + "Set encKinfoSet[" + encKinfoSet + "]," + "Map type," + "Map properties," + "Map context)"));
        }
        Element element = null;
        Set lockedTokens = STRDTKeyInfoResolver.lockTokens(context);
        try {
            Element keyInfo = STRDTKeyInfoResolver.getKeyInfoElement(secTokenRef);
            KeyInfoResult kresult = STRDTKeyInfoResolver.callKeyInfoConsumer(dsigKinfoSet, encKinfoSet, type, properties, keyInfo, context);
            if (kresult == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WEARNING: Unable to get the KeyInfoResult.");
                }
            } else {
                String id = kresult.getIdInSubject();
                Token token = TokenManager.getToken(context, kresult.getKeyInfoContentConsumer().getTokenConsumer(), id);
                if (token == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WEARNING: Unable to extract the token with the token identifier [" + id + "]."));
                    }
                } else {
                    if (token.getError() != null) {
                        throw token.getError();
                    }
                    element = token.getElement();
                }
            }
        }
        finally {
            STRDTKeyInfoResolver.restoreTokens(context, lockedTokens);
            STRDTKeyInfoResolver.removeKeyInfoResults(context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElement(Element secTokenRef,Set dsigKinfoSet,Set encKinfoSet,Map type,Map properties,Map context) returns Element[" + DOMUtil.getDisplayName((Node)element) + "]"));
        }
        return element;
    }

    private static Element getKeyInfoElement(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyInfoElement(Node node[" + DOMUtil.getDisplayName((Node)node) + "])"));
        }
        Element element = null;
        Node n = node.getParentNode();
        if (n != null) {
            element = n.getNodeType() == 1 && DOMUtil.equals((Node)n, (String)Constants.NS_DSIG, (String)"KeyInfo") ? (Element)n : STRDTKeyInfoResolver.getKeyInfoElement(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyInfoElement(Node node)returns Element[" + DOMUtil.getDisplayName((Node)element) + "]"));
        }
        return element;
    }

    private static KeyInfoResult callKeyInfoConsumer(Set dsigKinfoSet, Set encKinfoSet, Map type, Map properties, Element target, Map context) throws SoapSecurityException {
        KeyInfoResult[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callKeyInfoConsumer(Set dsigKinfoSet,Set encKinfoSet,Map type,Map properties,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        KeyInfoResult kresult = null;
        boolean succeeded = false;
        Exception lastException = null;
        for (KeyInfoConsumerConfig config : dsigKinfoSet) {
            try {
                SignatureConsumer.callKeyInfoConsumer(config, "VerifyingKey", type, properties, target, context);
                succeeded = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
                STRDTKeyInfoResolver.removeKeyInfoResults(context);
            }
        }
        if (succeeded) {
            results = SignatureConsumer.getKeyInfoResults(context);
            kresult = STRDTKeyInfoResolver.getProcessedResult(results, dsigKinfoSet);
        } else {
            for (KeyInfoConsumerConfig config : encKinfoSet) {
                try {
                    SignatureConsumer.callKeyInfoConsumer(config, "DecryptingKey", type, properties, target, context);
                    succeeded = true;
                    break;
                }
                catch (Exception e) {
                    lastException = e;
                    STRDTKeyInfoResolver.removeKeyInfoResults(context);
                }
            }
        }
        if (!succeeded) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", lastException);
        }
        results = SignatureConsumer.getKeyInfoResults(context);
        kresult = STRDTKeyInfoResolver.getProcessedResult(results, encKinfoSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callKeyInfoConsumer(boolean signature,Set keyInfoSet,Map type,Map properties,Element target,Map context) returns KeyInfoResult[" + kresult + "]"));
        }
        return kresult;
    }

    private static KeyInfoResult getProcessedResult(KeyInfoResult[] results, Set keyInfoSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProcessedResult(KeyInfoResult[] results,Set keyInfoSet");
        }
        KeyInfoResult result = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                KeyInfoContentConsumerConfig kic = r.getKeyInfoContentConsumer();
                for (KeyInfoConsumerConfig config : keyInfoSet) {
                    if (!config.getContentConsumers().contains(kic) || r.getError() != null) continue;
                    result = r;
                    break;
                }
                if (result != null) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProcessedResult(KeyInfoResult[] results,Set keyInfoSet) returns KeyInfoResult[" + result + "]"));
        }
        return result;
    }

    private static Set lockTokens(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lockTokens(Map context)");
        }
        HashSet set = new HashSet(TokenManager.getTokens(context));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockTokens(Map context)");
        }
        return set;
    }

    private static void removeKeyInfoResults(Map context) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
        if ((results = ResultPool.get((Map)context, KeyInfoResult.class)) != null && results.length > 0) {
            ResultPool.remove((Map)context, (Result[])results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreTokens(Map context, Set tokens) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreTokens(Map context,Set tokens)");
        }
        TokenManager.removeAllTokens(context);
        TokenManager.setTokens(context, tokens);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreResults(Map context,Set tokens)");
        }
    }
}

