/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.AttrProxy;
import com.ibm.ws.wssecurity.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class Canonicalizer {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    Canonicalizer() {
    }

    public static byte[] serializeSubset(NodeList nodeList, boolean withComments, Map replNodeSets) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Canonicalizer.serializeSubset(nodeList, withComments, replNodeSets, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static void serializeSubset(NodeList nodeList, boolean withComments, Map replNodeSets, Writer wr) throws IOException {
        Canonicalizer.serializeSubset(nodeList, withComments, replNodeSets, wr, null);
    }

    static void serializeSubset(NodeList nodeList, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node = nodeList.item(i);
            if (replNodeSets.containsKey(node)) {
                nodeVector.add(new ReplacedNode(node));
                int l = nodeList.getLength();
                for (int j = i + 1; j <= l; ++j) {
                    if (j < l && DOMUtil.isDescendantNode((Node)nodeList.item(j), (Node)node)) continue;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (node.getNodeType() != 2) {
                Node attr;
                nodeVector.addElement(node);
                if (node.getNodeType() != 1) continue;
                Hashtable<String, Node> attributes = Canonicalizer.collectXMLPrefixAttributesInAncestors(node);
                if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                    if (attributes == null) {
                        attributes = new Hashtable<String, Node>();
                    }
                    ++i;
                    while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && node == ((Attr)node2).getOwnerElement()) {
                        attributes.put(node2.getNodeName(), node2);
                        ++i;
                    }
                    if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                        attributes.remove("xmlns");
                    }
                    --i;
                    nodeVector.addElement(new Attributes(node, attributes));
                    continue;
                }
                if (attributes == null) continue;
                nodeVector.addElement(new Attributes(node, attributes));
                continue;
            }
            Element owner = ((Attr)node).getOwnerElement();
            Hashtable<String, Node> attributes = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && owner == ((Attr)node2).getOwnerElement()) {
                attributes.put(node2.getNodeName(), node2);
                ++i;
            }
            nodeVector.addElement(new Attributes(owner, attributes));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            Canonicalizer.serializeSubset(stack, nodeVector, i, withComments, replNodeSets, wr, apexNodes);
        }
    }

    private static void serializeSubset(Stack stack, Vector nodeVector, int i, boolean withComments, Map replNodeSets, Writer wr, Set apexNodes) throws IOException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof Attributes) {
            nodeVector.setElementAt(null, i);
            ((Attributes)obj).serialize(null, wr);
            return;
        }
        if (obj instanceof ReplacedNode) {
            NodeList nl = (NodeList)replNodeSets.get(((ReplacedNode)obj).getNode());
            HashSet<Node> s = new HashSet<Node>();
            int j = 0;
            int l = nl.getLength();
            block0: while (j < l) {
                Node n = nl.item(j);
                s.add(n);
                for (int k = j + 1; k <= l; ++k) {
                    if (k < l && DOMUtil.isDescendantNode((Node)nl.item(k), (Node)n)) continue;
                    j = k;
                    continue block0;
                }
            }
            Canonicalizer.serializeSubset(nl, false, replNodeSets, wr, s);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            Canonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        Attributes ancestorAttrs = stack.empty() ? null : (Attributes)stack.peek();
        Attributes attrs = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node || nodeVector.elementAt(next) instanceof ReplacedNode) {
            parent = node.getParentNode();
            if (parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns") || apexNodes != null && apexNodes.contains(node)) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            attrs = (Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns") && ((parent = node.getParentNode()).getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns") || apexNodes != null && apexNodes.contains(node))) {
                wr.write(" xmlns=\"\"");
            }
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!Canonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            Canonicalizer.serializeSubset(stack, nodeVector, next, withComments, replNodeSets, wr, apexNodes);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    static boolean isAncestor(Object me, Node anc) {
        Node parent = me instanceof Attributes ? ((Attributes)me).parent : (me instanceof ReplacedNode ? ((ReplacedNode)me).getNode() : (Node)me);
        while (parent != anc) {
            if ((parent = parent.getNodeType() == 2 ? ((Attr)parent).getOwnerElement() : parent.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void serializeNode(Node topNode, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        Canonicalizer.serializeNode(topNode, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(Node topNode, Stack stack, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        if (exceptedNode == node) {
            return;
        }
        boolean lesser = false;
        boolean greater = false;
        switch (node.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                wr.write("<");
                wr.write(node.getNodeName());
                Canonicalizer.serializeAttributes(topNode, stack, (Element)node, xmlAttributes, wr);
                wr.write(">");
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Canonicalizer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                stack.pop();
                wr.write("</");
                wr.write(node.getNodeName());
                wr.write(">");
                break;
            }
            case 3: 
            case 4: {
                String text = node.getNodeValue();
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '<') {
                        wr.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        wr.write("&gt;");
                        continue;
                    }
                    if (ch == '&') {
                        wr.write("&amp;");
                        continue;
                    }
                    if (ch == '\r') {
                        wr.write("&#xD;");
                        continue;
                    }
                    wr.write(ch);
                }
                break;
            }
            case 5: 
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Canonicalizer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                break;
            }
            case 7: {
                if (node.getParentNode().getNodeType() == 9) {
                    Node prev = node;
                    while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
                    }
                    if (prev == null) {
                        lesser = true;
                    } else {
                        greater = true;
                    }
                }
                ProcessingInstruction pi = (ProcessingInstruction)node;
                if (greater) {
                    wr.write("\n");
                }
                wr.write("<?");
                wr.write(pi.getTarget());
                if (pi.getData() != null && pi.getData().length() > 0) {
                    wr.write(" ");
                    String data = pi.getData();
                    int start = 0;
                    for (int index = 0; index < data.length(); ++index) {
                        if (data.charAt(index) != '\r') continue;
                        if (index > start) {
                            wr.write(data, start, index - start);
                        }
                        wr.write("&#xD;");
                        start = index + 1;
                    }
                    if (start < data.length()) {
                        wr.write(data, start, data.length() - start);
                    }
                }
                wr.write("?>");
                if (!lesser) break;
                wr.write("\n");
                break;
            }
            case 8: {
                if (!withComments) break;
                if (node.getParentNode().getNodeType() == 9) {
                    Node prev = node;
                    while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
                    }
                    if (prev == null) {
                        lesser = true;
                    } else {
                        greater = true;
                    }
                }
                if (greater) {
                    wr.write("\n");
                }
                wr.write("<!--");
                wr.write(node.getNodeValue());
                wr.write("-->");
                if (!lesser) break;
                wr.write("\n");
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                Canonicalizer.serializeAttribute((Attr)node, wr);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    private static boolean isTopElement(Node topNode, Element element) {
        if (topNode == element) {
            return true;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            switch (parent.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    parent = parent.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + parent.getNodeType());
        }
        return true;
    }

    private static void serializeAttributes(Node topNode, Stack stack, Element element, boolean xmlAttributes, Writer wr) throws IOException {
        Hashtable xmlattrs;
        Hashtable nsattrs = Canonicalizer.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap nnm = element.getAttributes();
        int atlen = nnm.getLength();
        for (int i = 0; i < atlen; ++i) {
            nsattrs.put(nnm.item(i).getNodeName(), nnm.item(i));
        }
        if (xmlAttributes && (xmlattrs = Canonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            Enumeration en = xmlattrs.elements();
            while (en.hasMoreElements()) {
                Attr attr = (Attr)en.nextElement();
                nsattrs.put(attr.getNodeName(), attr);
            }
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        Attr[] attrs = new Attr[atlen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            Attr attr = (Attr)en.nextElement();
            indexMap[i] = i;
            attrs[i] = attr;
            as[i] = Canonicalizer.createSortedString(attr, element);
            ++i;
        }
        C14nUtil.heapSort((int[])indexMap, (String[])as, (int)atlen);
        for (int j = 0; j < atlen; ++j) {
            Attr xa;
            Attr nsa;
            Attr a = attrs[indexMap[j]];
            String attrName = a.getNodeName();
            if (attrName.equals("xmlns:xml")) continue;
            if (attrName.equals("xmlns") && a.getNodeValue().length() == 0) {
                if (Canonicalizer.isTopElement(topNode, element)) continue;
                boolean found = false;
                for (int depth = stack.size() - 1; depth >= 0; --depth) {
                    Hashtable attrs2 = (Hashtable)stack.elementAt(depth);
                    Attr attr = (Attr)attrs2.get("xmlns");
                    if (attr == null || attr.getNodeValue().length() <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (attrName.equals("xmlns") || attrName.startsWith("xmlns:") ? parentAttrs != null && (nsa = (Attr)parentAttrs.get(attrName)) != null && nsa.getNodeValue().equals(a.getNodeValue()) : attrName.startsWith("xml:") && parentAttrs != null && (xa = (Attr)parentAttrs.get(attrName)) != null && xa.getNodeValue().equals(a.getNodeValue())) continue;
            Canonicalizer.serializeAttribute(a, wr);
        }
    }

    private static void serializeAttribute(Attr attr, Writer wr) throws IOException {
        String name = attr.getNodeName();
        boolean checkURI = name.equals("xmlns") || name.startsWith("xmlns:");
        wr.write(" ");
        wr.write(name);
        wr.write("=\"");
        String value = attr.getNodeValue();
        boolean hasColon = false;
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            if (ch == '&') {
                wr.write("&amp;");
                continue;
            }
            if (ch == '<') {
                wr.write("&lt;");
                continue;
            }
            if (ch == '\"') {
                wr.write("&quot;");
                continue;
            }
            if (ch == '\t') {
                wr.write("&#x9;");
                continue;
            }
            if (ch == '\n') {
                wr.write("&#xA;");
                continue;
            }
            if (ch == '\r') {
                wr.write("&#xD;");
                continue;
            }
            if (checkURI) {
                if (ch == ':') {
                    hasColon = true;
                } else if (ch == '/' && !hasColon) {
                    throw new RuntimeException("Found a relative URI: " + value);
                }
            }
            wr.write(ch);
        }
        if (value.length() > 0 && checkURI && !hasColon) {
            throw new RuntimeException("Found a relative URI: " + value);
        }
        wr.write("\"");
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node startNode, boolean useProxy) {
        Node node = startNode;
        Hashtable<String, Object> nsnodes = new Hashtable<String, Object>();
        Document factory = startNode.getOwnerDocument();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            if (useProxy) {
                nsnodes.put("xmlns:xml", new AttrProxy(startNode, factory, XMLNS_NS, "xmlns:xml", XML_NAMESPACE));
            } else {
                Attr xa = factory.createAttributeNS(XMLNS_NS, "xmlns:xml");
                xa.setNodeValue(XML_NAMESPACE);
                nsnodes.put("xmlns:xml", xa);
            }
        }
        do {
            NamedNodeMap attributeList;
            if ((attributeList = node.getAttributes()) == null) continue;
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr newAttr;
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || nsnodes.containsKey(attrName)) continue;
                if (node == startNode) {
                    nsnodes.put(attrName, attr);
                    continue;
                }
                if (useProxy) {
                    newAttr = new AttrProxy(startNode, factory, XMLNS_NS, attrName, attr.getNodeValue());
                    nsnodes.put(attrName, newAttr);
                    continue;
                }
                newAttr = factory.createAttributeNS(XMLNS_NS, attrName);
                newAttr.setNodeValue(attr.getNodeValue());
                nsnodes.put(attrName, newAttr);
            }
        } while ((node = node.getParentNode()) != null);
        return nsnodes;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node startNode) {
        NamedNodeMap attributeList;
        Hashtable<String, Attr> attrs = null;
        for (Node node = startNode.getParentNode(); node != null; node = node.getParentNode()) {
            NamedNodeMap attributeList2 = node.getAttributes();
            if (attributeList2 == null) continue;
            int nAttrs = attributeList2.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList2.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || attrs != null && attrs.containsKey(attrName)) continue;
                if (attrs == null) {
                    attrs = new Hashtable<String, Attr>();
                }
                attrs.put(attrName, attr);
            }
        }
        if (attrs != null && (attributeList = startNode.getAttributes()) != null) {
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || !attrs.containsKey(attrName)) continue;
                attrs.remove(attrName);
            }
        }
        return attrs;
    }

    private static String createSortedString(Attr node, Node element) {
        String ret;
        if (node.getNodeType() == 2) {
            String name = node.getNodeName();
            if (name.equals("xmlns")) {
                return "\u0000";
            }
            int index = name.indexOf(58);
            if (index <= 0) {
                return "\u0001" + name;
            }
            String prefix = name.substring(0, index);
            if (prefix.equals("xmlns")) {
                return "\u0000" + name.substring(index + 1);
            }
            String uri = com.ibm.ws.wssecurity.xss4j.domutil.DOMUtil.getNamespaceForPrefix((String)prefix, (Node)element);
            ret = uri == null || uri.length() == 0 ? "\u0001" + name : uri + "\u0001" + name.substring(index + 1);
        } else {
            throw new IllegalArgumentException("Requires an Attr node.");
        }
        return ret;
    }

    static class ReplacedNode {
        private Node fNode;

        ReplacedNode(Node node) {
            this.fNode = node;
        }

        Node getNode() {
            return this.fNode;
        }
    }

    static class Attributes {
        Node parent;
        Hashtable attributes;

        Attributes(Node node, Hashtable attrs) {
            this.parent = node;
            this.attributes = attrs;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(String attrname) {
            return this.attributes.containsKey(attrname);
        }

        void serialize(Attributes parent, Writer wr) throws IOException {
            Attr attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration en = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (Attr)en.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = Canonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort((int[])indexMap, (String[])as, (int)attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String attrName = attr.getNodeName();
                if (attrName.equals("xmlns:xml") || (attrName.equals("xmlns") || attrName.startsWith("xmlns:") ? parent != null && parent.contains(attrName) && parent.get(attrName).getNodeValue().equals(attr.getNodeValue()) : attrName.startsWith("xml:") && parent != null && parent.contains(attrName) && parent.get(attrName).getNodeValue().equals(attr.getNodeValue()))) continue;
                Canonicalizer.serializeAttribute(attr, wr);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        Attr get(String name) {
            return (Attr)this.attributes.get(name);
        }

        private void remove(String name) {
            Object attr = this.attributes.remove(name);
            if (attr == null) {
                System.err.println("Internal logic error: No attribute named " + name);
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enumeration();
            while (en.hasMoreElements()) {
                Attr attr = (Attr)en.nextElement();
                String p = attr.getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        static boolean inAncestors(Stack ancestors, String name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Attributes attrs = (Attributes)ancestors.elementAt(i);
                if (!attrs.contains(name) || !attrs.get(name).getNodeValue().equals(ns)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            Attr attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration en = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (Attr)en.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = Canonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort((int[])indexMap, (String[])as, (int)attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String attrName = attr.getNodeName();
                if (attrName.equals("xmlns:xml")) {
                    this.remove(attrName);
                    continue;
                }
                if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                    String prefix;
                    if (Attributes.inAncestors(ancestors, attrName, attr.getNodeValue())) {
                        this.remove(attrName);
                        continue;
                    }
                    String string = prefix = attrName.equals("xmlns") ? "" : attrName.substring(6);
                    if (!(prefixList != null && prefixList.get(prefix) != null || elprefix == null || elprefix.equals(prefix) || this.usePrefix(prefix))) {
                        this.remove(attrName);
                        continue;
                    }
                }
                Canonicalizer.serializeAttribute(attr, wr);
            }
        }

        public String toString() {
            return "Attributes[#=" + this.attributes.size() + "]";
        }
    }
}

