/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.handler.token.WSNonceManagerImpl;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class NonceManagerFactory {
    private static final TraceComponent tc = Tr.register(NonceManagerFactory.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = NonceManagerFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.NonceManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.NonceManagerFactory.getInstance");
    private static boolean _useCache = false;
    private static String _cacheName = null;
    private static int _cacheSize = -1;
    private static int _cacheTimeout = -1;
    private static int _nonceLength = -1;
    private static boolean _cacheDistributed = false;

    private NonceManagerFactory() {
    }

    public static NonceManager getInstance() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_INSTANCE_PERMISSION);
        }
        NonceManager instance = NonceInstance._instance;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstance() returns NonceManager[" + instance + "]"));
        }
        return instance;
    }

    static void init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout, int nonceLength, boolean cacheDistributed) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("init(boolean useCache[" + useCache + "]," + "String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]," + "int nonceLength[" + nonceLength + "]," + "boolean cacheDistributed[" + cacheDistributed + "])"));
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(INIT_PERMISSION);
        }
        _useCache = useCache;
        _cacheName = cacheName;
        _cacheSize = cacheSize;
        _cacheTimeout = cacheTimeout;
        _nonceLength = nonceLength;
        _cacheDistributed = cacheDistributed;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(String cacheName, int cacheSize, int cacheTimeout, int nonceLength, boolean cacheDistributed)");
        }
    }

    public String toString() {
        return clsName;
    }

    private static class NonceInstance {
        private static NonceManager _instance = null;

        private NonceInstance() {
        }

        static {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Initializing WSNonceManagerImpl instance with boolean useCache[" + _useCache + "]," + "String cacheName[" + _cacheName + "]," + "int cacheSize[" + _cacheSize + "]," + "int cacheTimeout[" + _cacheTimeout + "]," + "int nonceLength[" + _nonceLength + "]," + "boolean cacheDistributed[" + _cacheDistributed + "]"));
            }
            _instance = _useCache ? new WSNonceManagerImpl(_cacheName, _cacheSize, _cacheTimeout, _nonceLength, _cacheDistributed) : null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSNonceManagerImpl instance initialized [" + _instance + "]"));
            }
        }
    }
}

