/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.confimpl;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateGeneratorConfig
extends PrivateCommonConfig
implements WSSGeneratorConfig {
    private static final TraceComponent tc = Tr.register(PrivateGeneratorConfig.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PrivateGeneratorConfig.class.getName();
    protected String _myActor = null;
    protected String _targetActor = null;
    protected boolean _indentation = false;
    protected final Set _allowedTransforms = new HashSet();
    protected final Set _allowedCanonicalizationMethods = new HashSet();
    protected final Set _allowedSignatureMethods = new HashSet();
    protected final Set _allowedDigestMethods = new HashSet();
    protected final Set _allowedDataEncryptionMethods = new HashSet();
    protected final Set _allowedKeyEncryptionMethods = new HashSet();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set _defaultKeyInfoContentGenerators = new HashSet();
    protected final Set _defaultTokenGenerators = new HashSet();
    protected final Set _defaultCallbackHandlers = new HashSet();
    protected final Set _defaultKeyLocators = new HashSet();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _signatureEnabled = false;
    protected boolean _encryptionEnabled = false;
    protected boolean _tokenEnabled = false;
    protected boolean _timestampEnabled = false;
    protected final List _integralParts = new ArrayList();
    protected final List _confidentialParts = new ArrayList();
    protected final List _securityTokens = new ArrayList();
    protected final List _operationGenerators = new ArrayList();
    protected final Set _tokenGenerators = new HashSet();
    protected NonceManager _nonceManager = null;
    protected Map _properties = null;
    protected TimestampGeneratorConfImpl _timestampGenerator = null;
    protected boolean _clientSetMustUnderstand = true;
    protected boolean _serviceGetMustUnderstand = true;

    protected void processPrivateConfig(Document pconfig) throws SoapSecurityException {
        String value;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processPrivateConfig(Document pconfig[" + pconfig + "])"));
        }
        boolean fipsMode = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is true; getting FIPS algorithms");
            }
            fipsMode = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            fipsMode = false;
        }
        NodeList list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "Transform");
        int length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedTransforms.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed Transforms:", (Object)new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s11");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedCanonicalizationMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed canonicalizationMethods:", (Object)new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s12");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedSignatureMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed signatureMethods:", (Object)new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s13");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "digestMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedDigestMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed digestMethods:", (Object)new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s14");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            this._allowedDataEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed encryptionMethods:", (Object)new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s15");
        }
        list = fipsMode ? pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(value)) continue;
            this._allowedKeyEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed keyEncryptionMethods:", (Object)new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s16");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyInfoContentGenerator");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultKeyInfoContentGenerators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default KeyInfoContentGenerator:", (Object)new Object[]{this._defaultKeyInfoContentGenerators});
        }
        if (this._defaultKeyInfoContentGenerators.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6715W");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "TokenGenerator");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultTokenGenerators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default TokenGenerator:", (Object)new Object[]{this._defaultTokenGenerators});
        }
        if (this._defaultTokenGenerators.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6716W");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "CallbackHandler");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultCallbackHandlers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default CallbackHandler:", (Object)new Object[]{this._defaultCallbackHandlers});
        }
        if (this._defaultCallbackHandlers.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6717W");
        }
        list = pconfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            value = DOMUtil.getAttribute((Element)((Element)list.item(i)), (String)"class");
            this._defaultKeyLocators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default KeyLocator:", (Object)new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6714W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processPrivateConfig(Document pconfig)");
        }
    }

    public void validate() throws SoapSecurityException {
        this.validate(false);
    }

    public void validate(boolean defaultConfig) throws SoapSecurityException {
        block72: {
            block73: {
                int index;
                String keyword;
                String dialect;
                PrivateCommonConfig.ReferencePartConfImpl rconfig;
                int Timestamp2;
                int Nonce2;
                int MessageParts2;
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("validate(boolean defaultConfig[" + defaultConfig + "])"));
                }
                HashSet<PrivateCommonConfig.ReferencePartConfImpl> tgForDsigKey = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
                HashSet<PrivateCommonConfig.ReferencePartConfImpl> tgForEncKey = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
                Iterator i = this._integralParts.iterator();
                while (i.hasNext()) {
                    MessageParts2 = 0;
                    Nonce2 = 0;
                    Timestamp2 = 0;
                    rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
                    rconfig.validate();
                    for (PrivateCommonConfig.PartConfImpl pconfig : rconfig._parts) {
                        pconfig.validate();
                        if (pconfig.isNonce()) {
                            ++Nonce2;
                        } else if (pconfig.isTimestamp()) {
                            ++Timestamp2;
                        } else {
                            ++MessageParts2;
                        }
                        dialect = pconfig._dialect;
                        keyword = pconfig._keyword;
                        if (Constants.DIALECT_WAS.equals(dialect)) {
                            index = ConfigUtil.isIntegralWASDialect((String)keyword);
                            if (index == 1) {
                                if (pconfig.isTimestamp()) {
                                    throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
                                }
                                if (this._timestampGenerator == null) continue;
                                TimestampGeneratorConfImpl tsconfig = this._timestampGenerator;
                                tsconfig._signed = true;
                                continue;
                            }
                            if (index == 3) {
                                tgForDsigKey.add(rconfig);
                                continue;
                            }
                            if (index == 4) {
                                tgForEncKey.add(rconfig);
                                continue;
                            }
                            if (index >= 0) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, pconfig.toString());
                        }
                        if (Constants.DIALECT_FUNCTION.equals(dialect)) {
                            if (keyword != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                        }
                        if (Constants.DIALECT_XPATH.equals(dialect)) {
                            if (keyword != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, pconfig.toString());
                    }
                    if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s36");
                }
                i = this._confidentialParts.iterator();
                while (i.hasNext()) {
                    MessageParts2 = 0;
                    Nonce2 = 0;
                    Timestamp2 = 0;
                    rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
                    rconfig.validate();
                    for (PrivateCommonConfig.PartConfImpl pconfig : rconfig._parts) {
                        pconfig.validate();
                        if (pconfig.isNonce()) {
                            ++Nonce2;
                        } else if (pconfig.isTimestamp()) {
                            ++Timestamp2;
                        } else {
                            ++MessageParts2;
                        }
                        dialect = pconfig._dialect;
                        keyword = pconfig._keyword;
                        if (Constants.DIALECT_WAS.equals(dialect)) {
                            if (ConfigUtil.isConfidentialWASDialect((String)keyword) >= 0) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, pconfig.toString());
                        }
                        if (Constants.DIALECT_FUNCTION.equals(dialect)) {
                            if (keyword != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                        }
                        if (Constants.DIALECT_XPATH.equals(dialect)) {
                            if (keyword != null) continue;
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", dialect, pconfig.toString());
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, pconfig.toString());
                    }
                    if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
                    String msg = " If there is one or more Nonce or timestamp that need to be encrypted, also specify a MessagePart that needs to be encrypted ";
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s36");
                }
                if (defaultConfig) {
                    HashMap<QName, TokenGeneratorConfImpl> generatorsMap = new HashMap<QName, TokenGeneratorConfImpl>();
                    for (TokenGeneratorConfImpl tconfig : this._tokenGenerators) {
                        generatorsMap.put(tconfig.getType(), tconfig);
                    }
                    for (TokenGeneratorConfImpl tconfig : this._securityTokens) {
                        QName tctype = tconfig.getType();
                        TokenGeneratorConfImpl tc2 = (TokenGeneratorConfImpl)generatorsMap.get(tctype);
                        if (tc2 == null) {
                            String msg = "There is a security token that does not have a matching token generator. Its name is [" + tconfig._name + "] and its type is [" + tctype + "]";
                            throw new SoapSecurityException(msg);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Found token generator of type [" + tctype + "]."));
                    }
                } else {
                    for (TokenGeneratorConfImpl tconfig : this._securityTokens) {
                        if (!this._tokenGenerators.contains(tconfig)) {
                            String msg = "There is the security token that no token generator references. Its name is [" + tconfig._name + "].";
                            throw new SoapSecurityException(msg);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Found token generator in _tokenGenerators: " + tconfig));
                    }
                }
                ArrayList<EncryptionGeneratorConfImpl> lenc = new ArrayList<EncryptionGeneratorConfImpl>();
                for (Object obj : this._operationGenerators) {
                    KeyInfoContentGeneratorConfImpl kcconfig;
                    KeyInfoGeneratorConfImpl kconfig;
                    PrivateCommonConfig.AlgorithmConfImpl aconfig2;
                    if (obj instanceof SignatureGeneratorConfig) {
                        SignatureGeneratorConfImpl sconfig = (SignatureGeneratorConfImpl)obj;
                        sconfig.validate(defaultConfig);
                        aconfig2 = sconfig._canonicalizationMethod;
                        if (aconfig2 != null) {
                            aconfig2.validate();
                            if (!this._allowedCanonicalizationMethods.contains(aconfig2._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", aconfig2._algorithm);
                            }
                        }
                        aconfig2 = sconfig._signatureMethod;
                        boolean isSecretKeyAlgorithm = false;
                        String secretKeyAlgorithm = null;
                        if (aconfig2 != null) {
                            aconfig2.validate();
                            if (!this._allowedSignatureMethods.contains(aconfig2._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", aconfig2._algorithm);
                            }
                            secretKeyAlgorithm = aconfig2._algorithm;
                            isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm((String)secretKeyAlgorithm);
                        }
                        if ((aconfig2 = sconfig._keyInfoSignature) != null) {
                            aconfig2.validate();
                            if (ConfigUtil.isKeyInfoSignature((String)aconfig2._algorithm) < 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s10", aconfig2._algorithm);
                            }
                        }
                        PrivateCommonConfig.ReferencePartConfImpl requiredTG = null;
                        for (PrivateCommonConfig.SigningReferenceConfImpl srconfig : sconfig._references) {
                            srconfig.validate();
                            aconfig2 = srconfig._digestMethod;
                            if (aconfig2 != null) {
                                aconfig2.validate();
                                if (!this._allowedDigestMethods.contains(aconfig2._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", aconfig2._algorithm);
                                }
                            }
                            boolean strTransform = false;
                            for (PrivateCommonConfig.AlgorithmConfImpl aconfig2 : srconfig._transforms) {
                                aconfig2.validate();
                                if (!this._allowedTransforms.contains(aconfig2._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", aconfig2._algorithm);
                                }
                                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(aconfig2._algorithm)) {
                                    strTransform = true;
                                    continue;
                                }
                                if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(aconfig2._algorithm) || (keyword = ConfigUtil.trim((String)((String)aconfig2._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_XPATH_EXPRESSION)))) != null && keyword.length() != 0) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s27");
                            }
                            if (!strTransform || requiredTG != null) continue;
                            if (tgForDsigKey.contains(srconfig._reference)) {
                                requiredTG = srconfig._reference;
                                continue;
                            }
                            if (!tgForEncKey.contains(srconfig._reference)) continue;
                            requiredTG = srconfig._reference;
                        }
                        kconfig = sconfig._signingKeyInfo;
                        kconfig.validate();
                        kcconfig = kconfig._contentGenerator;
                        kcconfig.validate();
                        if (ConfigUtil.isKeyInfoType((String)kcconfig._keyInfoType) < 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", kcconfig.toString());
                        }
                        if (isSecretKeyAlgorithm) {
                            if (ConfigUtil.isKeyInfoEmb((String)kcconfig._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                            }
                            if (ConfigUtil.isKeyInfoX509issuer((String)kcconfig._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                            }
                        } else if (requiredTG != null && kcconfig._tokenGenerator == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s35");
                        }
                        for (EncryptionGeneratorConfImpl econfig : lenc) {
                            econfig._sigAfterEnc = true;
                        }
                        continue;
                    }
                    if (obj instanceof EncryptionGeneratorConfig) {
                        EncryptionGeneratorConfImpl econfig;
                        econfig = (EncryptionGeneratorConfImpl)obj;
                        econfig.validate(defaultConfig);
                        aconfig2 = econfig._dataEncryptionMethod;
                        aconfig2.validate();
                        if (!this._allowedDataEncryptionMethods.contains(aconfig2._algorithm)) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", aconfig2._algorithm);
                        }
                        String secretKeyAlgorithm = aconfig2._algorithm;
                        boolean isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm((String)secretKeyAlgorithm);
                        aconfig2 = econfig._keyEncryptionMethod;
                        if (aconfig2 != null) {
                            aconfig2.validate();
                            if (!this._allowedKeyEncryptionMethods.contains(aconfig2._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", aconfig2._algorithm);
                            }
                            secretKeyAlgorithm = aconfig2._algorithm;
                            isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm((String)secretKeyAlgorithm);
                        }
                        kconfig = econfig._encryptionKeyInfo;
                        kconfig.validate();
                        kcconfig = kconfig._contentGenerator;
                        kcconfig.validate();
                        if (ConfigUtil.isKeyInfoType((String)kcconfig._keyInfoType) < 0) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", kcconfig.toString());
                        }
                        if (isSecretKeyAlgorithm) {
                            if (ConfigUtil.isKeyInfoEmb((String)kcconfig._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                            }
                            if (ConfigUtil.isKeyInfoX509issuer((String)kcconfig._keyInfoType)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                            }
                        }
                        lenc.add(econfig);
                        continue;
                    }
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s01", this.toString());
                }
                i = this._tokenGenerators.iterator();
                while (i.hasNext()) {
                    TokenGeneratorConfImpl tconfig;
                    tconfig = (TokenGeneratorConfImpl)i.next();
                    tconfig.validate();
                    CallbackHandlerConfImpl cconfig = tconfig._callbackHandler;
                    if (cconfig != null) {
                        cconfig.validate();
                        PrivateCommonConfig.KeyStoreConfImpl ksconfig = cconfig._keyStoreConfig;
                        if (ksconfig != null) {
                            ksconfig.validate();
                        }
                        i = cconfig._keyInformationList.iterator();
                        while (i.hasNext()) {
                            PrivateCommonConfig.KeyInformationConfImpl kiconfig = (PrivateCommonConfig.KeyInformationConfImpl)i.next();
                            kiconfig.validate();
                        }
                    }
                    if (!tconfig._standAlone) continue;
                    if (tconfig._usedForSignature) {
                        tconfig._standAlone = false;
                        String msg = "The token generator [" + tconfig._name + "] that refers to the security token in DD is used for signature." + " The security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
                        throw new SoapSecurityException(msg);
                    }
                    if (!tconfig._usedForEncryption) continue;
                    tconfig._standAlone = false;
                    if (!tc.isDebugEnabled()) continue;
                    String msg = "The token generator [" + tconfig._name + "] that refers to the security token in DD is used for encryption." + " The security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
                    throw new SoapSecurityException(msg);
                }
                if (this._timestampGenerator == null) break block72;
                this._timestampGenerator.validate();
                String value = (String)this._timestampGenerator._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
                if (value != null) {
                    this._timestampGenerator._headerAttribute = ConfigUtil.isTrue((String)value);
                    this._timestampGenerator._soapHeader = true;
                }
                if ((value = (String)this._timestampGenerator._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT)) == null) break block72;
                if (!Constants.DIALECT_WAS.equals(value)) break block73;
                value = (String)this._timestampGenerator._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD);
                if (value == null) break block72;
                index = ConfigUtil.isTimestampWASDialect((String)value);
                switch (index) {
                    case 1: {
                        break block72;
                    }
                    case 2: 
                    case 3: {
                        this._timestampGenerator._soapHeader = true;
                    }
                    case 0: {
                        this._timestampGenerator._default = false;
                        break block72;
                    }
                    default: {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", value, this._timestampGenerator.toString());
                    }
                }
            }
            this._timestampGenerator._default = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate(boolean)");
        }
    }

    public boolean getServiceGetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceGetMustUnderstand");
            Tr.exit((TraceComponent)tc, (String)("getServiceGetMustUnderstand=" + this._serviceGetMustUnderstand));
        }
        return this._serviceGetMustUnderstand;
    }

    public boolean getClientSetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClientSetMustUnderstand");
            Tr.exit((TraceComponent)tc, (String)("getClientSetMustUnderstand=" + this._clientSetMustUnderstand));
        }
        return this._clientSetMustUnderstand;
    }

    public String getMyActor() {
        return this._myActor;
    }

    public String getTargetActor() {
        return this._targetActor;
    }

    public boolean doIndentation() {
        return this._indentation;
    }

    public void setIndentation(boolean f) {
        this._indentation = f;
    }

    public Set getAllowedTransforms() {
        return this._allowedTransforms;
    }

    public Set getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    public Set getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    public Set getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    public Set getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    public Set getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    public boolean isSignatureEnabled() {
        return this._signatureEnabled;
    }

    public boolean isEncryptionEnabled() {
        return this._encryptionEnabled;
    }

    public boolean isTokenEnabled() {
        return this._tokenEnabled;
    }

    public boolean isTimestampEnabled() {
        return this._timestampEnabled;
    }

    public List getIntegralParts() {
        return this._integralParts;
    }

    public List getConfidentialParts() {
        return this._confidentialParts;
    }

    public List getOperationGenerators() {
        return this._operationGenerators;
    }

    public Set getTokenGenerators() {
        return this._tokenGenerators;
    }

    public TimestampGeneratorConfig getTimestampGenerator() {
        return this._timestampGenerator;
    }

    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    public Map getProperties() {
        return this._properties;
    }

    public Object getProperty(Object property) {
        if (this._properties != null) {
            return this._properties.get(property);
        }
        return null;
    }

    protected String getLogProperties(Map defaultProps, Map extProps, Map bndProps, String reqRespTypeIn) {
        String logProps = null;
        if (tc.isDebugEnabled()) {
            logProps = super.getLogProperties(defaultProps, extProps, bndProps, this._properties, reqRespTypeIn, "generator");
        }
        return logProps;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("myActor=[").append(this._myActor).append("], ");
        buf.append("targetActor=[").append(this._targetActor).append("], ");
        buf.append("indentation=[").append(this._indentation).append("], ");
        buf.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        buf.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        buf.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        buf.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        buf.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        buf.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        buf.append("algorithmFactory=[").append((Object)this._algorithmFactory).append("], ");
        buf.append("signatureEnabled=[").append(this._signatureEnabled).append("], ");
        buf.append("encryptionEnabled=[").append(this._encryptionEnabled).append("], ");
        buf.append("tokenEnabled=[").append(this._tokenEnabled).append("], ");
        buf.append("timestampEnabled=[").append(this._timestampEnabled).append("], ");
        buf.append("integralParts=[").append(this._integralParts).append("], ");
        buf.append("confidentialParts=[").append(this._confidentialParts).append("], ");
        buf.append("operationGenerators=[").append(this._operationGenerators).append("], ");
        buf.append("tokenGenerators=[").append(this._tokenGenerators).append("], ");
        buf.append("timestampGenerator=[").append(this._timestampGenerator).append("], ");
        buf.append("nonceManager=[").append(this._nonceManager).append("], ");
        buf.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        if (!(this instanceof WSSecurityDefaultGeneratorConfig)) {
            buf.append("*clientSetMustUnderstand=[").append(this._clientSetMustUnderstand).append("], ");
            buf.append("*serviceGetMustUnderstand=[").append(this._serviceGetMustUnderstand).append("], ");
        }
        buf.append("properties=[").append(this._properties).append("]");
        buf.append(")");
        return buf.toString();
    }

    public static class KeyInfoContentGeneratorConfImpl
    implements KeyInfoContentGeneratorConfig {
        public String _className = null;
        public KeyInfoContentGeneratorComponent _instance = null;
        public String _keyInfoType = null;
        public KeyLocator _keyLocator = null;
        public String _keyName = null;
        public TokenGeneratorConfImpl _tokenGenerator = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
            if (this._keyInfoType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s26", this.toString());
            }
        }

        public KeyInfoContentGeneratorComponent getInstance() {
            return this._instance;
        }

        public String getKeyInfoType() {
            return this._keyInfoType;
        }

        public KeyLocator getKeyLocator() {
            return this._keyLocator;
        }

        public String getKeyName() {
            return this._keyName;
        }

        public TokenGeneratorConfig getTokenGenerator() {
            return this._tokenGenerator;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("keyInfoType=[").append(this._keyInfoType).append("], ");
            buf.append("keyLocator=[").append(this._keyLocator).append("], ");
            buf.append("keyName=[").append(this._keyName).append("], ");
            buf.append("tokenGenerator=[").append(this._tokenGenerator).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class KeyInfoGeneratorConfImpl
    implements KeyInfoGeneratorConfig {
        public KeyInfoContentGeneratorConfImpl _contentGenerator = null;

        public void validate() throws SoapSecurityException {
            if (this._contentGenerator == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s07", this.toString());
            }
        }

        public KeyInfoContentGeneratorConfig getContentGenerator() {
            return this._contentGenerator;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("contentGenerator=[").append(this._contentGenerator).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TimestampGeneratorConfImpl
    implements TimestampGeneratorConfig {
        public String _myActor = null;
        public String _targetActor = null;
        public Duration _duration = null;
        private boolean _signed = false;
        private boolean _headerAttribute = false;
        private boolean _default = true;
        private boolean _soapHeader = false;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
        }

        public String getMyActor() {
            return this._myActor;
        }

        public String getTargetActor() {
            return this._targetActor;
        }

        public Duration getDuration() {
            return this._duration;
        }

        public boolean toBeSigned() {
            return this._signed;
        }

        public void setToBeSigned(boolean signed) {
            this._signed = signed;
        }

        public boolean getSOAPHeaderAttribute() {
            return this._headerAttribute;
        }

        public boolean isSOAPHeaderElement() {
            return this._soapHeader;
        }

        public boolean isDefault() {
            return this._default;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("myActor=[").append(this._myActor).append("], ");
            buf.append("targetActor=[").append(this._targetActor).append("], ");
            buf.append("duration=[").append(this._duration).append("], ");
            buf.append("signed=[").append(this._signed).append("], ");
            buf.append("headerAttribute=[").append(this._headerAttribute).append("], ");
            buf.append("soapHeader=[").append(this._soapHeader).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class CallbackHandlerConfImpl
    implements CallbackHandlerConfig {
        public String _className = null;
        public PrivateCommonConfig.KeyStoreConfImpl _keyStoreConfig = null;
        public final Set _keyInformationList = new HashSet();
        public String _userId = null;
        public char[] _userPassword = null;
        public final Map _properties = new HashMap();
        private static final int ITSHA1_OCTETS = 20;
        private static final int IT60SHA1_OCTETS = 8;
        private static final String OID_KEYIDENTIFIER = "2.5.29.14";
        private static final byte BER_SEQUENCE = 48;
        private static final byte BER_BITSTRING = 3;
        private static final int STATUS_OK = 0;
        private static final int STATUS_CERT_ERROR = 1;
        private static final int STATUS_KEYID_ERROR = 2;
        private static final int STATUS_KEY_ERROR = 4;
        private volatile boolean _initialized = false;
        private CallbackHandler _instance = null;
        private KeyStore _keystore = null;
        private final Map _certlist = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._className == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s05", this.toString());
            }
            if (this._userId == null && this._userPassword != null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s06", this.toString());
            }
        }

        public String getClassName() {
            return this._className;
        }

        public CallbackHandler getInstance() {
            return this._instance;
        }

        public void setInstance(CallbackHandler instance) {
            this._instance = instance;
        }

        public Set getKeyInformationList() {
            return this._keyInformationList;
        }

        public KeyStore getKeyStore() throws SoapSecurityException {
            if (!this._initialized) {
                this.doInit();
            }
            return this._keystore;
        }

        public String getKeyStorePath() {
            return this._keyStoreConfig == null ? null : this._keyStoreConfig._path;
        }

        public Certificate getCertificate(String alias) throws SoapSecurityException {
            CertInformation cinfo;
            Certificate cert = null;
            if (!this._initialized) {
                this.doInit();
            }
            if ((cinfo = (CertInformation)this._certlist.get(alias)) != null) {
                cert = cinfo.getCertificate();
            }
            return cert;
        }

        public String getUserId() {
            return this._userId;
        }

        public char[] getUserPassword() {
            return this._userPassword;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("keyInformationList=[").append(this._keyInformationList).append("], ");
            buf.append("certInfomationList=[").append(this._certlist).append("], ");
            buf.append("userId=[").append(this._userId).append("], ");
            buf.append("userPassword=[XXXXXXXX], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }

        protected synchronized void doInit() throws SoapSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"doInit()");
            }
            if (this._initialized && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInit()");
            }
            PrivateCommonConfig.KeyStoreConfImpl ksconfig = this._keyStoreConfig;
            Set keyinfo = this._keyInformationList;
            if (ksconfig != null && keyinfo != null) {
                if (ksconfig._ksRef != null) {
                    this._keystore = ConfigUtil.getKeyStore((String)ksconfig._ksRef);
                } else if (ksconfig._type != null && ksconfig._path != null && ksconfig._password != null && ksconfig._path != null) {
                    this._keystore = ConfigUtil.getKeyStore((String)ksconfig._type, (String)ksconfig._path, (char[])ksconfig._password.toCharArray());
                }
                if (this._keystore == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.loadKeyStore01");
                }
                Iterator it = keyinfo.iterator();
                try {
                    while (it.hasNext()) {
                        PrivateCommonConfig.KeyInformationConfImpl kiconfig = (PrivateCommonConfig.KeyInformationConfImpl)it.next();
                        String keyName = KeyInfo.X509Data.encodeDName((String)kiconfig._name);
                        if (keyName == null || keyName.length() == 0) {
                            keyName = kiconfig._name;
                        }
                        Certificate cert = this._keystore.getCertificate(kiconfig._alias);
                        String subjectDN = null;
                        String encSubjectDN = null;
                        int status = 0;
                        long expiration = -1L;
                        String errorMes = null;
                        if (cert == null || !(cert instanceof X509Certificate)) continue;
                        X509Certificate x509 = (X509Certificate)cert;
                        subjectDN = x509.getSubjectDN().getName();
                        encSubjectDN = KeyInfo.X509Data.encodeDName((String)subjectDN);
                        expiration = x509.getNotAfter().getTime();
                        try {
                            x509.checkValidity();
                        }
                        catch (CertificateExpiredException e) {
                            status += 2;
                            Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"1387", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5181E", (Object)new Object[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e});
                            errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e.getClass().getName() + ": " + e.getMessage()});
                        }
                        catch (CertificateException e) {
                            ++status;
                            Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"1394", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5182E", (Object)new Object[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e});
                            errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5182E", (String[])new String[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e.getClass().getName() + ": " + e.getMessage()});
                        }
                        this._certlist.put(kiconfig._alias, new CertInformation(ksconfig._path, kiconfig._alias, keyName, cert, subjectDN, encSubjectDN, expiration, status, errorMes));
                    }
                }
                catch (KeyStoreException e) {
                    Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"1414", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.exception", (Object)new Object[]{ksconfig.getPath(), e});
                    throw new SoapSecurityException(e);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("KeyLocatorConfig [" + this._keyStoreConfig + "], " + "CertInformationList [" + this._certlist + "]."));
            }
            this._initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInit()");
            }
        }

        private class CertInformation {
            private String _kspath;
            private String _alias;
            private String _name;
            private Certificate _certificate;
            private String _subjectDN;
            private String _encSubjectDN;
            private int _status;
            private long _expiration;
            private String _errorMes;

            private CertInformation(String kspath, String alias, String name, Certificate certificate, String subjectDN, String encSubjectDN, long expiration, int status, String errorMes) {
                this._kspath = kspath;
                this._alias = alias;
                this._name = name;
                this._certificate = certificate;
                this._subjectDN = subjectDN;
                this._encSubjectDN = encSubjectDN;
                this._expiration = expiration;
                this._status = status;
                this._errorMes = errorMes;
            }

            private Certificate getCertificate() throws SoapSecurityException {
                if ((this._status & 1) == 1) {
                    throw new SoapSecurityException(this._errorMes);
                }
                this.checkExpiration();
                return this._certificate;
            }

            private void checkExpiration() throws SoapSecurityException {
                long millisBeforeExpiration;
                if (this._expiration >= 0L && (millisBeforeExpiration = this._expiration - System.currentTimeMillis()) < 0L) {
                    ++this._status;
                    this._errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + millisBeforeExpiration + " ms."});
                    throw new SoapSecurityException(this._errorMes);
                }
            }

            public String toString() {
                StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
                buf.append("keystorePath=[").append(this._kspath).append("], ");
                buf.append("alias=[").append(this._alias).append("], ");
                buf.append("name=[").append(this._name).append("], ");
                buf.append("status=[").append(this._status).append("], ");
                buf.append(")");
                return buf.toString();
            }
        }
    }

    public static class TokenGeneratorConfImpl
    implements TokenGeneratorConfig {
        public String _name = null;
        public String _className = null;
        public TokenGeneratorComponent _instance = null;
        public String _usage = null;
        public QName _type = null;
        public boolean _standAlone = false;
        public Provider _provider = null;
        public List _certStores = null;
        public CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _usedForSignature = false;
        public boolean _usedForEncryption = false;
        public final Map _properties = new HashMap();
        private volatile boolean _initialized = false;

        public TokenGeneratorConfImpl() {
        }

        public TokenGeneratorConfImpl(TokenGeneratorConfImpl tconfig) {
            this._name = tconfig._name;
            this._className = tconfig._className;
            this._instance = tconfig._instance;
            this._usage = tconfig._usage;
            this._type = tconfig._type;
            this._standAlone = tconfig._standAlone;
            this._provider = tconfig._provider;
            this._certStores = tconfig._certStores;
            this._callbackHandler = tconfig._callbackHandler;
            this._usedForSignature = tconfig._usedForSignature;
            this._usedForEncryption = tconfig._usedForEncryption;
            this._properties.putAll(tconfig._properties);
            this._initialized = tconfig._initialized;
        }

        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s03", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s04", this.toString());
            }
        }

        protected synchronized void initCerts() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initCerts()");
            }
            if (this._initialized) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initCerts()");
                }
                return;
            }
            if (this._certStores != null) {
                Iterator it;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_certStores is non-null");
                }
                if (!(it = this._certStores.iterator()).hasNext() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_certStores is empty");
                }
                ArrayList<CertStore> newCertStores = new ArrayList<CertStore>();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof CollectionCertStore) {
                        CollectionCertStore ccs;
                        CertStore cs;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Instance is a CollectionCertStore, creating CertStore instance.");
                        }
                        if ((cs = (ccs = (CollectionCertStore)obj).getInstance()) != null) {
                            this._provider = cs.getProvider();
                            newCertStores.add(cs);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"CollectionCertStore.getInstance() returned null.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Instance not a CollectionCertStore, nothing to do.");
                    }
                    newCertStores.add((CertStore)obj);
                }
                this._certStores = newCertStores;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"_certStores is null");
            }
            this._initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initCerts()");
            }
        }

        public TokenGeneratorComponent getInstance() {
            return this._instance;
        }

        public String getUsage() {
            return this._usage;
        }

        public QName getType() {
            return this._type;
        }

        public boolean isStandAlone() {
            return this._standAlone;
        }

        public Provider getProvider() {
            this.initCerts();
            return this._provider;
        }

        public List getCertStores() {
            this.initCerts();
            return this._certStores;
        }

        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("usage=[").append(this._usage).append("], ");
            buf.append("type=[").append(this._type).append("], ");
            buf.append("standAlone=[").append(this._standAlone).append("], ");
            buf.append("provider=[").append(this._provider).append("], ");
            buf.append("certStores=[").append(this._certStores).append("], ");
            buf.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class EncryptionGeneratorConfImpl
    implements EncryptionGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoGeneratorConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public final Map _properties = new HashMap();
        public boolean _sigAfterEnc = false;

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s02", this.toString());
            }
            if (this._reference == null && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        public KeyInfoGeneratorConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        public ReferencePartConfig getReference() {
            return this._reference;
        }

        public Map getProperties() {
            return this._properties;
        }

        public boolean remainSignatureAfterEncryption() {
            return this._sigAfterEnc;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            buf.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            buf.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            buf.append("reference=[").append(this._reference).append("], ");
            buf.append("properties=[").append(this._properties).append("], ");
            buf.append("signatureAfterEncryption=[").append(this._sigAfterEnc).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class SignatureGeneratorConfImpl
    implements SignatureGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoGeneratorConfImpl _signingKeyInfo = null;
        public final List _references = new ArrayList();
        public boolean _inclusiveNamespaces = true;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            this.checkInclusiveNsProperty();
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s01", this.toString());
            }
            if (this._references.isEmpty() && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        public void putInclusiveNsProperty(Map inProps) {
            String value = (String)inProps.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
            if (ConfigUtil.hasValue((String)value)) {
                this._properties.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES, value);
            }
        }

        private void checkInclusiveNsProperty() {
            if (this._properties.containsKey(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES)) {
                this._inclusiveNamespaces = ConfigUtil.isTrue((String)((String)this._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_INCLUSIVE_NAMESPACES)));
            }
        }

        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        public KeyInfoGeneratorConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        public List getReferences() {
            return this._references;
        }

        public boolean addInclusiveNamespaces() {
            return this._inclusiveNamespaces;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            buf.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            buf.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            buf.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            buf.append("refereces=[").append(this._references).append("], ");
            buf.append("addInclusiveNamespaces=[").append(this._inclusiveNamespaces).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }
}

