/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.confimpl;

import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmMappingConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocatorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PrivateCommonConfig {
    private static final String comp = "security.wssecurity";

    protected String getLogProperties(Map defaultProps, Map extProps, Map bndProps, Map allProps, String reqRespTypeIn, String genConTypeIn) {
        StringBuffer buf = new StringBuffer();
        String genConType = "";
        String reqRespType = "";
        if (genConTypeIn != null) {
            genConType = genConTypeIn;
        }
        if (reqRespTypeIn != null) {
            reqRespType = reqRespTypeIn;
        }
        buf.append("\nDefault properties: " + (defaultProps == null ? "null" : defaultProps.toString()));
        buf.append("\nApplication " + reqRespType + " " + genConType + " extension properties: " + (extProps == null ? "null" : extProps.toString()));
        buf.append("\nApplication " + reqRespType + " " + genConType + " binding properties: " + (bndProps == null ? "null" : bndProps.toString()));
        buf.append("\nCombined properties: " + allProps);
        return buf.toString();
    }

    public static class KeyInformationConfImpl
    implements KeyLocatorConfig.KeyInformationConfig {
        public String _alias = null;
        public String _keypass = null;
        public String _name = null;

        public void validate() throws SoapSecurityException {
            if (this._alias == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s16", this.toString());
            }
            if (this._name == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s17", this.toString());
            }
        }

        public String getAlias() {
            return this._alias;
        }

        public String getKeyPass() {
            return this._keypass;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("alias=[").append(this._alias).append("], ");
            buf.append("keypass=[XXXXXXXX], ");
            buf.append("name=[").append(this._name).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class KeyStoreConfImpl
    implements KeyLocatorConfig.KeyStoreConfig {
        public String _type = null;
        public String _path = null;
        public String _password = null;
        public String _ksRef = null;

        public void validate() throws SoapSecurityException {
            if (this._ksRef == null) {
                if (this._type == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s13", this.toString());
                }
                if (this._path == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s14", this.toString());
                }
                if (this._password == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s15", this.toString());
                }
            } else {
                if (this._type != null || this._path != null || this._password != null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s19", this.toString());
                }
                if (!ConfigUtil.isValidWSKeyStore((String)this._ksRef)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s18", this.toString());
                }
            }
        }

        public String getType() {
            return this._type;
        }

        public String getPath() {
            return this._path;
        }

        public String getPassword() {
            return this._password;
        }

        public String getKsRef() {
            return this._ksRef;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("type=[").append(this._type).append("], ");
            buf.append("path=[").append(this._path).append("], ");
            buf.append("password=[XXXXXXXX]");
            buf.append("keyStoreRef=[").append(this._ksRef).append("], ");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class KeyLocatorConfImpl
    implements KeyLocatorConfig {
        public String _className = null;
        public KeyStoreConfImpl _keyStore = null;
        public final Set _keyInformationList = new HashSet();
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._className == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s11", this.toString());
            }
        }

        public String getClassName() {
            return this._className;
        }

        public KeyLocatorConfig.KeyStoreConfig getKeyStore() {
            return this._keyStore;
        }

        public Set getKeyInformationList() {
            return this._keyInformationList;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("keyStore=[").append(this._keyStore).append("], ");
            buf.append("keyInformationList=[").append(this._keyInformationList).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class PartConfImpl
    implements ReferencePartConfig.PartConfig {
        public boolean _timestamp = false;
        public boolean _nonce = false;
        public String _usage = null;
        public String _dialect = null;
        public String _keyword = null;
        public Duration _duration = null;

        public void validate() throws SoapSecurityException {
            if (this._dialect == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s09", this.toString());
            }
            if (this._keyword == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s10", this.toString());
            }
        }

        public String getUsage() {
            return this._usage;
        }

        public boolean isTimestamp() {
            return this._timestamp;
        }

        public boolean isNonce() {
            return this._nonce;
        }

        public String getDialect() {
            return this._dialect;
        }

        public String getKeyword() {
            return this._keyword;
        }

        public Duration getDuration() {
            return this._duration;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("timestamp=[").append(this._timestamp).append("], ");
            buf.append("nonce=[").append(this._nonce).append("], ");
            buf.append("usage=[").append(this._usage).append("], ");
            buf.append("dialect=[").append(this._dialect).append("], ");
            buf.append("keyword=[").append(this._keyword).append("], ");
            buf.append("duration=[").append(this._duration).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class ReferencePartConfImpl
    implements ReferencePartConfig {
        public final Set _bindings = new HashSet();
        public final Set _parts = new HashSet();
        public String _usage = null;
        public int _order = -1;
        public boolean _oneOfIntegralParts = false;
        public boolean _callerRequired = false;
        public boolean _trustMethodRequired = false;

        public void validate() throws SoapSecurityException {
            if (this._parts.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s07", this.toString());
            }
            if (this._order < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s08", this.toString());
            }
        }

        public Set getBindings() {
            return this._bindings;
        }

        public Set getParts() {
            return this._parts;
        }

        public String getUsage() {
            return this._usage;
        }

        public int getOrder() {
            return this._order;
        }

        public boolean isOneOfIntegralParts() {
            return this._oneOfIntegralParts;
        }

        public boolean isCallerRequired() {
            return this._callerRequired;
        }

        public boolean isTrustMethodRequired() {
            return this._trustMethodRequired;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("parts=[").append(this._parts).append("], ");
            buf.append("usage=[").append(this._usage).append("], ");
            buf.append("order=[").append(this._order).append("], ");
            buf.append("oneOfIntegralParts=[").append(this._oneOfIntegralParts).append("], ");
            buf.append("callerRequired=[").append(this._callerRequired).append("], ");
            buf.append("trustMethodRequired=[").append(this._trustMethodRequired).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class SigningReferenceConfImpl
    implements SigningReferenceConfig {
        public ReferencePartConfImpl _reference = null;
        public AlgorithmConfImpl _digestMethod = null;
        public final List _transforms = new ArrayList();
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._reference == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s04", this.toString());
            }
            if (this._digestMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s05", this.toString());
            }
            if (this._transforms.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s06", this.toString());
            }
        }

        public ReferencePartConfig getReference() {
            return this._reference;
        }

        public AlgorithmConfig getDigestMethod() {
            return this._digestMethod;
        }

        public List getTransforms() {
            return this._transforms;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("reference=[").append(this._reference).append("], ");
            buf.append("digestMethod=[").append(this._digestMethod).append("], ");
            buf.append("transforms=[").append(this._transforms).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class AlgorithmMappingConfImpl
    implements AlgorithmMappingConfig {
        public String _factoryName = null;
        public final Set _algorithmURIs = new HashSet();
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._factoryName == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s02", this.toString());
            }
            if (this._algorithmURIs.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s03", this.toString());
            }
        }

        public String getFactoryName() {
            return this._factoryName;
        }

        public Set getAlgorithmURIs() {
            return this._algorithmURIs;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("factoryName=[").append(this._factoryName).append("], ");
            buf.append("algorithmURIs=[").append(this._algorithmURIs).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class AlgorithmConfImpl
    implements AlgorithmConfig {
        public String _algorithm = null;
        public String _type = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._algorithm == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s01", this.toString());
            }
        }

        public String getAlgorithm() {
            return this._algorithm;
        }

        public String getType() {
            return this._type;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("algorithm=[").append(this._algorithm).append("], ");
            buf.append("type=[").append(this._type).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }
}

