/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.NoopGenerator;
import com.ibm.ws.webservices.wsdl.introspect.Introspector;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.GroupEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GeneratorTable;
import com.ibm.ws.webservices.wsdl.toJava.JavaBindingWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaDefinitionWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaServiceWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaTypeWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesBndWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesClientBndWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesClientExtWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesExtWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLMappingWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLWebServicesClientWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLWebServicesWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.jem.java.JavaHelpers;

public class JavaGeneratorFactory
implements GeneratorFactory {
    private static boolean skipWCCMMappingPass = false;
    protected Emitter emitter;
    protected GeneratorTable genTable = new GeneratorTable();
    protected static NoopGenerator noGenerator = new NoopGenerator();
    public static final String OLD_NAME = "oldName";
    public static final String OLD_NAME2 = "oldName2";
    public static String INTERFACE_NAME = "interface name";
    public static String IMPL_NAME = "implName";
    public static String SIGNATURE = "signature";
    public static final String PARAM_SIG_TYPE = "parameterSignatureType";
    public static final String PARAM_TYPE = "parameterType";
    public static final String PARAM_WIRE_QNAME = "parameterWireQName";
    public static String COMPLEX_TYPE_FAULT = "ComplexTypeFault";
    public static String EXCEPTION_SYMTAB_ENTRY = "ExceptionSymTabEntry";
    public static String COMPLEX_TYPE_FAULT_COLLECTION = "ComplexTypeFaultList";
    public static final String CUSTOM_BINDER_NAME = "CustomBinderName";
    public static final String HOLDER_NAME = "HolderName";
    public static final String CONSTRUCTOR_ORDER = "constructorOrder";
    private static final String ANON_TYPE_PREPEND = "anonTypePrepend";
    public static final String DISABLE_HOLDER_GENERATION = "DisableHolderGeneration";
    public static final String DISABLE_GENERATION = "disable generation";
    public static final String OTHER_NAMES = "otherNames";
    private static final String RESOLVED_CHILDNAMES = "resolvedChildNames";
    public static final String THROWS_CHECKED_EXCEPTION = "throwsCheckedException";
    public static final String NOT_MAPPABLE = "notMappable";
    public static final String CUSTOM = "custom";
    public static final String EXCEPTION_INIT_STYLES = "ExceptionInitStyles";
    public static final String JAXRPC_NORMAL_INIT = "JAXRPC-Normal";
    public static final String JAXRPC_NOARG_INIT = "JAXRPC-NoArg";
    public static final String NOARG_INIT = "Non-JAXRPC-NoArg";
    public static final String MESSAGE_ARG_INIT = "Non-JAXRPC-MessageArg";
    public static String JAVA_TYPE = "javaType";
    public static String IS_DATA_MEMBER = "isDataMember";
    public static String SET_METHOD_NAME = "setMethodName";
    public static String GET_METHOD_NAME = "getMethodName";
    public static String MISSING_SETTER_NAME = "missingSetterName";
    public static String OUT_ORDERING_REQUIRED = "inoutOrderingReq";
    public static String IN_POSITION = "inputPosition";
    public static String OUT_POSITION = "outputPosition";
    public static String OLD_EXCEPTION_MAPPING = "Old exception mapping";
    int uniqueNum = 0;
    BaseTypeMapping btm = null;

    public JavaGeneratorFactory() {
        this.addGenerators();
    }

    public JavaGeneratorFactory(Emitter emitter) {
        this.setEmitter(emitter);
        this.addGenerators();
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public JavaGeneratorFactory(Emitter emitter, boolean mode) {
        this.setEmitter(emitter);
        skipWCCMMappingPass = mode;
        this.addGenerators();
    }

    public void addGenerator(Class construct, Class generator) {
        this.genTable.addGenerator(construct, generator);
    }

    public void removeGenerator(Class construct, Class generator) {
        this.genTable.removeGenerator(construct, generator);
    }

    public void removeAllGenerators() {
        this.genTable.clear();
    }

    public Iterator getGenerators(Class construct) {
        return this.genTable.getGenerators(construct);
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    private void addMessageGenerators() {
    }

    private void addPortTypeGenerators() {
    }

    private void addBindingGenerators() {
        this.genTable.addGenerator(Binding.class, JavaBindingWriter.class);
    }

    private void addServiceGenerators() {
        this.genTable.addGenerator(Service.class, JavaServiceWriter.class);
    }

    private void addTypeGenerators() {
        this.genTable.addGenerator(TypeEntry.class, JavaTypeWriter.class);
    }

    private void addDefinitionGenerators() {
        this.genTable.addGenerator(Definition.class, JavaDefinitionWriter.class);
        if (!skipWCCMMappingPass) {
            this.genTable.addGenerator(Definition.class, XMLWebServicesClientWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesClientBndWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesClientExtWriter.class);
            this.genTable.addGenerator(Definition.class, XMLWebServicesWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesBndWriter.class);
            this.genTable.addGenerator(Definition.class, XMLIBMWebServicesExtWriter.class);
            this.genTable.addGenerator(Definition.class, XMLMappingWriter.class);
        }
    }

    public final Generator getGenerator(Message message, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Message.class, this.emitter, message, symbolTable);
    }

    public final Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(PortType.class, this.emitter, portType, symbolTable);
    }

    public final Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Binding.class, this.emitter, binding, symbolTable);
    }

    public final Generator getGenerator(Service service, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Service.class, this.emitter, service, symbolTable);
    }

    public final Generator getGenerator(TypeEntry typeEntry, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(TypeEntry.class, this.emitter, typeEntry, symbolTable);
    }

    public final Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(Definition.class, this.emitter, definition, symbolTable);
    }

    public void generatorPass(Definition def, SymbolTable symbolTable) {
        this.setFaultContext(symbolTable);
        this.javifyNames(symbolTable);
        this.resolveNameClashes(symbolTable);
        if (this.emitter.inputMMD != null) {
            this.emitter.inputMMD.postSymbolTable(symbolTable);
        }
        this.customMappingSubstitution(symbolTable);
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue(symbolTable);
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        if (this.emitter.isIntrospect()) {
            Introspector introspector = new Introspector(this.emitter);
            introspector.run();
        }
        this.setChildJavaTypes(symbolTable);
        this.disableGeneration(symbolTable);
        this.constructSignatures(symbolTable);
        if (!skipWCCMMappingPass) {
            this.emitter.outputMMD.addPackageMappings(this.emitter.getNamespaces());
            this.emitter.outputMMD.fromSymbolTable(symbolTable);
        }
    }

    protected void javifyNames(SymbolTable symbolTable) {
        this.markAnonTypeClashes(symbolTable);
        HashMap anonQNames = new HashMap();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry.getName() != null) continue;
                if (entry instanceof TypeEntry) {
                    this.javifyTypeEntry((TypeEntry)entry, anonQNames, symbolTable);
                    continue;
                }
                if (entry instanceof MessageEntry) {
                    this.javifyMessageEntry((MessageEntry)entry);
                    continue;
                }
                if (entry instanceof ServiceEntry) {
                    this.javifyServiceEntry((ServiceEntry)entry);
                    continue;
                }
                if (entry instanceof BindingEntry) {
                    this.javifyBindingEntry((BindingEntry)entry);
                    continue;
                }
                if (entry instanceof GroupEntry) continue;
                entry.setName(this.createClassName(entry.getQName()));
            }
        }
    }

    protected void javifyTypeEntry(TypeEntry entry, HashMap anonQNames, SymbolTable symbolTable) {
        if (entry.getName() != null) {
            return;
        }
        if (entry instanceof Type && this.emitter.jsr101v11) {
            Type type;
            Type base;
            this.javifyArrayPattern(entry, anonQNames, symbolTable);
            if (((Type)entry).isSimpleType() && !((Type)entry).isEnumeration() && !((Type)entry).isList() && (base = (type = (Type)entry).getRestrictionBase()) != null) {
                this.javifyTypeEntry(base, anonQNames, symbolTable);
                entry.setName(base.getName());
            }
            this.javifyChildNames(symbolTable, ((Type)entry).getChildren());
        }
        if (entry.getName() != null) {
            return;
        }
        String dims = entry.getDimensions();
        TypeEntry refType = entry.getRefType();
        if (refType != null) {
            this.javifyTypeEntry(refType, anonQNames, symbolTable);
            entry.setName(refType.getName() + dims);
            return;
        }
        if (entry.getName() == null) {
            QName typeQName = entry.getQName();
            if (!(entry instanceof Type) || !((Type)entry).isAnonType()) {
                entry.setName(this.emitter.getJavaName(typeQName));
            } else {
                String localName = typeQName.getLocalPart();
                localName = localName.substring(localName.lastIndexOf(">") + 1);
                String prepend = (String)entry.getDynamicVar(ANON_TYPE_PREPEND);
                if (prepend != null) {
                    localName = prepend + localName;
                }
                typeQName = QNameTable.createQName(typeQName.getNamespaceURI(), localName);
                symbolTable.getType(typeQName);
                if (anonQNames.get(typeQName) != null) {
                    localName = localName + "Type" + this.uniqueNum++;
                    typeQName = QNameTable.createQName(typeQName.getNamespaceURI(), localName);
                }
                anonQNames.put(typeQName, typeQName);
                entry.setName(this.emitter.getJavaName(typeQName));
            }
        }
    }

    private void javifyArrayPattern(TypeEntry entry, HashMap anonQNames, SymbolTable symbolTable) {
        Type component2 = (Type)entry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (component2 != null) {
            this.javifyTypeEntry(component2, anonQNames, symbolTable);
            String componentName = component2.getName();
            Vector children = ((Type)entry).getChildren();
            if (children != null && children.get(0) instanceof ChildElement && ((ChildElement)children.get(0)).isNillable()) {
                componentName = Utils.getWrapperType(componentName);
            }
            entry.setName(componentName + "[]");
        }
    }

    private void javifyMessageEntry(MessageEntry entry) {
        MessageEntry me = entry;
        if (me.isFault() && (me.getDynamicVar(COMPLEX_TYPE_FAULT) == null || !((Boolean)me.getDynamicVar(COMPLEX_TYPE_FAULT)).booleanValue())) {
            entry.setName(this.createClassName(entry.getQName()));
            Vector parts = me.getFaultParts();
            ArrayList<String> order = new ArrayList<String>();
            for (int j = 0; j < parts.size(); ++j) {
                ChildFaultPartEntry part = (ChildFaultPartEntry)parts.elementAt(j);
                part.setName(JavaUtils.xmlNameToJava(part.getQName().getLocalPart()));
                order.add(part.getQName().getLocalPart());
            }
            me.setDynamicVar(CONSTRUCTOR_ORDER, order);
        }
    }

    private void javifyServiceEntry(ServiceEntry entry) {
        entry.setName(this.createClassName(entry.getQName()));
        ServiceEntry se = entry;
        for (int j = 0; j < se.numPorts(); ++j) {
            PortEntry pe = se.getPort(j);
            String portName = pe.getPort().getName();
            if (!JavaUtils.isJavaId(portName)) {
                portName = JavaUtils.xmlNameToJavaClass(portName);
            }
            pe.setName(portName);
        }
    }

    protected void javifyChildNames(SymbolTable symbolTable, Vector children) {
        if (children == null || children.size() == 0) {
            return;
        }
        if (!(children.get(0) instanceof ChildEnumValueEntry)) {
            for (int i = 0; i < children.size(); ++i) {
                ChildEntry ce = (ChildEntry)children.get(i);
                String name = JavaUtils.xmlNameToJava(ce.getQName().getLocalPart());
                ce.setName(this.getAsBeanPropertyName(name));
                if (!(ce instanceof ChildElement) || !((ChildElement)ce).getAnyElement()) continue;
                ce.setName("_any");
            }
        } else {
            ChildEnumValueEntry cev;
            int i;
            boolean isValidJava = true;
            for (i = 0; i < children.size() && isValidJava; ++i) {
                cev = (ChildEnumValueEntry)children.get(i);
                isValidJava = JavaUtils.isJavaId(cev.getEnumValue());
            }
            for (i = 0; i < children.size(); ++i) {
                cev = (ChildEnumValueEntry)children.get(i);
                if (isValidJava) {
                    cev.setName(cev.getEnumValue());
                    continue;
                }
                cev.setName("value" + (i + 1));
            }
        }
    }

    protected void javifyBindingEntry(BindingEntry bEntry) {
        bEntry.setName(this.createClassName(bEntry.getQName()));
        Iterator iter = bEntry.getOperations();
        while (iter.hasNext()) {
            BindingOperationEntry boe = (BindingOperationEntry)iter.next();
            boe.setName(JavaUtils.xmlNameToJava(boe.getQName().getLocalPart()));
            for (int i = 0; i < boe.numParameters(); ++i) {
                BindingParamEntry parm = boe.getParameter(i);
                parm.setName(JavaUtils.xmlNameToJava(parm.getQName().getLocalPart()));
            }
            Vector<String> used = new Vector<String>(boe.numParameters());
            for (int i = 0; i < boe.numParameters(); ++i) {
                BindingParamEntry parameter = boe.getParameter(i);
                int count = 2;
                while (used.contains(parameter.getName())) {
                    parameter.setName(parameter.getName() + Integer.toString(count++));
                }
                used.add(parameter.getName());
            }
        }
    }

    private String createClassName(QName qName) {
        String pkg = this.emitter.getPackage(qName.getNamespaceURI());
        String cls = JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        if (pkg != null && pkg != "") {
            cls = pkg + "." + cls;
        }
        return cls;
    }

    private String getAsBeanPropertyName(String fieldName) {
        if (fieldName.length() > 1 && Character.isUpperCase(fieldName.charAt(1))) {
            return JavaUtils.capitalizeFirstChar(fieldName);
        }
        return fieldName;
    }

    private boolean messageEntryClassExists(MessageEntry mEntry) {
        String name = this.emitter.getJavaName(mEntry.getQName());
        Class javaType = null;
        try {
            if (name != null && this.emitter.getToolEnv().isJavaIntrospectionAllowed()) {
                javaType = ClassUtils.forName(name, false, this.emitter.getToolEnv().getClassLoader());
            }
        }
        catch (Exception e) {
            return false;
        }
        return javaType != null;
    }

    protected void setFaultContext(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Iterator it2 = bEntry.getOperations();
                while (it2.hasNext()) {
                    BindingOperationEntry boe = (BindingOperationEntry)it2.next();
                    for (int j = 0; j < boe.numFaults(); ++j) {
                        this.setFaultContext(boe.getFault(j), symbolTable);
                    }
                }
            }
        }
    }

    private void setFaultContext(BindingFaultRefEntry fault, SymbolTable symbolTable) {
        MessageEntry me = fault.getMessageEntry();
        if (me.getFaultParts().size() == 0) {
            me.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, me);
            me.setDynamicVar(CONSTRUCTOR_ORDER, new ArrayList());
            return;
        }
        ChildFaultPartEntry cfp = (ChildFaultPartEntry)me.getFaultParts().elementAt(0);
        TypeEntry te = cfp.getType();
        TypeEntry elementTE = null;
        if (te instanceof Element) {
            elementTE = te;
            te = te.getRefType();
        }
        Type type = (Type)te;
        boolean oldSimpleContentExceptionMapping = false;
        if (type.isSimpleContent() && this.messageEntryClassExists(me)) {
            oldSimpleContentExceptionMapping = true;
            me.setDynamicVar(OLD_EXCEPTION_MAPPING, me);
        }
        if (me.getFaultParts().size() > 1 || type.isSimpleType() || type.getDimensions().length() > 0 && ((Type)type.getRefType()).isSimpleType() || oldSimpleContentExceptionMapping) {
            me.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, me);
            ArrayList<String> order = new ArrayList<String>();
            Vector parts = me.getFaultParts();
            for (int j = 0; j < parts.size(); ++j) {
                ChildFaultPartEntry part = (ChildFaultPartEntry)parts.elementAt(j);
                order.add(part.getQName().getLocalPart());
            }
            me.setDynamicVar(CONSTRUCTOR_ORDER, order);
        } else {
            me.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, type);
            me.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
            Set complexTypes = com.ibm.ws.webservices.wsdl.symbolTable.Utils.getDerivedTypes(type, symbolTable);
            complexTypes.add(type);
            Type base = type;
            while (base.getExtensionBase() != null && !base.getExtensionBase().isSimpleType()) {
                base = base.getExtensionBase();
                complexTypes.add(base);
            }
            me.setDynamicVar(COMPLEX_TYPE_FAULT_COLLECTION, complexTypes);
            Boolean isComplexFault = (Boolean)type.getDynamicVar(COMPLEX_TYPE_FAULT);
            if (isComplexFault == null || !isComplexFault.booleanValue()) {
                Set derivedSet = com.ibm.ws.webservices.wsdl.symbolTable.Utils.getDerivedTypes(base, symbolTable);
                derivedSet.add(base);
                derivedSet.add(type);
                Iterator derivedI = derivedSet.iterator();
                while (derivedI.hasNext()) {
                    TypeEntry derivedTE = (TypeEntry)derivedI.next();
                    derivedTE.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                    derivedTE.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
                    this.setConstructorOrder((Type)derivedTE);
                }
            }
        }
    }

    private void setConstructorOrder(Type type) {
        Vector<Type> extendList = new Vector<Type>();
        Type next = type;
        while (next != null) {
            extendList.add(next);
            if (next.getExtensionBase() != null) {
                next = next.getExtensionBase();
                continue;
            }
            next = next.getRestrictionBase();
        }
        ArrayList<String> paramParts = new ArrayList<String>();
        for (int i = extendList.size() - 1; i >= 0; --i) {
            int j;
            Type te = (Type)extendList.elementAt(i);
            Vector children = te.getChildren();
            if (children == null) continue;
            for (j = 0; j < children.size(); ++j) {
                if (!(children.get(j) instanceof ChildAttribute)) continue;
                ChildAttribute attr = (ChildAttribute)children.get(j);
                paramParts.add(attr.getQName().getLocalPart());
            }
            for (j = 0; j < children.size(); ++j) {
                if (!(children.get(j) instanceof ChildElement)) continue;
                ChildElement elem = (ChildElement)children.get(j);
                paramParts.add(elem.getQName().getLocalPart());
            }
        }
        type.setDynamicVar(CONSTRUCTOR_ORDER, paramParts);
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>();
        Iterator<Object> it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                String javaName;
                boolean addEntry = true;
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof MessageEntry) {
                    MessageEntry me = (MessageEntry)entry;
                    Boolean complexFault = (Boolean)me.getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (!me.isFault() || complexFault != null && complexFault.booleanValue()) {
                        addEntry = false;
                    }
                }
                if (entry instanceof BindingEntry || entry instanceof GroupEntry) {
                    addEntry = false;
                }
                if (entry instanceof TypeEntry && ((TypeEntry)entry).isOnlyWrappedLiteralReferenced()) {
                    addEntry = false;
                }
                if ((javaName = entry.getName()) == null) {
                    addEntry = false;
                }
                if (javaName != null && javaName.indexOf(91) >= 0) {
                    javaName = javaName.substring(0, javaName.indexOf(91));
                }
                if ("javax.xml.soap.SOAPElement".equals(javaName)) {
                    addEntry = false;
                }
                if (!addEntry) continue;
                Object value = entryMap.get(javaName);
                if (value == null) {
                    entryMap.put(javaName, entry);
                    continue;
                }
                if (value instanceof List) {
                    ((List)value).add(entry);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(value);
                list.add(entry);
                entryMap.put(javaName, list);
            }
        }
        it = entryMap.keySet().iterator();
        LinkedHashSet<SymTabEntry> resolved = new LinkedHashSet<SymTabEntry>();
        while (it.hasNext()) {
            SymTabEntry entry;
            int i;
            List list;
            boolean resolve;
            String key = (String)it.next();
            Object value = entryMap.get(key);
            if (!(value instanceof List) || !(resolve = !this.sameTypeEntryClasses(list = (List)value))) continue;
            resolved.clear();
            for (i = 0; i < list.size(); ++i) {
                entry = (SymTabEntry)list.get(i);
                if (!(entry instanceof Type) || entry.getQName().getLocalPart().startsWith(">") || entry.getName().indexOf(91) >= 0) continue;
                String suffix = "";
                Boolean complexFault = (Boolean)entry.getDynamicVar(COMPLEX_TYPE_FAULT);
                suffix = complexFault != null && complexFault != false ? "_Exception" : (((Type)entry).isEnumeration() ? "_Enumeration" : "_Type");
                entry.setName(this.mangleName(entry.getName(), suffix));
                resolved.add(entry);
                for (int j = 0; j < list.size(); ++j) {
                    SymTabEntry entry2 = (SymTabEntry)list.get(j);
                    if (entry == entry2 || !(entry2 instanceof TypeEntry)) continue;
                    TypeEntry refType = Utils.getReferencedType((TypeEntry)entry2);
                    while (refType != null && refType != entry) {
                        refType = Utils.getReferencedType(refType);
                    }
                    if (refType != entry) continue;
                    entry2.setName(this.mangleName(entry2.getName(), suffix));
                    resolved.add(entry2);
                }
            }
            for (i = 0; i < list.size(); ++i) {
                entry = (SymTabEntry)list.get(i);
                if (!(entry instanceof Element) || resolved.contains(entry)) continue;
                entry.setName(this.mangleName(entry.getName(), "_Element"));
                resolved.add(entry);
                TypeEntry refType = Utils.getReferencedType((TypeEntry)entry);
                while (refType != null) {
                    Boolean isComplexFault = (Boolean)refType.getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (isComplexFault == null || !isComplexFault.booleanValue()) {
                        refType.setName(this.mangleName(refType.getName(), "_Element"));
                    }
                    resolved.add(refType);
                    refType = Utils.getReferencedType(refType);
                }
            }
            for (i = 0; i < list.size(); ++i) {
                entry = (SymTabEntry)list.get(i);
                if (!(entry instanceof Type) || resolved.contains(entry)) continue;
                Boolean complexFault = (Boolean)entry.getDynamicVar(COMPLEX_TYPE_FAULT);
                if (complexFault != null && complexFault.booleanValue()) {
                    entry.setName(this.mangleName(entry.getName(), "_Exception"));
                } else if (((Type)entry).isEnumeration()) {
                    entry.setName(this.mangleName(entry.getName(), "_Enumeration"));
                } else {
                    entry.setName(this.mangleName(entry.getName(), "_Type"));
                }
                resolved.add(entry);
            }
            for (i = 0; i < list.size(); ++i) {
                entry = (SymTabEntry)list.get(i);
                if (entry instanceof Element || entry instanceof Type) continue;
                if (entry instanceof PortTypeEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_PortType"));
                    resolved.add(entry);
                    continue;
                }
                if (entry instanceof ServiceEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Service"));
                    resolved.add(entry);
                    continue;
                }
                if (entry instanceof MessageEntry) {
                    String name = this.mangleName(entry.getName(), "_Exception");
                    Iterator iter = resolved.iterator();
                    boolean found = false;
                    while (iter.hasNext() && !found) {
                        SymTabEntry e = (SymTabEntry)iter.next();
                        found = e.getName().equals(name);
                    }
                    if (found) {
                        name = this.mangleName(entry.getName(), "_SimpleException");
                    }
                    entry.setName(name);
                    resolved.add(entry);
                    continue;
                }
                if (!(entry instanceof BindingEntry)) continue;
                entry.setName(this.mangleName(entry.getName(), "_Binding"));
                resolved.add(entry);
            }
        }
        this.resolveJavaNameClashes(symbolTable);
        this.resolveChildEntryNameClashes(symbolTable);
    }

    private boolean sameTypeEntryClasses(List list) {
        if (list.size() < 2) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof TypeEntry) continue;
            return false;
        }
        TypeEntry refType = (TypeEntry)list.get(0);
        while (Utils.getReferencedType(refType) != null) {
            refType = Utils.getReferencedType(refType);
        }
        for (int i = 1; i < list.size(); ++i) {
            TypeEntry refType2 = (TypeEntry)list.get(i);
            while (Utils.getReferencedType(refType2) != null) {
                refType2 = Utils.getReferencedType(refType2);
            }
            if (refType2 == refType || refType2.isBaseType() || refType.isBaseType()) continue;
            return false;
        }
        return true;
    }

    private String mangleName(String name, String mangle) {
        int index = name.indexOf("[");
        if (index >= 0) {
            String pre = name.substring(0, index);
            String post = name.substring(index);
            return pre + mangle + post;
        }
        return name + mangle;
    }

    protected void resolveJavaNameClashes(SymbolTable symbolTable) {
        HashMap<String, ArrayList<SymTabEntry>> javaNames = new HashMap<String, ArrayList<SymTabEntry>>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                String javaName = entry.getName();
                if (!(entry instanceof BindingEntry)) continue;
                ArrayList<SymTabEntry> namedEntry = (ArrayList<SymTabEntry>)javaNames.get(javaName);
                if (namedEntry == null) {
                    namedEntry = new ArrayList<SymTabEntry>();
                    javaNames.put(javaName, namedEntry);
                }
                namedEntry.add(entry);
            }
        }
        Iterator nameKeys = javaNames.keySet().iterator();
        while (nameKeys.hasNext()) {
            ArrayList list;
            String nameKey = (String)nameKeys.next();
            if (nameKey == null || nameKey.equals("") || (list = (ArrayList)javaNames.get(nameKey)).size() <= 1) continue;
            for (int i = 0; i < list.size(); ++i) {
                this.createNonJAXRPCName((SymTabEntry)list.get(i));
            }
        }
    }

    private void createNonJAXRPCName(SymTabEntry entry) {
        String name = entry.getQName().getLocalPart();
        name = JavaUtils.createNonJAXRPCName(name);
        String pkg = entry.getName();
        int pkgEnd = pkg.lastIndexOf(46);
        if (pkgEnd < 0) {
            pkgEnd = pkg.length() - 1;
        }
        pkg = pkg.substring(0, pkgEnd + 1);
        entry.setName(pkg + name);
    }

    private void resolveChildEntryNameClashes(SymbolTable symbolTable) {
        Vector types2 = symbolTable.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)types2.get(i);
            if (!(typeEntry instanceof Type) || ((Type)typeEntry).getChildren() == null || typeEntry.getDynamicVar(RESOLVED_CHILDNAMES) != null) continue;
            this.resolveChildEntryNameClashes((Type)typeEntry);
        }
    }

    private List resolveChildEntryNameClashes(Type type) {
        ArrayList resolved = null;
        Type parent = type.getExtensionBase();
        if (parent == null) {
            parent = type.getRestrictionBase();
        }
        resolved = parent != null ? this.resolveChildEntryNameClashes(parent) : new ArrayList();
        AbstractList children = type.getChildren();
        if (children == null) {
            children = new ArrayList();
        }
        if (type.getDynamicVar(RESOLVED_CHILDNAMES) == null) {
            type.setDynamicVar(RESOLVED_CHILDNAMES, Boolean.TRUE);
            String mangleName = type.getName();
            int index = mangleName.lastIndexOf(".");
            mangleName = index > 0 ? "_" + mangleName.substring(index + 1) : "_" + mangleName;
            this.resolveJavaNameClashes(resolved, children, mangleName);
        } else {
            resolved.addAll(children);
        }
        return resolved;
    }

    private void resolveJavaNameClashes(List list1, List list2, String mangleSuffix) {
        if (list2 == null) {
            return;
        }
        if (list1 == null) {
            list1 = new ArrayList<Entry>();
        }
        for (int j = 0; j < list2.size(); ++j) {
            Entry e2 = (Entry)list2.get(j);
            boolean resolved = false;
            int pass = 1;
            while (!resolved) {
                Entry clash = null;
                for (int i = 0; i < list1.size() && clash == null; ++i) {
                    Entry e1 = (Entry)list1.get(i);
                    if (!e1.getName().equals(e2.getName())) continue;
                    clash = e1;
                }
                if (clash != null) {
                    switch (pass) {
                        case 1: {
                            e2.setName(JavaUtils.createNonJAXRPCName(e2.getName()));
                            break;
                        }
                        case 2: {
                            e2.setName(e2.getName() + mangleSuffix);
                            break;
                        }
                        default: {
                            e2.setName("_" + e2.getName());
                            break;
                        }
                    }
                } else {
                    resolved = true;
                }
                ++pass;
            }
            list1.add(e2);
        }
    }

    protected void setAllReferencesToTrue(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    int bindingType = ((BindingEntry)entry).getBindingType();
                    if (bindingType == 0 || bindingType == 4) {
                        entry.setIsReferenced(true);
                        continue;
                    }
                    entry.setIsReferenced(false);
                    continue;
                }
                entry.setIsReferenced(true);
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> unusedPortTypes = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> usedPortTypes = new Vector<PortTypeEntry>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Binding binding = bEntry.getBinding();
                PortType portType = binding.getPortType();
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
                if (bEntry.getBindingType() == 0 || bEntry.getBindingType() == 4) {
                    usedPortTypes.add(ptEntry);
                    if (!unusedPortTypes.contains(ptEntry)) continue;
                    unusedPortTypes.remove(ptEntry);
                    continue;
                }
                bEntry.setIsReferenced(false);
                if (usedPortTypes.contains(ptEntry)) continue;
                unusedPortTypes.add(ptEntry);
            }
        }
        for (int i = 0; i < unusedPortTypes.size(); ++i) {
            PortTypeEntry ptEntry = (PortTypeEntry)unusedPortTypes.get(i);
            ptEntry.setIsReferenced(false);
        }
    }

    protected void setChildJavaTypes(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            block1: for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                Vector children = null;
                if (entry instanceof Type) {
                    children = ((Type)entry).getChildren();
                } else if (entry instanceof MessageEntry) {
                    children = ((MessageEntry)entry).getFaultParts();
                }
                if (children == null) continue;
                for (int j = 0; j < children.size(); ++j) {
                    ChildEntry ce = (ChildEntry)children.get(j);
                    if (ce != null && ce.getType() != null && ce.getType().isOnlyWrappedLiteralReferenced()) {
                        entry.setDynamicVar(DISABLE_GENERATION, new Boolean(true));
                        continue block1;
                    }
                    JavaGeneratorFactory.defaultChildJavaType(ce);
                }
            }
        }
    }

    public static void defaultChildJavaType(ChildEntry ce) {
        if (ce != null && ce.getDynamicVar(JAVA_TYPE) == null) {
            TypeEntry tEntry;
            for (tEntry = ce.getType(); tEntry != null && !(tEntry instanceof Type) && !tEntry.isCollectionTypeEntry(); tEntry = tEntry.getRefType()) {
            }
            String javaType = null;
            if (tEntry != null) {
                javaType = tEntry.getName();
            }
            if (ce instanceof ChildAttribute) {
                if (((ChildAttribute)ce).isOptional()) {
                    javaType = Utils.getWrapperType(javaType);
                }
            } else if (ce instanceof ChildElement) {
                ChildElement childElement = (ChildElement)ce;
                if (childElement.isNillable() && childElement.getMaxOccurs()) {
                    if (javaType.endsWith("[]")) {
                        String compType = javaType.substring(0, javaType.length() - 2);
                        compType = Utils.getWrapperType(compType);
                        javaType = compType + "[]";
                    }
                } else if (childElement.isNillable() || childElement.getMinOccursIs0()) {
                    javaType = Utils.getWrapperType(javaType);
                }
            }
            ce.setDynamicVar(JAVA_TYPE, javaType);
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        SymTabEntry entry;
        int i;
        Vector v;
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            v = (Vector)it.next();
            for (i = 0; i < v.size(); ++i) {
                entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry) || !entry.isReferenced()) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Binding binding = bEntry.getBinding();
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                PortType portType = ptEntry.getPortType();
                if (bEntry.getBindingType() != 0) {
                    this.emitter.setGenImplSer(true);
                }
                if (bEntry.getDynamicVar(INTERFACE_NAME) == null) {
                    bEntry.setDynamicVar(INTERFACE_NAME, ptEntry.getName());
                }
                if (ptEntry.getDynamicVar(IMPL_NAME) == null) {
                    ptEntry.setDynamicVar(IMPL_NAME, bEntry.getName() + "Impl");
                } else {
                    ptEntry.setDynamicVar(IMPL_NAME, (String)bEntry.getDynamicVar(INTERFACE_NAME) + "Impl");
                }
                boolean checkDocLitOperations = false;
                Iterator operations = portType.getOperations().iterator();
                while (operations.hasNext()) {
                    String signature;
                    Operation operation = (Operation)operations.next();
                    OperationType type = operation.getStyle();
                    String name = operation.getName();
                    BindingOperationEntry boe = bEntry.getOperation(operation);
                    if (bEntry.getBindingStyle() == Style.DOCUMENT && bEntry.getBindingType() == 0 && !boe.isWrapped() && boe.getInputBodyUse() == Use.LITERAL) {
                        checkDocLitOperations = true;
                    }
                    if (type == OperationType.SOLICIT_RESPONSE) {
                        signature = "    // " + Messages.getMessage("invalidSolResp00", name);
                        boe.setDynamicVar(SIGNATURE, signature);
                        this.emitter.getToolEnv().reporterr(Messages.getMessage("invalidSolResp00", name));
                        continue;
                    }
                    if (type == OperationType.NOTIFICATION) {
                        signature = "    // " + Messages.getMessage("invalidNotif00", name);
                        boe.setDynamicVar(SIGNATURE, signature);
                        this.emitter.getToolEnv().reporterr(Messages.getMessage("invalidNotif00", name));
                        continue;
                    }
                    boe.setDynamicVar(SIGNATURE, this.constructSignature(symbolTable, boe));
                }
                if (!checkDocLitOperations) continue;
                this.checkDocLitOperations(bEntry);
            }
        }
        it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            v = (Vector)it.next();
            for (i = 0; i < v.size(); ++i) {
                entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof PortTypeEntry)) continue;
                entry.setName("");
            }
        }
    }

    private void checkDocLitOperations(BindingEntry bEntry) {
        String key;
        BindingOperationEntry boe;
        Iterator ops = bEntry.getOperations();
        HashMap<String, BindingOperationEntry> map = new HashMap<String, BindingOperationEntry>();
        while (ops.hasNext()) {
            boe = (BindingOperationEntry)ops.next();
            if (!boe.isWrapped()) continue;
            key = boe.getQName().toString();
            map.put(key, boe);
        }
        ops = bEntry.getOperations();
        while (ops.hasNext()) {
            boe = (BindingOperationEntry)ops.next();
            if (boe.isWrapped() || boe.getInputBodyUse() != Use.LITERAL) continue;
            key = "";
            for (int i = 0; i < boe.numParameters(); ++i) {
                BindingParamEntry bpe = boe.getParameter(i);
                if (bpe.getMode() == 2 || bpe.isInHeader()) continue;
                key = key + bpe.getDynamicVar(PARAM_WIRE_QNAME);
            }
            BindingOperationEntry matchingBOE = (BindingOperationEntry)map.get(key);
            if (matchingBOE != null) {
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("matchingDocLitParams00", matchingBOE.getQName().toString(), boe.getQName().toString()));
            }
            map.put(key, boe);
        }
    }

    private String constructSignature(SymbolTable symbolTable, BindingOperationEntry boe) {
        int i;
        String name = boe.getName();
        LinkedHashSet<QName> inQNames = new LinkedHashSet<QName>();
        LinkedHashSet<Object> outQNames = new LinkedHashSet<Object>();
        String ret = "void";
        if (boe.getReturn() != null) {
            ret = this.constructParamSigType(boe.getReturn(), true, symbolTable);
            outQNames.add(boe.getReturn().getDynamicVar(PARAM_WIRE_QNAME));
        }
        String signature = "    public " + ret + " " + name + "(";
        boolean needComma = false;
        for (i = 0; i < boe.numParameters(); ++i) {
            BindingParamEntry p = boe.getParameter(i);
            if (needComma) {
                signature = signature + ", ";
            } else {
                needComma = true;
            }
            signature = signature + this.constructParamSigType(p, false, symbolTable) + " " + p.getName();
            QName wireQName = (QName)p.getDynamicVar(PARAM_WIRE_QNAME);
            if (p.getMode() != 2) {
                if (inQNames.contains(wireQName)) {
                    this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("paramsNotUnique00", wireQName.toString(), "input", boe.getQName().toString()));
                }
                inQNames.add(wireQName);
            }
            if (p.getMode() == 1) continue;
            if (outQNames.contains(wireQName)) {
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("paramsNotUnique00", wireQName.toString(), "output", boe.getQName().toString()));
            }
            outQNames.add(wireQName);
        }
        signature = signature + ") throws java.rmi.RemoteException";
        if (boe.numFaults() > 0) {
            for (i = 0; i < boe.numFaults(); ++i) {
                MessageEntry me = boe.getFault(i).getMessageEntry();
                SymTabEntry entry = (SymTabEntry)me.getDynamicVar(EXCEPTION_SYMTAB_ENTRY);
                String exceptionName = entry.getName();
                if ("javax.xml.soap.SOAPElement".equals(exceptionName)) continue;
                signature = signature + ", " + exceptionName;
            }
        }
        return signature;
    }

    protected String constructHolderName(BindingParamEntry param, SymbolTable symbolTable) {
        String holderName = null;
        if (param.getMode() != 1) {
            boolean isPredefinedHolder;
            String mimeType = param.getMIMEType();
            if (mimeType != null) {
                if (mimeType.equals("image/gif") || mimeType.equals("image/jpeg")) {
                    return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
                }
                if (mimeType.equals("text/plain")) {
                    return "javax.xml.rpc.holders.StringHolder";
                }
                if (mimeType.startsWith("multipart/")) {
                    return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
                }
                if (mimeType.equals("text/xml") || mimeType.equals("application/xml")) {
                    return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
                }
                return "com.ibm.ws.webservices.engine.types.holders.DataHandlerHolder";
            }
            TypeEntry typeEntry = param.getType();
            holderName = (String)typeEntry.getDynamicVar(HOLDER_NAME);
            if (holderName == null && (holderName = (String)typeEntry.getDynamicVar(PARAM_SIG_TYPE)) == null) {
                holderName = this.defaultHolderName(param, symbolTable);
            }
            typeEntry.setDynamicVar(HOLDER_NAME, holderName);
            boolean bl = isPredefinedHolder = holderName.startsWith("javax.xml.rpc.holders") || holderName.startsWith("com.ibm.ws.webservices.engine.types.holders");
            if (isPredefinedHolder) {
                typeEntry.setDynamicVar(DISABLE_HOLDER_GENERATION, Boolean.TRUE);
            }
            if (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry() && typeEntry.getRefType() != null) {
                typeEntry.getRefType().setDynamicVar(HOLDER_NAME, holderName);
                if (isPredefinedHolder) {
                    typeEntry.getRefType().setDynamicVar(DISABLE_HOLDER_GENERATION, Boolean.TRUE);
                }
            }
        }
        return holderName;
    }

    protected String constructParamSigType(BindingParamEntry param, boolean isReturn, SymbolTable symbolTable) {
        QName paramWireQName = param.getQName();
        if (param.getType() instanceof Element) {
            TypeEntry el = param.getType();
            paramWireQName = el.getQName();
            while (el instanceof Element && el.isCollectionTypeEntry()) {
                el = el.getRefType();
            }
            if (el instanceof Element) {
                paramWireQName = el.getQName();
            }
        }
        param.setDynamicVar(PARAM_WIRE_QNAME, paramWireQName);
        String paramType = (String)param.getDynamicVar(PARAM_TYPE);
        if (paramType == null) {
            paramType = JavaGeneratorFactory.defaultParamType(param);
        }
        param.setDynamicVar(PARAM_TYPE, paramType);
        String paramSigType = paramType;
        if (param.getMode() != 1 && !isReturn) {
            paramSigType = this.constructHolderName(param, symbolTable);
        }
        param.setDynamicVar(PARAM_SIG_TYPE, paramSigType);
        return paramSigType;
    }

    public static String defaultParamType(BindingParamEntry param) {
        String paramType = null;
        String mime = param.getMIMEType();
        if (mime != null) {
            paramType = JavaUtils.mimeToJava(mime);
        }
        if (paramType == null) {
            TypeEntry el = param.getType();
            while (el instanceof Element && !el.isCollectionTypeEntry()) {
                el = el.getRefType();
            }
            paramType = el.getName();
        }
        if (param.isNillable() && !param.isMaxOccursIs1()) {
            if (paramType.endsWith("[]")) {
                String compType = paramType.substring(0, paramType.length() - 2);
                compType = Utils.getWrapperType(compType);
                paramType = compType + "[]";
            }
        } else if (param.isNillable() || param.isMinOccursIs0()) {
            paramType = Utils.getWrapperType(paramType);
        }
        return paramType;
    }

    private String defaultHolderName(BindingParamEntry param, SymbolTable symbolTable) {
        boolean tryJAXRPCHolder;
        String mimeType = param.getMIMEType();
        if (mimeType != null) {
            if (mimeType.equals("image/gif") || mimeType.equals("image/jpeg")) {
                return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
            }
            if (mimeType.equals("text/plain")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (mimeType.startsWith("multipart/")) {
                return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
            }
            if (mimeType.equals("text/xml") || mimeType.equals("application/xml")) {
                return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
            }
        }
        String typeValue = (String)param.getDynamicVar(PARAM_TYPE);
        QName xsiType = Utils.getXSIType(param);
        Type type = symbolTable.getType(xsiType);
        while (type.isSimpleType() && type.getRestrictionBase() != null && type.getName().equals(type.getRestrictionBase().getName())) {
            type = type.getRestrictionBase();
            xsiType = type.getQName();
        }
        boolean bl = tryJAXRPCHolder = Constants.isSchemaXSD(xsiType.getNamespaceURI()) || Constants.isSOAP_ENC(xsiType.getNamespaceURI());
        if (typeValue.endsWith("[]")) {
            if (typeValue.equals("byte[]") && tryJAXRPCHolder) {
                return "javax.xml.rpc.holders.ByteArrayHolder";
            }
            if (!param.getType().isCollectionTypeEntry()) {
                String packageName = this.emitter.getPackage(xsiType.getNamespaceURI()) + ".holders.";
                String className = JavaUtils.xmlNameToJavaClass(xsiType.getLocalPart()) + "Holder";
                return packageName + className;
            }
            String className = JavaUtils.xmlNameToJavaClass(xsiType.getLocalPart()) + "ArrayHolder";
            String namespaceURI = xsiType.getNamespaceURI();
            String packageName = this.emitter.getPackage(namespaceURI) + ".holders.";
            if (packageName.startsWith("java") || Constants.isSchemaXSD(namespaceURI) || Constants.isSOAP_ENC(namespaceURI) || xsiType.getNamespaceURI().length() == 0) {
                namespaceURI = param.getParentNamespace();
                packageName = this.emitter.getPackage(namespaceURI) + ".holders.";
            }
            return packageName + className;
        }
        if (tryJAXRPCHolder) {
            if (typeValue.equals("String")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (typeValue.equals("java.lang.String")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (typeValue.equals("Object")) {
                return "javax.xml.rpc.holders.ObjectHolder";
            }
            if (typeValue.equals("java.lang.Object")) {
                return "javax.xml.rpc.holders.ObjectHolder";
            }
            if (typeValue.equals("int") || typeValue.equals("long") || typeValue.equals("short") || typeValue.equals("float") || typeValue.equals("double") || typeValue.equals("boolean") || typeValue.equals("byte")) {
                return "javax.xml.rpc.holders." + JavaUtils.capitalizeFirstChar(typeValue) + "Holder";
            }
            if (typeValue.startsWith("java.lang.")) {
                return "javax.xml.rpc.holders" + typeValue.substring(typeValue.lastIndexOf(".")) + "WrapperHolder";
            }
            if (typeValue.indexOf(".") < 0) {
                return "javax.xml.rpc.holders" + typeValue + "WrapperHolder";
            }
            if (typeValue.equals("java.math.BigDecimal")) {
                return "javax.xml.rpc.holders.BigDecimalHolder";
            }
            if (typeValue.equals("java.math.BigInteger")) {
                return "javax.xml.rpc.holders.BigIntegerHolder";
            }
            if (typeValue.equals("java.util.Calendar")) {
                return "javax.xml.rpc.holders.CalendarHolder";
            }
            if (typeValue.equals("javax.xml.namespace.QName")) {
                return "javax.xml.rpc.holders.QNameHolder";
            }
        }
        if (typeValue.equals("javax.xml.soap.SOAPElement") || typeValue.equals("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement")) {
            return "com.ibm.ws.webservices.engine.types.holders.SOAPElementHolder";
        }
        if (typeValue.equals("java.util.Date")) {
            return "com.ibm.ws.webservices.engine.types.holders.DateHolder";
        }
        if (typeValue.equals("java.net.URI")) {
            return "com.ibm.ws.webservices.engine.types.holders.URIHolder";
        }
        if (typeValue.equals("org.w3c.dom.Element")) {
            return "com.ibm.ws.webservices.engine.types.holders.ElementHolder";
        }
        if (typeValue.equals("javax.activation.DataHandler")) {
            return "com.ibm.ws.webservices.engine.types.holders.DataHandlerHolder";
        }
        if (typeValue.equals("java.awt.Image")) {
            return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
        }
        if (typeValue.equals("javax.mail.internet.MimeMultipart")) {
            return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
        }
        if (typeValue.equals("javax.xml.transform.Source")) {
            return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
        }
        if (typeValue.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("char")) {
            return "com.ibm.ws.webservices.engine.types.holders.CharHolder";
        }
        if (typeValue.equals("Character")) {
            return "com.ibm.ws.webservices.engine.types.holders.CharacterWrapperHolder";
        }
        if (typeValue.equals("java.lang.Character")) {
            return "com.ibm.ws.webservices.engine.types.holders.CharacterWrapperHolder";
        }
        if (typeValue.equals("java.util.Vector")) {
            return "com.ibm.ws.webservices.engine.types.holders.VectorHolder";
        }
        if (typeValue.equals("java.util.Map")) {
            return "com.ibm.ws.webservices.engine.types.holders.MapHolder";
        }
        if (typeValue.equals("java.util.HashMap")) {
            return "com.ibm.ws.webservices.engine.types.holders.MapHolder";
        }
        if (typeValue.startsWith("com.ibm.ws.webservices.engine.types.")) {
            int i = typeValue.lastIndexOf(46);
            String t = typeValue.substring(i + 1);
            return "com.ibm.ws.webservices.engine.types.holders." + t + "Holder";
        }
        String className = JavaUtils.xmlNameToJavaClass(xsiType.getLocalPart()) + "Holder";
        String packageName = this.emitter.getPackage(xsiType.getNamespaceURI()) + ".holders.";
        return packageName + className;
    }

    public void setBaseTypeMapping(BaseTypeMapping btm) {
        this.btm = btm;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

                public String getBaseName(QName qNameIn) {
                    QName qName = QNameTable.createQName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = this.defaultTM.getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(cls.getName());
                }

                public TypeMapping getTypeMapping() {
                    return this.defaultTM;
                }
            };
        }
        return this.btm;
    }

    private void markAnonTypeClashes(SymbolTable symbolTable) {
        HashMap<QName, Vector<TypeEntry>> map = new HashMap<QName, Vector<TypeEntry>>();
        Vector tes = symbolTable.getTypes();
        for (int i = 0; i < tes.size(); ++i) {
            TypeEntry te = (TypeEntry)tes.elementAt(i);
            QName nsq = te.getQName();
            String localName = nsq.getLocalPart();
            int index = (localName = localName.substring(localName.lastIndexOf(">") + 1)).indexOf(93);
            if (index > 0) {
                localName = localName.substring(0, index);
            }
            localName = JavaUtils.xmlNameToJavaClass(localName);
            Vector<TypeEntry> v = (Vector<TypeEntry>)map.get(nsq = QNameTable.createQName(nsq.getNamespaceURI(), localName));
            if (v == null) {
                v = new Vector<TypeEntry>();
                map.put(nsq, v);
            }
            v.add(te);
        }
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            int index;
            TypeEntry te;
            int i;
            Vector v = (Vector)it.next();
            Vector<String> search = new Vector<String>();
            boolean conflict = false;
            for (i = 0; i < v.size() && !conflict; ++i) {
                te = (TypeEntry)v.elementAt(i);
                String name = "";
                index = te.getQName().getLocalPart().lastIndexOf(">");
                if (index > 0) {
                    name = te.getQName().getLocalPart().substring(0, index);
                }
                if (!search.contains(name)) {
                    search.add(name);
                }
                conflict = search.size() > 1;
            }
            if (!conflict) continue;
            for (i = 0; i < v.size(); ++i) {
                te = (TypeEntry)v.elementAt(i);
                String prepend = "";
                index = te.getQName().getLocalPart().lastIndexOf(">");
                if (index > 0) {
                    prepend = te.getQName().getLocalPart().substring(0, index);
                }
                if (prepend.length() <= 0) continue;
                prepend = JavaUtils.replace(prepend, ">", "_");
                prepend = this.reduceAnonTypePrependValue(prepend);
                prepend = prepend + '_';
                te.setDynamicVar(ANON_TYPE_PREPEND, prepend);
            }
        }
    }

    private String reduceAnonTypePrependValue(String prepend) {
        int MAX_PREPEND_LENGTH = 80;
        if (prepend.length() <= MAX_PREPEND_LENGTH) {
            return prepend;
        }
        int hashCode = prepend.hashCode();
        String newPrepend = prepend.substring(0, 20) + '_' + String.valueOf(hashCode);
        return newPrepend;
    }

    private void disableGeneration(SymbolTable symbolTable) {
        Vector types2 = symbolTable.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            Type type;
            Type enumBase;
            TypeEntry typeEntry = (TypeEntry)types2.get(i);
            if (this.disableGeneration(typeEntry)) {
                typeEntry.setDynamicVar(DISABLE_GENERATION, new Boolean(true));
            }
            if (!(typeEntry instanceof Type) || !((Type)typeEntry).isEnumeration() || !(enumBase = (type = (Type)typeEntry).getRestrictionBase()).getName().equals(type.getName())) continue;
            type.setEnumeration(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disableGeneration(TypeEntry typeEntry) {
        Type type;
        if (typeEntry.isBaseType()) {
            return true;
        }
        if (!typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced()) {
            return true;
        }
        if (typeEntry.getName().indexOf("javax.xml.soap.SOAPElement") == 0 || typeEntry.getName().indexOf("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement") == 0 || typeEntry.getName().indexOf("org.w3c.dom.Element") == 0) {
            return true;
        }
        if (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry()) {
            return true;
        }
        if (typeEntry instanceof Type && (type = (Type)typeEntry).isSimpleType() && type.getRestrictionBase() != null && type.getRestrictionBase().getName().equals(type.getName())) {
            return true;
        }
        if (!skipWCCMMappingPass && typeEntry instanceof Type && typeEntry.getName() != null) {
            if (this.emitter.getToolEnv().getJavaContext() == null) {
                System.err.println("Warning from JavaGeneratorFactory: getJavaContext() returns null");
            }
            try {
                ClassFactory classFactory = this.emitter.getToolEnv().getClassFactory();
                JavaHelpers collectionType = classFactory.forName("java.util.Collection");
                JavaHelpers javaType = classFactory.forName(typeEntry.getName());
                JavaHelpers javaHelpers = collectionType;
                synchronized (javaHelpers) {
                    if (collectionType.isAssignableFrom(javaType)) {
                        this.emitter.getToolEnv().reportWarning(Messages.getMessage("typeNotSupported00", typeEntry.getName()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void customMappingSubstitution(SymbolTable symbolTable) {
        CustomRegistry registry = this.emitter.getCustomRegistry();
        if (registry != null) {
            QName[] customQNames = registry.getQNames();
            for (int i = 0; i < customQNames.length; ++i) {
                QName qname = customQNames[i];
                String javaType = registry.getJavaName(qname);
                Type tEntry = symbolTable.getType(qname);
                if (tEntry == null) continue;
                String binderName = registry.getBinderName(qname, javaType);
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, tEntry, javaType, binderName, false);
                tEntry.setDynamicVar(DISABLE_GENERATION, Boolean.TRUE);
            }
        }
    }
}

